/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import org.netbeans.modules.j2ee.sun.dd.api.common.PortInfo;
import org.netbeans.modules.j2ee.sun.dd.api.common.WsdlPort;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.ServiceRefCustomizer;

public class PortInfoMapping {
    private PortInfo portInfo;
    private String displayText;
    private boolean textOutOfDate;

    public PortInfoMapping(PortInfo pi) {
        this.portInfo = pi;
        this.displayText = this.buildDisplayText();
    }

    public PortInfoMapping(PortInfo pi, String display) {
        this.portInfo = pi;
        this.displayText = display;
    }

    public String toString() {
        if (this.textOutOfDate) {
            this.displayText = this.buildDisplayText();
        }
        return this.displayText;
    }

    public PortInfo getPortInfo() {
        return this.portInfo;
    }

    public void updateDisplayText() {
        this.textOutOfDate = true;
    }

    private String buildDisplayText() {
        String sei = this.portInfo.getServiceEndpointInterface();
        WsdlPort wsdl = this.portInfo.getWsdlPort();
        String localPart = null;
        String namespaceURI = null;
        if (wsdl != null) {
            localPart = wsdl.getLocalpart();
            namespaceURI = wsdl.getNamespaceURI();
        }
        StringBuffer resultBuf = new StringBuffer(128);
        boolean separator = false;
        if (sei != null && sei.length() > 0) {
            resultBuf.append(sei);
            separator = true;
        }
        if (localPart != null && localPart.length() > 0) {
            if (separator) {
                resultBuf.append(", ");
            }
            resultBuf.append(localPart);
            separator = true;
        }
        if (namespaceURI != null && namespaceURI.length() > 0) {
            if (separator) {
                resultBuf.append(", ");
            }
            resultBuf.append(namespaceURI);
        }
        if (resultBuf.length() == 0) {
            resultBuf.append(ServiceRefCustomizer.bundle.getString("LBL_UntitledPortInfo"));
        }
        this.textOutOfDate = false;
        return resultBuf.toString();
    }
}

