/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;

public class CharsetMapping
implements Comparable {
    private static final ResourceBundle webappBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.Bundle");
    private Charset charset;
    private String chosenAlias;
    private boolean showAliases;
    private String displayText;
    private boolean textOutOfDate;
    private static boolean useAliases = false;
    private static SortedMap sortedCanonicalCharsetMappings = null;
    private static SortedMap sortedAliasCharsetMappings = null;
    public static final String CHARSET_DISPLAY_TYPE = "CharsetDisplayType";
    public static final Integer CHARSET_CANONICAL = new Integer(0);
    public static final Integer CHARSET_ALIAS_ASIDE = new Integer(1);
    public static final Integer CHARSET_ALIAS_SELECTION = new Integer(2);
    private static Integer displayOption = CHARSET_ALIAS_ASIDE;
    private static PropertyChangeSupport propSupport = new PropertyChangeSupport(CharsetMapping.class);

    public CharsetMapping(Charset c) {
        this(c, c.displayName(), true);
    }

    public CharsetMapping(Charset c, boolean sa) {
        this(c, c.displayName(), sa);
    }

    public CharsetMapping(Charset c, String alias) {
        this(c, alias, false);
    }

    private CharsetMapping(Charset c, String alias, boolean sa) {
        this.charset = c;
        this.chosenAlias = alias;
        this.showAliases = sa;
        this.displayText = this.buildDisplayText();
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof CharsetMapping) {
            CharsetMapping cm = (CharsetMapping)o;
            result = this.chosenAlias.equals(cm.getAlias());
        }
        return result;
    }

    public int hashCode() {
        return this.charset.hashCode();
    }

    public String toString() {
        if (this.textOutOfDate) {
            this.displayText = this.buildDisplayText();
        }
        return this.displayText;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getAlias() {
        return this.chosenAlias;
    }

    public void updateDisplayText() {
        this.textOutOfDate = true;
    }

    private String buildDisplayText() {
        String result = this.chosenAlias;
        if (this.showAliases) {
            StringBuffer aliasList = new StringBuffer(200);
            Iterator<String> iter = this.charset.aliases().iterator();
            while (iter.hasNext()) {
                aliasList.append(iter.next());
                if (!iter.hasNext()) continue;
                aliasList.append(", ");
            }
            Object[] args = new Object[]{this.chosenAlias, aliasList.toString()};
            result = MessageFormat.format(webappBundle.getString("LBL_CharsetComboBoxDisplayText"), args);
        }
        if (result == null || result.length() == 0) {
            result = webappBundle.getString("LBL_UnnamedCharset");
        }
        this.textOutOfDate = false;
        return result;
    }

    public int compareTo(Object obj) {
        int result = -1;
        if (obj instanceof CharsetMapping) {
            CharsetMapping targetMapping = (CharsetMapping)obj;
            result = this.chosenAlias.compareTo(targetMapping.getAlias());
        }
        return result;
    }

    private static SortedMap getSortedCanonicalCharsetMappings() {
        if (sortedCanonicalCharsetMappings == null) {
            SortedMap<String, Charset> charsets = Charset.availableCharsets();
            sortedCanonicalCharsetMappings = new TreeMap();
            Iterator<Map.Entry<String, Charset>> iter = charsets.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Charset> entry = iter.next();
                CharsetMapping mapping = new CharsetMapping(entry.getValue());
                sortedCanonicalCharsetMappings.put(mapping.getAlias(), mapping);
            }
        }
        return sortedCanonicalCharsetMappings;
    }

    private static SortedMap getSortedAliasCharsetMappings() {
        if (sortedAliasCharsetMappings == null) {
            SortedMap<String, Charset> charsets = Charset.availableCharsets();
            sortedAliasCharsetMappings = new TreeMap();
            Iterator<Map.Entry<String, Charset>> iter = charsets.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Charset> entry = iter.next();
                Charset charset = entry.getValue();
                CharsetMapping mapping = new CharsetMapping(charset, false);
                sortedAliasCharsetMappings.put(mapping.getAlias(), mapping);
                Iterator<String> aliasIter = charset.aliases().iterator();
                while (aliasIter.hasNext()) {
                    String alias = aliasIter.next();
                    CharsetMapping aliasMapping = new CharsetMapping(charset, alias);
                    sortedAliasCharsetMappings.put(alias, aliasMapping);
                }
            }
        }
        return sortedAliasCharsetMappings;
    }

    public static SortedMap getSortedAvailableCharsetMappings() {
        SortedMap result;
        if (useAliases) {
            if (sortedAliasCharsetMappings == null) {
                sortedAliasCharsetMappings = CharsetMapping.getSortedAliasCharsetMappings();
            }
            result = sortedAliasCharsetMappings;
        } else {
            if (sortedCanonicalCharsetMappings == null) {
                sortedCanonicalCharsetMappings = CharsetMapping.getSortedCanonicalCharsetMappings();
            }
            result = sortedCanonicalCharsetMappings;
        }
        return result;
    }

    public static CharsetMapping getCharsetMapping(Charset c) {
        return (CharsetMapping)CharsetMapping.getSortedAvailableCharsetMappings().get(c.name());
    }

    public static CharsetMapping getCharsetMapping(String name) {
        CharsetMapping result = null;
        if (name != null) {
            try {
                Charset charset = Charset.forName(name);
                if (charset != null) {
                    result = (CharsetMapping)CharsetMapping.getSortedAvailableCharsetMappings().get(charset.name());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        propSupport.addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        propSupport.removePropertyChangeListener(listener);
    }

    public static void setDisplayOption(Integer option) {
        Integer newDisplayOption = CharsetMapping.getDisplayOptionEnum(option);
        if (newDisplayOption != null && newDisplayOption != displayOption) {
            Integer oldDisplayOption = displayOption;
            displayOption = newDisplayOption;
            CharsetMapping.updateInternalState();
            propSupport.firePropertyChange(CHARSET_DISPLAY_TYPE, oldDisplayOption, displayOption);
        }
    }

    private static void updateInternalState() {
        if (displayOption == CHARSET_CANONICAL) {
            useAliases = false;
            if (sortedCanonicalCharsetMappings == null) {
                sortedCanonicalCharsetMappings = CharsetMapping.getSortedCanonicalCharsetMappings();
            }
            Collection mappings = sortedCanonicalCharsetMappings.values();
            Iterator iter = mappings.iterator();
            while (iter.hasNext()) {
                CharsetMapping mapping = (CharsetMapping)iter.next();
                mapping.showAliases = false;
                mapping.updateDisplayText();
            }
        } else if (displayOption == CHARSET_ALIAS_ASIDE) {
            useAliases = false;
            if (sortedCanonicalCharsetMappings == null) {
                sortedCanonicalCharsetMappings = CharsetMapping.getSortedCanonicalCharsetMappings();
            }
            Collection mappings = sortedCanonicalCharsetMappings.values();
            Iterator iter = mappings.iterator();
            while (iter.hasNext()) {
                CharsetMapping mapping = (CharsetMapping)iter.next();
                mapping.showAliases = true;
                mapping.updateDisplayText();
            }
        } else if (displayOption == CHARSET_ALIAS_SELECTION) {
            useAliases = true;
        }
    }

    public static Integer getDisplayOption() {
        return displayOption;
    }

    private static Integer getDisplayOptionEnum(Integer option) {
        Integer result = null;
        if (option != null) {
            if (CHARSET_CANONICAL.compareTo(option) == 0) {
                result = CHARSET_CANONICAL;
            } else if (CHARSET_ALIAS_ASIDE.compareTo(option) == 0) {
                result = CHARSET_ALIAS_ASIDE;
            } else if (CHARSET_ALIAS_SELECTION.compareTo(option) == 0) {
                result = CHARSET_ALIAS_SELECTION;
            }
        }
        return result;
    }
}

