/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

public class Base64Util {
    protected static final char[] encodeBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    protected static final int[] decodeBase64 = new int[]{62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public static String encode(byte[] value) throws Exception {
        if (value == null) {
            return null;
        }
        if (value.length == 0) {
            return "";
        }
        int blockCount = value.length / 3;
        int partialBlockLength = value.length % 3;
        if (partialBlockLength != 0) {
            ++blockCount;
        }
        int encodedLength = blockCount * 4;
        StringBuffer encodedValue = new StringBuffer(encodedLength);
        int idx = 0;
        for (int i = 0; i < blockCount; ++i) {
            int b3;
            int b1 = value[idx++];
            int b2 = idx < value.length ? value[idx++] : 0;
            int n = b3 = idx < value.length ? value[idx++] : 0;
            if (b1 < 0) {
                b1 += 256;
            }
            if (b2 < 0) {
                b2 += 256;
            }
            if (b3 < 0) {
                b3 += 256;
            }
            char encodedChar = encodeBase64[b1 >> 2];
            encodedValue.append(encodedChar);
            encodedChar = encodeBase64[(b1 & 3) << 4 | b2 >> 4];
            encodedValue.append(encodedChar);
            encodedChar = encodeBase64[(b2 & 0xF) << 2 | b3 >> 6];
            encodedValue.append(encodedChar);
            encodedChar = encodeBase64[b3 & 0x3F];
            encodedValue.append(encodedChar);
        }
        switch (partialBlockLength) {
            case 0: {
                break;
            }
            case 1: {
                encodedValue.setCharAt(encodedLength - 1, '=');
                encodedValue.setCharAt(encodedLength - 2, '=');
                break;
            }
            case 2: {
                encodedValue.setCharAt(encodedLength - 1, '=');
            }
        }
        return encodedValue.toString();
    }
}

