/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.java.j2seproject.SourceRoots;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.modules.java.j2seproject.classpath.ClassPathSupport;
import org.netbeans.modules.java.j2seproject.ui.customizer.ClassPathUiSupport;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEClassPathUi;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SESourceRootsUi;
import org.netbeans.modules.java.j2seproject.ui.customizer.PlatformUiSupport;
import org.netbeans.modules.websvc.api.jaxws.project.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public class J2SEProjectProperties {
    private static final Integer BOOLEAN_KIND_TF;
    private static final Integer BOOLEAN_KIND_YN;
    private static final Integer BOOLEAN_KIND_ED;
    private Integer javacDebugBooleanKind;
    private Integer javadocPreviewBooleanKind;
    public static final String J2SE_PROJECT_NAME = "j2se.project.name";
    public static final String JAVA_PLATFORM = "platform.active";
    public static final String DIST_DIR = "dist.dir";
    public static final String DIST_JAR = "dist.jar";
    public static final String JAVAC_CLASSPATH = "javac.classpath";
    public static final String RUN_CLASSPATH = "run.classpath";
    public static final String RUN_JVM_ARGS = "run.jvmargs";
    public static final String RUN_WORK_DIR = "work.dir";
    public static final String DEBUG_CLASSPATH = "debug.classpath";
    public static final String JAR_COMPRESS = "jar.compress";
    public static final String MAIN_CLASS = "main.class";
    public static final String JAVAC_SOURCE = "javac.source";
    public static final String JAVAC_TARGET = "javac.target";
    public static final String JAVAC_TEST_CLASSPATH = "javac.test.classpath";
    public static final String JAVAC_DEBUG = "javac.debug";
    public static final String JAVAC_DEPRECATION = "javac.deprecation";
    public static final String JAVAC_COMPILER_ARG = "javac.compilerargs";
    public static final String RUN_TEST_CLASSPATH = "run.test.classpath";
    public static final String BUILD_DIR = "build.dir";
    public static final String BUILD_CLASSES_DIR = "build.classes.dir";
    public static final String BUILD_TEST_CLASSES_DIR = "build.test.classes.dir";
    public static final String BUILD_TEST_RESULTS_DIR = "build.test.results.dir";
    public static final String BUILD_CLASSES_EXCLUDES = "build.classes.excludes";
    public static final String DIST_JAVADOC_DIR = "dist.javadoc.dir";
    public static final String NO_DEPENDENCIES = "no.dependencies";
    public static final String DEBUG_TEST_CLASSPATH = "debug.test.classpath";
    public static final String JAVADOC_PRIVATE = "javadoc.private";
    public static final String JAVADOC_NO_TREE = "javadoc.notree";
    public static final String JAVADOC_USE = "javadoc.use";
    public static final String JAVADOC_NO_NAVBAR = "javadoc.nonavbar";
    public static final String JAVADOC_NO_INDEX = "javadoc.noindex";
    public static final String JAVADOC_SPLIT_INDEX = "javadoc.splitindex";
    public static final String JAVADOC_AUTHOR = "javadoc.author";
    public static final String JAVADOC_VERSION = "javadoc.version";
    public static final String JAVADOC_WINDOW_TITLE = "javadoc.windowtitle";
    public static final String JAVADOC_ENCODING = "javadoc.encoding";
    public static final String JAVADOC_ADDITIONALPARAM = "javadoc.additionalparam";
    public static final String APPLICATION_ARGS = "application.args";
    public static final String JAVADOC_PREVIEW = "javadoc.preview";
    public static final String[] WELL_KNOWN_PATHS;
    public static final String LIBRARY_PREFIX = "${libs.";
    public static final String LIBRARY_SUFFIX = ".classpath}";
    public static final String ANT_ARTIFACT_PREFIX = "${reference.";
    ClassPathSupport cs;
    DefaultTableModel SOURCE_ROOTS_MODEL;
    DefaultTableModel TEST_ROOTS_MODEL;
    ComboBoxModel JAVAC_SOURCE_MODEL;
    DefaultListModel JAVAC_CLASSPATH_MODEL;
    DefaultListModel JAVAC_TEST_CLASSPATH_MODEL;
    DefaultListModel RUN_CLASSPATH_MODEL;
    DefaultListModel RUN_TEST_CLASSPATH_MODEL;
    ComboBoxModel PLATFORM_MODEL;
    ListCellRenderer CLASS_PATH_LIST_RENDERER;
    ListCellRenderer PLATFORM_LIST_RENDERER;
    ListCellRenderer JAVAC_SOURCE_RENDERER;
    ButtonModel JAVAC_DEPRECATION_MODEL;
    ButtonModel JAVAC_DEBUG_MODEL;
    ButtonModel NO_DEPENDENCIES_MODEL;
    Document JAVAC_COMPILER_ARG_MODEL;
    Document DIST_JAR_MODEL;
    Document BUILD_CLASSES_EXCLUDES_MODEL;
    ButtonModel JAR_COMPRESS_MODEL;
    ButtonModel JAVADOC_PRIVATE_MODEL;
    ButtonModel JAVADOC_NO_TREE_MODEL;
    ButtonModel JAVADOC_USE_MODEL;
    ButtonModel JAVADOC_NO_NAVBAR_MODEL;
    ButtonModel JAVADOC_NO_INDEX_MODEL;
    ButtonModel JAVADOC_SPLIT_INDEX_MODEL;
    ButtonModel JAVADOC_AUTHOR_MODEL;
    ButtonModel JAVADOC_VERSION_MODEL;
    Document JAVADOC_WINDOW_TITLE_MODEL;
    ButtonModel JAVADOC_PREVIEW_MODEL;
    Document JAVADOC_ADDITIONALPARAM_MODEL;
    Document MAIN_CLASS_MODEL;
    Document APPLICATION_ARGS_MODEL;
    Document RUN_JVM_ARGS_MODEL;
    Document RUN_WORK_DIR_MODEL;
    private J2SEProject project;
    private HashMap properties;
    private UpdateHelper updateHelper;
    private PropertyEvaluator evaluator;
    private ReferenceHelper refHelper;
    private GeneratedFilesHelper genFileHelper;
    private StoreGroup privateGroup;
    private StoreGroup projectGroup;
    private Properties additionalProperties;
    static /* synthetic */ Class class$org$netbeans$modules$java$j2seproject$J2SEProject;
    static final /* synthetic */ boolean $assertionsDisabled;

    J2SEProject getProject() {
        return this.project;
    }

    public J2SEProjectProperties(J2SEProject project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper, GeneratedFilesHelper genFileHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
        this.genFileHelper = genFileHelper;
        this.cs = new ClassPathSupport(evaluator, refHelper, updateHelper.getAntProjectHelper(), WELL_KNOWN_PATHS, LIBRARY_PREFIX, LIBRARY_SUFFIX, ANT_ARTIFACT_PREFIX);
        this.privateGroup = new StoreGroup();
        this.projectGroup = new StoreGroup();
        this.additionalProperties = new Properties();
        this.init();
    }

    private void init() {
        this.CLASS_PATH_LIST_RENDERER = new J2SEClassPathUi.ClassPathListCellRenderer(this.evaluator);
        this.SOURCE_ROOTS_MODEL = J2SESourceRootsUi.createModel(this.project.getSourceRoots());
        this.TEST_ROOTS_MODEL = J2SESourceRootsUi.createModel(this.project.getTestSourceRoots());
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        this.JAVAC_CLASSPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator((String)projectProperties.get((Object)JAVAC_CLASSPATH)));
        this.JAVAC_TEST_CLASSPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator((String)projectProperties.get((Object)JAVAC_TEST_CLASSPATH)));
        this.RUN_CLASSPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator((String)projectProperties.get((Object)RUN_CLASSPATH)));
        this.RUN_TEST_CLASSPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator((String)projectProperties.get((Object)RUN_TEST_CLASSPATH)));
        this.PLATFORM_MODEL = PlatformUiSupport.createPlatformComboBoxModel(this.evaluator.getProperty(JAVA_PLATFORM));
        this.PLATFORM_LIST_RENDERER = PlatformUiSupport.createPlatformListCellRenderer();
        this.JAVAC_SOURCE_MODEL = PlatformUiSupport.createSourceLevelComboBoxModel(this.PLATFORM_MODEL, this.evaluator.getProperty(JAVAC_SOURCE));
        this.JAVAC_SOURCE_RENDERER = PlatformUiSupport.createSourceLevelListCellRenderer();
        this.JAVAC_DEPRECATION_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVAC_DEPRECATION);
        Integer[] kind = new Integer[1];
        this.JAVAC_DEBUG_MODEL = J2SEProjectProperties.createToggleButtonModel(this.evaluator, JAVAC_DEBUG, kind);
        this.javacDebugBooleanKind = kind[0];
        this.NO_DEPENDENCIES_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, NO_DEPENDENCIES);
        this.JAVAC_COMPILER_ARG_MODEL = this.projectGroup.createStringDocument(this.evaluator, JAVAC_COMPILER_ARG);
        this.DIST_JAR_MODEL = this.projectGroup.createStringDocument(this.evaluator, DIST_JAR);
        this.BUILD_CLASSES_EXCLUDES_MODEL = this.projectGroup.createStringDocument(this.evaluator, BUILD_CLASSES_EXCLUDES);
        this.JAR_COMPRESS_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAR_COMPRESS);
        this.JAVADOC_PRIVATE_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVADOC_PRIVATE);
        this.JAVADOC_NO_TREE_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, JAVADOC_NO_TREE);
        this.JAVADOC_USE_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVADOC_USE);
        this.JAVADOC_NO_NAVBAR_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, JAVADOC_NO_NAVBAR);
        this.JAVADOC_NO_INDEX_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, JAVADOC_NO_INDEX);
        this.JAVADOC_SPLIT_INDEX_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVADOC_SPLIT_INDEX);
        this.JAVADOC_AUTHOR_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVADOC_AUTHOR);
        this.JAVADOC_VERSION_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVADOC_VERSION);
        this.JAVADOC_WINDOW_TITLE_MODEL = this.projectGroup.createStringDocument(this.evaluator, JAVADOC_WINDOW_TITLE);
        this.JAVADOC_PREVIEW_MODEL = J2SEProjectProperties.createToggleButtonModel(this.evaluator, JAVADOC_PREVIEW, kind);
        this.javadocPreviewBooleanKind = kind[0];
        this.JAVADOC_ADDITIONALPARAM_MODEL = this.projectGroup.createStringDocument(this.evaluator, JAVADOC_ADDITIONALPARAM);
        this.MAIN_CLASS_MODEL = this.projectGroup.createStringDocument(this.evaluator, MAIN_CLASS);
        this.APPLICATION_ARGS_MODEL = this.privateGroup.createStringDocument(this.evaluator, APPLICATION_ARGS);
        this.RUN_JVM_ARGS_MODEL = this.projectGroup.createStringDocument(this.evaluator, RUN_JVM_ARGS);
        this.RUN_WORK_DIR_MODEL = this.privateGroup.createStringDocument(this.evaluator, RUN_WORK_DIR);
    }

    public void save() {
        try {
            Boolean result = (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){
                final FileObject projectDir;
                {
                    this.projectDir = J2SEProjectProperties.this.updateHelper.getAntProjectHelper().getProjectDirectory();
                }

                public Object run() throws IOException {
                    if ((J2SEProjectProperties.this.genFileHelper.getBuildScriptState("nbproject/build-impl.xml", (class$org$netbeans$modules$java$j2seproject$J2SEProject == null ? (class$org$netbeans$modules$java$j2seproject$J2SEProject = J2SEProjectProperties.class$("org.netbeans.modules.java.j2seproject.J2SEProject")) : class$org$netbeans$modules$java$j2seproject$J2SEProject).getResource("resources/build-impl.xsl"), J2SEProjectProperties.this.findJaxWsFileObject(this.projectDir)) & 4) == 4) {
                        if (J2SEProjectProperties.showModifiedMessage(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$customizer$J2SEProjectProperties == null ? (class$org$netbeans$modules$java$j2seproject$ui$customizer$J2SEProjectProperties = J2SEProjectProperties.class$("org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties")) : class$org$netbeans$modules$java$j2seproject$ui$customizer$J2SEProjectProperties), (String)"TXT_ModifiedTitle"))) {
                            FileObject fo = this.projectDir.getFileObject("nbproject/build-impl.xml");
                            if (fo != null) {
                                fo.delete();
                            }
                        } else {
                            return Boolean.FALSE;
                        }
                    }
                    J2SEProjectProperties.this.storeProperties();
                    return Boolean.TRUE;
                }
            });
            if (result == Boolean.TRUE) {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((Throwable)((IOException)e.getException()));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private void storeProperties() throws IOException {
        this.resolveProjectDependencies();
        String[] javac_cp = this.cs.encodeToStrings(ClassPathUiSupport.getIterator(this.JAVAC_CLASSPATH_MODEL));
        String[] javac_test_cp = this.cs.encodeToStrings(ClassPathUiSupport.getIterator(this.JAVAC_TEST_CLASSPATH_MODEL));
        String[] run_cp = this.cs.encodeToStrings(ClassPathUiSupport.getIterator(this.RUN_CLASSPATH_MODEL));
        String[] run_test_cp = this.cs.encodeToStrings(ClassPathUiSupport.getIterator(this.RUN_TEST_CLASSPATH_MODEL));
        this.storeRoots(this.project.getSourceRoots(), this.SOURCE_ROOTS_MODEL);
        this.storeRoots(this.project.getTestSourceRoots(), this.TEST_ROOTS_MODEL);
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        EditableProperties privateProperties = this.updateHelper.getProperties("nbproject/private/private.properties");
        if (!this.JAVADOC_NO_INDEX_MODEL.isSelected()) {
            this.JAVADOC_SPLIT_INDEX_MODEL.setSelected(false);
        }
        this.projectGroup.store(projectProperties);
        this.privateGroup.store(privateProperties);
        privateProperties.setProperty(JAVAC_DEBUG, J2SEProjectProperties.encodeBoolean(this.JAVAC_DEBUG_MODEL.isSelected(), this.javacDebugBooleanKind));
        privateProperties.setProperty(JAVADOC_PREVIEW, J2SEProjectProperties.encodeBoolean(this.JAVADOC_PREVIEW_MODEL.isSelected(), this.javadocPreviewBooleanKind));
        projectProperties.setProperty(JAVAC_CLASSPATH, javac_cp);
        projectProperties.setProperty(JAVAC_TEST_CLASSPATH, javac_test_cp);
        projectProperties.setProperty(RUN_CLASSPATH, run_cp);
        projectProperties.setProperty(RUN_TEST_CLASSPATH, run_test_cp);
        PlatformUiSupport.storePlatform(projectProperties, this.updateHelper, this.PLATFORM_MODEL.getSelectedItem(), this.JAVAC_SOURCE_MODEL.getSelectedItem());
        if (this.NO_DEPENDENCIES_MODEL.isSelected()) {
            projectProperties.remove((Object)NO_DEPENDENCIES);
        }
        if (J2SEProjectProperties.getDocumentText(this.RUN_WORK_DIR_MODEL).trim().equals("")) {
            privateProperties.remove((Object)RUN_WORK_DIR);
        }
        this.storeAdditionalProperties(projectProperties);
        this.updateHelper.putProperties("nbproject/project.properties", projectProperties);
        this.updateHelper.putProperties("nbproject/private/private.properties", privateProperties);
    }

    private void storeAdditionalProperties(EditableProperties projectProperties) {
        Iterator<Object> i = this.additionalProperties.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            projectProperties.put(key, this.additionalProperties.get(key));
        }
    }

    private static String getDocumentText(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private void resolveProjectDependencies() {
        HashSet oldArtifacts = new HashSet();
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        oldArtifacts.addAll(this.cs.itemsList((String)projectProperties.get((Object)JAVAC_CLASSPATH)));
        oldArtifacts.addAll(this.cs.itemsList((String)projectProperties.get((Object)JAVAC_TEST_CLASSPATH)));
        oldArtifacts.addAll(this.cs.itemsList((String)projectProperties.get((Object)RUN_CLASSPATH)));
        oldArtifacts.addAll(this.cs.itemsList((String)projectProperties.get((Object)RUN_TEST_CLASSPATH)));
        HashSet newArtifacts = new HashSet();
        newArtifacts.addAll(ClassPathUiSupport.getList(this.JAVAC_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.JAVAC_TEST_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.RUN_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.RUN_TEST_CLASSPATH_MODEL));
        HashSet removed = new HashSet(oldArtifacts);
        removed.removeAll(newArtifacts);
        HashSet added = new HashSet(newArtifacts);
        added.removeAll(oldArtifacts);
        Iterator it = removed.iterator();
        while (it.hasNext()) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)it.next();
            if (item.getType() != 2 && item.getType() != 0) continue;
            this.refHelper.destroyReference(item.getReference());
        }
        EditableProperties ep = this.updateHelper.getProperties("nbproject/project.properties");
        boolean changed = false;
        Iterator it2 = removed.iterator();
        while (it2.hasNext()) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)it2.next();
            if (item.getType() != 1) continue;
            String prop = item.getReference();
            prop = prop.substring(2, prop.length() - 1);
            ep.remove((Object)prop);
            changed = true;
        }
        File projDir = FileUtil.toFile((FileObject)this.updateHelper.getAntProjectHelper().getProjectDirectory());
        Iterator it3 = added.iterator();
        while (it3.hasNext()) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)it3.next();
            if (item.getType() != 1 || item.isBroken()) continue;
            String prop = this.cs.getLibraryReference(item);
            String value = this.relativizeLibraryClasspath(prop = prop.substring(2, prop.length() - 1), projDir);
            if (value == null) continue;
            ep.setProperty(prop, value);
            ep.setComment(prop, new String[]{"# Property " + prop + " is set here just to make sharing of project simpler.", "# The library definition has always preference over this property."}, false);
            changed = true;
        }
        if (changed) {
            this.updateHelper.putProperties("nbproject/project.properties", ep);
        }
    }

    private String relativizeLibraryClasspath(String property, File projectDir) {
        String value = PropertyUtils.getGlobalProperties().getProperty(property);
        if (value == null) {
            return null;
        }
        String[] paths = PropertyUtils.tokenizePath((String)value);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            File f = this.updateHelper.getAntProjectHelper().resolveFile(paths[i]);
            if (!CollocationQuery.areCollocated((File)f, (File)projectDir)) {
                return null;
            }
            sb.append(PropertyUtils.relativizeFile((File)projectDir, (File)f));
            if (i + 1 >= paths.length) continue;
            sb.append(File.pathSeparatorChar);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private void storeRoots(SourceRoots roots, DefaultTableModel tableModel) throws MalformedURLException {
        Vector<Vector> data = tableModel.getDataVector();
        URL[] rootURLs = new URL[data.size()];
        String[] rootLabels = new String[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            File f = (File)data.elementAt(i).elementAt(0);
            rootURLs[i] = J2SEProjectUtil.getRootURL(f, null);
            rootLabels[i] = (String)data.elementAt(i).elementAt(1);
        }
        roots.putRoots(rootURLs, rootLabels);
    }

    public static String getAntPropertyName(String property) {
        if (property != null && property.startsWith("${") && property.endsWith("}")) {
            return property.substring(2, property.length() - 1);
        }
        return property;
    }

    public void putAdditionalProperty(String propertyName, String propertyValue) {
        this.additionalProperties.setProperty(propertyName, propertyValue);
    }

    private static boolean showModifiedMessage(String title) {
        String message = NbBundle.getMessage((Class)J2SEProjectProperties.class, (String)"TXT_Regenerate");
        JButton regenerateButton = new JButton(NbBundle.getMessage((Class)J2SEProjectProperties.class, (String)"CTL_RegenerateButton"));
        regenerateButton.setDefaultCapable(true);
        regenerateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)J2SEProjectProperties.class, (String)"AD_RegenerateButton"));
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)message, 2);
        d.setTitle(title);
        d.setOptionType(2);
        d.setOptions(new Object[]{regenerateButton, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == regenerateButton;
    }

    private static String encodeBoolean(boolean value, Integer kind) {
        if (kind == BOOLEAN_KIND_ED) {
            return value ? "on" : "off";
        }
        if (kind == BOOLEAN_KIND_YN) {
            return value ? "yes" : "no";
        }
        return value ? "true" : "false";
    }

    private static JToggleButton.ToggleButtonModel createToggleButtonModel(PropertyEvaluator evaluator, String propName, Integer[] kind) {
        if (!($assertionsDisabled || evaluator != null && propName != null && kind != null && kind.length == 1)) {
            throw new AssertionError();
        }
        String value = evaluator.getProperty(propName);
        boolean isSelected = false;
        if (value == null) {
            isSelected = true;
        } else {
            String lowercaseValue = value.toLowerCase();
            kind[0] = lowercaseValue.equals("yes") || lowercaseValue.equals("no") ? BOOLEAN_KIND_YN : (lowercaseValue.equals("on") || lowercaseValue.equals("off") ? BOOLEAN_KIND_ED : BOOLEAN_KIND_TF);
            if (lowercaseValue.equals("true") || lowercaseValue.equals("yes") || lowercaseValue.equals("on")) {
                isSelected = true;
            }
        }
        JToggleButton.ToggleButtonModel bm = new JToggleButton.ToggleButtonModel();
        bm.setSelected(isSelected);
        return bm;
    }

    private FileObject findJaxWsFileObject(FileObject projectDir) {
        return projectDir.getFileObject("nbproject/jax-ws.xml");
    }

    static {
        $assertionsDisabled = !J2SEProjectProperties.class.desiredAssertionStatus();
        BOOLEAN_KIND_TF = new Integer(0);
        BOOLEAN_KIND_YN = new Integer(1);
        BOOLEAN_KIND_ED = new Integer(2);
        WELL_KNOWN_PATHS = new String[]{"${javac.classpath}", "${javac.test.classpath}", "${run.classpath}", "${run.test.classpath}", "${build.classes.dir}", "${build.test.classes.dir}"};
    }
}

