/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.modules.java.j2seproject.classpath.ClassPathSupport;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class J2SEProjectClassPathExtender
implements ProjectClassPathExtender {
    private static final String CP_CLASS_PATH = "javac.classpath";
    private Project project;
    private UpdateHelper helper;
    private ReferenceHelper refHelper;
    private PropertyEvaluator eval;
    private ClassPathSupport cs;
    static final /* synthetic */ boolean $assertionsDisabled;

    public J2SEProjectClassPathExtender(Project project, UpdateHelper helper, PropertyEvaluator eval, ReferenceHelper refHelper) {
        this.project = project;
        this.helper = helper;
        this.eval = eval;
        this.refHelper = refHelper;
        this.cs = new ClassPathSupport(eval, refHelper, helper.getAntProjectHelper(), J2SEProjectProperties.WELL_KNOWN_PATHS, "${libs.", ".classpath}", "${reference.");
    }

    public boolean addLibrary(Library library) throws IOException {
        return this.addLibrary(CP_CLASS_PATH, library);
    }

    public boolean addLibrary(final String classPathId, final Library library) throws IOException {
        if (!$assertionsDisabled && library == null) {
            throw new AssertionError((Object)"Parameter cannot be null");
        }
        try {
            return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    ClassPathSupport.Item item;
                    EditableProperties props = J2SEProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathId);
                    List resources = J2SEProjectClassPathExtender.this.cs.itemsList(raw);
                    if (!resources.contains(item = ClassPathSupport.Item.create(library, null))) {
                        resources.add(item);
                        String[] itemRefs = J2SEProjectClassPathExtender.this.cs.encodeToStrings(resources.iterator());
                        props = J2SEProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathId, itemRefs);
                        J2SEProjectClassPathExtender.this.helper.putProperties("nbproject/project.properties", props);
                        ProjectManager.getDefault().saveProject(J2SEProjectClassPathExtender.this.project);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public boolean addArchiveFile(FileObject archiveFile) throws IOException {
        return this.addArchiveFile(CP_CLASS_PATH, archiveFile);
    }

    public boolean addArchiveFile(final String classPathId, final FileObject archiveFile) throws IOException {
        if (!$assertionsDisabled && archiveFile == null) {
            throw new AssertionError((Object)"Parameter cannot be null");
        }
        try {
            return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    EditableProperties props = J2SEProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathId);
                    List resources = J2SEProjectClassPathExtender.this.cs.itemsList(raw);
                    File f = FileUtil.toFile((FileObject)archiveFile);
                    if (f == null) {
                        throw new IllegalArgumentException("The file must exist on disk");
                    }
                    ClassPathSupport.Item item = ClassPathSupport.Item.create(f, null);
                    if (!resources.contains(item)) {
                        resources.add(item);
                        String[] itemRefs = J2SEProjectClassPathExtender.this.cs.encodeToStrings(resources.iterator());
                        props = J2SEProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathId, itemRefs);
                        J2SEProjectClassPathExtender.this.helper.putProperties("nbproject/project.properties", props);
                        ProjectManager.getDefault().saveProject(J2SEProjectClassPathExtender.this.project);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException t = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)t, (Throwable)e);
        }
    }

    public boolean addAntArtifact(AntArtifact artifact, URI artifactElement) throws IOException {
        return this.addAntArtifact(CP_CLASS_PATH, artifact, artifactElement);
    }

    public boolean addAntArtifact(final String classPathId, final AntArtifact artifact, final URI artifactElement) throws IOException {
        if (!$assertionsDisabled && artifact == null) {
            throw new AssertionError((Object)"Parameter cannot be null");
        }
        try {
            return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    ClassPathSupport.Item item;
                    EditableProperties props = J2SEProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathId);
                    List resources = J2SEProjectClassPathExtender.this.cs.itemsList(raw);
                    if (!resources.contains(item = ClassPathSupport.Item.create(artifact, artifactElement, null))) {
                        resources.add(item);
                        String[] itemRefs = J2SEProjectClassPathExtender.this.cs.encodeToStrings(resources.iterator());
                        props = J2SEProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathId, itemRefs);
                        J2SEProjectClassPathExtender.this.helper.putProperties("nbproject/project.properties", props);
                        ProjectManager.getDefault().saveProject(J2SEProjectClassPathExtender.this.project);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException t = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)t, (Throwable)e);
        }
    }

    static {
        $assertionsDisabled = !J2SEProjectClassPathExtender.class.desiredAssertionStatus();
    }
}

