/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.File;
import java.io.IOException;
import java.util.Stack;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class J2SEProjectGenerator {
    static final String MINIMUM_ANT_VERSION = "1.6.5";
    private static SpecificationVersion defaultSourceLevel;
    static final /* synthetic */ boolean $assertionsDisabled;

    private J2SEProjectGenerator() {
    }

    public static AntProjectHelper createProject(File dir, String name, String mainClass, String manifestFile) throws IOException {
        FileObject dirFO = J2SEProjectGenerator.createProjectDir(dir);
        AntProjectHelper h = J2SEProjectGenerator.createProject(dirFO, name, "src", "test", mainClass, manifestFile, manifestFile == null);
        Project p = ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject(p);
        FileObject srcFolder = dirFO.createFolder("src");
        dirFO.createFolder("test");
        if (mainClass != null) {
            J2SEProjectGenerator.createMainClass(mainClass, srcFolder);
        }
        return h;
    }

    public static AntProjectHelper createProject(File dir, final String name, final File[] sourceFolders, final File[] testFolders, String manifestFile) throws IOException {
        if (!($assertionsDisabled || sourceFolders != null && testFolders != null)) {
            throw new AssertionError((Object)"Package roots can't be null");
        }
        FileObject dirFO = J2SEProjectGenerator.createProjectDir(dir);
        final AntProjectHelper h = J2SEProjectGenerator.createProject(dirFO, name, null, null, null, manifestFile, false);
        final J2SEProject p = (J2SEProject)ProjectManager.getDefault().findProject(dirFO);
        final ReferenceHelper refHelper = p.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public Object run() throws Exception {
                    Element root;
                    EditableProperties props;
                    int rootIndex;
                    String propName;
                    int i;
                    Element data = h.getPrimaryConfigurationData(true);
                    Document doc = data.getOwnerDocument();
                    NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
                    if (!$assertionsDisabled && nl.getLength() != 1) {
                        throw new AssertionError();
                    }
                    Element sourceRoots = (Element)nl.item(0);
                    nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
                    if (!$assertionsDisabled && nl.getLength() != 1) {
                        throw new AssertionError();
                    }
                    Element testRoots = (Element)nl.item(0);
                    for (i = 0; i < sourceFolders.length; ++i) {
                        if (i == 0) {
                            propName = "src.dir";
                        } else {
                            String name2 = sourceFolders[i].getName();
                            propName = name2 + ".dir";
                        }
                        rootIndex = 1;
                        props = h.getProperties("nbproject/project.properties");
                        while (props.containsKey((Object)propName)) {
                            propName = name + ++rootIndex + ".dir";
                        }
                        String srcReference = refHelper.createForeignFileReference(sourceFolders[i], "java");
                        root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                        root.setAttribute("id", propName);
                        sourceRoots.appendChild(root);
                        props = h.getProperties("nbproject/project.properties");
                        props.put((Object)propName, (Object)srcReference);
                        h.putProperties("nbproject/project.properties", props);
                    }
                    for (i = 0; i < testFolders.length; ++i) {
                        if (!testFolders[i].exists()) {
                            testFolders[i].mkdirs();
                        }
                        if (i == 0) {
                            propName = "test.src.dir";
                        } else {
                            String name3 = testFolders[i].getName();
                            propName = "test." + name3 + ".dir";
                        }
                        rootIndex = 1;
                        props = h.getProperties("nbproject/project.properties");
                        while (props.containsKey((Object)propName)) {
                            propName = "test." + name + ++rootIndex + ".dir";
                        }
                        String testReference = refHelper.createForeignFileReference(testFolders[i], "java");
                        root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                        root.setAttribute("id", propName);
                        testRoots.appendChild(root);
                        props = h.getProperties("nbproject/project.properties");
                        props.put((Object)propName, (Object)testReference);
                        h.putProperties("nbproject/project.properties", props);
                    }
                    h.putPrimaryConfigurationData(data, true);
                    ProjectManager.getDefault().saveProject((Project)p);
                    return null;
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$modules$java$j2seproject$J2SEProjectGenerator == null ? (class$org$netbeans$modules$java$j2seproject$J2SEProjectGenerator = J2SEProjectGenerator.class$("org.netbeans.modules.java.j2seproject.J2SEProjectGenerator")) : class$org$netbeans$modules$java$j2seproject$J2SEProjectGenerator).desiredAssertionStatus();
                }
            });
        }
        catch (MutexException me) {
            ErrorManager.getDefault().notify((Throwable)me);
        }
        return h;
    }

    private static AntProjectHelper createProject(FileObject dirFO, String name, String srcRoot, String testRoot, String mainClass, String manifestFile, boolean isLibrary) throws IOException {
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.java.j2seproject");
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        Element minant = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "minimum-ant-version");
        minant.appendChild(doc.createTextNode(MINIMUM_ANT_VERSION));
        data.appendChild(minant);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "src.dir");
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
        if (testRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "test.src.dir");
            testRoots.appendChild(root);
            ep.setProperty("test.src.dir", testRoot);
        }
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        ep.setProperty("dist.dir", "dist");
        ep.setComment("dist.dir", new String[]{"# " + NbBundle.getMessage((Class)J2SEProjectGenerator.class, (String)"COMMENT_dist.dir")}, false);
        ep.setProperty("dist.jar", "${dist.dir}/" + PropertyUtils.getUsablePropertyName((String)name) + ".jar");
        ep.setProperty("javac.classpath", new String[0]);
        ep.setProperty("build.sysclasspath", "ignore");
        ep.setComment("build.sysclasspath", new String[]{"# " + NbBundle.getMessage((Class)J2SEProjectGenerator.class, (String)"COMMENT_build.sysclasspath")}, false);
        ep.setProperty("run.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}"});
        ep.setProperty("debug.classpath", new String[]{"${run.classpath}"});
        ep.setProperty("application.args", "");
        ep.setProperty("jar.compress", "false");
        if (!isLibrary) {
            ep.setProperty("main.class", mainClass == null ? "" : mainClass);
        }
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage((Class)J2SEProjectGenerator.class, (String)"COMMENT_javac.compilerargs")}, false);
        SpecificationVersion sourceLevel = J2SEProjectGenerator.getDefaultSourceLevel();
        ep.setProperty("javac.source", sourceLevel.toString());
        ep.setProperty("javac.target", sourceLevel.toString());
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}:", "${libs.junit.classpath}"});
        ep.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        ep.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("meta.inf.dir", "${src.dir}/META-INF");
        ep.setProperty("build.dir", "build");
        ep.setComment("build.dir", new String[]{"# " + NbBundle.getMessage((Class)J2SEProjectGenerator.class, (String)"COMMENT_build.dir")}, false);
        ep.setProperty("build.classes.dir", "${build.dir}/classes");
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("platform.active", "default_platform");
        ep.setProperty("run.jvmargs", "");
        ep.setComment("run.jvmargs", new String[]{"# " + NbBundle.getMessage((Class)J2SEProjectGenerator.class, (String)"COMMENT_run.jvmargs"), "# " + NbBundle.getMessage((Class)J2SEProjectGenerator.class, (String)"COMMENT_run.jvmargs_2"), "# " + NbBundle.getMessage((Class)J2SEProjectGenerator.class, (String)"COMMENT_run.jvmargs_3")}, false);
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "");
        ep.setProperty("javadoc.additionalparam", "");
        if (manifestFile != null) {
            ep.setProperty("manifest.file", manifestFile);
        }
        h.putProperties("nbproject/project.properties", ep);
        ep = h.getProperties("nbproject/private/private.properties");
        ep.setProperty("application.args", "");
        ep.setProperty("javac.debug", "true");
        ep.setProperty("javadoc.preview", "true");
        h.putProperties("nbproject/private/private.properties", ep);
        return h;
    }

    private static FileObject createProjectDir(File dir) throws IOException {
        Stack<String> stack = new Stack<String>();
        while (!dir.exists()) {
            stack.push(dir.getName());
            dir = dir.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)dir);
        if (dirFO == null) {
            J2SEProjectGenerator.refreshFileSystem(dir);
            dirFO = FileUtil.toFileObject((File)dir);
        }
        if (!$assertionsDisabled && dirFO == null) {
            throw new AssertionError();
        }
        while (!stack.isEmpty()) {
            dirFO = dirFO.createFolder((String)stack.pop());
        }
        return dirFO;
    }

    private static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File rootF = dir;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)rootF);
        if (!$assertionsDisabled && dirFO == null) {
            throw new AssertionError((Object)("At least disk roots must be mounted! " + rootF));
        }
        dirFO.getFileSystem().refresh(false);
    }

    private static void createMainClass(String mainClassName, FileObject srcFolder) throws IOException {
        String pName;
        String mName;
        int lastDotIdx = mainClassName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            mName = mainClassName.trim();
            pName = null;
        } else {
            mName = mainClassName.substring(lastDotIdx + 1).trim();
            pName = mainClassName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0) {
            return;
        }
        FileObject mainTemplate = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Classes/Main.java");
        if (mainTemplate == null) {
            return;
        }
        DataObject mt = DataObject.find((FileObject)mainTemplate);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
        }
        DataFolder pDf = DataFolder.findFolder((FileObject)pkgFolder);
        mt.createFromTemplate(pDf, mName);
    }

    private static SpecificationVersion getDefaultSourceLevel() {
        if (defaultSourceLevel != null) {
            return defaultSourceLevel;
        }
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        return defaultPlatform.getSpecification().getVersion();
    }

    public static void setDefaultSourceLevel(SpecificationVersion version) {
        defaultSourceLevel = version;
    }

    static {
        $assertionsDisabled = !J2SEProjectGenerator.class.desiredAssertionStatus();
    }
}

