/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.openide.util.Enumerations;

final class AuxClassLoader
extends AntBridge.AllPermissionURLClassLoader {
    private final ClassLoader nbLoader;

    private static boolean masked(String name) {
        return name.startsWith("org.apache.tools.") && !name.startsWith("org.apache.tools.ant.module.");
    }

    public AuxClassLoader(ClassLoader nbLoader, ClassLoader antLoader, URL extraJar) {
        super(new URL[]{extraJar}, antLoader);
        this.nbLoader = nbLoader;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (!AuxClassLoader.masked(name)) {
            try {
                return this.nbLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.findClass(name);
    }

    public URL findResource(String name) {
        URL u;
        if (!AuxClassLoader.masked(name) && (u = this.nbLoader.getResource(name)) != null) {
            return u;
        }
        return super.findResource(name);
    }

    public Enumeration findResources(String name) throws IOException {
        return Enumerations.removeDuplicates((Enumeration)Enumerations.concat(this.nbLoader.getResources(name), (Enumeration)super.findResources(name)));
    }
}

