/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.netbeans.modules.tasklist.core.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.core.filter.FilterCondition;
import org.netbeans.modules.tasklist.core.filter.SuggestionProperty;
import org.openide.util.NbBundle;

public abstract class Filter {
    private boolean allTrue = false;
    private List appliedConditions = null;
    private String name = null;
    private boolean flattened;
    private PropertyChangeSupport pcs = null;
    private static final String NO_FILTER = NbBundle.getMessage((Class)Filter.class, (String)"no-filter");
    public static final String PROP_NAME = "PropName";
    public static final String PROP_ALLTRUE = "PropAllTrue";
    public static final String PROP_CONDITIONS = "PropConditions";
    public static final String PROP_FLATTENED = "PropFlattened";

    protected PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    protected boolean hasListeners() {
        return this.pcs != null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPCS().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPCS().removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.getPCS().addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.getPCS().removePropertyChangeListener(property, listener);
    }

    public Filter(String name) {
        this(name, true, new ArrayList(), false);
    }

    public Filter(String name, boolean allTrue, List conditions, boolean flattened) {
        this.name = name;
        this.allTrue = allTrue;
        this.appliedConditions = conditions;
        this.flattened = flattened;
    }

    protected Filter(Filter rhs) {
        this(rhs.name, rhs.allTrue, Filter.cloneConditions(rhs.appliedConditions), rhs.flattened);
    }

    protected Filter() {
        this.name = null;
        this.appliedConditions = null;
    }

    private static List cloneConditions(List conditions) {
        LinkedList<Object> l = new LinkedList<Object>();
        Iterator it = conditions.iterator();
        while (it.hasNext()) {
            l.add(((AppliedFilterCondition)it.next()).clone());
        }
        return l;
    }

    public abstract Object clone();

    public abstract AppliedFilterCondition[] createConditions(SuggestionProperty var1);

    public abstract SuggestionProperty[] getProperties();

    public void clear() {
        Vector oldc = null;
        if (this.hasListeners()) {
            oldc = new Vector(this.appliedConditions);
        }
        this.getConditions().clear();
        if (this.hasListeners()) {
            this.fireChange(PROP_CONDITIONS, oldc, Collections.EMPTY_LIST);
        }
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public void setFlattened(boolean f) {
        if (f != this.flattened) {
            this.flattened = f;
            this.fireChange(PROP_FLATTENED, !f, f);
        }
    }

    public boolean accept(Object node) {
        if (!this.hasConstraints()) {
            return true;
        }
        Iterator it = this.appliedConditions.iterator();
        boolean b = true;
        while (it.hasNext()) {
            AppliedFilterCondition acond = (AppliedFilterCondition)it.next();
            b = acond.isTrue(node);
            if (b && !this.allTrue) {
                return true;
            }
            if (b || !this.allTrue) continue;
            return false;
        }
        return b;
    }

    public boolean matchAll() {
        return this.allTrue;
    }

    public boolean hasConstraints() {
        return this.appliedConditions != null && this.appliedConditions.size() > 0;
    }

    public void setMatchAll(boolean b) {
        if (this.allTrue != b) {
            this.allTrue = b;
            this.fireChange(PROP_ALLTRUE, !b, b);
        }
    }

    public final List getConditions() {
        return this.appliedConditions;
    }

    public final void setConditions(List conditions) {
        Vector oldc = null;
        if (this.hasListeners()) {
            oldc = new Vector(conditions);
        }
        this.appliedConditions = conditions;
        if (this.hasListeners()) {
            this.fireChange(PROP_CONDITIONS, oldc, this.appliedConditions);
        }
    }

    private void fireChange(String property, Object oldv, Object newv) {
        if (this.pcs != null) {
            this.getPCS().firePropertyChange(property, oldv, newv);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldname = this.name;
        this.name = name;
        this.fireChange(PROP_NAME, oldname, name);
    }

    public String toString() {
        Iterator it = this.appliedConditions.iterator();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName() + "[name=" + this.name + ", ");
        sb.append(this.allTrue ? "ALL of the following conditions" : "ANY of the following conditions");
        sb.append(", ");
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    protected static AppliedFilterCondition[] applyConditions(SuggestionProperty property, FilterCondition[] conds) {
        if (conds == null) {
            return null;
        }
        AppliedFilterCondition[] applied = new AppliedFilterCondition[conds.length];
        for (int i = 0; i < conds.length; ++i) {
            applied[i] = new AppliedFilterCondition(property, conds[i]);
        }
        return applied;
    }

    public static class ListModelElement {
        public Filter filter;

        public ListModelElement(Filter f) {
            this.filter = f;
        }

        public String toString() {
            return this.filter != null ? this.filter.getName() : NO_FILTER;
        }

        public int hashCode() {
            return this.filter != null ? this.filter.hashCode() : 0;
        }

        public boolean equals(Object rhs) {
            if (rhs instanceof ListModelElement) {
                rhs = ((ListModelElement)rhs).filter;
            }
            return this.filter == rhs;
        }
    }
}

