/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openide.awt.Actions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class ToggleViewAction
extends BooleanStateAction
implements PropertyChangeListener,
Presenter.Menu {
    private static final long serialVersionUID = 1L;
    private boolean block;
    private String mode = "output";
    private WeakReference activated;

    public JMenuItem getMenuPresenter() {
        return new Actions.MenuItem((SystemAction)this, true);
    }

    public void setBooleanState(final boolean value) {
        super.setBooleanState(value);
        if (this.block) {
            return;
        }
        this.block = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToggleViewAction.this.toggleView(value);
                ToggleViewAction.this.block = false;
            }
        });
    }

    protected abstract TopComponent getView();

    protected boolean isViewOpened() {
        return this.getView().isOpened();
    }

    private void toggleView(boolean visible) {
        if (visible == this.isViewOpened()) {
            return;
        }
        TopComponent view = this.getView();
        WindowManager wm = WindowManager.getDefault();
        if (!visible) {
            TopComponent act;
            Mode mode = wm.findMode(view);
            if (mode != null) {
                this.mode = mode.getName();
            }
            view.close();
            if (this.activated != null && (act = (TopComponent)this.activated.get()) != null) {
                act.requestActive();
            }
        } else {
            TopComponent act = WindowManager.getDefault().getRegistry().getActivated();
            this.activated = act == null ? null : new WeakReference<TopComponent>(act);
            Mode mode = wm.findMode(this.mode);
            if (mode != null) {
                mode.dockInto(view);
            }
            view.open();
            view.requestVisible();
            view.requestActive();
        }
    }

    protected void initialize() {
        super.initialize();
        WindowManager.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.putProperty("booleanState", this.isViewOpened());
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String p = e.getPropertyName();
        if (p.equals("opened")) {
            super.setBooleanState(this.isViewOpened());
        }
    }
}

