/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;

public final class TaskTransfer
implements ExClipboard.Convertor {
    private static final Logger LOGGER = TLUtils.getLogger(TaskNode.class);
    public static final DataFlavor TODO_FLAVOR;

    public Transferable convert(final Transferable t) {
        boolean supportsString = t.isDataFlavorSupported(DataFlavor.stringFlavor);
        boolean supportsTodo = t.isDataFlavorSupported(TODO_FLAVOR);
        if (supportsString && !supportsTodo) {
            ExTransferable t2 = ExTransferable.create((Transferable)t);
            t2.put(new ExTransferable.Single(TODO_FLAVOR){

                protected Object getData() throws IOException, UnsupportedFlavorException {
                    String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                    return Task.parse(new StringReader(text));
                }
            });
            return t2;
        }
        if (!supportsString && supportsTodo) {
            ExTransferable t2 = ExTransferable.create((Transferable)t);
            t2.put(new ExTransferable.Single(DataFlavor.stringFlavor){

                protected Object getData() throws IOException, UnsupportedFlavorException {
                    Task item = (Task)t.getTransferData(TODO_FLAVOR);
                    StringWriter wr = new StringWriter();
                    Task.generate(item, wr);
                    return wr.toString();
                }
            });
            return t2;
        }
        if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            LOGGER.fine("multi selection");
            try {
                final MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                boolean allSupportTodo = mto.areDataFlavorsSupported(new DataFlavor[]{TODO_FLAVOR});
                if (allSupportTodo) {
                    LOGGER.fine("multi selection all supports todo");
                    ExTransferable t2 = ExTransferable.create((Transferable)t);
                    if (!supportsString) {
                        t2.put(new ExTransferable.Single(DataFlavor.stringFlavor){

                            protected Object getData() throws IOException, UnsupportedFlavorException {
                                StringWriter wr = new StringWriter();
                                for (int i = 0; i < mto.getCount(); ++i) {
                                    Task item = (Task)mto.getTransferData(i, TODO_FLAVOR);
                                    Task.generate(item, wr);
                                }
                                return wr.toString();
                            }
                        });
                    }
                    return t2;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return t;
    }

    static {
        LOGGER.setLevel(Level.OFF);
        TODO_FLAVOR = new DataFlavor(Task.class, NbBundle.getMessage((Class)TaskTransfer.class, (String)"LBL_todo_flavor"));
    }
}

