/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskAnnotation;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.TaskViewListener;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

public final class TaskEditorListener
implements TaskViewListener,
PropertyChangeListener {
    private transient Annotation taskMarker = null;
    private static TaskEditorListener deflt = null;

    public TaskEditorListener() {
        deflt = this;
    }

    static TaskEditorListener getDefault() {
        return deflt == null ? new TaskEditorListener() : deflt;
    }

    public void showTask(Task item, Annotation annotation) {
        this.hideTask();
        if (item == null) {
            return;
        }
        Line l = item.getLine();
        if (l != null) {
            this.taskMarker = annotation != null ? annotation : new TaskAnnotation(item);
            this.taskMarker.attach((Annotatable)l);
            l.addPropertyChangeListener((PropertyChangeListener)this);
            TaskListView view = TaskListView.getCurrent();
            if (view.getClientProperty("isSliding") == Boolean.TRUE) {
                l.show(1);
            } else {
                l.show(2);
            }
        }
    }

    public void hideTask() {
        if (this.taskMarker != null) {
            Annotatable line = this.taskMarker.getAttachedAnnotatable();
            line.removePropertyChangeListener((PropertyChangeListener)this);
            this.taskMarker.detach();
            this.taskMarker = null;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("text".equals(evt.getPropertyName())) {
            this.hideTask();
        }
    }
}

