/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.explorer.propertysheet.PSheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class DescriptionComponent
extends JComponent
implements ActionListener,
MouseListener,
Accessible {
    private static int fontHeight = -1;
    private JTextArea jta;
    private JLabel lbl;
    private JButton btn;
    private JScrollPane jsc;

    public DescriptionComponent() {
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jta = new JTextArea();
        this.jta.setLineWrap(true);
        this.jta.setWrapStyleWord(true);
        this.jta.setOpaque(false);
        this.jta.setBackground(this.getBackground());
        this.jta.setEditable(false);
        this.jta.setOpaque(false);
        this.jta.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)DescriptionComponent.class, (String)"ACS_Description"));
        this.jta.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DescriptionComponent.class, (String)"ACSD_Description"));
        this.jsc = new JScrollPane(this.jta);
        this.jsc.setHorizontalScrollBarPolicy(31);
        this.jsc.setVerticalScrollBarPolicy(21);
        this.jsc.setBorder(BorderFactory.createEmptyBorder());
        this.jsc.setViewportBorder(this.jsc.getBorder());
        this.jsc.setOpaque(false);
        this.jsc.setBackground(this.getBackground());
        this.jsc.getViewport().setOpaque(false);
        Font f = UIManager.getFont("Tree.font");
        if (f != null) {
            this.jta.setFont(f);
        }
        this.btn = new JButton();
        this.btn.addActionListener(this);
        Image help = Utilities.loadImage((String)"org/openide/resources/propertysheet/propertySheetHelp.gif", (boolean)true);
        ImageIcon helpIcon = new ImageIcon(help);
        this.btn.setIcon(helpIcon);
        this.btn.setPreferredSize(new Dimension(helpIcon.getIconWidth(), helpIcon.getIconHeight()));
        this.btn.setBorder(BorderFactory.createEmptyBorder());
        this.btn.setBorderPainted(false);
        this.btn.setFocusable(false);
        this.lbl = new JLabel("Label");
        this.lbl.setFont(new Font(this.lbl.getFont().getName(), 1, this.lbl.getFont().getSize()));
        this.add(this.jsc);
        this.add(this.lbl);
        this.add(this.btn);
        this.jta.addMouseListener(this);
        this.jsc.addMouseListener(this);
        this.lbl.addMouseListener(this);
        this.btn.addMouseListener(this);
        this.jsc.getViewport().addMouseListener(this);
    }

    public void doLayout() {
        Insets ins = this.getInsets();
        Dimension bttn = this.btn.getMinimumSize();
        Dimension lbll = this.lbl.getPreferredSize();
        int height = Math.max(bttn.height, lbll.height);
        int right = this.getWidth() - (ins.right + bttn.width);
        this.btn.setBounds(right, ins.top, bttn.width, height);
        this.lbl.setBounds(ins.left, ins.top, right, height);
        this.jsc.setBounds(ins.left, height, this.getWidth() - (ins.left + ins.right), this.getHeight() - height);
    }

    public void setDescription(String title, String txt) {
        if (title == null) {
            title = "";
        }
        if (txt == null) {
            txt = "";
        }
        this.lbl.setText(title);
        if (title.equals(txt)) {
            this.jta.setText("");
        } else {
            this.jta.setText(txt);
        }
    }

    public void setHelpEnabled(boolean val) {
        this.btn.setEnabled(val);
    }

    public void paint(Graphics g) {
        if (fontHeight == -1) {
            fontHeight = g.getFontMetrics(this.lbl.getFont()).getHeight();
        }
        super.paint(g);
    }

    public Dimension getPreferredSize() {
        Dimension d = new Dimension(super.getPreferredSize());
        if (fontHeight > 0) {
            Insets ins = this.getInsets();
            d.height = Math.max(50, Math.max(d.height, 4 * fontHeight + ins.top + ins.bottom + 12));
        } else {
            d.height = Math.min(d.height, 64);
        }
        return d;
    }

    public Dimension getMinimumSize() {
        if (fontHeight < 0) {
            return super.getMinimumSize();
        }
        Dimension d = new Dimension(4 * fontHeight, 4 * fontHeight);
        return d;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PSheet sheet = (PSheet)SwingUtilities.getAncestorOfClass(PSheet.class, this);
        if (sheet != null) {
            sheet.helpRequested();
        }
    }

    private PSheet findSheet() {
        return (PSheet)SwingUtilities.getAncestorOfClass(PSheet.class, this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        PSheet sh = this.findSheet();
        if (sh != null) {
            sh.mousePressed(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        PSheet sh = this.findSheet();
        if (sh != null) {
            sh.mousePressed(e);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (null == this.accessibleContext) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.SWING_COMPONENT;
                }
            };
            this.accessibleContext.setAccessibleName(NbBundle.getMessage((Class)DescriptionComponent.class, (String)"ACS_Description"));
            this.accessibleContext.setAccessibleDescription(NbBundle.getMessage((Class)DescriptionComponent.class, (String)"ACSD_Description"));
        }
        return this.accessibleContext;
    }
}

