/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.javacore.api.JavaModel;

public class JMIUtil {
    public static JavaClass findClass(String className, ClassPath classPath) {
        JavaClass result = (JavaClass)JMIUtil.resolveType(className, classPath);
        return result instanceof UnresolvedClass ? null : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type resolveType(String typeName, ClassPath classPath) {
        JMIUtil.beginJmiTransaction();
        try {
            JavaModel.setClassPath((ClassPath)classPath);
            Type type = JMIUtil.resolveType(typeName);
            return type;
        }
        finally {
            JMIUtil.endJmiTransaction();
        }
    }

    public static Method[] getMethods(JavaClass jc) {
        LinkedList result = new LinkedList();
        if (jc != null) {
            List features = jc.getFeatures();
            for (Object o : features) {
                if (!(o instanceof Method)) continue;
                result.add(o);
            }
        }
        return result.toArray(new Method[result.size()]);
    }

    public static void beginJmiTransaction(boolean writeAccess) {
        JavaModel.getJavaRepository().beginTrans(writeAccess);
    }

    public static void beginJmiTransaction() {
        JMIUtil.beginJmiTransaction(false);
    }

    public static void endJmiTransaction(boolean rollback) {
        JavaModel.getJavaRepository().endTrans(rollback);
    }

    public static void endJmiTransaction() {
        JMIUtil.endJmiTransaction(false);
    }

    public static Type resolveType(String typeName) {
        Type basicType;
        Type type = JavaModel.getDefaultExtent().getType().resolve(typeName);
        if (type instanceof UnresolvedClass && !((basicType = JavaModel.getDefaultExtent().getType().resolve("java.lang." + typeName)) instanceof UnresolvedClass)) {
            return basicType;
        }
        return type;
    }
}

