/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.text.MessageFormat;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.web.core.syntax.ELTokenContext;
import org.netbeans.modules.web.core.syntax.JspJavaSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.completion.ELExpression;
import org.netbeans.modules.web.core.syntax.completion.JMIUtil;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JSPHyperlinkProvider
implements HyperlinkProvider {
    public boolean isHyperlinkPoint(Document doc, int offset) {
        if (!(doc instanceof BaseDocument)) {
            return false;
        }
        try {
            BaseDocument bdoc = (BaseDocument)doc;
            JTextComponent target = Utilities.getFocusedComponent();
            if (target == null || target.getDocument() != bdoc) {
                return false;
            }
            SyntaxSupport sup = bdoc.getSyntaxSupport();
            JspSyntaxSupport jspSup = (JspSyntaxSupport)sup.get(JspSyntaxSupport.class);
            TokenItem token = jspSup.getTokenChain(offset, offset + 1);
            if (token == null) {
                return false;
            }
            TokenID tokenID = token.getTokenID();
            if (tokenID == null) {
                return false;
            }
            if (token.getImage() == null) {
                return false;
            }
            if (tokenID.getCategory() != null && tokenID.getCategory().getNumericID() == 12 && tokenID.getNumericID() == 8) {
                while (token != null && token.getTokenID().getCategory().getNumericID() == 12 && token.getTokenID().getNumericID() != 7) {
                    token = token.getPrevious();
                }
                if (token != null && token.getTokenID().getCategory().getNumericID() == 12 && token.getTokenID().getNumericID() == 7 && "file".equals(token.getImage().trim())) {
                    return true;
                }
            }
            if (tokenID.getNumericID() == 8) {
                while (token != null && token.getTokenID().getNumericID() != 7 && token.getTokenID().getNumericID() != 3 && (token.getTokenID().getNumericID() != 4 || token.getImage().charAt(0) != '<')) {
                    token = token.getPrevious();
                }
                if (token != null && token.getTokenID().getNumericID() == 7 && "page".equals(token.getImage().trim())) {
                    return true;
                }
                if (token != null && token.getTokenID().getNumericID() == 7 && ("class".equals(token.getImage().trim()) || "type".equals(token.getImage().trim()))) {
                    return true;
                }
            }
            if (token.getTokenContextPath().contains(ELTokenContext.contextPath)) {
                ELExpression exp = new ELExpression((JspSyntaxSupport)bdoc.getSyntaxSupport());
                int res = exp.parse(token.getOffset() + token.getImage().length());
                if (res == 1) {
                    res = exp.parse(token.getOffset() + token.getImage().length() + 1);
                }
                return res == 2;
            }
            return this.getTagFile(token, jspSup) != null;
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return false;
        }
    }

    public int[] getHyperlinkSpan(Document doc, int offset) {
        if (!(doc instanceof BaseDocument)) {
            return null;
        }
        try {
            int tokenOffset;
            ELExpression exp;
            int res;
            BaseDocument bdoc = (BaseDocument)doc;
            JTextComponent target = Utilities.getFocusedComponent();
            if (target == null || target.getDocument() != bdoc) {
                return null;
            }
            SyntaxSupport sup = bdoc.getSyntaxSupport();
            JspSyntaxSupport jspSup = (JspSyntaxSupport)sup.get(JspSyntaxSupport.class);
            TokenItem token = jspSup.getTokenChain(offset, offset + 1);
            if (token == null) {
                return null;
            }
            TokenID tokenID = token.getTokenID();
            if (tokenID == null) {
                return null;
            }
            if (this.getTagFile(token, jspSup) != null) {
                return new int[]{token.getOffset(), token.getOffset() + token.getImage().length() - 1};
            }
            if (token.getTokenContextPath().contains(ELTokenContext.contextPath) && ((res = (exp = new ELExpression((JspSyntaxSupport)bdoc.getSyntaxSupport())).parse(token.getOffset() + token.getImage().length())) == 2 || res == 1)) {
                return new int[]{token.getOffset(), token.getOffset() + token.getImage().length()};
            }
            String image = token.getImage();
            for (tokenOffset = 0; tokenOffset < image.length() && bdoc.isWhitespace(image.charAt(tokenOffset)); ++tokenOffset) {
            }
            return new int[]{token.getOffset() + ++tokenOffset, token.getOffset() + token.getImage().length() - 2};
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    public void performClickAction(Document doc, int offset) {
        TokenItem token = null;
        try {
            FileObject fObj;
            TokenItem userToken;
            BaseDocument bdoc = (BaseDocument)doc;
            JTextComponent target = Utilities.getFocusedComponent();
            if (target == null || target.getDocument() != bdoc) {
                return;
            }
            SyntaxSupport sup = bdoc.getSyntaxSupport();
            JspSyntaxSupport jspSup = (JspSyntaxSupport)sup.get(JspSyntaxSupport.class);
            token = jspSup.getTokenChain(offset, offset + 1);
            if (token == null) {
                return;
            }
            if (token.getTokenContextPath().contains(ELTokenContext.contextPath)) {
                ELExpression exp = new ELExpression((JspSyntaxSupport)bdoc.getSyntaxSupport());
                int res = exp.parse(token.getOffset() + token.getImage().length());
                if (res == 1) {
                    this.navigateToUserBeanDef(doc, jspSup, target, token.getImage());
                    return;
                }
                if (res == 2) {
                    JavaClass bean = exp.getBean(exp.getExpression());
                    Object property = exp.getPropertyDeclaration(exp.getExpression(), bean);
                    OpenJavaItem run = new OpenJavaItem(property, sup);
                    JavaMetamodel.getManager().invokeAfterScanFinished((Runnable)run, NbBundle.getMessage(JSPHyperlinkProvider.class, (String)"MSG_goto-source"));
                }
                return;
            }
            for (userToken = token; userToken != null && userToken.getTokenID().getNumericID() != 3 && !"jsp:useBean".equals(userToken.getImage()); userToken = userToken.getPrevious()) {
            }
            if (userToken != null && userToken.getTokenID().getNumericID() == 3) {
                JavaClass bean;
                String className = token.getImage().substring(1, token.getImage().length() - 1).trim();
                DataObject obj = NbEditorUtilities.getDataObject((Document)sup.getDocument());
                if (obj != null && (bean = JMIUtil.findClass(className, ClassPath.getClassPath((FileObject)obj.getPrimaryFile(), (String)"classpath/execute"))) != null) {
                    OpenJavaItem run = new OpenJavaItem(bean, sup);
                    JavaMetamodel.getManager().invokeAfterScanFinished((Runnable)run, NbBundle.getMessage(JSPHyperlinkProvider.class, (String)"MSG_goto-source"));
                }
            }
            if ((fObj = this.getTagFile(token, jspSup)) != null) {
                this.openInEditor(fObj);
            } else {
                String path = token.getImage();
                path = path.substring(path.indexOf(34) + 1);
                fObj = this.getFileObject(doc, path = path.substring(0, path.indexOf(34)));
                if (fObj != null) {
                    this.openInEditor(fObj);
                } else {
                    String msg = NbBundle.getBundle(JSPHyperlinkProvider.class).getString("LBL_file_not_found");
                    StatusDisplayer.getDefault().setStatusText(MessageFormat.format(msg, path));
                }
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private FileObject getFileObject(Document doc, String path) {
        FileObject fobj;
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        FileObject fileObject = fobj = dobj != null ? NbEditorUtilities.getDataObject((Document)doc).getPrimaryFile() : null;
        if (fobj != null) {
            return this.getFileObject(doc, fobj, path);
        }
        return null;
    }

    private FileObject getFileObject(Document doc, FileObject file, String path) {
        if (path == null) {
            return file;
        }
        path = path.trim();
        FileObject find = file;
        if (!file.isFolder()) {
            find = file.getParent();
        }
        if (path.charAt(0) == '/') {
            find = JspUtils.guessWebModuleRoot(doc, file);
            if (find == null) {
                return null;
            }
            path = path.substring(1);
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (find != null && st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("..".equals(token)) {
                find = find.getParent();
                continue;
            }
            if (".".equals(token)) continue;
            find = find.getFileObject(token);
        }
        return find;
    }

    private String getTagName(String tagwithprefix) {
        int index = tagwithprefix.indexOf(58);
        if (index > 0) {
            return tagwithprefix.substring(index + 1);
        }
        return tagwithprefix;
    }

    private void openInEditor(FileObject fObj) {
        if (fObj != null) {
            Node.Cookie cookie;
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fObj);
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return;
            }
            if (dobj != null && (cookie = dobj.getCookie(EditCookie.class)) != null) {
                ((EditCookie)cookie).edit();
            }
        }
    }

    private FileObject getTagFile(TokenItem token, JspSyntaxSupport jspSup) {
        TagFileInfo fileInfo;
        TagLibraryInfo libInfo;
        List l;
        String image;
        if (token != null && token.getTokenID().getCategory() == null && token.getTokenID().getNumericID() == 3 && !(image = token.getImage().trim()).startsWith("jsp:") && image.indexOf(58) != -1 && (l = jspSup.getTags(image)).size() == 1 && (libInfo = ((TagInfo)l.get(0)).getTagLibrary()) != null && (fileInfo = libInfo.getTagFile(this.getTagName(image))) != null) {
            return this.getFileObject((Document)jspSup.getDocument(), fileInfo.getPath());
        }
        return null;
    }

    private void navigateToUserBeanDef(Document doc, JspSyntaxSupport jspSup, JTextComponent target, String bean) throws BadLocationException {
        String text = doc.getText(0, doc.getLength());
        int index = text.indexOf(bean);
        TokenItem token = null;
        while (index > 0) {
            token = jspSup.getTokenChain(index, index + 1);
            if (token != null && token.getTokenID().getNumericID() == 8) {
                while (!(token == null || token.getTokenID().getNumericID() == 7 && (token.getImage().equals("class") || token.getImage().equals("type")) || token.getTokenID().getNumericID() == 4 && token.getImage().equals("/>"))) {
                    token = token.getNext();
                }
                if (token != null && token.getTokenID().getNumericID() == 4) {
                    while (!(token == null || token.getTokenID().getNumericID() == 7 && (token.getImage().equals("class") || token.getImage().equals("type")) || token.getTokenID().getNumericID() != 4 && token.getImage().equals("<"))) {
                        token = token.getPrevious();
                    }
                }
                if (token != null && token.getTokenID().getNumericID() == 7) {
                    while (token != null && token.getTokenID().getNumericID() != 8) {
                        token = token.getNext();
                    }
                }
                if (token != null && token.getTokenID().getNumericID() == 8) {
                    target.setCaretPosition(token.getOffset() + 1);
                    break;
                }
            }
            index = text.indexOf(bean, index + bean.length());
        }
    }

    public static class OpenJavaItem
    implements Runnable {
        private Object item;
        private SyntaxSupport sup;

        OpenJavaItem(Object item, SyntaxSupport sup) {
            this.item = item;
            this.sup = sup;
        }

        public void run() {
            JspJavaSyntaxSupport javaSup = (JspJavaSyntaxSupport)this.sup.get(JspJavaSyntaxSupport.class);
            if (this.item != null && javaSup != null) {
                String itemDesc = null;
                itemDesc = javaSup.openSource(this.item, true);
                if (itemDesc != null) {
                    String msg = NbBundle.getBundle(JSPHyperlinkProvider.class).getString("MSG_source_not_found");
                    StatusDisplayer.getDefault().setStatusText(msg);
                }
            }
        }
    }
}

