/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;

public abstract class InnerTableModel
extends AbstractTableModel {
    private XmlMultiViewDataSynchronizer synchronizer;
    protected final String[] columnNames;
    private int[] columnWidths;
    private int rowCount = -1;

    public InnerTableModel(XmlMultiViewDataSynchronizer synchronizer, String[] columnNames, int[] columnWidths) {
        this.synchronizer = synchronizer;
        this.columnNames = columnNames;
        this.columnWidths = columnWidths;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public TableCellEditor getCellEditor(int columnIndex) {
        return null;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public abstract int addRow();

    public abstract void removeRow(int var1);

    public int getDefaultColumnWidth(int i) {
        return this.columnWidths[i];
    }

    public void refreshView() {
        this.fireTableDataChanged();
    }

    protected void tableChanged() {
        if (!this.checkRowCount()) {
            this.fireTableDataChanged();
        }
    }

    private boolean checkRowCount() {
        int n = this.getRowCount();
        if (this.rowCount == -1) {
            this.rowCount = n;
        }
        if (n != this.rowCount) {
            while (this.rowCount < n) {
                ++this.rowCount;
                this.fireTableRowsInserted(0, 0);
            }
            while (this.rowCount > n) {
                --this.rowCount;
                this.fireTableRowsDeleted(0, 0);
            }
            return true;
        }
        return false;
    }

    protected void modelUpdatedFromUI() {
        if (this.synchronizer != null) {
            this.synchronizer.requestUpdateData();
        }
    }

    public TableCellEditor getTableCellEditor(int column) {
        return null;
    }

    protected TableCellEditor createComboBoxCellEditor(Object[] items) {
        return InnerTableModel.createComboBoxCellEditor(items, false);
    }

    private static TableCellEditor createComboBoxCellEditor(Object[] items, boolean editable) {
        JComboBox<Object> comboBox = new JComboBox<Object>(items);
        comboBox.setEditable(editable);
        return new DefaultCellEditor(comboBox);
    }
}

