/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class EditableProperties
extends AbstractMap
implements Cloneable {
    private List items = new ArrayList();
    private Map itemIndex = new HashMap();
    private boolean alphabetize = true;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String commentChars = "#!";
    private static final String INDENT = "    ";
    private static final int WAITING_FOR_KEY_VALUE = 1;
    private static final int READING_KEY_VALUE = 2;

    public EditableProperties() {
    }

    public EditableProperties(boolean alphabetize) {
        this();
        this.alphabetize = alphabetize;
    }

    public EditableProperties(Map map) {
        this();
        this.putAll(map);
    }

    EditableProperties(EditableProperties ep) {
        this();
        for (Item item : ep.items) {
            this.addItem((Item)item.clone(), false);
        }
    }

    public Set entrySet() {
        return new SetImpl(this);
    }

    public void load(InputStream stream) throws IOException {
        String line;
        int state = 1;
        BufferedReader input = new BufferedReader(new InputStreamReader(stream, "ISO-8859-1"));
        LinkedList<String> tempList = new LinkedList<String>();
        int commentLinesCount = 0;
        while (null != (line = input.readLine())) {
            tempList.add(line);
            boolean empty = EditableProperties.isEmpty(line);
            boolean comment = EditableProperties.isComment(line);
            if (state == 1) {
                if (empty) {
                    this.createNonKeyItem(tempList);
                    commentLinesCount = 0;
                } else if (comment) {
                    ++commentLinesCount;
                } else {
                    state = 2;
                }
            }
            if (state != 2 || this.isContinue(line)) continue;
            this.createKeyItem(tempList, commentLinesCount);
            state = 1;
            commentLinesCount = 0;
        }
        if (tempList.size() > 0) {
            if (state == 2) {
                this.createKeyItem(tempList, commentLinesCount);
            } else {
                this.createNonKeyItem(tempList);
            }
        }
    }

    public void store(OutputStream stream) throws IOException {
        boolean previousLineWasEmpty = true;
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(stream, "ISO-8859-1"));
        for (Item item : this.items) {
            if (item.isSeparate() && !previousLineWasEmpty) {
                output.newLine();
            }
            Iterator it2 = item.getRawData().iterator();
            String line = null;
            while (it2.hasNext()) {
                line = (String)it2.next();
                output.write(line);
                output.newLine();
            }
            if (line == null) continue;
            previousLineWasEmpty = EditableProperties.isEmpty(line);
        }
        output.flush();
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        Item item = (Item)this.itemIndex.get((String)key);
        String result = null;
        if (item != null) {
            result = item.getValue();
            item.setValue((String)value);
        } else {
            item = new Item((String)key, (String)value);
            this.addItem(item, this.alphabetize);
        }
        return result;
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public String setProperty(String key, String value) {
        String result = this.getProperty(key);
        this.put(key, value);
        return result;
    }

    public String setProperty(String key, String[] value) {
        String result = this.getProperty(key);
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        List<String> valueList = Arrays.asList(value);
        Item item = (Item)this.itemIndex.get(key);
        if (item != null) {
            item.setValue(valueList);
        } else {
            this.addItem(new Item(key, valueList), this.alphabetize);
        }
        return result;
    }

    public String[] getComment(String key) {
        Item item = (Item)this.itemIndex.get(key);
        if (item == null) {
            return new String[0];
        }
        return item.getComment();
    }

    public void setComment(String key, String[] comment, boolean separate) {
        Item item = (Item)this.itemIndex.get(key);
        if (item == null) {
            throw new IllegalArgumentException("Cannot set comment for non-existing property " + key);
        }
        item.setComment(comment, separate);
    }

    public Object clone() {
        return this.cloneProperties();
    }

    public EditableProperties cloneProperties() {
        return new EditableProperties(this);
    }

    private void createNonKeyItem(List lines) {
        Item item;
        if (this.items.size() > 0 && (item = (Item)this.items.get(this.items.size() - 1)).getKey() == null) {
            item.addCommentLines(lines);
            lines.clear();
            return;
        }
        item = new Item(lines);
        this.addItem(item, false);
        lines.clear();
    }

    private void createKeyItem(List lines, int commentLinesCount) {
        Item item = new Item(lines.subList(0, commentLinesCount), lines.subList(commentLinesCount, lines.size()));
        this.addItem(item, false);
        lines.clear();
    }

    private void addItem(Item item, boolean sort) {
        String key = item.getKey();
        if (sort) {
            assert (key != null);
            for (int i = 0; i < this.items.size(); ++i) {
                String k = ((Item)this.items.get(i)).getKey();
                if (k == null || k.compareToIgnoreCase(key) <= 0) continue;
                this.items.add(i, item);
                this.itemIndex.put(key, item);
                return;
            }
        }
        this.items.add(item);
        if (key != null) {
            this.itemIndex.put(key, item);
        }
    }

    private void removeItem(Item item) {
        this.items.remove(item);
        if (item.getKey() != null) {
            this.itemIndex.remove(item.getKey());
        }
    }

    private boolean isContinue(String line) {
        int slashCount = 0;
        for (int index = line.length() - 1; index >= 0 && line.charAt(index) == '\\'; --index) {
            ++slashCount;
        }
        return slashCount % 2 != 0;
    }

    private static boolean isComment(String line) {
        return (line = EditableProperties.trimLeft(line)).length() != 0 && commentChars.indexOf(line.charAt(0)) != -1;
    }

    private static boolean isEmpty(String line) {
        return EditableProperties.trimLeft(line).length() == 0;
    }

    private static String trimLeft(String line) {
        int start;
        for (start = 0; start < line.length() && whiteSpaceChars.indexOf(line.charAt(start)) != -1; ++start) {
        }
        return line.substring(start);
    }

    private static class MapEntryImpl
    implements Map.Entry {
        private Item item;

        public MapEntryImpl(Item item) {
            this.item = item;
        }

        public Object getKey() {
            return this.item.getKey();
        }

        public Object getValue() {
            return this.item.getValue();
        }

        public Object setValue(Object value) {
            String result = this.item.getValue();
            this.item.setValue((String)value);
            return result;
        }
    }

    private static class IteratorImpl
    implements Iterator {
        private EditableProperties props;
        private int index = -1;
        private Item item;

        public IteratorImpl(EditableProperties props) {
            this.props = props;
        }

        public boolean hasNext() {
            return this.findNext() != -1;
        }

        public Object next() {
            this.index = this.findNext();
            if (this.index == -1) {
                throw new NoSuchElementException("There is no more items");
            }
            this.item = (Item)this.props.items.get(this.index);
            return new MapEntryImpl(this.item);
        }

        public void remove() {
            if (this.item == null) {
                throw new IllegalStateException();
            }
            this.props.removeItem(this.item);
            --this.index;
            this.item = null;
        }

        private int findNext() {
            for (int res = this.index + 1; res < this.props.size(); ++res) {
                Item i = (Item)this.props.items.get(res);
                if (i.getKey() == null || i.getValue() == null) continue;
                return res;
            }
            return -1;
        }
    }

    private static class SetImpl
    extends AbstractSet {
        private EditableProperties props;

        public SetImpl(EditableProperties props) {
            this.props = props;
        }

        public Iterator iterator() {
            return new IteratorImpl(this.props);
        }

        public int size() {
            return this.props.items.size();
        }
    }

    private static class Item
    implements Cloneable {
        private List commentLines;
        private List keyValueLines;
        private String key;
        private String value;
        private boolean separate;

        private Item() {
        }

        public Item(List commentLines) {
            this.commentLines = new ArrayList(commentLines);
        }

        public Item(List commentLines, List keyValueLines) {
            this.commentLines = new ArrayList(commentLines);
            this.keyValueLines = new ArrayList(keyValueLines);
            this.parse(keyValueLines);
        }

        public Item(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Item(String key, List value) {
            this.key = key;
            this.setValue(value);
        }

        void addCommentLines(List lines) {
            assert (this.key == null);
            this.commentLines.addAll(lines);
        }

        public String[] getComment() {
            String[] res = new String[this.commentLines.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = Item.decodeUnicode((String)this.commentLines.get(i));
            }
            return res;
        }

        public void setComment(String[] commentLines, boolean separate) {
            this.separate = separate;
            this.commentLines = new ArrayList(commentLines.length);
            for (int i = 0; i < commentLines.length; ++i) {
                this.commentLines.add(Item.encodeUnicode(commentLines[i]));
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
            this.keyValueLines = null;
        }

        public void setValue(List value) {
            StringBuffer val = new StringBuffer();
            ArrayList<String> l = new ArrayList<String>();
            if (!value.isEmpty()) {
                l.add(Item.encode(this.key, true) + "=\\");
                Iterator it = value.iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    val.append(s);
                    s = Item.encode(s, false);
                    l.add(it.hasNext() ? EditableProperties.INDENT + s + '\\' : EditableProperties.INDENT + s);
                }
            } else {
                l.add(Item.encode(this.key, true) + '=');
            }
            this.value = val.toString();
            this.keyValueLines = l;
        }

        public boolean isSeparate() {
            return this.separate;
        }

        public List getRawData() {
            ArrayList l = new ArrayList();
            if (this.commentLines != null) {
                l.addAll(this.commentLines);
            }
            if (this.keyValueLines != null) {
                l.addAll(this.keyValueLines);
            } else {
                this.keyValueLines = new ArrayList();
                if (this.key != null && this.value != null) {
                    this.keyValueLines.add(Item.encode(this.key, true) + "=" + Item.encode(this.value, false));
                }
                l.addAll(this.keyValueLines);
            }
            return l;
        }

        private void parse(List keyValueLines) {
            String line = this.mergeLines(keyValueLines);
            this.splitKeyValue(line);
        }

        private String mergeLines(List lines) {
            String line = "";
            Iterator it = lines.iterator();
            while (it.hasNext()) {
                String l = EditableProperties.trimLeft((String)it.next());
                if (it.hasNext()) {
                    assert (l.endsWith("\\")) : lines;
                    l = l.substring(0, l.length() - 1);
                }
                line = line + l;
            }
            return line;
        }

        private void splitKeyValue(String line) {
            int separatorIndex;
            for (separatorIndex = 0; separatorIndex < line.length(); ++separatorIndex) {
                char ch = line.charAt(separatorIndex);
                if (ch == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if (EditableProperties.keyValueSeparators.indexOf(ch) != -1) break;
            }
            this.key = Item.decode(line.substring(0, separatorIndex));
            if ((line = EditableProperties.trimLeft(line.substring(separatorIndex))).length() == 0) {
                this.value = "";
                return;
            }
            if (EditableProperties.strictKeyValueSeparators.indexOf(line.charAt(0)) != -1) {
                line = EditableProperties.trimLeft(line.substring(1));
            }
            this.value = Item.decode(line);
        }

        private static String decode(String input) {
            int len = input.length();
            StringBuffer output = new StringBuffer(len);
            for (int x = 0; x < len; ++x) {
                int ch = input.charAt(x);
                if (ch != 92) {
                    output.append((char)ch);
                    continue;
                }
                if (++x == len) continue;
                ch = input.charAt(x);
                if (ch == 117) {
                    if (x + 5 > len) {
                        output.append(input.substring(x - 1));
                        x += 4;
                        continue;
                    }
                    String val = input.substring(x + 1, x + 5);
                    try {
                        output.append((char)Integer.parseInt(val, 16));
                    }
                    catch (NumberFormatException e) {
                        output.append(input.substring(x - 1, x + 5));
                    }
                    x += 4;
                    continue;
                }
                if (ch == 116) {
                    ch = 9;
                } else if (ch == 114) {
                    ch = 13;
                } else if (ch == 110) {
                    ch = 10;
                } else if (ch == 102) {
                    ch = 12;
                }
                output.append((char)ch);
            }
            return output.toString();
        }

        private static String encode(String input, boolean escapeSpace) {
            int len = input.length();
            StringBuffer output = new StringBuffer(len * 2);
            block8: for (int x = 0; x < len; ++x) {
                char ch = input.charAt(x);
                switch (ch) {
                    case ' ': {
                        if (x == 0 || escapeSpace) {
                            output.append('\\');
                        }
                        output.append(' ');
                        continue block8;
                    }
                    case '\\': {
                        output.append("\\\\");
                        continue block8;
                    }
                    case '\t': {
                        output.append("\\t");
                        continue block8;
                    }
                    case '\n': {
                        output.append("\\n");
                        continue block8;
                    }
                    case '\r': {
                        output.append("\\r");
                        continue block8;
                    }
                    case '\f': {
                        output.append("\\f");
                        continue block8;
                    }
                    default: {
                        if (ch < ' ' || ch > '~') {
                            output.append("\\u");
                            String hex = Integer.toHexString(ch);
                            for (int i = 0; i < 4 - hex.length(); ++i) {
                                output.append('0');
                            }
                            output.append(hex);
                            continue block8;
                        }
                        output.append(ch);
                    }
                }
            }
            return output.toString();
        }

        private static String decodeUnicode(String input) {
            int len = input.length();
            StringBuffer output = new StringBuffer(len);
            for (int x = 0; x < len; ++x) {
                char ch = input.charAt(x);
                if (ch != '\\') {
                    output.append(ch);
                    continue;
                }
                if (++x == len) continue;
                ch = input.charAt(x);
                if (ch == 'u') {
                    if (x + 5 > len) {
                        output.append(input.substring(x - 1));
                        x += 4;
                        continue;
                    }
                    String val = input.substring(x + 1, x + 5);
                    try {
                        output.append((char)Integer.parseInt(val, 16));
                    }
                    catch (NumberFormatException e) {
                        output.append(input.substring(x - 1, x + 5));
                    }
                    x += 4;
                    continue;
                }
                output.append(ch);
            }
            return output.toString();
        }

        private static String encodeUnicode(String input) {
            int len = input.length();
            StringBuffer output = new StringBuffer(len * 2);
            for (int x = 0; x < len; ++x) {
                char ch = input.charAt(x);
                if (ch < ' ' || ch > '~') {
                    output.append("\\u");
                    String hex = Integer.toHexString(ch);
                    for (int i = 0; i < 4 - hex.length(); ++i) {
                        output.append('0');
                    }
                    output.append(hex);
                    continue;
                }
                output.append(ch);
            }
            return output.toString();
        }

        public Object clone() {
            Item item = new Item();
            if (this.keyValueLines != null) {
                item.keyValueLines = new ArrayList(this.keyValueLines);
            }
            if (this.commentLines != null) {
                item.commentLines = new ArrayList(this.commentLines);
            }
            item.key = this.key;
            item.value = this.value;
            return item;
        }
    }
}

