/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.nodes;

import java.util.Collections;
import java.util.TreeSet;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.tomcat5.AuthorizationException;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.TomcatModule;
import org.netbeans.modules.tomcat5.nodes.TomcatWebModule;
import org.netbeans.modules.tomcat5.nodes.TomcatWebModuleNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TomcatWebModuleChildren
extends Children.Keys {
    private static final String WAIT_NODE = "wait_node";
    private Lookup lookup;

    TomcatWebModuleChildren(Lookup lkp) {
        this.lookup = lkp;
    }

    public void updateKeys() {
        TreeSet<String> ts = new TreeSet<String>();
        ts.add(WAIT_NODE);
        this.setKeys(ts);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                DeploymentManager manager = (DeploymentManager)TomcatWebModuleChildren.this.lookup.lookup(DeploymentManager.class);
                Target target = (Target)TomcatWebModuleChildren.this.lookup.lookup(Target.class);
                TreeSet<TomcatWebModule> list = new TreeSet<TomcatWebModule>(new TomcatWebModule.TomcatWebModuleComparator());
                if (manager instanceof TomcatManager && target != null) {
                    TomcatManager tm = (TomcatManager)manager;
                    if (tm.isSuspended() || !tm.isRunning(true)) {
                        TomcatWebModuleChildren.this.removeNotify();
                        return;
                    }
                    try {
                        int i;
                        TargetModuleID[] modules = manager.getRunningModules(ModuleType.WAR, new Target[]{target});
                        for (i = 0; i < modules.length; ++i) {
                            list.add(new TomcatWebModule(manager, (TomcatModule)modules[i], true));
                        }
                        modules = manager.getNonRunningModules(ModuleType.WAR, new Target[]{target});
                        for (i = 0; i < modules.length; ++i) {
                            list.add(new TomcatWebModule(manager, (TomcatModule)modules[i], false));
                        }
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof AuthorizationException) {
                            String errMsg = NbBundle.getMessage(TomcatWebModuleChildren.class, (String)"MSG_AuthorizationFailed");
                            NotifyDescriptor.Message notDesc = new NotifyDescriptor.Message((Object)errMsg, 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                        }
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
                TomcatWebModuleChildren.this.setKeys(list);
            }
        }, 0);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof TomcatWebModule) {
            TomcatWebModule tm = (TomcatWebModule)key;
            TomcatWebModuleNode node = new TomcatWebModuleNode(tm);
            tm.setRepresentedNode((Node)node);
            return new Node[]{node};
        }
        if (key instanceof String && key.equals(WAIT_NODE)) {
            return new Node[]{this.createWaitNode()};
        }
        return null;
    }

    private Node createWaitNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(NbBundle.getMessage(TomcatWebModuleChildren.class, (String)"LBL_WaitNode_DisplayName"));
        n.setIconBaseWithExtension("org/openide/src/resources/wait.gif");
        return n;
    }
}

