/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.JAASCallbackHandler;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAASRealm
extends RealmBase {
    private static Log log = LogFactory.getLog((Class)JAASRealm.class);
    protected String appName = null;
    protected static final String info = "org.apache.catalina.realm.JAASRealm/1.0";
    protected static final String name = "JAASRealm";
    protected List roleClasses = new ArrayList();
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.realm");
    protected List userClasses = new ArrayList();
    protected boolean useContextClassLoader = true;
    protected String roleClassNames = null;
    protected String userClassNames = null;

    public void setAppName(String name) {
        this.appName = name;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setUseContextClassLoader(boolean useContext) {
        this.useContextClassLoader = useContext;
        log.info((Object)("Setting useContextClassLoader = " + useContext));
    }

    public boolean isUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setContainer(Container container) {
        super.setContainer(container);
        if (this.appName == null) {
            String name = container.getName();
            this.appName = name = this.makeLegalForJAAS(name);
            log.info((Object)("Set JAAS app name " + this.appName));
        }
    }

    public String getRoleClassNames() {
        return this.roleClassNames;
    }

    public void setRoleClassNames(String roleClassNames) {
        int comma;
        this.roleClassNames = roleClassNames;
        this.roleClasses.clear();
        String temp = this.roleClassNames;
        if (temp == null) {
            return;
        }
        while ((comma = temp.indexOf(44)) >= 0) {
            this.roleClasses.add(temp.substring(0, comma).trim());
            temp = temp.substring(comma + 1);
        }
        temp = temp.trim();
        if (temp.length() > 0) {
            this.roleClasses.add(temp);
        }
    }

    public String getUserClassNames() {
        return this.userClassNames;
    }

    public void setUserClassNames(String userClassNames) {
        int comma;
        this.userClassNames = userClassNames;
        this.userClasses.clear();
        String temp = this.userClassNames;
        if (temp == null) {
            return;
        }
        while ((comma = temp.indexOf(44)) >= 0) {
            this.userClasses.add(temp.substring(0, comma).trim());
            temp = temp.substring(comma + 1);
        }
        temp = temp.trim();
        if (temp.length() > 0) {
            this.userClasses.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal authenticate(String username, String credentials) {
        try {
            Principal principal;
            LoginContext loginContext = null;
            if (this.appName == null) {
                this.appName = "Tomcat";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.beginLogin", (Object)username, (Object)this.appName));
            }
            ClassLoader ocl = null;
            if (this.isUseContextClassLoader()) {
                ocl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            }
            try {
                loginContext = new LoginContext(this.appName, new JAASCallbackHandler(this, username, credentials));
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("jaasRealm.unexpectedError"), e);
                Principal principal2 = null;
                return principal2;
            }
            finally {
                if (this.isUseContextClassLoader()) {
                    Thread.currentThread().setContextClassLoader(ocl);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Login context created " + username));
            }
            Subject subject = null;
            try {
                loginContext.login();
                subject = loginContext.getSubject();
                if (subject == null) {
                    if (!log.isDebugEnabled()) return null;
                    log.debug((Object)sm.getString("jaasRealm.failedLogin", (Object)username));
                    return null;
                }
            }
            catch (AccountExpiredException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug((Object)sm.getString("jaasRealm.accountExpired", (Object)username));
                return null;
            }
            catch (CredentialExpiredException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug((Object)sm.getString("jaasRealm.credentialExpired", (Object)username));
                return null;
            }
            catch (FailedLoginException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug((Object)sm.getString("jaasRealm.failedLogin", (Object)username));
                return null;
            }
            catch (LoginException e) {
                log.warn((Object)sm.getString("jaasRealm.loginException", (Object)username), (Throwable)e);
                return null;
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("jaasRealm.unexpectedError"), e);
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.loginContextCreated", (Object)username));
            }
            if ((principal = this.createPrincipal(username, subject)) == null) {
                log.debug((Object)sm.getString("jaasRealm.authenticateFailure", (Object)username));
                return null;
            }
            if (!log.isDebugEnabled()) return principal;
            log.debug((Object)sm.getString("jaasRealm.authenticateSuccess", (Object)username));
            return principal;
        }
        catch (Throwable t) {
            log.error((Object)"error ", t);
            return null;
        }
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    protected Principal createPrincipal(String username, Subject subject) {
        Object password = null;
        ArrayList<String> roles = new ArrayList<String>();
        Principal userPrincipal = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal principal = principals.next();
            String principalClass = principal.getClass().getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.checkPrincipal", (Object)principal, (Object)principalClass));
            }
            if (userPrincipal == null && this.userClasses.contains(principalClass)) {
                userPrincipal = principal;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("jaasRealm.userPrincipalSuccess", (Object)principal.getName()));
                }
            }
            if (!this.roleClasses.contains(principalClass)) continue;
            roles.add(principal.getName());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("jaasRealm.rolePrincipalAdd", (Object)principal.getName()));
        }
        if (userPrincipal == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.userPrincipalFailure"));
                log.debug((Object)sm.getString("jaasRealm.rolePrincipalFailure"));
            }
        } else if (roles.size() == 0 && log.isDebugEnabled()) {
            log.debug((Object)sm.getString("jaasRealm.rolePrincipalFailure"));
        }
        return new GenericPrincipal((Realm)this, username, null, roles, userPrincipal);
    }

    protected String makeLegalForJAAS(String src) {
        String result = src;
        if (result == null) {
            result = "other";
        }
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public void start() throws LifecycleException {
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
    }
}

