<?php
/**
  * Old Chinese / Late Middle Chinese (文言)
  * Based on http://zh-classical.wikipedia.org/w/index.php?title=Wikipedia:%E7%94%A8%E6%88%B6%E4%BB%8B%E9%9D%A2%E7%BF%BB%E8%AD%AF/MessagesZh_classical.php&oldid=30887
  *
  * @addtogroup Language
  */

/**
 * 風名。無稱者用英名。
 */
$skinNames = array(
        'standard' => '經典',
        'nostalgia' => '懷古',
        'cologneblue' => '古龍水藍',
        'monobook' => '單書',
        'myskin' => '吾風',
        'chick' => '窈窕'
);

/**
 * A list of date format preference keys which can be selected in user 
 * preferences. New preference keys can be added, provided they are supported
 * by the language class's timeanddate(). Only the 5 keys listed below are 
 * supported by the wikitext converter (DateFormatter.php).
 *
 * The special key "default" is an alias for either dmy or mdy depending on 
 * $wgAmericanDates
 */
$datePreferences = array(
	'default',
	'ISO 8601',
);

$defaultDateFormat = 'zh';

/**
 * These are formats for dates generated by MediaWiki (as opposed to the wikitext
 * DateFormatter). Documentation for the format string can be found in 
 * Language.php, search for sprintfDate. 
 *
 * This array is automatically inherited by all subclasses. Individual keys can be
 * overridden.
 */
$dateFormats = array(
        'zh time' => 'H時i分',
        'zh date' => 'Y年n月j日 （l）',
        'zh both' => 'Y年n月j日 （D） H時i分',
);

$linkTrail = '/^([a-z]+)(.*)$/sD';

$digitTransformTable = array(
	'0' => '〇',
	'1' => '一',
	'2' => '二',
	'3' => '三',
	'4' => '四',
	'5' => '五',
	'6' => '六',
	'7' => '七',
	'8' => '八',
	'9' => '九',
	'.' => '點',
	',' => '',
);

#-------------------------------------------------------------------
# Default messages
#-------------------------------------------------------------------
# Allowed characters in keys are: A-Z, a-z, 0-9, underscore (_) and
# hyphen (-). If you need more characters, you may be able to change
# the regex in MagicWord::initRegex

$messages = array(
# User preference toggles
'tog-underline'               => '通者墊之：',
'tog-highlightbroken'         => '格不通<a href="" class="new">如斯</a>，替之以<a href="" class="internal">？</a>',
'tog-justify'                 => '齊各段',
'tog-hideminor'               => '隱校文',
'tog-extendwatchlist'         => '彊哨站兮，盡示可用之易',
'tog-usenewrc'                => '近易更善本（JavaScript）',
'tog-numberheadings'          => '自生章數',
'tog-showtoolbar'             => '示多寶列（JavaScript）',
'tog-editondblclick'          => '雙擊以修文（JavaScript）',
'tog-editsection'             => '點［修］以修文',
'tog-editsectiononrightclick' => '右擊節標以修文（JavaScript）',
'tog-showtoc'                 => '越三章者示目次',
'tog-rememberpassword'        => '符節通越',
'tog-editwidth'               => '全幅',
'tog-watchcreations'          => '哨吾撰',
'tog-watchdefault'            => '哨吾纂',
'tog-minordefault'            => '常為校',
'tog-previewontop'            => '覽文至頂',
'tog-previewonfirst'          => '先覽後修',
'tog-nocache'                 => '莫謄文',
'tog-enotifwatchlistpages'    => '哨新遣函',
'tog-enotifusertalkpages'     => '議新遣函',
'tog-enotifminoredits'        => '校新遣函',
'tog-enotifrevealaddr'        => '列余址於書內',
'tog-shownumberswatching'     => '放哨有',
'tog-fancysig'                => '署以本碼 （免自連）',
'tog-externaleditor'          => '常以它器修文',
'tog-externaldiff'            => '常以它器修異',
'tog-showjumplinks'           => '"往"字可通',
'tog-uselivepreview'          => '即覽（JavaScript），尚不穩',
'tog-forceeditsummary'        => '缺概',
'tog-watchlisthideown'        => '不哨吾文',
'tog-watchlisthidebots'       => '不哨僕文',

'underline-always'  => '恆',
'underline-never'   => '絕',
'underline-default' => '予定',

'skinpreview' => '（預覽）',

# Dates
'sunday'        => '週日',
'monday'        => '週一',
'tuesday'       => '週二',
'wednesday'     => '週三',
'thursday'      => '週四',
'friday'        => '週五',
'saturday'      => '週六',
'sun'           => '日',
'mon'           => '一',
'tue'           => '二',
'wed'           => '三',
'thu'           => '四',
'fri'           => '五',
'sat'           => '六',
'january'       => '一月',
'february'      => '二月',
'march'         => '三月',
'april'         => '四月',
'may_long'      => '五月',
'june'          => '六月',
'july'          => '七月',
'august'        => '八月',
'september'     => '九月',
'october'       => '十月',
'november'      => '十一月',
'december'      => '十二月',
'january-gen'   => '一月',
'february-gen'  => '二月',
'march-gen'     => '三月',
'april-gen'     => '四月',
'may-gen'       => '五月',
'june-gen'      => '六月',
'july-gen'      => '七月',
'august-gen'    => '八月',
'september-gen' => '九月',
'october-gen'   => '十月',
'november-gen'  => '十一月',
'december-gen'  => '十二月',
'jan'           => '一月',
'feb'           => '二月',
'mar'           => '三月',
'apr'           => '四月',
'may'           => '五月',
'jun'           => '六月',
'jul'           => '七月',
'aug'           => '八月',
'sep'           => '九月',
'oct'           => '十月',
'nov'           => '十一月',
'dec'           => '十二月',

# Bits of text used by many pages
'categories'            => '類',
'pagecategories'        => '$1類',
'category_header'       => '"$1"文',
'subcategories'         => '次類',
'category-media-header' => '"$1"媒',
'category-empty'        => "''此類未包文媒也。''",

'mainpagetext'      => "<big>'''媒維基安置矣'''</big>",
'mainpagedocfooter' => "欲識維基，見[http://meta.wikimedia.org/wiki/Help:Contents User's Guide] 

== 始 ==

* [http://www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [http://www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [http://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",

'about'          => '大典簡介',
'article'        => '文',
'newwindow'      => '（撰新頁）',
'cancel'         => '捨',
'qbfind'         => '尋',
'qbbrowse'       => '覽',
'qbedit'         => '修',
'qbpageoptions'  => '此頁',
'qbpageinfo'     => '內文',
'qbmyoptions'    => '吾好',
'qbspecialpages' => '非凡頁',
'moredotdotdot'  => '逾…',
'mypage'         => '寒舍',
'mytalk'         => '書房',
'anontalk'       => '與（IP）私議',
'navigation'     => '導',

# Metadata in edit box
'metadata_help' => '衍意：',

'errorpagetitle'    => '誤',
'returnto'          => '返$1。',
'tagline'           => '語出維基大典，自由之大典矣',
'help'              => '助',
'search'            => '尋',
'searchbutton'      => '尋',
'go'                => '往',
'searcharticle'     => '始',
'history'           => '誌',
'history_short'     => '誌',
'updatedmarker'     => '新也',
'info_short'        => '快訊',
'printableversion'  => '印本',
'permalink'         => '恆通',
'print'             => '印',
'edit'              => '纂',
'editthispage'      => '纂',
'delete'            => '刪',
'deletethispage'    => '刪',
'undelete_short'    => '還$1已刪',
'protect'           => '錮',
'protectthispage'   => '錮此頁',
'unprotect'         => '赦',
'unprotectthispage' => '赦此頁',
'newpage'           => '新頁',
'talkpage'          => '參議此文',
'talkpagelinktext'  => '議',
'specialpage'       => '奇頁',
'personaltools'     => '家私',
'postcomment'       => '增一參議',
'articlepage'       => '閱內文',
'talk'              => '議',
'views'             => '覽',
'toolbox'           => '多寶格',
'userpage'          => '簿',
'projectpage'       => '計畫頁',
'imagepage'         => '覽圖',
'mediawikipage'     => '觀媒',
'templatepage'      => '鑄模',
'viewhelppage'      => '助文',
'categorypage'      => '分類',
'viewtalkpage'      => '見議',
'otherlanguages'    => '他山',
'redirectedfrom'    => '（轉自$1）',
'redirectpagesub'   => '轉',
'lastmodifiedat'    => '此頁$1$2方易。', # $1 date, $2 time
'viewcount'         => '此頁$1閱矣',
'protectedpage'     => '此頁錮矣',
'jumpto'            => '往：',
'jumptonavigation'  => '嚮',
'jumptosearch'      => '索',

# All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).
'aboutsite'         => '關於 {{SITENAME}}',
'aboutpage'         => 'Project:相關',
'bugreports'        => '稟明錯漏',
'bugreportspage'    => 'Project:錯漏集',
'copyright'         => '文悉釋以$1。',
'copyrightpagename' => '{{SITENAME}}版權',
'copyrightpage'     => 'Project:版權',
'currentevents'     => '世事',
'currentevents-url' => '天下大事',
'disclaimers'       => '免責告示',
'disclaimerpage'    => 'Project:免責告示',
'edithelp'          => '助',
'edithelppage'      => '{{ns:help}}:修',
'faq'               => '頻答問',
'faqpage'           => 'Project:頻答問集',
'helppage'          => 'Help:目錄',
'mainpage'          => '卷首',
'policy-url'        => 'Project:策',
'portal'            => '市集',
'portal-url'        => 'Project:市集',
'privacy'           => '隱私通例',
'privacypage'       => 'Project:隱私通例',
'sitesupport'       => '捐助',
'sitesupport-url'   => 'Project:捐助集',

'badaccess'        => '子未逮',
'badaccess-group0' => '子未逮，歉限之。',
'badaccess-group1' => '子非$1，歉限之',

'versionrequired'     => '$1媒維基務安之',
'versionrequiredtext' => '$1媒維基務安之，見[[Special:Version|版]]。',

'ok'                      => '可',
'pagetitle'               => '$1 - {{SITENAME}}',
'retrievedfrom'           => '取自"$1"',
'youhavenewmessages'      => '子有$1（$2）',
'newmessageslink'         => '新訊',
'newmessagesdifflink'     => '變更',
'youhavenewmessagesmulti' => '新訊於$1',
'editsection'             => '纂',
'editold'                 => '纂',
'editsectionhint'         => '纂 $1',
'toc'                     => '章',
'showtoc'                 => '示',
'hidetoc'                 => '藏',
'thisisdeleted'           => '還$1或閱之？',
'viewdeleted'             => '閱$1之？',
'restorelink'             => '$1已刪',

# Short words for each namespace, by default used in the 'article' tab in monobook
'nstab-main'      => '文',
'nstab-user'      => '齋',
'nstab-media'     => '雅',
'nstab-special'   => '奇',
'nstab-project'   => '策',
'nstab-image'     => '檔',
'nstab-mediawiki' => '要',
'nstab-template'  => '模',
'nstab-help'      => '助',
'nstab-category'  => '類',

# Main script and global functions
'nosuchaction'      => '無可為',
'nosuchactiontext'  => '查無此址',
'nosuchspecialpage' => '查無奇頁',
'nospecialpagetext' => "'''<big>查無奇頁。</big>'''

見[[{{ns:special}}:Specialpages]]。",

# General errors
'error'                => '有誤',
'databaseerror'        => '庫藏有誤',
'dberrortext'          => '庫藏問語誤，或軟體有錯。
末語道:
<blockquote><tt>$1</tt></blockquote>
內此函式"<tt>$2</tt>".
MySQL報有誤"<tt>$3: $4</tt>"。',
'dberrortextcl'        => '庫藏問語有誤，末語道：
"$1"
內此函式"$2".
MySQL報有誤"$3: $4"',
'noconnect'            => '歉哉有變，莫能問庫藏。<br />
$1',
'nodb'                 => '莫能擇$1庫',
'cachederror'          => '此為謄本，恐不新也',
'laggedslavemode'      => '警兆，此頁不新',
'readonly'             => '鎖庫藏',
'enterlockreason'      => '何鎖？另附開赦之日。',
'readonlytext'         => '或因檢修之故，庫藏鎖矣。莫可撰，亦莫可纂。鎖者告曰：「$1」',
'missingarticle'       => '未見"$1"，或舊、或刪。若非此情，軟體恐錯，請上報網址。',
'internalerror'        => '內誤',
'internalerror_info'   => '內誤：$1',
'filecopyerror'        => '"$1"未可謄至"$2"。',
'filerenameerror'      => '"$1"名未可更為"$2"。',
'filedeleteerror'      => '"$1"未可刪。',
'directorycreateerror' => '"$1"之目莫能立也。',
'filenotfound'         => '未見"$1"。',
'fileexistserror'      => '"$1"檔莫之能書︰蓋因其檔已在',
'unexpected'           => '異數，"$1"="$2"。',
'formerror'            => '有誤：表未可呈',
'badarticleerror'      => '此頁莫為之',
'cannotdelete'         => '此頁或刪矣，不復為之',
'badtitle'             => '無此題',
'badtitletext'         => '或別、或缺、或違、或他山謬通，此題不存。',
'perfdisabled'         => '歉哉，此舉累甚，他恐不得，故封也。',
'perfcached'           => '下為謄本，恐不新。',
'perfcachedts'         => '下為謄本，$1已新之。',
'wrong_wfQuery_params' => 'wfQuery()參數有誤<br />
函式: $1<br />
問語: $2',
'viewsource'           => '案碼',
'viewsourcefor'        => '$1',
'protectedinterface'   => '此頁司版面，錮之以遠濫。',
'editinginterface'     => "'''警示：'''此頁司版面，一人易之眾人動，懇請戒慎之。",
'sqlhidden'            => '藏SQL問語',
'cascadeprotected'     => '這頁已錮，因註"連環錮"之{{PLURAL:$1|一|多}}頁有：
$2',
'namespaceprotected'   => "舉凡'''$1'''者，爾無權耳，莫之能修。",
'customcssjsprotected' => '爾無權耳，莫之能修，含他之喜好也。',
'ns-specialprotected'  => '{{ns:special}}領域之頁無修也。',

# Login and logout pages
'logouttitle'                => '去簿',
'logouttext'                 => '<strong>子去簿矣</strong><br />
子可匿名還覽{{SITENAME}}，或復登同簿、異簿。瀏覽器謄本未清，文舊，留意之。',
'welcomecreation'            => '== $1大駕光臨! ==
子簿已增，可更[[Special:Preferences|簿註]]。',
'loginpagetitle'             => '合符節',
'yourname'                   => '名',
'yourpassword'               => '符節',
'yourpasswordagain'          => '復核符節',
'remembermypassword'         => '記之',
'loginproblem'               => '<b>登簿有誤</b><br />請再之',
'login'                      => '登簿',
'loginprompt'                => '登簿{{SITENAME}}須cookies，請釋之。',
'userlogin'                  => '登簿／增簿',
'logout'                     => '去簿',
'userlogout'                 => '去簿',
'notloggedin'                => '尚未登簿',
'nologin'                    => '$1無簿乎？',
'nologinlink'                => '增簿',
'createaccount'              => '增簿',
'gotaccount'                 => '$1有簿矣乎？',
'gotaccountlink'             => '登簿',
'createaccountmail'          => '同電郵',
'badretype'                  => '符節不合',
'userexists'                 => '簿名存矣，請更之',
'youremail'                  => '電郵：',
'username'                   => '簿名：',
'uid'                        => '名：',
'yourrealname'               => '實名：',
'yourlanguage'               => '語言：',
'yourvariant'                => '變字：',
'yournick'                   => '號：',
'email'                      => '電郵',
'prefs-help-realname'        => '本名可略也。若爾供，則用以註汝之作。',
'loginerror'                 => '登簿有誤',
'prefs-help-email'           => '電郵可略也。以此通他人，或於共議處匿論。',
'nocookiesnew'               => '簿已增而未登。登簿{{SITENAME}}須cookies，請釋之後登。',
'nocookieslogin'             => '登簿{{SITENAME}}須cookies，請釋之後登。',
'noname'                     => '簿名缺',
'loginsuccesstitle'          => '登簿成矣',
'loginsuccess'               => "'''$1'''登簿{{SITENAME}}矣",
'nosuchuser'                 => '查無"$1"，請核之或增簿。',
'nosuchusershort'            => '查無"$1"，請核之。',
'nouserspecified'            => '須簿名',
'wrongpassword'              => '符節不合，請核之。',
'wrongpasswordempty'         => '缺符節，請補之。',
'passwordtooshort'           => '符節過短，須逾$1字，且跟簿異。',
'mailmypassword'             => '遣吾符節',
'passwordremindertitle'      => '符節遣自{{SITENAME}}',
'passwordremindertext'       => '$1求遣{{SITENAME}}（$4）"$2"符節於此，係"$3"。

若非汝求，或省更之，略之即可。',
'noemail'                    => '"$1"無存址',
'passwordsent'               => '符節遣$1矣"，請復登之。',
'eauthentsent'               => '核文遣矣。子循以核之，簿方可活。',
'mailerror'                  => '$1信未遣之',
'acct_creation_throttle_hit' => '歉哉，$1在矣，不可復增。',
'emailauthenticated'         => '$1郵驛證矣',
'emailnotauthenticated'      => '郵驛<strong>未證</strong>，下不遺書。',
'noemailprefs'               => '下需郵驛：',
'emailconfirmlink'           => '請考郵驛',
'invalidemailaddress'        => '驛址不格，請正之或空白。',
'accountcreated'             => '簿增矣',
'accountcreatedtext'         => '$1簿增矣',
'loginlanguagelabel'         => '語：$1',

# Edit page toolbar
'bold_sample'     => '粗體',
'bold_tip'        => '粗體',
'italic_sample'   => '斜體',
'italic_tip'      => '斜體',
'link_sample'     => '通',
'link_tip'        => '通內',
'extlink_tip'     => '冠http://以通外',
'headline_sample' => '題',
'headline_tip'    => '二題',
'math_sample'     => '此書方程式',
'math_tip'        => '數學方程式（LaTeX）',
'nowiki_sample'   => '此不排版',
'nowiki_tip'      => '不排維基之版',
'image_tip'       => '嵌圖',
'media_tip'       => '通影音檔',
'sig_tip'         => '署之與時',
'hr_tip'          => '縱線，慎用之',

# Edit pages
'summary'                   => '概',
'subject'                   => '題',
'minoredit'                 => '此乃小改',
'watchthis'                 => '派哨',
'savearticle'               => '儲存',
'preview'                   => '預覽',
'showpreview'               => '預覽',
'showlivepreview'           => '即覽',
'showdiff'                  => '示異',
'anoneditwarning'           => "'''警：'''子未登簿，IP將誌。",
'missingsummary'            => "''''醒：'''子未概之，復存之則文倍焉。",
'missingcommenttext'        => '請贊之',
'blockedtitle'              => '子見禁',
'blockedtext'               => "<big>'''子名、IP見禁。'''</big>

禁者$1也，因''$2''故。

* 始之時為：$8
* 終之時為：$6
* 見禁之人：$7

存惑可詢$1，或[[{{MediaWiki:grouppage-sysop}}|有秩]]，[[Special:Preferences|簿註]]無驛則信不遣。
另，子IP為$3，其禁號為#$5。詢時切附之。",
'autoblockedtext'           => "爾之IP或簿自禁，因簿先用，禁者$1也。
因故：

:\'\'$2\'\'

* 始之時為：$8
* 終之時為：$6

存惑可詢$1，或[[{{MediaWiki:grouppage-sysop}}|有秩]]，[[Special:Preferences|簿註]]無驛則信不遣。
另，子禁號為#$5。詢時切附之。",
'blockedoriginalsource'     => "'''$1'''本源如下：",
'blockededitsource'         => "子'''$1纂文'''如下：",
'whitelistedittitle'        => '登簿以纂',
'whitelistedittext'         => '$1後方可纂文。',
'whitelistreadtitle'        => '登簿以閱',
'whitelistreadtext'         => '[[Special:Userlogin|登簿]]後方可閱。',
'whitelistacctitle'         => '拒增此簿',
'whitelistacctext'          => '欲增此簿，[[Special:Userlogin|登簿]]求允',
'confirmedittitle'          => '證驛以纂',
'confirmedittext'           => '驛證方可纂文。請見[[Special:Preferences|簿註]]。',
'loginreqtitle'             => '須登簿',
'loginreqlink'              => '登簿',
'loginreqpagetext'          => '$1以覽它頁。',
'accmailtitle'              => '符節傳矣',
'accmailtext'               => '"$1"符節傳$2矣',
'newarticle'                => '撰',
'newarticletext'            => '此頁尚缺。欲補，撰於下，有惑見[[{{ns:help}}:Contents|助]]。
誤入者，返前即可。',
'anontalkpagetext'          => "----''此乃匿名論壇，為未簿或不簿者設，所言俱錄IP以辨人焉。然IP不獨有，恐生亂象，不喜請[[Special:Userlogin|登簿]]以遠之。",
'noarticletext'             => '此頁無文。子可 [[{{ns:special}}:Search/{{PAGENAME}}|尋同題]]，或[{{fullurl:{{FULLPAGENAME}}|action=edit}} 撰新文]。',
'clearyourcache'            => "'''註：'''重取頁面，文方新焉。
'''Mozilla / Firefox / Safari:'''押''Shift''並點''重新載入''，或合鍵''Ctrl-Shift-R''（Apple Mac為''Cmd-Shift-R''）。
'''IE:'''押''Ctrl''並點''重新整理''，或合鍵''Ctrl-F5''。
'''Konqueror:'''點''Reload''即可，或押''F5''。
'''Opera:'''須至''Tools→Preferences''清謄本。",
'usercssjsyoucanpreview'    => '<strong>訣：</strong>CSS/JS應先預覽而後存。',
'usercsspreview'            => "'''預覽CSS，尚未儲焉。'''",
'userjspreview'             => "'''預覽JavaScript，尚未儲焉。'''",
'userinvalidcssjstitle'     => "'''警：'''\"\$1\"無此面版。自製者，全名務小寫，如User:Foo/monobook.css 而非User:Foo/Monobook.css",
'updated'                   => '（新）',
'note'                      => '<strong>註</strong>',
'previewnote'               => '<strong>此乃預覽，尚未儲焉。</strong>',
'session_fail_preview'      => '<strong>歉哉有變，子纂未存焉，請再之。如復不成，簿重登焉。</strong>',
'session_fail_preview_html' => "<strong>歉哉有變，子纂未存焉</strong>

''此維基亦合純HTML，除預覽以遠惡JavaScript侵。''
<strong>纂文若合，請再之。如復不成，簿重登焉。</strong>",
'token_suffix_mismatch'     => '<strong>君修見拒，蓋因代理之故，亂事見兮。</strong>',
'editing'                   => '纂$1',
'editinguser'               => '<b>$1</b>正纂之',
'editingsection'            => '纂節$1',
'editingcomment'            => '贊$1',
'editconflict'              => '纂沖$1',
'explainconflict'           => '子纂與他人沖，上者時也，下者子也，望子合之。
註，<b>惟</b>上文儲焉<br />',
'yourtext'                  => '子也',
'storedversion'             => '時也',
'nonunicodebrowser'         => '<strong>警：子之瀏覽器不允萬國碼，以十六進位數代之，以保纂可也。</strong>',
'editingold'                => "<strong>'''警'''子纂已舊。如強儲之，則新易盡失矣。</strong>",
'yourdiff'                  => '異',
'copyrightwarning'          => '{{SITENAME}}全文皆循$2，詳見$1。若不喜己文它變，但去可矣。文務親撰，或謄公本，
<strong>萬勿盜版！</strong>',
'copyrightwarning2'         => '{{SITENAME}}全文，允眾人撰、纂、刪、校。如不喜己文它變，但去可矣。<br />
文務親撰，或謄公本，如$1。<strong>萬勿盜版！</strong>',
'longpagewarning'           => '<strong>警：此頁長$1仟位元組，逾卅二，瀏覽器恐不盡堪，望子縮之、斷之。<strong>',
'longpageerror'             => '<strong>警：子文長$1仟位元組，越限$2，未能儲焉。</strong>',
'readonlywarning'           => '<strong>警：檢修之故，庫藏鎖，存儲封矣。子自備之而後用。</strong>',
'protectedpagewarning'      => '<strong>警：庫藏鎖矣，惟有秩得纂之。</strong>',
'semiprotectedpagewarning'  => "'''註'''庫藏鎖矣，惟登簿得纂之。",
'templatesused'             => '此文所用之模：',
'nocreatetitle'             => '新題見禁',
'nocreatetext'              => '新題見禁，惟舊可修。可赦之以[[Special:Userlogin|登簿、增簿]]。',
'nocreate-loggedin'         => '爾無權創新頁。',
'permissionserrors'         => '權錯',
'permissionserrorstext'     => '據下{{PLURAL:$1|因|因}}，爾無權作動：',
'recreate-deleted-warn'     => "'''警：君欲重書斯文乎？'''

斯文也，嘗去耳，其據如下，若異乎君意，當書無妨；若君文同之，則請三思耳。",

# Account creation failure
'cantcreateaccounttitle' => '新簿莫增',
'cantcreateaccounttext'  => '子之IP <b>$1</b> 疑嘗惡，故見封。',

# History pages
'revhistory'          => '頁誌',
'viewpagelogs'        => '誌審',
'nohistory'           => '此題無誌',
'revnotfound'         => '此本覓不得',
'revnotfoundtext'     => '君所求之舊本覓不得，請君核所使之網址。',
'loadhist'            => '正取誌…',
'currentrev'          => '今審',
'revisionasof'        => '$1審',
'previousrevision'    => '←舊本',
'nextrevision'        => '新本→',
'currentrevisionlink' => '今審',
'cur'                 => '今',
'next'                => '後',
'last'                => '易',
'orig'                => '本',
'page_first'          => '首',
'page_last'           => '末',
'histlegend'          => '辨異：擇二孔後，按Enter、或點下鈕以辨之。<br />
釋，（今）：與今審辨；（新）：與前審辨, M：校',
'deletedrev'          => '[刪矣]',
'histfirst'           => '初',
'histlast'            => '末',
'historysize'         => '（$1位元組）',
'historyempty'        => '（空）',

# Revision feed
'history-feed-title'          => '誌審',
'history-feed-description'    => '維基誌審',
'history-feed-item-nocomment' => '$1於$2', # user at time
'history-feed-empty'          => '此頁不存，或刪、或更。類[[Special:Search|由此尋]]',

# Revision deletion
'rev-deleted-comment'         => '（此註刪矣）',
'rev-deleted-user'            => '（此簿刪矣）',
'rev-deleted-text-permission' => '<div class="mw-warning plainlinks">
此審刪矣，詳見[{{fullurl:Special:Log/delete|page={{PAGENAMEE}}}}誌刪].
</div>',
'rev-deleted-text-view'       => '<div class="mw-warning plainlinks">
此審刪矣，惟有秩可見之，詳見[{{fullurl:Special:Log/delete|page={{PAGENAMEE}}}} 誌刪].
</div>',
'rev-delundel'                => '見/藏',
'revisiondelete'              => '刪、還審',
'revdelete-nooldid-title'     => '無此審。',
'revdelete-nooldid-text'      => '審未擇，不可為之。',
'revdelete-selected'          => '審[[:$1]]已擇$2。',
'revdelete-text'              => '刪審雖見誌，其文摒公眾，惟有秩可得之。無規則有秩可復還焉。',
'revdelete-legend'            => '審，規之以：',
'revdelete-hide-text'         => '藏審文',
'revdelete-hide-comment'      => '藏贊',
'revdelete-hide-user'         => '簿、IP以藏',
'revdelete-log'               => '誌贊：',
'revdelete-submit'            => '擇審使之',

# Diffs
'difference'                => '（辨異）',
'loadingrev'                => '取審以辨…',
'lineno'                    => '列$1：',
'editcurrent'               => '纂今審',
'selectnewerversionfordiff' => '擇一新以辨',
'selectolderversionfordiff' => '擇一舊以辨',
'compareselectedversions'   => '辨所擇',
'editundo'                  => '返',

# Search results
'searchresults'         => '得尋',
'searchresulttext'      => '何索{{SITENAME}}，詳見[[{{MediaWiki:helppage}}|{{int:help}}]]。',
'searchsubtitle'        => "'''[[:$1]]'''尋焉",
'searchsubtitleinvalid' => "'''$1'''索焉",
'noexactmatch'          => "'''無題曰\"\$1\"'''。子可[[:\$1|撰之]]。",
'titlematches'          => '合題',
'notitlematches'        => '無題合',
'textmatches'           => '合文',
'notextmatches'         => '無文合',
'prevn'                 => '前$1',
'nextn'                 => '次$1',
'viewprevnext'          => '見（$1）（$2）（$3）',
'showingresults'        => '見<b>$1</b>尋，自<b>$2</b>始：',
'showingresultsnum'     => '見<b>$3</b>尋，自<b>$2</b>始：',
'powersearch'           => '索',

# Preferences page
'preferences'           => '簿註',
'mypreferences'         => '簿註',
'prefs-edits'           => '數篡：',
'prefsnologin'          => '未登簿',
'prefsnologintext'      => '註記須[[Special:Userlogin|登簿]]。',
'prefsreset'            => '簿註重謄',
'changepassword'        => '易符節',
'skin'                  => '面版',
'math'                  => '數學',
'dateformat'            => '日期格式',
'datedefault'           => '原註',
'datetime'              => '日期時間',
'math_failure'          => '譯不成',
'math_unknown_error'    => '未知之誤',
'math_unknown_function' => '未知函式',
'math_lexing_error'     => '律有誤',
'math_syntax_error'     => '語法有誤',
'prefs-personal'        => '概簿',
'prefs-rc'              => '近易',
'prefs-watchlist'       => '哨站',
'prefs-watchlist-days'  => '哨報有日長',
'prefs-watchlist-edits' => '哨站有易多',
'prefs-misc'            => '雜',
'saveprefs'             => '儲',
'resetprefs'            => '重置',
'oldpassword'           => '舊符節：',
'newpassword'           => '新符節：',
'retypenew'             => '重察新符節：',
'textboxsize'           => '在修',
'rows'                  => '行：',
'columns'               => '列：',
'searchresultshead'     => '索',
'resultsperpage'        => '頁有尋：',
'contextlines'          => '尋有列：',
'contextchars'          => '列有文：',
'recentchangescount'    => '近易有題：',
'savedprefs'            => '簿註書矣',
'timezonelegend'        => '時區',
'timezonetext'          => '與伺服器偏時有',
'localtime'             => '本地時',
'timezoneoffset'        => '偏¹',
'servertime'            => '伺服器時',
'guesstimezone'         => '瀏覽器填之',
'allowemail'            => '予收信',
'default'               => '予定',
'files'                 => '檔',

# User rights
'userrights-lookup-user'     => '司社',
'userrights-user-editname'   => '簿名：',
'editusergroup'              => '治社',
'userrights-editusergroup'   => '治社',
'saveusergroups'             => '定之',
'userrights-groupsmember'    => '有員：',
'userrights-groupsavailable' => '社可治有：',
'userrights-groupshelp'      => '揀社以增員、減員，未揀者不變也。欲略之，押Ctrl並左擊。',

# Groups
'group'               => '社:',
'group-autoconfirmed' => '自證其簿',
'group-bot'           => '僕',
'group-sysop'         => '有秩',
'group-bureaucrat'    => '門下',
'group-all'           => '（眾）',

'group-autoconfirmed-member' => '自證其簿',
'group-bot-member'           => '僕',
'group-sysop-member'         => '有秩',
'group-bureaucrat-member'    => '門下',

'grouppage-autoconfirmed' => '{{ns:project}}:自證其簿',
'grouppage-bot'           => '{{ns:project}}:僕',
'grouppage-sysop'         => '{{ns:project}}:有秩',
'grouppage-bureaucrat'    => '{{ns:project}}:門下',

# User rights log
'rightsnone' => '（凡）',

# Recent changes
'nchanges'                          => '$1易',
'recentchanges'                     => '近易',
'recentchangestext'                 => '大典新易，悉列於此。',
'rcnote'                            => '下為自<strong>$3</strong>起，<strong>$2</strong>日內<strong>$1</strong>近易也。',
'rcnotefrom'                        => '下為自<b>$2</b至<b>$1</b>之易也。',
'rclistfrom'                        => '自$1起之易也',
'rcshowhideminor'                   => '$1校',
'rcshowhidebots'                    => '$1僕',
'rcshowhideliu'                     => '$1簿',
'rcshowhideanons'                   => '$1匿名',
'rcshowhidepatr'                    => '$1哨',
'rcshowhidemine'                    => '$1吾纂',
'rclinks'                           => '$2日內$1近易。<br />$3',
'diff'                              => '辨',
'hist'                              => '誌',
'hide'                              => '藏',
'show'                              => '示',
'minoreditletter'                   => '校',
'newpageletter'                     => '新',
'boteditletter'                     => '僕',
'number_of_watching_users_pageview' => '[放有$1哨]',
'rc_categories_any'                 => '任',
'newsectionsummary'                 => '新節:',

# Recent changes linked
'recentchangeslinked'          => '鍵出文',
'recentchangeslinked-title'    => '$1之鍵出易',

# Upload
'upload'                     => '進獻',
'uploadbtn'                  => '進獻',
'reupload'                   => '復獻之',
'reuploaddesc'               => '返載獻',
'uploadnologin'              => '未登簿',
'uploadnologintext'          => '[[Special:Userlogin|登簿]]始可進獻',
'upload_directory_read_only' => '目錄$1禁入，無可獻。',
'uploaderror'                => '進獻有變',
'uploadtext'                 => "下表以獻，[[Special:Imagelist|載獻]]覽之。或見[[Special:Log/upload|誌獻]]。
欲嵌頁中，是格通之：
'''<nowiki>[[</nowiki>{{ns:image}}:File.jpg]]'''、
'''<nowiki>[[</nowiki>{{ns:image}}:File.png|名]]'''或
'''<nowiki>[[</nowiki>{{ns:media}}:File.ogg]]'''",
'uploadlog'                  => '誌獻',
'uploadlogpage'              => '誌獻',
'uploadlogpagetext'          => '近獻如下：',
'filename'                   => '名',
'filedesc'                   => '概',
'fileuploadsummary'          => '概：',
'filestatus'                 => '授權',
'filesource'                 => '源',
'uploadedfiles'              => '進獻',
'ignorewarning'              => '強儲之。',
'ignorewarnings'             => '警略。',
'minlength1'                 => '名務逾一字元。',
'illegalfilename'            => '名"$1"不格，更之再焉。',
'badfilename'                => '更名"$1。"。',
'large-file'                 => '檔長$2仟位元組，不逾$1為佳。',
'emptyfile'                  => '無以獻，疑謬名也，請核之。',
'fileexists'                 => '$1存矣，欲蓋之則再也。',
'successfulupload'           => '君成功置檔案於此',
'overwroteimage'             => '已置「[[$1]]」之新版也',
'sourcefilename'             => '源名',
'destfilename'               => '欲置檔名',
'watchthisupload'            => '派哨',

'license-nopreview' => '（預覽無視也）',

# Image list
'ilsubmit'                  => '尋',
'byname'                    => '以名',
'bydate'                    => '以日',
'bysize'                    => '以量',
'imgdelete'                 => '刪',
'imgdesc'                   => '述',
'imgfile'                   => '檔',
'filehist'                  => '檔案沿革',
'filehist-help'             => '擊日時，察時今檔。',
'filehist-deleteall'        => '刪全',
'filehist-deleteone'        => '刪此',
'filehist-revert'           => '還',
'filehist-current'          => '今',
'filehist-datetime'         => '日時',
'filehist-user'             => '薄',
'filehist-dimensions'       => '度',
'filehist-filesize'         => '檔量',
'filehist-comment'          => '注',
'imagelinks'                => '通',
'shareduploadwiki'          => '欲知更多，請詳閱$1。',
'shareduploadwiki-linktext' => '文件描述頁',
'imagelist_date'            => '時',
'imagelist_name'            => '名',
'imagelist_user'            => '簿',
'imagelist_size'            => '量（位元組）',
'imagelist_description'     => '述',
'imagelist_search_for'      => '以圖名尋：',

# File reversion
'filerevert'                => '還$1',
'filerevert-legend'         => '還檔',
'filerevert-intro'          => '<span class="plainlinks">汝還\'\'\'[[Media:$1|$1]]\'\'\'至[$4 在$2$3之版本]。</span>',
'filerevert-comment'        => '注:',
'filerevert-defaultcomment' => '已還至在$1$2之版矣',
'filerevert-submit'         => '還',
'filerevert-success'        => '<span class="plainlinks">\'\'\'[[Media:$1|$1]]\'\'\'已還[$4 在$2$3之版本]矣。</span>',
'filerevert-badversion'     => '此檔之時印無本地之前版也。',

# File deletion
'filedelete'             => '刪$1',
'filedelete-legend'      => '刪檔',
'filedelete-intro'       => "汝刪'''[[Media:$1|$1]]'''。",
'filedelete-intro-old'   => "<span class=\"plainlinks\">汝刪'''[[Media:$1|$1]]'''在[$4 $2$3]之版本。</span>",
'filedelete-comment'     => '注:',
'filedelete-submit'      => '刪',
'filedelete-success'     => "'''$1'''已刪矣。",
'filedelete-success-old' => "<span class=\"plainlinks\">'''[[Media:$1|$1]]'''在 $2$3 之版本已刪矣。</span>",
'filedelete-nofile'      => "'''$1'''在本網無存也。",
'filedelete-nofile-old'  => "指屬，無'''$1'''在 $2$3 之版本也。",
'filedelete-iscurrent'   => '汝試刪近之檔。先退至舊版也。',

# Unwatched pages
'unwatchedpages' => '無哨',

# Statistics
'statistics'             => '統計',
'sitestats'              => '{{SITENAME}}統計',
'userstats'              => '統計有簿者',
'sitestatstext'          => "庫藏共'''$1'''頁，除議、釋、芻文、轉與不濟者，有足文$2、獻品'''$8'''。
自大典始焉，閱頁'''$3'''，纂文'''$4'''。均之則每頁'''$5'''覽，每文'''$6'''纂。
[http://meta.wikimedia.org/wiki/Help:Job_queue job queue]長'''$7'''",
'userstatstext'          => "有[[Special:Listusers|簿]]者'''$1'''，中有'''$2'''人有$5之權，計有百分之'''$4'''。",
'statistics-mostpopular' => '首博之頁',

'disambiguations' => '釋義',

'doubleredirects'     => '複轉',
'doubleredirectstext' => '此頁列全之複轉之頁，轉另轉之頁也。每行含複轉鏈，二之目標也，顯「真」目標，首應轉至也。',

'brokenredirects'     => '斷轉',
'brokenredirectstext' => '不通',

# Miscellaneous special pages
'nbytes'                  => '$1位元組',
'ncategories'             => '$1門',
'nlinks'                  => '$1通',
'nmembers'                => '$1簿',
'nrevisions'              => '$1審',
'nviews'                  => '$1閱',
'lonelypages'             => '孤頁',
'lonelypagestext'         => '此頁無通',
'uncategorizedpages'      => '門無屬',
'uncategorizedcategories' => '此門未屬焉',
'uncategorizedimages'     => '圖無屬',
'unusedcategories'        => '此圖未屬焉',
'popularpages'            => '膾炙',
'wantedcategories'        => '缺門',
'wantedpages'             => '缺頁',
'mostrevisions'           => '首審之文',
'allpages'                => '全頁',
'randompage'              => '清風翻書',
'shortpages'              => '短頁',
'longpages'               => '長頁',
'listusers'               => '盡列有簿',
'specialpages'            => '奇頁',
'spheading'               => '眾可觀之非凡頁',
'restrictedpheading'      => '含禁忌之非凡頁',
'newpages'                => '新頁',
'newpages-username'       => '名：',
'ancientpages'            => '舊頁',
'intl'                    => '通他語',
'move'                    => '遷',
'movethispage'            => '遷此頁',

'categoriespagetext' => '大典有門：',
'version'            => '版',

# Special:Log
'specialloguserlabel'  => '有簿：',
'speciallogtitlelabel' => '題：',
'log'                  => '誌',
'logempty'             => '無是項存稿。',

# Special:Allpages
'nextpage'          => '次頁，$1',
'allpagesfrom'      => '見頁自：',
'allarticles'       => '全文',
'allinnamespace'    => '全頁（$1領域者）',
'allnotinnamespace' => '全頁（非$1領域者）',
'allpagesprev'      => '前',
'allpagesnext'      => '次',
'allpagessubmit'    => '往',
'allpagesprefix'    => '見頁冠以：',

# Special:Listusers
'listusersfrom'    => '列有簿自：',
'listusers-submit' => '示',

# E-mail user
'mailnologin'     => '無驛',
'mailnologintext' => '君須[[Special:Userlogin|登簿]]，方可遺書。
並在[[Special:Preferences|喜好]]之內，書電郵之址，方能電郵他人。',
'emailuser'       => '遺是君書',
'emailpage'       => '遺書',
'defemailsubject' => '{{SITENAME}}有信',
'noemailtitle'    => '無驛',
'emailfrom'       => '自',
'emailto'         => '至',
'emailsubject'    => '題',
'emailmessage'    => '訊',
'emailsend'       => '遣',
'emailsent'       => '信遣矣',
'emailsenttext'   => '信遣矣',

# Watchlist
'watchlist'            => '哨站',
'watchlistfor'         => "（'''$1'''之哨）",
'nowatchlist'          => '無哨',
'watchlistanontext'    => '$1以治哨',
'watchnologin'         => '未登簿',
'watchnologintext'     => '[[Special:Userlogin|登簿]]以治哨。',
'addedwatch'           => '派哨',
'addedwatchtext'       => "加哨\"[[:\$1]]\"。後有易、議者可見於[[Special:Watchlist|哨站]]，或'''粗體'''醒於[[Special:Recentchanges|列近易]]。

後如欲撤之，點側欄之\"撤哨\"即可。",
'removedwatch'         => '撤哨',
'removedwatchtext'     => '"[[:$1]]"哨已撤。',
'watch'                => '哨',
'watchthispage'        => '派哨',
'unwatch'              => '無哨',
'unwatchthispage'      => '撤哨',
'notanarticle'         => '此頁非文',
'watchnochange'        => '皆無易也',
'watchlist-details'    => '共有$1哨，不含議論。',
'wlheader-enotif'      => '*准報信。',
'wlheader-showupdated' => "*有易者'''粗體'''。",
'watchlistcontains'    => '哨有$1頁',
'iteminvalidname'      => "'$1'謬名",
'wlnote'               => '前<b>$2</b>時有$1者易',
'wlshowlast'           => '下為自$1小時；$2天；$3之纂。',
'watchlist-show-bots'  => '示僕',
'watchlist-hide-bots'  => '藏僕',
'watchlist-show-own'   => '示吾纂',
'watchlist-hide-own'   => '藏吾纂',
'watchlist-show-minor' => '示校',
'watchlist-hide-minor' => '藏校',

'enotif_mailer'      => '{{SITENAME}}報',
'enotif_reset'       => '記之通閱',
'enotif_newpagetext' => '新頁',
'changed'            => '易矣',
'created'            => '撰矣',
'enotif_subject'     => '{$PAGEEDITDATE}{{SITENAME}}有文{$PAGETITLE}為{$PAGEEDITOR}{$CHANGEDORCREATED}',
'enotif_lastvisited' => '新易見$1',
'enotif_body'        => '$WATCHINGUSERNAME鈞鑑，
{$PAGEEDITDATE}{{SITENAME}}有文{$PAGETITLE}為{$PAGEEDITOR}{$CHANGEDORCREATED}，詳見{$PAGETITLE_URL}。

$NEWPAGE

編者略：$PAGESUMMARY $PAGEMINOREDIT

聯繫之以
電郵：$PAGEEDITOR_EMAIL
維基：$PAGEEDITOR_WIKI

後有哨報，悉照此例遣，或訪維基更之。

             {{SITENAME}}敬上

--
哨報，見{{fullurl:{{ns:special}}:Watchlist/edit}}。
饋之、助之，見{{fullurl:{{ns:help}}:Contents}}',

# Delete/protect/revert
'deletepage'                  => '刪頁',
'confirm'                     => '准',
'excontent'                   => "文乃：'$1'",
'excontentauthor'             => "文乃：'$1' （而[[Special:Contributions/$2|$2]]者，為僅有之與者也）",
'exblank'                     => '缺頁',
'confirmdelete'               => '准刪',
'deletesub'                   => '（"$1"，正刪之）',
'historywarning'              => '警：欲刪之頁有誌：',
'confirmdeletetext'           => '子若欲久刪此物與其誌，知後果、合[[{{MediaWiki:policy-url}}]]後再為之。',
'actioncomplete'              => '已矣',
'deletedtext'                 => '"$1"刪矣，見誌於$2。',
'deletedarticle'              => '"[[$1]]"刪矣',
'dellogpage'                  => '誌刪',
'dellogpagetext'              => '近刪一覽。',
'deletionlog'                 => '誌刪',
'reverted'                    => '還',
'deletecomment'               => '註刪',
'rollback'                    => '退修',
'rollback_short'              => '退',
'rollbacklink'                => '退',
'rollbackfailed'              => '退敗',
'alreadyrolled'               => '退至[[User:$2|$2]]（[[User talk:$2|議]]）對[[$1]]不可也；某君已編修或回退此文。 

最終編修自[[User:$3|$3]]（[[User talk:$3|議]]）。',
'editcomment'                 => '贊："<i>$1</i>"', # only shown if there is an edit comment
'revertpage'                  => '蓋[[Special:Contributions/$2|$2]] （[[User talk:$2|議]]）者，所修無理，故去之，復為[[User:$1|$1]]之本耳',
'rollback-success'            => '蓋$1者，所修無理，故去之，復為$2之本耳。',
'protectlogpage'              => '誌錮',
'protectlogtext'              => '誌錮赦如下：',
'protectedarticle'            => '"[[$1]]"有錮',
'unprotectedarticle'          => '"[[$1]]"有赦',
'protectsub'                  => '（正錮"$1"）',
'confirmprotect'              => '准錮',
'protectcomment'              => '錮之有由：',
'unprotectsub'                => '（正赦"$1"）',
'protect-unchain'             => '准遷之',
'protect-text'                => '錮級可見<strong>$1</strong>',
'protect-default'             => '（予定）',
'protect-fallback'            => '需「$1」之權',
'protect-level-autoconfirmed' => '驅無簿',
'protect-level-sysop'         => '惟有秩',

# Restrictions (nouns)
'restriction-edit' => '纂',
'restriction-move' => '遷',

# Undelete
'undelete'                     => '覽已刪',
'undeletepage'                 => '覽已刪並還之',
'viewdeletedpage'              => '覽已刪',
'undeletepagetext'             => '列已刪如下。有複存可還之，常清。',
'undeleterevisions'            => '有審$1',
'undelete-revision'            => '刪$1自$3（於$2）所篡之審：',
'undeletebtn'                  => '還',
'undeletereset'                => '重置',
'undeletecomment'              => '贊：',
'undeletedarticle'             => '"[[$1]]"還矣',
'undeletedrevisions'           => '$1審還矣',
'undeletedrevisions-files'     => '$1審$2檔還矣',
'undeletedfiles'               => '$1檔還矣',
'cannotundelete'               => '無以還檔，或早復矣。',
'undeletedpage'                => "<big>'''$1還矣'''</big>
見[[Special:Log/delete|刪還誌]]",
'undelete-filename-mismatch'   => '欲復之檔名有誤，故無以復$1',
'undelete-bad-store-key'       => '$1之檔，蓋本無之，故無之復也。',
'undelete-cleanup-error'       => '"$1"存檔，蓋被誤刪耳。',
'undelete-missing-filearchive' => '$1者，無以復，蓋或已復矣。',
'undelete-error-short'         => '欲復檔時，見誤也：$1',
'undelete-error-long'          => '夫復檔時，見誤耳：

$1',

# Namespace form on various pages
'namespace' => '名集：',
'invert'    => '逆擇',
'blanknamespace' => '（主）',

# Contributions
'contributions' => '功績',
'mycontris'     => '吾績',
'contribsub2'   => '$1之功績 （$2）',
'nocontribs'    => '尺斯無易',
'ucnote'        => '近<b>$2</b>有<b>$1</b>新易。',
'uclinks'       => ' 近$1易，近$2日',
'uctop'         => ' （頂）',
'month'         => '自該月 （或先於其者）:',
'year'          => '自該年 （或先於其者）:',

'sp-contributions-newest'      => '末',
'sp-contributions-oldest'      => '首',
'sp-contributions-newer'       => '後$1',
'sp-contributions-older'       => '前$1',
'sp-contributions-newbies'     => '僅列初來之人',
'sp-contributions-newbies-sub' => '予新進',
'sp-contributions-blocklog'    => '誌禁',
'sp-contributions-search'      => '尋往績',
'sp-contributions-username'    => 'IP或簿名：',
'sp-contributions-submit'      => '尋',

'sp-newimages-showfrom' => '賞新圖，自$1',

# What links here
'whatlinkshere'       => '何通此',
'whatlinkshere-title' => '通$1之頁',
'notargettitle'       => '無向',
'linklistsub'         => '（表通）',
'linkshere'           => "下文通'''[[:$1]]''':",
'nolinkshere'         => "無頁通'''[[:$1]]'''.",
'nolinkshere-ns'      => "名集中無頁通'''[[:$1]]'''.",
'isredirect'          => '導',
'istemplate'          => '含',
'whatlinkshere-prev'  => '前$1通',
'whatlinkshere-next'  => '次$1通',
'whatlinkshere-links' => '← 通',

# Block/unblock
'blockip'              => '禁簿',
'ipaddress'            => 'IP址',
'ipadressorusername'   => 'IP或簿名',
'ipbexpiry'            => '限期',
'ipbreason'            => '緣',
'ipbanononly'          => '禁名匿',
'ipbcreateaccount'     => '禁增簿',
'ipbsubmit'            => '禁此簿',
'ipbother'             => '它時',
'ipboptions'           => '二時:2 hours,一日:1 day,三日:3 days,一週:1 week,二週:2 weeks,一月:1 month,三月:3 months,六月:6 months,一年:1 year,永:infinite',
'ipbotheroption'       => '他',
'badipaddress'         => 'IP不格',
'blockipsuccesssub'    => '見禁',
'blockipsuccesstext'   => '[[{{ns:Special}}:Contributions/$1|$1]]見禁<br />見[[{{ns:Special}}:Ipblocklist|誌禁]]',
'unblockip'            => '赦禁簿',
'unblockiptext'        => '以下表赦禁簿、IP：',
'ipusubmit'            => '赦此址',
'unblocked'            => '[[User:$1|$1]]見赦。',
'ipblocklist'          => '列禁簿、禁IP：',
'ipblocklist-legend'   => '尋禁簿',
'ipblocklist-username' => '簿或IP:',
'blocklistline'        => '$1,$2禁$3（$4）',
'infiniteblock'        => '永',
'expiringblock'        => '過$1',
'anononlyblock'        => '惟名匿',
'createaccountblock'   => '禁增簿',
'ipblocklist-empty'    => '誌空也。',
'blocklink'            => '禁',
'unblocklink'          => '赦',
'contribslink'         => '功績',
'autoblocker'          => '近日"[[User:$1|$1]]"用子IP"\'\'\'$2\'\'\'"，故禁',
'blocklogpage'         => '誌禁',
'blocklogentry'        => '禁[[$1]]至$2 $3',
'unblocklogentry'      => '赦$1',
'ipb_expiry_invalid'   => '限期不格。',
'ipb_already_blocked'  => '"$1"早禁矣',
'proxyblocksuccess'    => '已矣',

# Developer tools
'lockdb'              => '鎖庫藏',
'unlockdb'            => '解庫藏',
'lockconfirm'         => '篤欲鎖之',
'unlockconfirm'       => '篤欲解之',
'lockbtn'             => '鎖',
'unlockbtn'           => '解',
'lockdbsuccesssub'    => '庫藏鎖矣',
'unlockdbsuccesssub'  => '庫藏解矣',
'lockdbsuccesstext'   => '庫藏鎖矣。<br />檢修後務[[Special:Unlockdb|解之]]。',
'unlockdbsuccesstext' => '庫藏解矣',
'databasenotlocked'   => '庫藏未鎖',

# Move page
'movepage'         => '遷文',
'movearticle'      => '遷此文:',
'movenologin'      => '未登簿',
'movenologintext'  => '遷文須[[Special:Userlogin|登簿]]。',
'movenotallowed'   => '爾無遷頁之權也。',
'newtitle'         => '至新題:',
'move-watch'       => '哨',
'movepagebtn'      => '遷此頁',
'pagemovedsub'     => '成',
'movepage-moved'   => "<big>'''「$1」遷「$2」矣'''</big>", # The two titles are passed in plain text as $3 and $4 to allow additional goodies in the message.
'articleexists'    => '此頁復存，或名謬焉。請更之。',
'movedto'          => '遷至',
'movetalk'         => '並遷其議',
'talkpagemoved'    => '其議已並遷。',
'talkpagenotmoved' => '其議<strong>未</strong>並遷。',
'1movedto2'        => '[[$1]]遷[[$2]]矣',
'1movedto2_redir'  => '[[$1]]遷[[$2]]矣',
'movelogpage'      => '誌遷',
'movelogpagetext'  => '有遷如下：',
'movereason'       => '因',
'revertmove'       => '還',
'delete_and_move'  => '刪並遷',

# Export
'export-download' => '供存文',

# Namespace 8 related
'allmessages'         => '官訊',
'allmessagesname'     => '名',
'allmessagesdefault'  => '予定文',
'allmessagescurrent'  => '今文',
'allmessagestext'     => '此為MediaWiki領域處所含之系統訊息一覽。',
'allmessagesfilter'   => '濾訊名：',
'allmessagesmodified' => '見曾易',

# Thumbnails
'thumbnail-more' => '放',
'missingimage'   => '<b>失圖</b><br /><i>$1</i>',
'filemissing'    => '檔已失。',

# Special:Import
'import-interwiki-submit' => '匯入',
'importstart'             => '正匯入…',
'import-revision-count'   => '共$1審',
'importnopages'           => '無可匯。',
'importfailed'            => '匯入有變：$1',
'importsuccess'           => '匯入成矣！',

# Import log
'import-logentry-upload-detail'    => '共$1審',
'import-logentry-interwiki-detail' => '$1審自$2',

# Tooltip help for the actions
'tooltip-pt-userpage'             => '余齋',
'tooltip-pt-anonuserpage'         => '君IP之舍',
'tooltip-pt-mytalk'               => '余議事處',
'tooltip-pt-anontalk'             => '此IP所修之議',
'tooltip-pt-preferences'          => '余之所好',
'tooltip-pt-watchlist'            => '余之哨站',
'tooltip-pt-mycontris'            => '吾績',
'tooltip-pt-login'                => '誠望君登簿，縱非必須耳。',
'tooltip-pt-anonlogin'            => '誠望君登簿，縱非必須耳。',
'tooltip-pt-logout'               => '登出',
'tooltip-ca-talk'                 => '關乎正文之議',
'tooltip-ca-edit'                 => '君可修斯文，惟望先察之，以保無誤。',
'tooltip-ca-addsection'           => '置新議於斯頁',
'tooltip-ca-viewsource'           => '斯文已護耳，君無可修也，惟仍可察其碼。',
'tooltip-ca-history'              => '斯文之前版。',
'tooltip-ca-protect'              => '護之',
'tooltip-ca-delete'               => '去之',
'tooltip-ca-undelete'             => '復之',
'tooltip-ca-move'                 => '遷之',
'tooltip-ca-watch'                => '置之於哨',
'tooltip-ca-unwatch'              => '自哨站去之',
'tooltip-search'                  => '索本站',
'tooltip-p-logo'                  => '卷首',
'tooltip-n-mainpage'              => '如卷首',
'tooltip-n-portal'                => '關乎本策，君可為之事、及何以為之',
'tooltip-n-currentevents'         => '言明今事之情',
'tooltip-n-recentchanges'         => '列其近易',
'tooltip-n-randompage'            => '清風翻書',
'tooltip-n-help'                  => '求助',
'tooltip-n-sitesupport'           => '資吾人耳',
'tooltip-t-whatlinkshere'         => '凡相連本文者，咸示之也',
'tooltip-t-recentchangeslinked'   => '凡本文有連者，其易咸示於斯',
'tooltip-minoredit'               => '此為校文',
'tooltip-save'                    => '儲簿註',
'tooltip-preview'                 => '預覽，儲前務覽之',
'tooltip-diff'                    => '覽易者',
'tooltip-compareselectedversions' => '二揀辨異',
'tooltip-watch'                   => '派哨',
'tooltip-recreate'                => '重建之',
'tooltip-upload'                  => '始獻',

# Attribution
'anonymous'        => '{{SITENAME}}無簿',
'siteuser'         => '{{SITENAME}}有簿$1',
'lastmodifiedatby' => '是頁由$3近易於$1 $2。', # $1 date, $2 time, $3 user
'and'              => '與',
'othercontribs'    => '$1主撰',
'others'           => '它',
'siteusers'        => '{{SITENAME}}有簿$1',

# Spam protection
'listingcontinuesabbrev' => '續',

# Info page
'infosubtitle'   => '頁註',
'numedits'       => '有纂$1',
'numtalkedits'   => '有議$1',
'numwatchers'    => '有哨$1',
'numauthors'     => '文有$1編者',
'numtalkauthors' => '議有$1與會',

# Patrolling
'markaspatrolleddiff'        => '派哨',
'markaspatrolledtext'        => '派哨',
'markedaspatrolled'          => '派哨',
'markedaspatrolledtext'      => '此審哨矣',
'rcpatroldisabled'           => '不哨近易',
'markedaspatrollederror'     => '未可哨',
'markedaspatrollederrortext' => '揀之方可哨',

# Image deletion
'deletedrevision'                 => '刪舊審$1。',
'filedeleteerror-short'           => '去檔時，見誤耳：$1',
'filedeleteerror-long'            => '刪檔時，見誤耳：

$1',
'filedelete-missing'              => '"$1"無以復，蓋因本無之。',
'filedelete-old-unregistered'     => '古檔 "$1" 者，資料庫所無也。',
'filedelete-current-unregistered' => '"$1" 者，資料庫所無也。',
'filedelete-archive-read-only'    => '"$1"之目，莫之能書。',

# Browsing diffs
'previousdiff' => '←前辨',
'nextdiff'     => '後辨→',

# Media information
'widthheight'     => '長$1寬$2',
'widthheightpage' => '長$1寬$2，頁$3',
'svg-long-desc'        => '（SVG檔，表長$1寬$2像素，檔積：$3）',

# Special:Newimages
'newimages'    => '新圖廊',
'showhidebots' => '（$1僕）',
'noimages'     => '無',

# Video information, used by Language::formatTimePeriod() to format lengths in the above messages
'video-dims'     => '$1，長$2寬$3',

# Bad image list
'bad_image_list' => '根式篡:

列示項（以 * 始）以慮也。首鏈必連壞圖也。
然，同行之鏈慮作例外，即圖可於文中示也。',

# Metadata
'metadata'          => '衍義',
'metadata-help'     => '斯檔也，所有之訊，蓋由數碼相機、掃描器之物所加，以數碼之。

倘嘗易之，衍義之果，或有異也。',
'metadata-expand'   => '示其詳',
'metadata-collapse' => '藏其詳',
'metadata-fields'   => '在EXIF衍義表毀時，兹列之訊，無有不示，他者則藏。
* 相機製造商
* 相機型號
* 本之時日
* 曝光時間
* 光圈(F值)
* 焦距',

# EXIF tags
'exif-imagewidth'        => '寬',
'exif-imagelength'       => '長',
'exif-datetime'          => '文檔修訂之日期時辰',
'exif-datetimeoriginal'  => '數據生成之日期時辰',
'exif-datetimedigitized' => '數位化之日期時辰',

# External editor support
'edit-externally'      => '以外部程式修此文',
'edit-externally-help' => '請閱[http://meta.wikimedia.org/wiki/Help:External_editors 安裝指引]以知詳情。',

# 'all' in various places, this might be different for inflected languages
'recentchangesall' => '全',
'imagelistall'     => '全',
'watchlistall2'    => '全',
'namespacesall'    => '全',
'monthsall'        => '全',

# E-mail address confirmation
'confirmemail'            => '核郵驛',
'confirmemail_noemail'    => '[[Special:Preferences|簿註]]有驛。',
'confirmemail_send'       => '遣核符',
'confirmemail_sent'       => '核符遣矣',
'confirmemail_sendfailed' => '信未遣焉，請核郵驛。

郵者覆之：$1',

# Scary transclusion
'scarytranscludedisabled' => '[蓋跨共筆之轉碼者，莫之能用也]',
'scarytranscludefailed'   => '[歉哉，$1模不得]',
'scarytranscludetoolong'  => '[歉哉，網址過長]',

# Trackbacks
'trackbackbox'      => '<div id="mw_trackbacks">
此文之引:<br />
$1
</div>',
'trackbackremove'   => ' （[$1刪]）',
'trackbacklink'     => '迴響',
'trackbackdeleteok' => 'Trackback 刪矣。',

# Delete conflict
'deletedwhileediting' => '警：纂中見刪。',
'confirmrecreate'     => "[[User:$1|$1]]（[[User talk:$1|議]]）刪之有由：
''$2''
請審視之。",
'recreate'            => '復',

# HTML dump
'redirectingto' => '轉至[[$1]]…',

# action=purge
'confirm_purge'        => '清謄本？

$1',
'confirm_purge_button' => '准',

# AJAX search
'searchcontaining' => "尋文含''$1''",
'searchnamed'      => "尋文名''$1''.",
'articletitles'    => "文首為''$1''",
'hideresults'      => '藏',

# Multipage image navigation
'imgmultipageprev'   => '←前頁',
'imgmultipagenext'   => '次頁→',
'imgmultigo'         => '往',
'imgmultigotopre'    => '往第',
'imgmultigotopost'   => '頁',
'imgmultiparseerror' => '斯圖也，類毀矣，故{{SITENAME}}無以得其表。',

# Table pager
'ascending_abbrev'         => '升冪',
'descending_abbrev'        => '降冪',
'table_pager_next'         => '次頁',
'table_pager_prev'         => '前頁',
'table_pager_first'        => '首頁',
'table_pager_last'         => '末頁',
'table_pager_limit'        => '頁有物$1',
'table_pager_limit_submit' => '往',
'table_pager_empty'        => '空',

# Auto-summaries
'autosumm-blank'   => '盡除之',
'autosumm-replace' => "置為'$1'",
'autoredircomment' => '轉至[[$1]]',
'autosumm-new'     => '新文：$1',

# Size units
'size-bytes'     => '$1 位元組',
'size-kilobytes' => '$1 KB',
'size-megabytes' => '$1 MB',
'size-gigabytes' => '$1 GB',

# Live preview
'livepreview-loading' => '在示…',
'livepreview-ready'   => '在示… 成！',
'livepreview-failed'  => '弗能即時示之！嘗以本法。',
'livepreview-error'   => '莫之連也：$1 "$2" 嘗以本法。',

# Friendlier slave lag warnings
'lag-warn-normal' => '凡易新於$1秒者，或無之示矣。',
'lag-warn-high'   => '蓋因資料庫延誤，凡易新於$1秒者，或無之示矣。',

# Watchlist editor
'watchlistedit-numitems'       => '不計議論，爾哨計有題$1。',
'watchlistedit-noitems'        => '爾哨無題也。',
'watchlistedit-clear-title'    => '清哨',
'watchlistedit-clear-legend'   => '清哨',
'watchlistedit-clear-confirm'  => '清整哨也。篤撤之？亦[[Special:Watchlist/edit|治哨站]]也。',
'watchlistedit-clear-submit'   => '清',
'watchlistedit-clear-done'     => '爾哨已清。整題已去之。',
'watchlistedit-normal-title'   => '治哨站',
'watchlistedit-normal-legend'  => '從哨站撤之',
'watchlistedit-normal-explain' => '此列有哨之題。要除題，揀之，擊撤題。亦[[Special:Watchlist/raw|治源哨]]或[[Special:Watchlist/clear|清哨]]也。',
'watchlistedit-normal-submit'  => '撤題',
'watchlistedit-normal-done'    => '$1題之哨已撤：',
'watchlistedit-raw-title'      => '治源哨',
'watchlistedit-raw-legend'     => '治源哨',
'watchlistedit-raw-explain'    => '此列有哨之題，治此表以加減題；一行一題之。善，擊更哨。亦[[Special:Watchlist/edit|標準治哨]]也。',
'watchlistedit-raw-titles'     => '題：',
'watchlistedit-raw-submit'     => '更哨',
'watchlistedit-raw-done'       => '爾哨已更也。',
'watchlistedit-raw-added'      => '已添$1題：',
'watchlistedit-raw-removed'    => '已撤$1題：',

# Watchlist editing tools
'watchlisttools-view'  => '察易',
'watchlisttools-edit'  => '治哨站',
'watchlisttools-raw'   => '治源哨',
'watchlisttools-clear' => '清哨',

);








