/*
 * Decompiled with CFR 0.152.
 */
package junit.samples.money;

import junit.framework.TestCase;
import junit.samples.money.IMoney;
import junit.samples.money.Money;
import junit.samples.money.MoneyBag;
import junit.textui.TestRunner;

public class MoneyTest
extends TestCase {
    private Money f12CHF;
    private Money f14CHF;
    private Money f7USD;
    private Money f21USD;
    private IMoney fMB1;
    private IMoney fMB2;

    public static void main(String[] args) {
        TestRunner.run(MoneyTest.class);
    }

    protected void setUp() {
        this.f12CHF = new Money(12, "CHF");
        this.f14CHF = new Money(14, "CHF");
        this.f7USD = new Money(7, "USD");
        this.f21USD = new Money(21, "USD");
        this.fMB1 = MoneyBag.create(this.f12CHF, this.f7USD);
        this.fMB2 = MoneyBag.create(this.f14CHF, this.f21USD);
    }

    public void testBagMultiply() {
        IMoney expected = MoneyBag.create(new Money(24, "CHF"), new Money(14, "USD"));
        MoneyTest.assertEquals(expected, this.fMB1.multiply(2));
        MoneyTest.assertEquals(this.fMB1, this.fMB1.multiply(1));
        MoneyTest.assertTrue(this.fMB1.multiply(0).isZero());
    }

    public void testBagNegate() {
        IMoney expected = MoneyBag.create(new Money(-12, "CHF"), new Money(-7, "USD"));
        MoneyTest.assertEquals(expected, this.fMB1.negate());
    }

    public void testBagSimpleAdd() {
        IMoney expected = MoneyBag.create(new Money(26, "CHF"), new Money(7, "USD"));
        MoneyTest.assertEquals(expected, this.fMB1.add(this.f14CHF));
    }

    public void testBagSubtract() {
        IMoney expected = MoneyBag.create(new Money(-2, "CHF"), new Money(-14, "USD"));
        MoneyTest.assertEquals(expected, this.fMB1.subtract(this.fMB2));
    }

    public void testBagSumAdd() {
        IMoney expected = MoneyBag.create(new Money(26, "CHF"), new Money(28, "USD"));
        MoneyTest.assertEquals(expected, this.fMB1.add(this.fMB2));
    }

    public void testIsZero() {
        MoneyTest.assertTrue(this.fMB1.subtract(this.fMB1).isZero());
        MoneyTest.assertTrue(MoneyBag.create(new Money(0, "CHF"), new Money(0, "USD")).isZero());
    }

    public void testMixedSimpleAdd() {
        IMoney expected = MoneyBag.create(this.f12CHF, this.f7USD);
        MoneyTest.assertEquals(expected, this.f12CHF.add(this.f7USD));
    }

    public void testBagNotEquals() {
        IMoney bag = MoneyBag.create(this.f12CHF, this.f7USD);
        MoneyTest.assertFalse(bag.equals(new Money(12, "DEM").add(this.f7USD)));
    }

    public void testMoneyBagEquals() {
        MoneyTest.assertTrue(!this.fMB1.equals(null));
        MoneyTest.assertEquals(this.fMB1, this.fMB1);
        IMoney equal = MoneyBag.create(new Money(12, "CHF"), new Money(7, "USD"));
        MoneyTest.assertTrue(this.fMB1.equals(equal));
        MoneyTest.assertTrue(!this.fMB1.equals(this.f12CHF));
        MoneyTest.assertTrue(!this.f12CHF.equals(this.fMB1));
        MoneyTest.assertTrue(!this.fMB1.equals(this.fMB2));
    }

    public void testMoneyBagHash() {
        IMoney equal = MoneyBag.create(new Money(12, "CHF"), new Money(7, "USD"));
        MoneyTest.assertEquals(this.fMB1.hashCode(), equal.hashCode());
    }

    public void testMoneyEquals() {
        MoneyTest.assertTrue(!this.f12CHF.equals(null));
        Money equalMoney = new Money(12, "CHF");
        MoneyTest.assertEquals(this.f12CHF, this.f12CHF);
        MoneyTest.assertEquals(this.f12CHF, equalMoney);
        MoneyTest.assertEquals(this.f12CHF.hashCode(), equalMoney.hashCode());
        MoneyTest.assertTrue(!this.f12CHF.equals(this.f14CHF));
    }

    public void testMoneyHash() {
        MoneyTest.assertTrue(!this.f12CHF.equals(null));
        Money equal = new Money(12, "CHF");
        MoneyTest.assertEquals(this.f12CHF.hashCode(), equal.hashCode());
    }

    public void testSimplify() {
        IMoney money = MoneyBag.create(new Money(26, "CHF"), new Money(28, "CHF"));
        MoneyTest.assertEquals(new Money(54, "CHF"), money);
    }

    public void testNormalize2() {
        Money expected = new Money(7, "USD");
        MoneyTest.assertEquals(expected, this.fMB1.subtract(this.f12CHF));
    }

    public void testNormalize3() {
        IMoney ms1 = MoneyBag.create(new Money(12, "CHF"), new Money(3, "USD"));
        Money expected = new Money(4, "USD");
        MoneyTest.assertEquals(expected, this.fMB1.subtract(ms1));
    }

    public void testNormalize4() {
        IMoney ms1 = MoneyBag.create(new Money(12, "CHF"), new Money(3, "USD"));
        Money expected = new Money(-3, "USD");
        MoneyTest.assertEquals(expected, this.f12CHF.subtract(ms1));
    }

    public void testPrint() {
        MoneyTest.assertEquals("[12 CHF]", this.f12CHF.toString());
    }

    public void testSimpleAdd() {
        Money expected = new Money(26, "CHF");
        MoneyTest.assertEquals(expected, this.f12CHF.add(this.f14CHF));
    }

    public void testSimpleBagAdd() {
        IMoney expected = MoneyBag.create(new Money(26, "CHF"), new Money(7, "USD"));
        MoneyTest.assertEquals(expected, this.f14CHF.add(this.fMB1));
    }

    public void testSimpleMultiply() {
        Money expected = new Money(28, "CHF");
        MoneyTest.assertEquals(expected, this.f14CHF.multiply(2));
    }

    public void testSimpleNegate() {
        Money expected = new Money(-14, "CHF");
        MoneyTest.assertEquals(expected, this.f14CHF.negate());
    }

    public void testSimpleSubtract() {
        Money expected = new Money(2, "CHF");
        MoneyTest.assertEquals(expected, this.f14CHF.subtract(this.f12CHF));
    }
}

