/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubySymbol;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefsNode
extends MethodDefNode
implements INameNode {
    private final Node receiverNode;

    public DefsNode(ISourcePosition position, Node receiverNode, ArgumentNode nameNode, ArgsNode argsNode, StaticScope scope, Node bodyNode) {
        super(position, nameNode, argsNode, scope, bodyNode, NodeType.DEFSNODE);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDefsNode(this);
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public String getName() {
        return this.nameNode.getName();
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.nameNode, this.argsNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
        String name = this.getName();
        if (runtime.getSafeLevel() >= 4 && !receiver.isTaint()) {
            throw runtime.newSecurityError("Insecure; can't define singleton method.");
        }
        if (receiver instanceof RubyFixnum || receiver instanceof RubySymbol) {
            throw runtime.newTypeError("can't define singleton method \"" + name + "\" for " + receiver.getMetaClass().getBaseName());
        }
        if (receiver.isFrozen()) {
            throw runtime.newFrozenError("object");
        }
        RubyClass rubyClass = receiver.getSingletonClass();
        if (runtime.getSafeLevel() >= 4 && rubyClass.getMethods().get(name) != null) {
            throw runtime.newSecurityError("redefining method prohibited.");
        }
        this.scope.determineModule();
        Node body = this.bodyNode == null ? new NilNode(this.getPosition()) : this.bodyNode;
        DefaultMethod newMethod = new DefaultMethod(rubyClass, this.scope, body, this.argsNode, Visibility.PUBLIC, this.getPosition());
        rubyClass.addMethod(name, newMethod);
        receiver.callMethod(context, "singleton_method_added", runtime.fastNewSymbol(name));
        return runtime.getNil();
    }
}

