/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.Utils;

public class XOpenTypeViewer
extends JPanel
implements ActionListener {
    JButton prev;
    JButton incr;
    JButton decr;
    JButton tabularPrev;
    JButton tabularNext;
    JLabel compositeLabel;
    JLabel tabularLabel;
    JScrollPane container;
    XOpenTypeData current;
    XOpenTypeDataListener listener;
    private static final String compositeNavigationSingle = Resources.getText("MBeansTab.compositeNavigationSingle", new Object[0]);
    private static final String tabularNavigationSingle = Resources.getText("MBeansTab.tabularNavigationSingle", new Object[0]);
    private static TableCellEditor editor = new Utils.ReadOnlyTableCellEditor(new JTextField());

    public static boolean isViewableValue(Object object) {
        if (object instanceof CompositeData || object instanceof TabularData) {
            return true;
        }
        if (object instanceof CompositeData[] || object instanceof TabularData[]) {
            return Array.getLength(object) > 0;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                return false;
            }
            return Utils.isUniformCollection(collection, CompositeData.class) || Utils.isUniformCollection(collection, TabularData.class);
        }
        return false;
    }

    public static Component loadOpenType(Object object) {
        XOpenTypeViewer xOpenTypeViewer = null;
        if (XOpenTypeViewer.isViewableValue(object)) {
            XOpenTypeViewer xOpenTypeViewer2;
            xOpenTypeViewer = xOpenTypeViewer2 = new XOpenTypeViewer(object);
        }
        return xOpenTypeViewer;
    }

    private XOpenTypeViewer(Object object) {
        block14: {
            Object object2;
            this.listener = new XOpenTypeDataListener();
            XCompositeData xCompositeData = null;
            if (object instanceof CompositeData) {
                xCompositeData = new XCompositeData(null, (CompositeData)object);
            } else if (object instanceof TabularData) {
                xCompositeData = new XTabularData(null, (TabularData)object);
            } else if (object instanceof CompositeData[]) {
                object2 = (CompositeData[])object;
                CompositeType compositeType = object2[0].getCompositeType();
                xCompositeData = new XArrayData(null, 1, compositeType, object2);
            } else if (object instanceof TabularData[]) {
                object2 = (TabularData[])object;
                TabularType tabularType = object2[0].getTabularType();
                xCompositeData = new XArrayData(null, 1, tabularType, object2);
            } else if (object instanceof Collection) {
                object2 = ((Collection)object).iterator().next();
                if (object2 instanceof CompositeData) {
                    Collection collection = (Collection)object;
                    CompositeData[] compositeDataArray = collection.toArray(new CompositeData[0]);
                    CompositeType compositeType = compositeDataArray[0].getCompositeType();
                    xCompositeData = new XArrayData(null, 1, compositeType, compositeDataArray);
                } else if (object2 instanceof TabularData) {
                    Collection collection = (Collection)object;
                    TabularData[] tabularDataArray = collection.toArray(new TabularData[0]);
                    TabularType tabularType = tabularDataArray[0].getTabularType();
                    xCompositeData = new XArrayData(null, 1, tabularType, tabularDataArray);
                }
            }
            this.setupDisplay(xCompositeData);
            try {
                ((XOpenTypeData)xCompositeData).viewed(this);
            }
            catch (Exception exception) {
                if (!JConsole.isDebug()) break block14;
                System.out.println("Exception viewing openType : " + exception);
                exception.printStackTrace();
            }
        }
    }

    void setOpenType(XOpenTypeData xOpenTypeData) {
        boolean bl;
        Navigatable navigatable;
        if (this.current != null) {
            this.current.removeMouseListener(this.listener);
        }
        this.current = xOpenTypeData;
        if (this.current.getViewedParent() == null) {
            this.prev.setEnabled(false);
        } else {
            this.prev.setEnabled(true);
        }
        this.current.addMouseListener(this.listener);
        if (!(xOpenTypeData instanceof XViewedTabularData)) {
            this.tabularPrev.setEnabled(false);
            this.tabularNext.setEnabled(false);
            this.tabularLabel.setText(tabularNavigationSingle);
            this.tabularLabel.setEnabled(false);
        } else {
            navigatable = (XViewedTabularData)((Object)xOpenTypeData);
            this.tabularNext.setEnabled(navigatable.canIncrement());
            this.tabularPrev.setEnabled(navigatable.canDecrement());
            boolean bl2 = bl = navigatable.canIncrement() || navigatable.canDecrement();
            if (bl) {
                this.tabularLabel.setText(Resources.getText("MBeansTab.tabularNavigationMultiple", String.format("%d", navigatable.getSelectedElementIndex() + 1), String.format("%d", navigatable.getElementCount())));
            } else {
                this.tabularLabel.setText(tabularNavigationSingle);
            }
            this.tabularLabel.setEnabled(bl);
        }
        if (!(xOpenTypeData instanceof XViewedArrayData)) {
            this.incr.setEnabled(false);
            this.decr.setEnabled(false);
            this.compositeLabel.setText(compositeNavigationSingle);
            this.compositeLabel.setEnabled(false);
        } else {
            navigatable = (XViewedArrayData)((Object)xOpenTypeData);
            this.incr.setEnabled(navigatable.canIncrement());
            this.decr.setEnabled(navigatable.canDecrement());
            boolean bl3 = bl = navigatable.canIncrement() || navigatable.canDecrement();
            if (bl) {
                this.compositeLabel.setText(Resources.getText("MBeansTab.compositeNavigationMultiple", String.format("%d", navigatable.getSelectedElementIndex() + 1), String.format("%d", navigatable.getElementCount())));
            } else {
                this.compositeLabel.setText(compositeNavigationSingle);
            }
            this.compositeLabel.setEnabled(bl);
        }
        this.container.invalidate();
        this.container.setViewportView(this.current);
        this.container.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.prev) {
                XOpenTypeData xOpenTypeData = this.current.getViewedParent();
                try {
                    xOpenTypeData.viewed(this);
                }
                catch (Exception exception) {}
            } else if (jButton == this.incr) {
                ((XViewedArrayData)((Object)this.current)).incrElement();
                try {
                    this.current.viewed(this);
                }
                catch (Exception exception) {}
            } else if (jButton == this.decr) {
                ((XViewedArrayData)((Object)this.current)).decrElement();
                try {
                    this.current.viewed(this);
                }
                catch (Exception exception) {}
            } else if (jButton == this.tabularNext) {
                ((XViewedTabularData)((Object)this.current)).incrElement();
                try {
                    this.current.viewed(this);
                }
                catch (Exception exception) {}
            } else if (jButton == this.tabularPrev) {
                ((XViewedTabularData)((Object)this.current)).decrElement();
                try {
                    this.current.viewed(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void setupDisplay(XOpenTypeData xOpenTypeData) {
        this.setBackground(Color.white);
        this.container = new JScrollPane(xOpenTypeData, 20, 30);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.tabularPrev = new JButton(Resources.getText("<", new Object[0]));
        this.tabularNext = new JButton(Resources.getText(">", new Object[0]));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.tabularPrev);
        this.tabularPrev.addActionListener(this);
        this.tabularLabel = new JLabel(tabularNavigationSingle);
        this.tabularLabel.setEnabled(false);
        jPanel2.add(this.tabularLabel);
        jPanel2.add(this.tabularNext);
        this.tabularNext.addActionListener(this);
        jPanel2.setBackground(Color.white);
        this.prev = new JButton(Resources.getText("<<", new Object[0]));
        this.prev.addActionListener(this);
        jPanel.add(this.prev);
        this.incr = new JButton(Resources.getText(">", new Object[0]));
        this.incr.addActionListener(this);
        this.decr = new JButton(Resources.getText("<", new Object[0]));
        this.decr.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        jPanel3.add(this.decr);
        this.compositeLabel = new JLabel(compositeNavigationSingle);
        this.compositeLabel.setEnabled(false);
        jPanel3.add(this.compositeLabel);
        jPanel3.add(this.incr);
        jPanel.add(jPanel3);
        this.setLayout(new BorderLayout());
        jPanel.setBackground(Color.white);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBackground(Color.white);
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)jPanel, "West");
        this.add((Component)jPanel4, "North");
        this.add((Component)this.container, "Center");
        Dimension dimension = new Dimension((int)this.container.getPreferredSize().getWidth() + 20, (int)this.container.getPreferredSize().getHeight() + 20);
        this.setPreferredSize(dimension);
    }

    static class XArrayData
    extends XCompositeData
    implements XViewedArrayData {
        private int dimension;
        private int size;
        private OpenType elemType;
        private Object val;
        private boolean isCompositeType;
        private boolean isTabularType;
        private int currentIndex;
        private CompositeData[] elements;
        private final String[] arrayColumns = new String[]{Resources.getText("Value", new Object[0])};
        private Font normalFont;
        private Font boldFont;

        XArrayData(XOpenTypeData xOpenTypeData, ArrayType arrayType, Object object) {
            this(xOpenTypeData, arrayType.getDimension(), arrayType.getElementOpenType(), object);
        }

        XArrayData(XOpenTypeData xOpenTypeData, int n, OpenType openType, Object object) {
            super(xOpenTypeData);
            this.dimension = n;
            this.elemType = openType;
            this.val = object;
            String[] stringArray = null;
            if (n > 1) {
                return;
            }
            this.isCompositeType = openType instanceof CompositeType;
            this.isTabularType = openType instanceof TabularType;
            stringArray = this.isCompositeType ? this.columnNames : this.arrayColumns;
            this.initTable(stringArray);
            this.loadArray();
        }

        public void viewed(XOpenTypeViewer xOpenTypeViewer) throws Exception {
            if (this.size == 0) {
                throw new Exception(Resources.getText("Empty array", new Object[0]));
            }
            if (this.dimension > 1) {
                throw new Exception(Resources.getText("Dimension is not supported:", new Object[0]) + this.dimension);
            }
            super.viewed(xOpenTypeViewer);
        }

        public int getElementCount() {
            return this.size;
        }

        public int getSelectedElementIndex() {
            return this.currentIndex;
        }

        public void renderKey(String string, Component component) {
            if (this.normalFont == null) {
                this.normalFont = component.getFont();
                this.boldFont = this.normalFont.deriveFont(1);
            }
            if (this.isTabularType) {
                component.setFont(this.boldFont);
            }
        }

        public void incrElement() {
            ++this.currentIndex;
            this.loadCompositeData(this.elements[this.currentIndex]);
        }

        public void decrElement() {
            --this.currentIndex;
            this.loadCompositeData(this.elements[this.currentIndex]);
        }

        public boolean canDecrement() {
            return this.isCompositeType && this.currentIndex > 0;
        }

        public boolean canIncrement() {
            return this.isCompositeType && this.currentIndex < this.size - 1;
        }

        private void loadArray() {
            if (this.isCompositeType) {
                this.elements = (CompositeData[])this.val;
                this.size = this.elements.length;
                if (this.size != 0) {
                    this.loadCompositeData(this.elements[0]);
                }
            } else {
                this.load();
            }
        }

        private void load() {
            Object[] objectArray = new Object[1];
            this.size = Array.getLength(this.val);
            for (int i = 0; i < this.size; ++i) {
                objectArray[0] = this.isTabularType ? new XTabularData((XOpenTypeData)this, (TabularData)Array.get(this.val, i)) : Array.get(this.val, i);
                String string = objectArray[0].toString();
                if (string.length() > this.col1Width) {
                    this.col1Width = string.length();
                }
                ((DefaultTableModel)this.getModel()).addRow(objectArray);
            }
        }

        public String toString() {
            if (this.dimension > 1) {
                return Resources.getText("Dimension is not supported:", new Object[0]) + this.dimension;
            }
            return this.elemType.getTypeName() + "[" + this.size + "]";
        }
    }

    static class XCompositeData
    extends XOpenTypeData {
        protected final String[] columnNames = new String[]{Resources.getText("Name", new Object[0]), Resources.getText("Value", new Object[0])};
        CompositeData composite;

        public XCompositeData() {
            super((XOpenTypeData)null);
            this.initTable(this.columnNames);
        }

        public XCompositeData(XOpenTypeData xOpenTypeData) {
            super(xOpenTypeData);
        }

        public XCompositeData(XOpenTypeData xOpenTypeData, CompositeData compositeData) {
            super(xOpenTypeData);
            this.initTable(this.columnNames);
            if (compositeData != null) {
                this.composite = compositeData;
                this.loadCompositeData(compositeData);
            }
        }

        public void viewed(XOpenTypeViewer xOpenTypeViewer) throws Exception {
            xOpenTypeViewer.setOpenType(this);
            this.updateColumnWidth();
        }

        public String toString() {
            return this.composite == null ? "" : this.composite.getCompositeType().getTypeName();
        }

        protected Object formatKey(String string) {
            return string;
        }

        private void load(CompositeData compositeData) {
            CompositeType compositeType = compositeData.getCompositeType();
            Set<String> set = compositeType.keySet();
            Iterator<String> iterator = set.iterator();
            Object[] objectArray = new Object[2];
            while (iterator.hasNext()) {
                OpenType<?> openType;
                String string = iterator.next();
                Object object = compositeData.get(string);
                objectArray[0] = this.formatKey(string);
                if (object == null) {
                    objectArray[1] = "";
                } else {
                    openType = compositeType.getType(string);
                    if (openType instanceof CompositeType) {
                        objectArray[1] = new XCompositeData(this, (CompositeData)object);
                    } else if (openType instanceof ArrayType) {
                        objectArray[1] = new XArrayData(this, (ArrayType)openType, object);
                    } else if (openType instanceof SimpleType) {
                        objectArray[1] = object;
                    } else if (openType instanceof TabularType) {
                        objectArray[1] = new XTabularData((XOpenTypeData)this, (TabularData)object);
                    }
                }
                openType = null;
                if (objectArray[0] != null && ((String)((Object)(openType = objectArray[0].toString()))).length() > this.col1Width) {
                    this.col1Width = ((String)((Object)openType)).length();
                }
                if (objectArray[1] != null && ((String)((Object)(openType = objectArray[1].toString()))).length() > this.col2Width) {
                    this.col2Width = ((String)((Object)openType)).length();
                }
                ((DefaultTableModel)this.getModel()).addRow(objectArray);
            }
        }

        protected void loadCompositeData(CompositeData compositeData) {
            this.composite = compositeData;
            this.emptyTable();
            this.load(compositeData);
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
        }
    }

    static class XTabularData
    extends XCompositeData
    implements XViewedTabularData {
        final TabularData tabular;
        final TabularType type;
        int currentIndex = 0;
        final Object[] elements;
        final int size;
        private Font normalFont;
        private Font italicFont;

        public XTabularData(XOpenTypeData xOpenTypeData, TabularData tabularData) {
            super(xOpenTypeData, XTabularData.accessFirstElement(tabularData));
            this.tabular = tabularData;
            this.type = tabularData.getTabularType();
            this.size = tabularData.values().size();
            if (this.size > 0) {
                ArrayList arrayList = new ArrayList(tabularData.values());
                Collections.sort(arrayList, new TabularDataComparator(this.type));
                this.elements = arrayList.toArray();
                this.loadCompositeData((CompositeData)this.elements[0]);
            } else {
                this.elements = new Object[0];
            }
        }

        private static CompositeData accessFirstElement(TabularData tabularData) {
            if (tabularData.values().size() == 0) {
                return null;
            }
            return (CompositeData)tabularData.values().toArray()[0];
        }

        public void renderKey(String string, Component component) {
            if (this.normalFont == null) {
                this.normalFont = component.getFont();
                this.italicFont = this.normalFont.deriveFont(2);
            }
            for (String string2 : this.type.getIndexNames()) {
                if (!string.equals(string2)) continue;
                component.setFont(this.italicFont);
            }
        }

        public int getElementCount() {
            return this.size;
        }

        public int getSelectedElementIndex() {
            return this.currentIndex;
        }

        public void incrElement() {
            ++this.currentIndex;
            this.loadCompositeData((CompositeData)this.elements[this.currentIndex]);
        }

        public void decrElement() {
            --this.currentIndex;
            this.loadCompositeData((CompositeData)this.elements[this.currentIndex]);
        }

        public boolean canDecrement() {
            return this.currentIndex != 0;
        }

        public boolean canIncrement() {
            return this.size != 0 && this.currentIndex != this.size - 1;
        }

        public String toString() {
            return this.type == null ? "" : this.type.getDescription();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TabularDataComparator
    implements Comparator<CompositeData> {
        private final List<String> indexNames;

        public TabularDataComparator(TabularType tabularType) {
            this.indexNames = tabularType.getIndexNames();
        }

        @Override
        public int compare(CompositeData compositeData, CompositeData compositeData2) {
            for (String string : this.indexNames) {
                int n;
                Object object = compositeData.get(string);
                Object object2 = compositeData2.get(string);
                if (!(object instanceof Comparable) || !(object2 instanceof Comparable) || (n = ((Comparable)object).compareTo(object2)) == 0) continue;
                return n;
            }
            return 0;
        }
    }

    static abstract class XOpenTypeData
    extends JTable {
        XOpenTypeData parent;
        private Color defaultColor;
        protected int col1Width = -1;
        protected int col2Width = -1;
        private boolean init;
        private Font normalFont;
        private Font boldFont;

        protected XOpenTypeData(XOpenTypeData xOpenTypeData) {
            this.parent = xOpenTypeData;
        }

        public XOpenTypeData getViewedParent() {
            return this.parent;
        }

        public String getToolTip(int n, int n2) {
            Object object;
            if (n2 == 1 && (object = this.getModel().getValueAt(n, n2)) != null) {
                if (this.isClickableElement(object)) {
                    return Resources.getText("Double click to visualize", new Object[0]) + ". " + object.toString();
                }
                return object.toString();
            }
            return null;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)super.getCellRenderer(n, n2);
            defaultTableCellRenderer.setToolTipText(this.getToolTip(n, n2));
            return defaultTableCellRenderer;
        }

        public void renderKey(String string, Component component) {
            component.setFont(this.normalFont);
        }

        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            if (this.normalFont == null) {
                this.normalFont = component.getFont();
                this.boldFont = this.normalFont.deriveFont(1);
            }
            Object object = ((DefaultTableModel)this.getModel()).getValueAt(n, n2);
            if (n2 == 0) {
                String string = object.toString();
                this.renderKey(string, component);
            } else if (this.isClickableElement(object)) {
                component.setFont(this.boldFont);
            } else {
                component.setFont(this.normalFont);
            }
            return component;
        }

        protected boolean isClickableElement(Object object) {
            if (object instanceof XOpenTypeData) {
                if (object instanceof Navigatable) {
                    return ((Navigatable)object).getElementCount() != 0;
                }
                return object instanceof XCompositeData;
            }
            return false;
        }

        protected void updateColumnWidth() {
            if (!this.init) {
                TableColumnModel tableColumnModel = this.getColumnModel();
                if (this.col2Width == -1) {
                    this.col1Width *= 7;
                    if ((double)this.col1Width < this.getPreferredScrollableViewportSize().getWidth()) {
                        this.col1Width = (int)this.getPreferredScrollableViewportSize().getWidth();
                    }
                    tableColumnModel.getColumn(0).setPreferredWidth(this.col1Width);
                    this.init = true;
                    return;
                }
                this.col1Width = this.col1Width * 7 + 7;
                this.col1Width = Math.max(this.col1Width, 70);
                this.col2Width = this.col2Width * 7 + 7;
                if ((double)(this.col1Width + this.col2Width) < this.getPreferredScrollableViewportSize().getWidth()) {
                    this.col2Width = (int)this.getPreferredScrollableViewportSize().getWidth() - this.col1Width;
                }
                tableColumnModel.getColumn(0).setPreferredWidth(this.col1Width);
                tableColumnModel.getColumn(1).setPreferredWidth(this.col2Width);
                this.init = true;
            }
        }

        public abstract void viewed(XOpenTypeViewer var1) throws Exception;

        protected void initTable(String[] stringArray) {
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.getTableHeader().setReorderingAllowed(false);
            ((DefaultTableModel)this.getModel()).setColumnIdentifiers(stringArray);
            Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                tableColumn.setCellEditor(editor);
            }
            this.addKeyListener(new Utils.CopyKeyAdapter());
            this.setAutoResizeMode(2);
            this.setPreferredScrollableViewportSize(new Dimension(350, 200));
        }

        protected void emptyTable() {
            this.invalidate();
            while (this.getModel().getRowCount() > 0) {
                ((DefaultTableModel)this.getModel()).removeRow(0);
            }
            this.validate();
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }

    static interface XViewedArrayData
    extends Navigatable {
    }

    static interface XViewedTabularData
    extends Navigatable {
    }

    static interface Navigatable {
        public void incrElement();

        public void decrElement();

        public boolean canDecrement();

        public boolean canIncrement();

        public int getElementCount();

        public int getSelectedElementIndex();
    }

    class XOpenTypeDataListener
    extends MouseAdapter {
        XOpenTypeDataListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            XOpenTypeData xOpenTypeData;
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() >= 2 && (xOpenTypeData = this.getSelectedViewedOpenType()) != null) {
                try {
                    xOpenTypeData.viewed(XOpenTypeViewer.this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private XOpenTypeData getSelectedViewedOpenType() {
            int n = XOpenTypeViewer.this.current.getSelectedRow();
            int n2 = XOpenTypeViewer.this.current.getSelectedColumn();
            Object object = XOpenTypeViewer.this.current.getModel().getValueAt(n, n2);
            if (object instanceof XOpenTypeData) {
                return (XOpenTypeData)object;
            }
            return null;
        }
    }
}

