/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.tools.example.debug.bdi.AccessWatchpointSpec;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.ChildSession;
import com.sun.tools.example.debug.bdi.EventRequestSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpecList;
import com.sun.tools.example.debug.bdi.ExceptionSpec;
import com.sun.tools.example.debug.bdi.InputListener;
import com.sun.tools.example.debug.bdi.ModificationWatchpointSpec;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.OutputListener;
import com.sun.tools.example.debug.bdi.Session;
import com.sun.tools.example.debug.bdi.SessionListener;
import com.sun.tools.example.debug.bdi.SpecListener;
import com.sun.tools.example.debug.bdi.ThreadInfo;
import com.sun.tools.example.debug.bdi.VMLaunchFailureException;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.expr.ExpressionParser;
import com.sun.tools.example.debug.expr.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionManager {
    private Session session;
    int traceMode = 0;
    Vector<SessionListener> sessionListeners = new Vector();
    Vector<SpecListener> specListeners = new Vector();
    Vector<JDIListener> jdiListeners = new Vector();
    private Vector<OutputListener> appEchoListeners = new Vector();
    private Vector<OutputListener> appOutputListeners = new Vector();
    private Vector<OutputListener> appErrorListeners = new Vector();
    private Vector<OutputListener> diagnosticsListeners = new Vector();
    private List<ThreadInfo> threadInfoList = new LinkedList<ThreadInfo>();
    private HashMap<ThreadReference, ThreadInfo> threadInfoMap = new HashMap();
    private Object inputLock = new Object();
    private LinkedList<String> inputBuffer = new LinkedList();
    private InputListener appInput = new InputListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getLine() {
            Object object;
            Object object2 = null;
            while (object2 == null) {
                object = ExecutionManager.this.inputLock;
                synchronized (object) {
                    try {
                        while (ExecutionManager.this.inputBuffer.size() < 1) {
                            ExecutionManager.this.inputLock.wait();
                        }
                        object2 = (String)ExecutionManager.this.inputBuffer.removeLast();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            object = object2;
            SwingUtilities.invokeLater(new Runnable((String)object){
                final /* synthetic */ String val$input;
                {
                    this.val$input = string;
                }

                public void run() {
                    ExecutionManager.this.echoInputLine(this.val$input);
                }
            });
            return object2;
        }
    };
    private static String newline = System.getProperty("line.separator");
    private OutputListener appOutput = new OutputListener(){

        public void putString(String string) {
            Vector vector = (Vector)ExecutionManager.this.appOutputListeners.clone();
            for (int i = 0; i < vector.size(); ++i) {
                ((OutputListener)vector.elementAt(i)).putString(string);
            }
        }
    };
    private OutputListener appError = new OutputListener(){

        public void putString(String string) {
            Vector vector = (Vector)ExecutionManager.this.appErrorListeners.clone();
            for (int i = 0; i < vector.size(); ++i) {
                ((OutputListener)vector.elementAt(i)).putString(string);
            }
        }
    };
    private OutputListener diagnostics = new OutputListener(){

        public void putString(String string) {
            Vector vector = (Vector)ExecutionManager.this.diagnosticsListeners.clone();
            for (int i = 0; i < vector.size(); ++i) {
                ((OutputListener)vector.elementAt(i)).putString(string);
            }
        }
    };
    private EventRequestSpecList specList = new EventRequestSpecList(this);

    public void addSessionListener(SessionListener sessionListener) {
        this.sessionListeners.add(sessionListener);
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.sessionListeners.remove(sessionListener);
    }

    public void addSpecListener(SpecListener specListener) {
        this.specListeners.add(specListener);
    }

    public void removeSpecListener(SpecListener specListener) {
        this.specListeners.remove(specListener);
    }

    public void addJDIListener(JDIListener jDIListener) {
        this.jdiListeners.add(jDIListener);
    }

    public void addJDIListener(int n, JDIListener jDIListener) {
        this.jdiListeners.add(n, jDIListener);
    }

    public void removeJDIListener(JDIListener jDIListener) {
        this.jdiListeners.remove(jDIListener);
    }

    public void addApplicationEchoListener(OutputListener outputListener) {
        this.appEchoListeners.addElement(outputListener);
    }

    public void removeApplicationEchoListener(OutputListener outputListener) {
        this.appEchoListeners.removeElement(outputListener);
    }

    public void addApplicationOutputListener(OutputListener outputListener) {
        this.appOutputListeners.addElement(outputListener);
    }

    public void removeApplicationOutputListener(OutputListener outputListener) {
        this.appOutputListeners.removeElement(outputListener);
    }

    public void addApplicationErrorListener(OutputListener outputListener) {
        this.appErrorListeners.addElement(outputListener);
    }

    public void removeApplicationErrorListener(OutputListener outputListener) {
        this.appErrorListeners.removeElement(outputListener);
    }

    public void addDiagnosticsListener(OutputListener outputListener) {
        this.diagnosticsListeners.addElement(outputListener);
    }

    public void removeDiagnosticsListener(OutputListener outputListener) {
        this.diagnosticsListeners.removeElement(outputListener);
    }

    public VirtualMachine vm() {
        return this.session == null ? null : this.session.vm;
    }

    void ensureActiveSession() throws NoSessionException {
        if (this.session == null) {
            throw new NoSessionException();
        }
    }

    public EventRequestManager eventRequestManager() {
        return this.vm() == null ? null : this.vm().eventRequestManager();
    }

    public int getTraceMode(int n) {
        return this.traceMode;
    }

    public void setTraceMode(int n) {
        this.traceMode = n;
        if (this.session != null) {
            this.session.setTraceMode(n);
        }
    }

    public boolean isInterrupted() {
        return this.session.interrupted;
    }

    public List<ReferenceType> allClasses() throws NoSessionException {
        this.ensureActiveSession();
        return this.vm().allClasses();
    }

    public List<ReferenceType> findClassesByName(String string) throws NoSessionException {
        this.ensureActiveSession();
        return this.vm().classesByName(string);
    }

    public List<ReferenceType> findClassesMatchingPattern(String string) throws NoSessionException {
        this.ensureActiveSession();
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        if (string.startsWith("*.")) {
            string = string.substring(1);
            List<ReferenceType> list = this.vm().allClasses();
            for (ReferenceType referenceType : list) {
                if (!referenceType.name().endsWith(string)) continue;
                arrayList.add(referenceType);
            }
            return arrayList;
        }
        return this.vm().classesByName(string);
    }

    public List<ThreadReference> allThreads() throws NoSessionException {
        this.ensureActiveSession();
        return this.vm().allThreads();
    }

    public List<ThreadGroupReference> topLevelThreadGroups() throws NoSessionException {
        this.ensureActiveSession();
        return this.vm().topLevelThreadGroups();
    }

    public ThreadGroupReference systemThreadGroup() throws NoSessionException {
        this.ensureActiveSession();
        return this.vm().topLevelThreadGroups().get(0);
    }

    public Value evaluate(final StackFrame stackFrame, String string) throws ParseException, InvocationException, InvalidTypeException, ClassNotLoadedException, NoSessionException, IncompatibleThreadStateException {
        ExpressionParser.GetFrame getFrame = null;
        this.ensureActiveSession();
        if (stackFrame != null) {
            getFrame = new ExpressionParser.GetFrame(){

                public StackFrame get() {
                    return stackFrame;
                }
            };
        }
        return ExpressionParser.evaluate(string, this.vm(), getFrame);
    }

    public void run(boolean bl, String string, String string2, String string3) throws VMLaunchFailureException {
        Object object;
        this.endSession();
        if (bl) {
            object = new ArrayList<String>(1);
            object.add("java.lang.String[]");
            this.createMethodBreakpoint(string2, "main", (List)object);
        }
        object = string2 + " " + string3;
        this.startSession(new ChildSession(this, string, (String)object, this.appInput, this.appOutput, this.appError, this.diagnostics));
    }

    public void attach(String string) throws VMLaunchFailureException {
        this.endSession();
        VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
        List<AttachingConnector> list = virtualMachineManager.attachingConnectors();
        AttachingConnector attachingConnector = list.get(0);
        Map<String, Connector.Argument> map = attachingConnector.defaultArguments();
        map.get("port").setValue(string);
        Session session = this.internalAttach(attachingConnector, map);
        if (session != null) {
            this.startSession(session);
        }
    }

    private Session internalAttach(AttachingConnector attachingConnector, Map<String, Connector.Argument> map) {
        try {
            VirtualMachine virtualMachine = attachingConnector.attach(map);
            return new Session(virtualMachine, this, this.diagnostics);
        }
        catch (IOException iOException) {
            this.diagnostics.putString("\n Unable to attach to target VM: " + iOException.getMessage());
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            this.diagnostics.putString("\n Invalid connector arguments: " + illegalConnectorArgumentsException.getMessage());
        }
        return null;
    }

    private Session internalListen(ListeningConnector listeningConnector, Map<String, Connector.Argument> map) {
        try {
            VirtualMachine virtualMachine = listeningConnector.accept(map);
            return new Session(virtualMachine, this, this.diagnostics);
        }
        catch (IOException iOException) {
            this.diagnostics.putString("\n Unable to accept connection to target VM: " + iOException.getMessage());
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            this.diagnostics.putString("\n Invalid connector arguments: " + illegalConnectorArgumentsException.getMessage());
        }
        return null;
    }

    public boolean explictStart(Connector connector, Map<String, Connector.Argument> map) throws VMLaunchFailureException {
        Session session = null;
        this.endSession();
        if (connector instanceof LaunchingConnector) {
            session = new ChildSession(this, (LaunchingConnector)connector, map, this.appInput, this.appOutput, this.appError, this.diagnostics);
        } else if (connector instanceof AttachingConnector) {
            session = this.internalAttach((AttachingConnector)connector, map);
        } else if (connector instanceof ListeningConnector) {
            session = this.internalListen((ListeningConnector)connector, map);
        } else {
            this.diagnostics.putString("\n Unknown connector: " + connector);
        }
        if (session != null) {
            this.startSession(session);
        }
        return session != null;
    }

    public void detach() throws NoSessionException {
        this.ensureActiveSession();
        this.endSession();
    }

    private void startSession(Session session) throws VMLaunchFailureException {
        if (!session.attach()) {
            throw new VMLaunchFailureException();
        }
        this.session = session;
        EventRequestManager eventRequestManager = this.vm().eventRequestManager();
        ClassPrepareRequest classPrepareRequest = eventRequestManager.createClassPrepareRequest();
        classPrepareRequest.setSuspendPolicy(2);
        classPrepareRequest.enable();
        ClassUnloadRequest classUnloadRequest = eventRequestManager.createClassUnloadRequest();
        classUnloadRequest.setSuspendPolicy(0);
        classUnloadRequest.enable();
        ThreadStartRequest threadStartRequest = eventRequestManager.createThreadStartRequest();
        threadStartRequest.setSuspendPolicy(0);
        threadStartRequest.enable();
        ThreadDeathRequest threadDeathRequest = eventRequestManager.createThreadDeathRequest();
        threadDeathRequest.setSuspendPolicy(0);
        threadDeathRequest.enable();
        ExceptionRequest exceptionRequest = eventRequestManager.createExceptionRequest(null, false, true);
        exceptionRequest.setSuspendPolicy(2);
        exceptionRequest.enable();
        this.validateThreadInfo();
        this.session.interrupted = true;
        this.notifySessionStart();
    }

    void endSession() {
        if (this.session != null) {
            this.session.detach();
            this.session = null;
            this.invalidateThreadInfo();
            this.notifySessionDeath();
        }
    }

    public void interrupt() throws NoSessionException {
        this.ensureActiveSession();
        this.vm().suspend();
        this.validateThreadInfo();
        this.session.interrupted = true;
        this.notifyInterrupted();
    }

    public void go() throws NoSessionException, VMNotInterruptedException {
        this.ensureActiveSession();
        this.invalidateThreadInfo();
        this.session.interrupted = false;
        this.notifyContinued();
        this.vm().resume();
    }

    void clearPreviousStep(ThreadReference threadReference) {
        EventRequestManager eventRequestManager = this.vm().eventRequestManager();
        List<StepRequest> list = eventRequestManager.stepRequests();
        for (StepRequest stepRequest : list) {
            if (!stepRequest.thread().equals(threadReference)) continue;
            eventRequestManager.deleteEventRequest(stepRequest);
            break;
        }
    }

    private void generalStep(ThreadReference threadReference, int n, int n2) throws NoSessionException {
        this.ensureActiveSession();
        this.invalidateThreadInfo();
        this.session.interrupted = false;
        this.notifyContinued();
        this.clearPreviousStep(threadReference);
        EventRequestManager eventRequestManager = this.vm().eventRequestManager();
        StepRequest stepRequest = eventRequestManager.createStepRequest(threadReference, n, n2);
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        this.vm().resume();
    }

    public void stepIntoInstruction(ThreadReference threadReference) throws NoSessionException {
        this.generalStep(threadReference, -1, 1);
    }

    public void stepOverInstruction(ThreadReference threadReference) throws NoSessionException {
        this.generalStep(threadReference, -1, 2);
    }

    public void stepIntoLine(ThreadReference threadReference) throws NoSessionException, AbsentInformationException {
        this.generalStep(threadReference, -2, 1);
    }

    public void stepOverLine(ThreadReference threadReference) throws NoSessionException, AbsentInformationException {
        this.generalStep(threadReference, -2, 2);
    }

    public void stepOut(ThreadReference threadReference) throws NoSessionException {
        this.generalStep(threadReference, -1, 3);
    }

    public void suspendThread(ThreadReference threadReference) throws NoSessionException {
        this.ensureActiveSession();
        threadReference.suspend();
    }

    public void resumeThread(ThreadReference threadReference) throws NoSessionException {
        this.ensureActiveSession();
        threadReference.resume();
    }

    public void stopThread(ThreadReference threadReference) throws NoSessionException {
        this.ensureActiveSession();
    }

    public ThreadInfo threadInfo(ThreadReference threadReference) {
        if (this.session == null || threadReference == null) {
            return null;
        }
        ThreadInfo threadInfo = this.threadInfoMap.get(threadReference);
        if (threadInfo == null) {
            threadInfo = new ThreadInfo(threadReference);
            if (this.session.interrupted) {
                threadInfo.validate();
            }
            this.threadInfoList.add(threadInfo);
            this.threadInfoMap.put(threadReference, threadInfo);
        }
        return threadInfo;
    }

    void validateThreadInfo() {
        this.session.interrupted = true;
        Iterator<ThreadInfo> iterator = this.threadInfoList.iterator();
        while (iterator.hasNext()) {
            iterator.next().validate();
        }
    }

    private void invalidateThreadInfo() {
        if (this.session != null) {
            this.session.interrupted = false;
            Iterator<ThreadInfo> iterator = this.threadInfoList.iterator();
            while (iterator.hasNext()) {
                iterator.next().invalidate();
            }
        }
    }

    void removeThreadInfo(ThreadReference threadReference) {
        ThreadInfo threadInfo = this.threadInfoMap.get(threadReference);
        if (threadInfo != null) {
            threadInfo.invalidate();
            this.threadInfoMap.remove(threadReference);
            this.threadInfoList.remove(threadInfo);
        }
    }

    private void notifyInterrupted() {
        Vector vector = (Vector)this.sessionListeners.clone();
        EventObject eventObject = new EventObject(this);
        for (int i = 0; i < vector.size(); ++i) {
            ((SessionListener)vector.elementAt(i)).sessionInterrupt(eventObject);
        }
    }

    private void notifyContinued() {
        Vector vector = (Vector)this.sessionListeners.clone();
        EventObject eventObject = new EventObject(this);
        for (int i = 0; i < vector.size(); ++i) {
            ((SessionListener)vector.elementAt(i)).sessionContinue(eventObject);
        }
    }

    private void notifySessionStart() {
        Vector vector = (Vector)this.sessionListeners.clone();
        EventObject eventObject = new EventObject(this);
        for (int i = 0; i < vector.size(); ++i) {
            ((SessionListener)vector.elementAt(i)).sessionStart(eventObject);
        }
    }

    private void notifySessionDeath() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetInputBuffer() {
        Object object = this.inputLock;
        synchronized (object) {
            this.inputBuffer = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLineToApplication(String string) {
        Object object = this.inputLock;
        synchronized (object) {
            this.inputBuffer.addFirst(string);
            this.inputLock.notifyAll();
        }
    }

    private void echoInputLine(String string) {
        Vector vector = (Vector)this.appEchoListeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            OutputListener outputListener = (OutputListener)vector.elementAt(i);
            outputListener.putString(string);
            outputListener.putString(newline);
        }
    }

    public BreakpointSpec createSourceLineBreakpoint(String string, int n) {
        return this.specList.createSourceLineBreakpoint(string, n);
    }

    public BreakpointSpec createClassLineBreakpoint(String string, int n) {
        return this.specList.createClassLineBreakpoint(string, n);
    }

    public BreakpointSpec createMethodBreakpoint(String string, String string2, List list) {
        return this.specList.createMethodBreakpoint(string, string2, list);
    }

    public ExceptionSpec createExceptionIntercept(String string, boolean bl, boolean bl2) {
        return this.specList.createExceptionIntercept(string, bl, bl2);
    }

    public AccessWatchpointSpec createAccessWatchpoint(String string, String string2) {
        return this.specList.createAccessWatchpoint(string, string2);
    }

    public ModificationWatchpointSpec createModificationWatchpoint(String string, String string2) {
        return this.specList.createModificationWatchpoint(string, string2);
    }

    public void delete(EventRequestSpec eventRequestSpec) {
        this.specList.delete(eventRequestSpec);
    }

    void resolve(ReferenceType referenceType) {
        this.specList.resolve(referenceType);
    }

    public void install(EventRequestSpec eventRequestSpec) {
        this.specList.install(eventRequestSpec, this.vm());
    }

    public List eventRequestSpecs() {
        return this.specList.eventRequestSpecs();
    }
}

