/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.State;
import sun.security.provider.certpath.URICertStore;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ForwardBuilder
extends Builder {
    private static final Debug debug = Debug.getInstance("certpath");
    private final Set<X509Certificate> trustedCerts;
    private final Set<X500Principal> trustedSubjectDNs;
    private final Set<TrustAnchor> trustAnchors;
    private X509CertSelector eeSelector;
    private X509CertSelector caSelector;
    private X509CertSelector caTargetSelector;
    TrustAnchor trustAnchor;
    private Comparator<X509Certificate> comparator;
    private boolean searchAllCertStores = true;

    ForwardBuilder(PKIXBuilderParameters pKIXBuilderParameters, X500Principal x500Principal, boolean bl) {
        super(pKIXBuilderParameters, x500Principal);
        this.trustAnchors = pKIXBuilderParameters.getTrustAnchors();
        this.trustedCerts = new HashSet<X509Certificate>(this.trustAnchors.size());
        this.trustedSubjectDNs = new HashSet<X500Principal>(this.trustAnchors.size());
        for (TrustAnchor trustAnchor : this.trustAnchors) {
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            if (x509Certificate != null) {
                this.trustedCerts.add(x509Certificate);
                this.trustedSubjectDNs.add(x509Certificate.getSubjectX500Principal());
                continue;
            }
            this.trustedSubjectDNs.add(trustAnchor.getCA());
        }
        this.comparator = new PKIXCertComparator(this.trustedSubjectDNs);
        this.searchAllCertStores = bl;
    }

    @Override
    Collection<X509Certificate> getMatchingCerts(State state, List<CertStore> list) throws CertStoreException, CertificateException, IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCerts()...");
        }
        ForwardState forwardState = (ForwardState)state;
        TreeSet<X509Certificate> treeSet = new TreeSet<X509Certificate>(this.comparator);
        if (forwardState.isInitial()) {
            this.getMatchingEECerts(forwardState, list, treeSet);
        }
        this.getMatchingCACerts(forwardState, list, treeSet);
        return treeSet;
    }

    private void getMatchingEECerts(ForwardState forwardState, List<CertStore> list, Collection<X509Certificate> collection) throws IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingEECerts()...");
        }
        if (this.eeSelector == null) {
            this.eeSelector = (X509CertSelector)this.targetCertConstraints.clone();
            this.eeSelector.setCertificateValid(this.date);
            if (this.buildParams.isExplicitPolicyRequired()) {
                this.eeSelector.setPolicy(this.getMatchingPolicies());
            }
            this.eeSelector.setBasicConstraints(-2);
        }
        this.addMatchingCerts(this.eeSelector, list, collection, this.searchAllCertStores);
    }

    private void getMatchingCACerts(ForwardState forwardState, List<CertStore> list, Collection<X509Certificate> collection) throws IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCACerts()...");
        }
        int n = collection.size();
        X509CertSelector x509CertSelector = null;
        if (forwardState.isInitial()) {
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts(): ca is target");
            }
            if (this.caTargetSelector == null) {
                this.caTargetSelector = (X509CertSelector)this.targetCertConstraints.clone();
                this.caTargetSelector.setCertificateValid(this.date);
                if (this.buildParams.isExplicitPolicyRequired()) {
                    this.caTargetSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            this.caTargetSelector.setBasicConstraints(forwardState.traversedCACerts);
            x509CertSelector = this.caTargetSelector;
        } else {
            if (this.caSelector == null) {
                this.caSelector = new X509CertSelector();
                this.caSelector.setCertificateValid(this.date);
                if (this.buildParams.isExplicitPolicyRequired()) {
                    this.caSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            this.caSelector.setSubject(forwardState.issuerDN);
            CertPathHelper.setPathToNames(this.caSelector, forwardState.subjectNamesTraversed);
            this.caSelector.setBasicConstraints(forwardState.traversedCACerts);
            x509CertSelector = this.caSelector;
        }
        X509CertSelector x509CertSelector2 = null;
        if (forwardState.isInitial()) {
            x509CertSelector2 = this.targetCertConstraints;
        } else {
            x509CertSelector2 = new X509CertSelector();
            x509CertSelector2.setSubject(forwardState.issuerDN);
        }
        boolean bl = false;
        Object object = this.trustedCerts.iterator();
        while (object.hasNext()) {
            X509Certificate x509Certificate = object.next();
            if (!x509CertSelector2.match(x509Certificate)) continue;
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts: found matching trust anchor");
            }
            if (!collection.add(x509Certificate) || this.searchAllCertStores) continue;
            return;
        }
        if ((forwardState.isInitial() || this.buildParams.getMaxPathLength() == -1 || this.buildParams.getMaxPathLength() > forwardState.traversedCACerts) && this.addMatchingCerts(x509CertSelector, list, collection, this.searchAllCertStores) && !this.searchAllCertStores) {
            return;
        }
        if (!forwardState.isInitial() && Builder.USE_AIA && (object = forwardState.cert.getAuthorityInfoAccessExtension()) != null) {
            this.getCerts((AuthorityInfoAccessExtension)object, collection);
        }
        if (debug != null) {
            int n2 = collection.size() - n;
            debug.println("ForwardBuilder.getMatchingCACerts: found " + n2 + " CA certs");
        }
    }

    private boolean getCerts(AuthorityInfoAccessExtension authorityInfoAccessExtension, Collection<X509Certificate> collection) {
        if (!Builder.USE_AIA) {
            return false;
        }
        List<AccessDescription> list = authorityInfoAccessExtension.getAccessDescriptions();
        if (list == null || list.isEmpty()) {
            return false;
        }
        boolean bl = false;
        for (AccessDescription accessDescription : list) {
            CertStore certStore = URICertStore.getInstance(accessDescription);
            try {
                if (!collection.addAll(certStore.getCertificates(this.caSelector))) continue;
                bl = true;
                if (this.searchAllCertStores) continue;
                return true;
            }
            catch (CertStoreException certStoreException) {
                if (debug == null) continue;
                debug.println("exception getting certs from CertStore:");
                certStoreException.printStackTrace();
            }
        }
        return bl;
    }

    @Override
    void verifyCert(X509Certificate x509Certificate, State state, List<X509Certificate> list) throws GeneralSecurityException {
        Object object;
        boolean bl;
        if (debug != null) {
            debug.println("ForwardBuilder.verifyCert(SN: " + Debug.toHexString(x509Certificate.getSerialNumber()) + "\n  Issuer: " + x509Certificate.getIssuerX500Principal() + ")" + "\n  Subject: " + x509Certificate.getSubjectX500Principal() + ")");
        }
        ForwardState forwardState = (ForwardState)state;
        if (list != null) {
            bl = false;
            for (X509Certificate object2 : list) {
                X509CertImpl x509CertImpl = X509CertImpl.toImpl(object2);
                object = x509CertImpl.getPolicyMappingsExtension();
                if (object != null) {
                    bl = true;
                }
                if (debug != null) {
                    debug.println("policyMappingFound = " + bl);
                }
                if (!x509Certificate.equals(object2) || !this.buildParams.isPolicyMappingInhibited() && bl) continue;
                if (debug != null) {
                    debug.println("loop detected!!");
                }
                throw new CertPathValidatorException("loop detected");
            }
        }
        if (!(bl = this.trustedCerts.contains(x509Certificate))) {
            Set<String> set = x509Certificate.getCriticalExtensionOIDs();
            if (set == null) {
                set = Collections.emptySet();
            }
            for (PKIXCertPathChecker pKIXCertPathChecker : forwardState.forwardCheckers) {
                pKIXCertPathChecker.check(x509Certificate, set);
            }
            for (PKIXCertPathChecker pKIXCertPathChecker : this.buildParams.getCertPathCheckers()) {
                if (pKIXCertPathChecker.isForwardCheckingSupported() || (object = pKIXCertPathChecker.getSupportedExtensions()) == null) continue;
                set.removeAll((Collection<?>)object);
            }
            if (!set.isEmpty()) {
                set.remove(PKIXExtensions.BasicConstraints_Id.toString());
                set.remove(PKIXExtensions.NameConstraints_Id.toString());
                set.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                set.remove(PKIXExtensions.PolicyMappings_Id.toString());
                set.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                set.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                set.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                set.remove(PKIXExtensions.KeyUsage_Id.toString());
                set.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                if (!set.isEmpty()) {
                    throw new CertificateException("Unrecognized critical extension(s)");
                }
            }
        }
        if (forwardState.isInitial()) {
            return;
        }
        if (!bl) {
            if (x509Certificate.getBasicConstraints() == -1) {
                throw new CertificateException("cert is NOT a CA cert");
            }
            KeyChecker.verifyCAKeyUsage(x509Certificate);
        }
        if (this.buildParams.isRevocationEnabled() && CrlRevocationChecker.certCanSignCrl(x509Certificate) && !forwardState.keyParamsNeeded()) {
            forwardState.crlChecker.check(forwardState.cert, x509Certificate.getPublicKey(), true);
        }
        if (!forwardState.keyParamsNeeded()) {
            forwardState.cert.verify(x509Certificate.getPublicKey(), this.buildParams.getSigProvider());
        }
    }

    @Override
    boolean isPathCompleted(X509Certificate x509Certificate) {
        for (TrustAnchor trustAnchor : this.trustAnchors) {
            if (trustAnchor.getTrustedCert() != null) {
                if (!x509Certificate.equals(trustAnchor.getTrustedCert())) continue;
                this.trustAnchor = trustAnchor;
                return true;
            }
            X500Principal x500Principal = trustAnchor.getCA();
            if (!x500Principal.equals(x509Certificate.getIssuerX500Principal())) continue;
            if (this.buildParams.isRevocationEnabled()) {
                try {
                    CrlRevocationChecker crlRevocationChecker = new CrlRevocationChecker(trustAnchor, this.buildParams);
                    crlRevocationChecker.check(x509Certificate, trustAnchor.getCAPublicKey(), true);
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    if (debug == null) continue;
                    debug.println("ForwardBuilder.isPathCompleted() cpve");
                    certPathValidatorException.printStackTrace();
                    continue;
                }
            }
            try {
                x509Certificate.verify(trustAnchor.getCAPublicKey(), this.buildParams.getSigProvider());
            }
            catch (InvalidKeyException invalidKeyException) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() invalid DSA key found");
                continue;
            }
            catch (Exception exception) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() unexpected exception");
                exception.printStackTrace();
                continue;
            }
            this.trustAnchor = trustAnchor;
            return true;
        }
        return false;
    }

    @Override
    void addCertToPath(X509Certificate x509Certificate, LinkedList<X509Certificate> linkedList) {
        linkedList.addFirst(x509Certificate);
    }

    @Override
    void removeFinalCertFromPath(LinkedList<X509Certificate> linkedList) {
        linkedList.removeFirst();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PKIXCertComparator
    implements Comparator<X509Certificate> {
        static final String METHOD_NME = "PKIXCertComparator.compare()";
        private final Set<X500Principal> trustedSubjectDNs;

        PKIXCertComparator(Set<X500Principal> set) {
            this.trustedSubjectDNs = set;
        }

        @Override
        public int compare(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
            int n;
            int n2;
            int n3;
            X500Name x500Name;
            X500Principal x500Principal4;
            if (x509Certificate.equals(x509Certificate2)) {
                return 0;
            }
            X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
            X500Principal x500Principal3 = x509Certificate2.getIssuerX500Principal();
            X500Name x500Name2 = X500Name.asX500Name(x500Principal2);
            X500Name x500Name3 = X500Name.asX500Name(x500Principal3);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() o1 Issuer:  " + x500Principal2);
                debug.println("PKIXCertComparator.compare() o2 Issuer:  " + x500Principal3);
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() MATCH TRUSTED SUBJECT TEST...");
            }
            boolean bl = this.trustedSubjectDNs.contains(x500Principal2);
            boolean bl2 = this.trustedSubjectDNs.contains(x500Principal3);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() m1: " + bl);
                debug.println("PKIXCertComparator.compare() m2: " + bl2);
            }
            if (bl && bl2) {
                return -1;
            }
            if (bl) {
                return -1;
            }
            if (bl2) {
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() NAMING DESCENDANT TEST...");
            }
            for (X500Principal x500Principal4 : this.trustedSubjectDNs) {
                x500Name = X500Name.asX500Name(x500Principal4);
                n3 = Builder.distance(x500Name, x500Name2, -1);
                n2 = Builder.distance(x500Name, x500Name3, -1);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() distanceTto1: " + n3);
                    debug.println("PKIXCertComparator.compare() distanceTto2: " + n2);
                }
                if (n3 <= 0 && n2 <= 0) continue;
                if (n3 == n2) {
                    return -1;
                }
                if (n3 > 0 && n2 <= 0) {
                    return -1;
                }
                if (n3 <= 0 && n2 > 0) {
                    return 1;
                }
                if (n3 < n2) {
                    return -1;
                }
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() NAMING ANCESTOR TEST...");
            }
            for (X500Principal x500Principal4 : this.trustedSubjectDNs) {
                x500Name = X500Name.asX500Name(x500Principal4);
                n3 = Builder.distance(x500Name, x500Name2, Integer.MAX_VALUE);
                n2 = Builder.distance(x500Name, x500Name3, Integer.MAX_VALUE);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() distanceTto1: " + n3);
                    debug.println("PKIXCertComparator.compare() distanceTto2: " + n2);
                }
                if (n3 >= 0 && n2 >= 0) continue;
                if (n3 == n2) {
                    return -1;
                }
                if (n3 < 0 && n2 >= 0) {
                    return -1;
                }
                if (n3 >= 0 && n2 < 0) {
                    return 1;
                }
                if (n3 > n2) {
                    return -1;
                }
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() SAME NAMESPACE AS TRUSTED TEST...");
            }
            for (X500Principal x500Principal4 : this.trustedSubjectDNs) {
                x500Name = X500Name.asX500Name(x500Principal4);
                X500Name x500Name4 = x500Name.commonAncestor(x500Name2);
                X500Name x500Name5 = x500Name.commonAncestor(x500Name3);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() tAo1: " + String.valueOf(x500Name4));
                    debug.println("PKIXCertComparator.compare() tAo2: " + String.valueOf(x500Name5));
                }
                if (x500Name4 == null && x500Name5 == null) continue;
                if (x500Name4 != null && x500Name5 != null) {
                    n = Builder.hops(x500Name, x500Name2, Integer.MAX_VALUE);
                    int n4 = Builder.hops(x500Name, x500Name3, Integer.MAX_VALUE);
                    if (debug != null) {
                        debug.println("PKIXCertComparator.compare() hopsTto1: " + n);
                        debug.println("PKIXCertComparator.compare() hopsTto2: " + n4);
                    }
                    if (n == n4) continue;
                    if (n > n4) {
                        return 1;
                    }
                    return -1;
                }
                if (x500Name4 == null) {
                    return 1;
                }
                return -1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() CERT ISSUER/SUBJECT COMPARISON TEST...");
            }
            X500Principal x500Principal5 = x509Certificate.getSubjectX500Principal();
            x500Principal4 = x509Certificate2.getSubjectX500Principal();
            x500Name = X500Name.asX500Name(x500Principal5);
            X500Name x500Name6 = X500Name.asX500Name(x500Principal4);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() o1 Subject: " + x500Principal5);
                debug.println("PKIXCertComparator.compare() o2 Subject: " + x500Principal4);
            }
            int n5 = Builder.distance(x500Name, x500Name2, Integer.MAX_VALUE);
            n = Builder.distance(x500Name6, x500Name3, Integer.MAX_VALUE);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() distanceStoI1: " + n5);
                debug.println("PKIXCertComparator.compare() distanceStoI2: " + n);
            }
            if (n > n5) {
                return -1;
            }
            if (n < n5) {
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() no tests matched; RETURN 0");
            }
            return -1;
        }
    }
}

