/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.Unicode;

class UTF_8
extends Unicode {
    public UTF_8() {
        super("UTF-8", StandardCharsets.aliases_UTF_8);
    }

    public String historicalName() {
        return "UTF8";
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends CharsetEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset charset) {
            super(charset, 1.1f, 4.0f);
        }

        public boolean canEncode(char c) {
            return !Surrogate.is(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            n = n <= n2 ? n : n2;
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            try {
                while (n < n2) {
                    int n5;
                    char c = cArray[n];
                    if (c < '\u0080') {
                        if (n3 >= n4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)c;
                        ++n;
                        continue;
                    }
                    if (!Surrogate.is(c)) {
                        if (c < '\u0800') {
                            if (n4 - n3 < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = (byte)(0xC0 | c >> 6);
                            byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
                            ++n;
                            continue;
                        }
                        if (c <= '\uffff') {
                            if (n4 - n3 < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = (byte)(0xE0 | c >> 12);
                            byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                            byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
                            ++n;
                            continue;
                        }
                    }
                    if ((n5 = this.sgp.parse(c, cArray, n, n2)) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    if (n5 < 0x200000) {
                        if (n4 - n3 < 4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)(0xF0 | n5 >> 18);
                        byArray[n3++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                        byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                        byArray[n3++] = (byte)(0x80 | n5 >> 0 & 0x3F);
                        n += this.sgp.increment();
                        continue;
                    }
                    assert (false);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n2;
                    char c = charBuffer.get();
                    if (c < '\u0080') {
                        if (!byteBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c);
                        ++n;
                        continue;
                    }
                    if (!Surrogate.is(c)) {
                        if (c < '\u0800') {
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)(0xC0 | c >> 6));
                            byteBuffer.put((byte)(0x80 | c >> 0 & 0x3F));
                            ++n;
                            continue;
                        }
                        if (c <= '\uffff') {
                            if (byteBuffer.remaining() < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)(0xE0 | c >> 12));
                            byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                            byteBuffer.put((byte)(0x80 | c >> 0 & 0x3F));
                            ++n;
                            continue;
                        }
                    }
                    if ((n2 = this.sgp.parse(c, charBuffer)) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    if (n2 < 0x200000) {
                        if (byteBuffer.remaining() < 4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)(0xF0 | n2 >> 18));
                        byteBuffer.put((byte)(0x80 | n2 >> 12 & 0x3F));
                        byteBuffer.put((byte)(0x80 | n2 >> 6 & 0x3F));
                        byteBuffer.put((byte)(0x80 | n2 >> 0 & 0x3F));
                        n += this.sgp.increment();
                        continue;
                    }
                    assert (false);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        private final Surrogate.Generator sgg = new Surrogate.Generator();

        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        private boolean isContinuation(int n) {
            return (n & 0xC0) == 128;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n <= n2);
            n = n <= n2 ? n : n2;
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            try {
                block40: while (n < n2) {
                    byte by = byArray[n];
                    switch (by >> 4 & 0xF) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            cArray[n3++] = (char)(by & 0x7F);
                            ++n;
                            continue block40;
                        }
                        case 12: 
                        case 13: {
                            if (n2 - n < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byte by2 = byArray[n + 1];
                            if (!this.isContinuation(by2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            cArray[n3++] = (char)((by & 0x1F) << 6 | (by2 & 0x3F) << 0);
                            n += 2;
                            continue block40;
                        }
                        case 14: {
                            if (n2 - n < 3) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byte by2 = byArray[n + 1];
                            if (!this.isContinuation(by2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            byte by3 = byArray[n + 2];
                            if (!this.isContinuation(by3)) {
                                CoderResult coderResult = CoderResult.malformedForLength(2);
                                return coderResult;
                            }
                            cArray[n3++] = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | (by3 & 0x3F) << 0);
                            n += 3;
                            continue block40;
                        }
                        case 15: {
                            int n5;
                            int n6;
                            byte by3;
                            byte by2;
                            switch (by & 0xF) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    if (n2 - n < 4) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byArray[n + 1];
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byArray[n + 2];
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byArray[n + 3];
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    n6 = (by & 7) << 18 | (by2 & 0x3F) << 12 | (by3 & 0x3F) << 6 | (by4 & 0x3F) << 0;
                                    n5 = 4;
                                    break;
                                }
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    if (n2 - n < 5) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byArray[n + 1];
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byArray[n + 2];
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byArray[n + 3];
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    byte by5 = byArray[n + 4];
                                    if (!this.isContinuation(by5)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(4);
                                        return coderResult;
                                    }
                                    n6 = (by & 3) << 24 | (by2 & 0x3F) << 18 | (by3 & 0x3F) << 12 | (by4 & 0x3F) << 6 | (by5 & 0x3F) << 0;
                                    n5 = 5;
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    if (n2 - n < 6) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byArray[n + 1];
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byArray[n + 2];
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byArray[n + 3];
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    byte by5 = byArray[n + 4];
                                    if (!this.isContinuation(by5)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(4);
                                        return coderResult;
                                    }
                                    byte by6 = byArray[n + 5];
                                    if (!this.isContinuation(by6)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(5);
                                        return coderResult;
                                    }
                                    n6 = (by & 1) << 30 | (by2 & 0x3F) << 24 | (by3 & 0x3F) << 18 | (by4 & 0x3F) << 12 | (by5 & 0x3F) << 6 | by6 & 0x3F;
                                    n5 = 6;
                                    break;
                                }
                                default: {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                            }
                            int n7 = this.sgg.generate(n6, n5, cArray, n3, n4);
                            if (n7 < 0) {
                                CoderResult coderResult = this.sgg.error();
                                return coderResult;
                            }
                            n3 += n7;
                            n += n5;
                            continue block40;
                        }
                    }
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                block40: while (byteBuffer.hasRemaining()) {
                    byte by = byteBuffer.get();
                    switch (by >> 4 & 0xF) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            charBuffer.put((char)by);
                            ++n;
                            continue block40;
                        }
                        case 12: 
                        case 13: {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byte by2 = byteBuffer.get();
                            if (!this.isContinuation(by2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            charBuffer.put((char)((by & 0x1F) << 6 | (by2 & 0x3F) << 0));
                            n += 2;
                            continue block40;
                        }
                        case 14: {
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byte by2 = byteBuffer.get();
                            if (!this.isContinuation(by2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            byte by3 = byteBuffer.get();
                            if (!this.isContinuation(by3)) {
                                CoderResult coderResult = CoderResult.malformedForLength(2);
                                return coderResult;
                            }
                            charBuffer.put((char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | (by3 & 0x3F) << 0));
                            n += 3;
                            continue block40;
                        }
                        case 15: {
                            int n2;
                            int n3;
                            byte by3;
                            byte by2;
                            switch (by & 0xF) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    if (byteBuffer.remaining() < 3) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byteBuffer.get();
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byteBuffer.get();
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byteBuffer.get();
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    n3 = (by & 7) << 18 | (by2 & 0x3F) << 12 | (by3 & 0x3F) << 6 | (by4 & 0x3F) << 0;
                                    n2 = 4;
                                    break;
                                }
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    if (byteBuffer.remaining() < 4) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byteBuffer.get();
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byteBuffer.get();
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byteBuffer.get();
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    byte by5 = byteBuffer.get();
                                    if (!this.isContinuation(by5)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(4);
                                        return coderResult;
                                    }
                                    n3 = (by & 3) << 24 | (by2 & 0x3F) << 18 | (by3 & 0x3F) << 12 | (by4 & 0x3F) << 6 | (by5 & 0x3F) << 0;
                                    n2 = 5;
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    if (byteBuffer.remaining() < 4) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byteBuffer.get();
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byteBuffer.get();
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byteBuffer.get();
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    byte by5 = byteBuffer.get();
                                    if (!this.isContinuation(by5)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(4);
                                        return coderResult;
                                    }
                                    byte by6 = byteBuffer.get();
                                    if (!this.isContinuation(by6)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(5);
                                        return coderResult;
                                    }
                                    n3 = (by & 1) << 30 | (by2 & 0x3F) << 24 | (by3 & 0x3F) << 18 | (by4 & 0x3F) << 12 | (by5 & 0x3F) << 6 | by6 & 0x3F;
                                    n2 = 6;
                                    break;
                                }
                                default: {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                            }
                            if (this.sgg.generate(n3, n2, charBuffer) < 0) {
                                CoderResult coderResult = this.sgg.error();
                                return coderResult;
                            }
                            n += n2;
                            continue block40;
                        }
                    }
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }
}

