/*
 * Decompiled with CFR 0.152.
 */
package sun.launcher;

import java.io.File;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class LauncherHelp {
    private static final String defaultBundleName = "sun.launcher.resources.launcher";
    private static ResourceBundle javarb = ResourceBundle.getBundle("sun.launcher.resources.launcher");
    private static StringBuilder outBuf = new StringBuilder();

    private LauncherHelp() {
    }

    private static String getLocalizedMessage(String string, Object ... objectArray) {
        String string2 = javarb.getString(string);
        return objectArray != null ? MessageFormat.format(string2, objectArray) : string2;
    }

    static void initHelpMessage(String string) {
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.header", string == null ? "java" : string));
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.datamodel", 32));
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.datamodel", 64));
    }

    static void appendVmSelectMessage(String string, String string2) {
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.vmselect", string, string2));
    }

    static void appendVmSynonymMessage(String string, String string2) {
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.hotspot", string, string2));
    }

    static void appendVmErgoMessage(boolean bl, String string) {
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.ergo.message1", string));
        outBuf = bl ? outBuf.append(",\n" + LauncherHelp.getLocalizedMessage("java.launcher.ergo.message2", new Object[0]) + "\n\n") : outBuf.append(".\n\n");
    }

    static void printHelpMessage(boolean bl) {
        PrintStream printStream = bl ? System.err : System.out;
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.footer", File.pathSeparator));
        printStream.println(outBuf.toString());
    }

    static void printXUsageMessage(boolean bl) {
        PrintStream printStream = bl ? System.err : System.out;
        printStream.println(LauncherHelp.getLocalizedMessage("java.launcher.X.usage", File.pathSeparator));
    }

    public static void main(String[] stringArray) {
        LauncherHelp.initHelpMessage("java");
        LauncherHelp.appendVmSelectMessage("-client", "client");
        LauncherHelp.appendVmSelectMessage("-server", "server");
        LauncherHelp.appendVmSynonymMessage("-hotspot", "client");
        LauncherHelp.appendVmErgoMessage(true, "server");
        LauncherHelp.printHelpMessage(true);
        System.err.println("------------------------------------");
        LauncherHelp.printXUsageMessage(true);
    }
}

