/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.dnd.SunDropTargetEvent;

public abstract class SunDropTargetContextPeer
implements DropTargetContextPeer,
Transferable {
    public static final boolean DISPATCH_SYNC = true;
    private DropTarget currentDT;
    private DropTargetContext currentDTC;
    private long[] currentT;
    private int currentA;
    private int currentSA;
    private int currentDA;
    private int previousDA;
    private long nativeDragContext;
    private Transferable local;
    private boolean dragRejected = false;
    protected int dropStatus = 0;
    protected boolean dropComplete = false;
    protected static final Object _globalLock = new Object();
    private static final Logger dndLog = Logger.getLogger("sun.awt.dnd.SunDropTargetContextPeer");
    protected static Transferable currentJVMLocalSourceTransferable = null;
    protected static final int STATUS_NONE = 0;
    protected static final int STATUS_WAIT = 1;
    protected static final int STATUS_ACCEPT = 2;
    protected static final int STATUS_REJECT = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentJVMLocalSourceTransferable(Transferable transferable) throws InvalidDnDOperationException {
        Object object = _globalLock;
        synchronized (object) {
            if (transferable != null && currentJVMLocalSourceTransferable != null) {
                throw new InvalidDnDOperationException();
            }
            currentJVMLocalSourceTransferable = transferable;
        }
    }

    private static Transferable getJVMLocalSourceTransferable() {
        return currentJVMLocalSourceTransferable;
    }

    public DropTarget getDropTarget() {
        return this.currentDT;
    }

    public synchronized void setTargetActions(int n) {
        this.currentA = n & 0x40000003;
    }

    public int getTargetActions() {
        return this.currentA;
    }

    public Transferable getTransferable() {
        return this;
    }

    public DataFlavor[] getTransferDataFlavors() {
        Transferable transferable = this.local;
        if (transferable != null) {
            return transferable.getTransferDataFlavors();
        }
        return DataTransferer.getInstance().getFlavorsForFormatsAsArray(this.currentT, DataTransferer.adaptFlavorMap(this.currentDT.getFlavorMap()));
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        Transferable transferable = this.local;
        if (transferable != null) {
            return transferable.isDataFlavorSupported(dataFlavor);
        }
        return DataTransferer.getInstance().getFlavorsForFormats(this.currentT, DataTransferer.adaptFlavorMap(this.currentDT.getFlavorMap())).containsKey(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException, InvalidDnDOperationException {
        Long l = null;
        Transferable transferable = this.local;
        if (transferable != null) {
            return transferable.getTransferData(dataFlavor);
        }
        if (this.dropStatus != 2 || this.dropComplete) {
            throw new InvalidDnDOperationException("No drop current");
        }
        Map map = DataTransferer.getInstance().getFlavorsForFormats(this.currentT, DataTransferer.adaptFlavorMap(this.currentDT.getFlavorMap()));
        l = (Long)map.get(dataFlavor);
        if (l == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (dataFlavor.isRepresentationClassRemote() && this.currentDA != 0x40000000) {
            throw new InvalidDnDOperationException("only ACTION_LINK is permissable for transfer of java.rmi.Remote objects");
        }
        long l2 = l;
        Object object = this.getNativeData(l2);
        if (object instanceof byte[]) {
            try {
                return DataTransferer.getInstance().translateBytes((byte[])object, dataFlavor, l2, this);
            }
            catch (IOException iOException) {
                throw new InvalidDnDOperationException(iOException.getMessage());
            }
        }
        if (object instanceof InputStream) {
            try {
                return DataTransferer.getInstance().translateStream((InputStream)object, dataFlavor, l2, this);
            }
            catch (IOException iOException) {
                throw new InvalidDnDOperationException(iOException.getMessage());
            }
        }
        throw new IOException("no native data was transfered");
    }

    protected abstract Object getNativeData(long var1) throws IOException;

    public boolean isTransferableJVMLocal() {
        return this.local != null || SunDropTargetContextPeer.getJVMLocalSourceTransferable() != null;
    }

    private int handleEnterMessage(Component component, int n, int n2, int n3, int n4, long[] lArray, long l) {
        return this.postDropTargetEvent(component, n, n2, n3, n4, lArray, l, 504, true);
    }

    protected void processEnterMessage(SunDropTargetEvent sunDropTargetEvent) {
        Component component = (Component)sunDropTargetEvent.getSource();
        DropTarget dropTarget = component.getDropTarget();
        Point point = sunDropTargetEvent.getPoint();
        this.local = SunDropTargetContextPeer.getJVMLocalSourceTransferable();
        if (this.currentDTC != null) {
            this.currentDTC.removeNotify();
            this.currentDTC = null;
        }
        if (component.isShowing() && dropTarget != null && dropTarget.isActive()) {
            this.currentDT = dropTarget;
            this.currentDTC = this.currentDT.getDropTargetContext();
            this.currentDTC.addNotify(this);
            this.currentA = dropTarget.getDefaultActions();
            try {
                dropTarget.dragEnter(new DropTargetDragEvent(this.currentDTC, point, this.currentDA, this.currentSA));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentDA = 0;
            }
        } else {
            this.currentDT = null;
            this.currentDTC = null;
            this.currentDA = 0;
            this.currentSA = 0;
            this.currentA = 0;
        }
    }

    private void handleExitMessage(Component component, long l) {
        this.postDropTargetEvent(component, 0, 0, 0, 0, null, l, 505, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExitMessage(SunDropTargetEvent sunDropTargetEvent) {
        Component component = (Component)sunDropTargetEvent.getSource();
        DropTarget dropTarget = component.getDropTarget();
        DropTargetContext dropTargetContext = null;
        if (dropTarget == null) {
            this.currentDT = null;
            this.currentT = null;
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentDTC = null;
            return;
        }
        if (dropTarget != this.currentDT) {
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentDT = dropTarget;
            this.currentDTC = dropTarget.getDropTargetContext();
            this.currentDTC.addNotify(this);
        }
        dropTargetContext = this.currentDTC;
        if (dropTarget.isActive()) {
            try {
                dropTarget.dragExit(new DropTargetEvent(dropTargetContext));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.currentA = 0;
                this.currentSA = 0;
                this.currentDA = 0;
                this.currentDT = null;
                this.currentT = null;
                this.currentDTC.removeNotify();
                this.currentDTC = null;
                this.local = null;
                this.dragRejected = false;
            }
        }
    }

    private int handleMotionMessage(Component component, int n, int n2, int n3, int n4, long[] lArray, long l) {
        return this.postDropTargetEvent(component, n, n2, n3, n4, lArray, l, 506, true);
    }

    protected void processMotionMessage(SunDropTargetEvent sunDropTargetEvent, boolean bl) {
        Component component = (Component)sunDropTargetEvent.getSource();
        Point point = sunDropTargetEvent.getPoint();
        int n = sunDropTargetEvent.getID();
        DropTarget dropTarget = component.getDropTarget();
        DropTargetContext dropTargetContext = null;
        if (component.isShowing() && dropTarget != null && dropTarget.isActive()) {
            if (this.currentDT != dropTarget) {
                if (this.currentDTC != null) {
                    this.currentDTC.removeNotify();
                }
                this.currentDT = dropTarget;
                this.currentDTC = null;
            }
            if ((dropTargetContext = this.currentDT.getDropTargetContext()) != this.currentDTC) {
                if (this.currentDTC != null) {
                    this.currentDTC.removeNotify();
                }
                this.currentDTC = dropTargetContext;
                this.currentDTC.addNotify(this);
            }
            this.currentA = this.currentDT.getDefaultActions();
            try {
                DropTargetDragEvent dropTargetDragEvent = new DropTargetDragEvent(dropTargetContext, point, this.currentDA, this.currentSA);
                DropTarget dropTarget2 = dropTarget;
                if (bl) {
                    dropTarget2.dropActionChanged(dropTargetDragEvent);
                } else {
                    dropTarget2.dragOver(dropTargetDragEvent);
                }
                if (this.dragRejected) {
                    this.currentDA = 0;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentDA = 0;
            }
        } else {
            this.currentDA = 0;
        }
    }

    private void handleDropMessage(Component component, int n, int n2, int n3, int n4, long[] lArray, long l) {
        this.postDropTargetEvent(component, n, n2, n3, n4, lArray, l, 502, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDropMessage(SunDropTargetEvent sunDropTargetEvent) {
        Component component = (Component)sunDropTargetEvent.getSource();
        Point point = sunDropTargetEvent.getPoint();
        DropTarget dropTarget = component.getDropTarget();
        this.dropStatus = 1;
        this.dropComplete = false;
        if (component.isShowing() && dropTarget != null && dropTarget.isActive()) {
            DropTargetContext dropTargetContext = dropTarget.getDropTargetContext();
            this.currentDT = dropTarget;
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentDTC = dropTargetContext;
            this.currentDTC.addNotify(this);
            this.currentA = dropTarget.getDefaultActions();
            Object object = _globalLock;
            synchronized (object) {
                this.local = SunDropTargetContextPeer.getJVMLocalSourceTransferable();
                if (this.local != null) {
                    SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
                }
            }
            try {
                dropTarget.drop(new DropTargetDropEvent(dropTargetContext, point, this.currentDA, this.currentSA, this.local != null));
            }
            finally {
                if (this.dropStatus == 1) {
                    this.rejectDrop();
                } else if (!this.dropComplete) {
                    this.dropComplete(false);
                }
            }
        }
        this.rejectDrop();
    }

    protected int postDropTargetEvent(Component component, int n, int n2, int n3, int n4, long[] lArray, long l, int n5, boolean bl) {
        AppContext appContext = SunToolkit.targetToAppContext(component);
        EventDispatcher eventDispatcher = new EventDispatcher(this, n3, n4, lArray, l, bl);
        SunDropTargetEvent sunDropTargetEvent = new SunDropTargetEvent(component, n5, n, n2, eventDispatcher);
        if (bl) {
            DataTransferer.getInstance().getToolkitThreadBlockedHandler().lock();
        }
        SunToolkit.postEvent(appContext, sunDropTargetEvent);
        this.eventPosted(sunDropTargetEvent);
        if (bl) {
            while (!eventDispatcher.isDone()) {
                DataTransferer.getInstance().getToolkitThreadBlockedHandler().enter();
            }
            DataTransferer.getInstance().getToolkitThreadBlockedHandler().unlock();
            return eventDispatcher.getReturnValue();
        }
        return 0;
    }

    public synchronized void acceptDrag(int n) {
        if (this.currentDT == null) {
            throw new InvalidDnDOperationException("No Drag pending");
        }
        this.currentDA = this.mapOperation(n);
        if (this.currentDA != 0) {
            this.dragRejected = false;
        }
    }

    public synchronized void rejectDrag() {
        if (this.currentDT == null) {
            throw new InvalidDnDOperationException("No Drag pending");
        }
        this.currentDA = 0;
        this.dragRejected = true;
    }

    public synchronized void acceptDrop(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("invalid acceptDrop() action");
        }
        if (this.dropStatus != 1) {
            throw new InvalidDnDOperationException("invalid acceptDrop()");
        }
        this.currentDA = this.currentA = this.mapOperation(n & this.currentSA);
        this.dropStatus = 2;
        this.dropComplete = false;
    }

    public synchronized void rejectDrop() {
        if (this.dropStatus != 1) {
            throw new InvalidDnDOperationException("invalid rejectDrop()");
        }
        this.dropStatus = -1;
        this.currentDA = 0;
        this.dropComplete(false);
    }

    private int mapOperation(int n) {
        int[] nArray = new int[]{2, 1, 0x40000000};
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if ((n & nArray[i]) != nArray[i]) continue;
            n2 = nArray[i];
            break;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dropComplete(boolean bl) {
        if (this.dropStatus == 0) {
            throw new InvalidDnDOperationException("No Drop pending");
        }
        if (this.currentDTC != null) {
            this.currentDTC.removeNotify();
        }
        this.currentDT = null;
        this.currentDTC = null;
        this.currentT = null;
        this.currentA = 0;
        Object object = _globalLock;
        synchronized (object) {
            currentJVMLocalSourceTransferable = null;
        }
        this.dropStatus = 0;
        this.dropComplete = true;
        try {
            this.doDropDone(bl, this.currentDA, this.local != null);
        }
        finally {
            this.currentDA = 0;
            this.nativeDragContext = 0L;
        }
    }

    protected abstract void doDropDone(boolean var1, int var2, boolean var3);

    protected synchronized long getNativeDragContext() {
        return this.nativeDragContext;
    }

    protected void eventPosted(SunDropTargetEvent sunDropTargetEvent) {
    }

    protected void eventProcessed(SunDropTargetEvent sunDropTargetEvent, int n, boolean bl) {
    }

    static /* synthetic */ long[] access$202(SunDropTargetContextPeer sunDropTargetContextPeer, long[] lArray) {
        sunDropTargetContextPeer.currentT = lArray;
        return lArray;
    }

    protected static class EventDispatcher {
        private final SunDropTargetContextPeer peer;
        private final int dropAction;
        private final int actions;
        private final long[] formats;
        private long nativeCtxt;
        private final boolean dispatchType;
        private boolean dispatcherDone = false;
        private int returnValue = 0;
        private final HashSet eventSet = new HashSet(3);
        static final ToolkitThreadBlockedHandler handler = DataTransferer.getInstance().getToolkitThreadBlockedHandler();

        EventDispatcher(SunDropTargetContextPeer sunDropTargetContextPeer, int n, int n2, long[] lArray, long l, boolean bl) {
            this.peer = sunDropTargetContextPeer;
            this.nativeCtxt = l;
            this.dropAction = n;
            this.actions = n2;
            this.formats = null == lArray ? null : Arrays.copyOf(lArray, lArray.length);
            this.dispatchType = bl;
        }

        void dispatchEvent(SunDropTargetEvent sunDropTargetEvent) {
            int n = sunDropTargetEvent.getID();
            switch (n) {
                case 504: {
                    this.dispatchEnterEvent(sunDropTargetEvent);
                    break;
                }
                case 506: {
                    this.dispatchMotionEvent(sunDropTargetEvent);
                    break;
                }
                case 505: {
                    this.dispatchExitEvent(sunDropTargetEvent);
                    break;
                }
                case 502: {
                    this.dispatchDropEvent(sunDropTargetEvent);
                    break;
                }
                default: {
                    throw new InvalidDnDOperationException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchEnterEvent(SunDropTargetEvent sunDropTargetEvent) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                this.peer.previousDA = this.dropAction;
                this.peer.nativeDragContext = this.nativeCtxt;
                SunDropTargetContextPeer.access$202(this.peer, this.formats);
                this.peer.currentSA = this.actions;
                this.peer.currentDA = this.dropAction;
                this.peer.dropStatus = 2;
                this.peer.dropComplete = false;
                try {
                    this.peer.processEnterMessage(sunDropTargetEvent);
                }
                finally {
                    this.peer.dropStatus = 0;
                }
                this.setReturnValue(this.peer.currentDA);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchMotionEvent(SunDropTargetEvent sunDropTargetEvent) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                boolean bl = this.peer.previousDA != this.dropAction;
                this.peer.previousDA = this.dropAction;
                this.peer.nativeDragContext = this.nativeCtxt;
                SunDropTargetContextPeer.access$202(this.peer, this.formats);
                this.peer.currentSA = this.actions;
                this.peer.currentDA = this.dropAction;
                this.peer.dropStatus = 2;
                this.peer.dropComplete = false;
                try {
                    this.peer.processMotionMessage(sunDropTargetEvent, bl);
                }
                finally {
                    this.peer.dropStatus = 0;
                }
                this.setReturnValue(this.peer.currentDA);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchExitEvent(SunDropTargetEvent sunDropTargetEvent) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                this.peer.nativeDragContext = this.nativeCtxt;
                this.peer.processExitMessage(sunDropTargetEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchDropEvent(SunDropTargetEvent sunDropTargetEvent) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                this.peer.nativeDragContext = this.nativeCtxt;
                SunDropTargetContextPeer.access$202(this.peer, this.formats);
                this.peer.currentSA = this.actions;
                this.peer.currentDA = this.dropAction;
                this.peer.processDropMessage(sunDropTargetEvent);
            }
        }

        void setReturnValue(int n) {
            this.returnValue = n;
        }

        int getReturnValue() {
            return this.returnValue;
        }

        boolean isDone() {
            return this.eventSet.isEmpty();
        }

        void registerEvent(SunDropTargetEvent sunDropTargetEvent) {
            handler.lock();
            if (!this.eventSet.add(sunDropTargetEvent) && dndLog.isLoggable(Level.FINE)) {
                dndLog.log(Level.FINE, "Event is already registered: " + sunDropTargetEvent);
            }
            handler.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregisterEvent(SunDropTargetEvent sunDropTargetEvent) {
            handler.lock();
            try {
                if (!this.eventSet.remove(sunDropTargetEvent)) {
                    return;
                }
                if (this.eventSet.isEmpty()) {
                    if (!this.dispatcherDone && this.dispatchType) {
                        handler.exit();
                    }
                    this.dispatcherDone = true;
                }
            }
            finally {
                handler.unlock();
            }
            try {
                this.peer.eventProcessed(sunDropTargetEvent, this.returnValue, this.dispatcherDone);
            }
            finally {
                if (this.dispatcherDone) {
                    this.nativeCtxt = 0L;
                    this.peer.nativeDragContext = 0L;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterAllEvents() {
            Object[] objectArray = null;
            handler.lock();
            try {
                objectArray = this.eventSet.toArray();
            }
            finally {
                handler.unlock();
            }
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.unregisterEvent((SunDropTargetEvent)objectArray[i]);
                }
            }
        }
    }
}

