/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.WindowPeer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.ComponentAccessor;
import sun.awt.DisplayChangedListener;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;
import sun.awt.WindowAccessor;
import sun.awt.X11.MWMConstants;
import sun.awt.X11.Native;
import sun.awt.X11.PropMwmHints;
import sun.awt.X11.ToplevelStateListener;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAWTIcon32_java_icon16_png;
import sun.awt.X11.XAWTIcon32_java_icon24_png;
import sun.awt.X11.XAWTIcon32_java_icon32_png;
import sun.awt.X11.XAWTIcon32_java_icon48_png;
import sun.awt.X11.XAWTIcon64_java_icon16_png;
import sun.awt.X11.XAWTIcon64_java_icon24_png;
import sun.awt.X11.XAWTIcon64_java_icon32_png;
import sun.awt.X11.XAWTIcon64_java_icon48_png;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XCrossingEvent;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XFocusChangeEvent;
import sun.awt.X11.XFocusProxyWindow;
import sun.awt.X11.XIconInfo;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XPanelPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTrayIconPeer;
import sun.awt.X11.XUnmapEvent;
import sun.awt.X11.XVisibilityEvent;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWarningWindow;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11GraphicsEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XWindowPeer
extends XPanelPeer
implements WindowPeer,
DisplayChangedListener,
MWMConstants {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XWindowPeer");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XWindowPeer");
    private static final Logger insLog = Logger.getLogger("sun.awt.X11.insets.XWindowPeer");
    private static final Logger grabLog = Logger.getLogger("sun.awt.X11.grab.XWindowPeer");
    private static final Logger iconLog = Logger.getLogger("sun.awt.X11.icon.XWindowPeer");
    private static Set<XWindowPeer> windows = new HashSet<XWindowPeer>();
    static XAtom wm_protocols;
    static XAtom wm_delete_window;
    static XAtom wm_take_focus;
    Insets insets = new Insets(0, 0, 0, 0);
    XWindowAttributesData winAttr;
    private boolean cachedFocusableWindow;
    XWarningWindow warningWindow;
    private boolean alwaysOnTop;
    PropMwmHints mwm_hints;
    private boolean locationByPlatform;
    Dialog modalBlocker;
    boolean delayedModalBlocking = false;
    Dimension targetMinimumSize = null;
    private XWindowPeer ownerPeer;
    protected XWindowPeer prevTransientFor;
    protected XWindowPeer nextTransientFor;
    private XWindowPeer curRealTransientFor;
    private boolean grab = false;
    private boolean isMapped = false;
    private boolean stateChanged;
    private int savedState;
    private boolean mustControlStackPosition = false;
    private XEventDispatcher rootPropertyEventDispatcher = null;
    private boolean isUnhiding = false;
    private boolean isBeforeFirstMapNotify = false;
    protected Vector<ToplevelStateListener> toplevelStateListeners = new Vector();
    static Font defaultFont;
    private static final int PREFERRED_SIZE_FOR_ICON = 128;
    private static final int MAXIMUM_BUFFER_LENGTH_NET_WM_ICON = 65535;
    private static ArrayList<XIconInfo> defaultIconInfo;
    private int dropTargetCount = 0;
    XAtom XA_NET_WM_STATE;
    XAtomList net_wm_state;
    private Insets wm_set_insets;
    private XBaseWindow pressTarget = this;

    XWindowPeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams.putIfNull((Object)"parent window", (Object)0L));
    }

    XWindowPeer(Window window) {
        super(new XCreateWindowParams(new Object[]{"target", window, "parent window", 0L}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void preInit(XCreateWindowParams xCreateWindowParams) {
        Object object;
        Color color;
        xCreateWindowParams.put("reparented", this.isOverrideRedirect() || this.isSimpleWindow());
        super.preInit(xCreateWindowParams);
        xCreateWindowParams.putIfNull((Object)"bit gravity", (Object)1);
        this.savedState = 0;
        this.XA_NET_WM_STATE = XAtom.get("_NET_WM_STATE");
        this.winAttr = new XWindowAttributesData();
        this.insets = new Insets(0, 0, 0, 0);
        xCreateWindowParams.put("overrideRedirect", this.isOverrideRedirect());
        SunToolkit.awtLock();
        try {
            windows.add(this);
            if (wm_protocols == null) {
                wm_protocols = XAtom.get("WM_PROTOCOLS");
                wm_delete_window = XAtom.get("WM_DELETE_WINDOW");
                wm_take_focus = XAtom.get("WM_TAKE_FOCUS");
            }
        }
        finally {
            SunToolkit.awtUnlock();
        }
        this.cachedFocusableWindow = this.isFocusableWindow();
        Font font = this.target.getFont();
        if (font == null) {
            if (defaultFont == null) {
                defaultFont = new Font("Dialog", 0, 12);
            }
            font = defaultFont;
            this.target.setFont(font);
        }
        if ((color = this.target.getBackground()) == null) {
            object = SystemColor.window;
            this.target.setBackground((Color)object);
        }
        if ((color = this.target.getForeground()) == null) {
            this.target.setForeground(SystemColor.windowText);
        }
        this.alwaysOnTop = ((Window)this.target).isAlwaysOnTop() && ((Window)this.target).isAlwaysOnTopSupported();
        object = this.getGraphicsConfiguration();
        ((X11GraphicsDevice)((GraphicsConfiguration)object).getDevice()).addDisplayChangedListener(this);
    }

    private void initWMProtocols() {
        wm_protocols.setAtomListProperty((XBaseWindow)this, this.getWMProtocols());
    }

    protected XAtomList getWMProtocols() {
        return new XAtomList();
    }

    @Override
    protected String getWMName() {
        String string = this.target.getName();
        if (string == null || string.trim().equals("")) {
            string = " ";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        this.initWMProtocols();
        Window window = (Window)this.target;
        Window window2 = window.getOwner();
        if (window2 != null) {
            long l;
            this.ownerPeer = (XWindowPeer)window2.getPeer();
            if (focusLog.isLoggable(Level.FINER)) {
                focusLog.fine("Owner is " + window2);
                focusLog.fine("Owner peer is " + this.ownerPeer);
                focusLog.fine("Owner X window " + Long.toHexString(this.ownerPeer.getWindow()));
                focusLog.fine("Owner content X window " + Long.toHexString(this.ownerPeer.getContentWindow()));
            }
            if ((l = this.ownerPeer.getWindow()) != 0L) {
                XToolkit.awtLock();
                try {
                    if (focusLog.isLoggable(Level.FINE)) {
                        focusLog.fine("Setting transient on " + Long.toHexString(this.getWindow()) + " for " + Long.toHexString(l));
                    }
                    XWindowPeer.setToplevelTransientFor(this, this.ownerPeer, false, true);
                    XWMHints xWMHints = this.getWMHints();
                    xWMHints.set_flags(xWMHints.get_flags() | 0x40L);
                    xWMHints.set_window_group(l);
                    XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
        }
        if (((Window)this.target).getWarningString() != null && !WindowAccessor.isTrayIconWindow((Window)this.target)) {
            this.warningWindow = new XWarningWindow((Window)this.target, this.getWindow());
        }
        this.setSaveUnder(true);
        XWM.requestWMExtents(this.getWindow());
        this.updateIconImages();
    }

    @Override
    public void updateIconImages() {
        Window window = (Window)this.target;
        List<Image> list = window.getIconImages();
        XWindowPeer xWindowPeer = this.getOwnerPeer();
        this.winAttr.icons = new ArrayList<XIconInfo>();
        if (list.size() != 0) {
            this.winAttr.iconsInherited = false;
            for (Image image : list) {
                XIconInfo xIconInfo;
                if (image == null) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("XWindowPeer.updateIconImages: Skipping the image passed into Java because it's null.");
                    continue;
                }
                try {
                    xIconInfo = new XIconInfo(image);
                }
                catch (Exception exception) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("XWindowPeer.updateIconImages: Perhaps the image passed into Java is broken. Skipping this icon.");
                    continue;
                }
                if (!xIconInfo.isValid()) continue;
                this.winAttr.icons.add(xIconInfo);
            }
        }
        this.winAttr.icons = XWindowPeer.normalizeIconImages(this.winAttr.icons);
        if (this.winAttr.icons.size() == 0) {
            if (xWindowPeer != null) {
                this.winAttr.iconsInherited = true;
                this.winAttr.icons = xWindowPeer.getIconInfo();
            } else {
                this.winAttr.iconsInherited = false;
                this.winAttr.icons = XWindowPeer.getDefaultIconInfo();
            }
        }
        this.recursivelySetIcon(this.winAttr.icons);
    }

    static List<XIconInfo> normalizeIconImages(List<XIconInfo> list) {
        ArrayList<XIconInfo> arrayList = new ArrayList<XIconInfo>();
        int n = 0;
        boolean bl = false;
        for (XIconInfo xIconInfo : list) {
            int n2 = xIconInfo.getWidth();
            int n3 = xIconInfo.getHeight();
            int n4 = xIconInfo.getRawLength();
            if (n2 > 128 || n3 > 128) {
                int n5;
                if (bl) continue;
                int n6 = n2;
                for (n5 = n3; n6 > 128 || n5 > 128; n6 /= 2, n5 /= 2) {
                }
                xIconInfo.setScaledSize(n6, n5);
                n4 = xIconInfo.getRawLength();
            }
            if (n + n4 > 65535) continue;
            n += n4;
            arrayList.add(xIconInfo);
            if (n2 <= 128 && n3 <= 128) continue;
            bl = true;
        }
        if (iconLog.isLoggable(Level.FINEST)) {
            iconLog.log(Level.FINEST, ">>> Length_ of buffer of icons data: " + n + ", maximum length: " + 65535);
        }
        return arrayList;
    }

    static void dumpIcons(List<XIconInfo> list) {
        if (iconLog.isLoggable(Level.FINEST)) {
            iconLog.log(Level.FINEST, ">>> Sizes of icon images:");
            Iterator<XIconInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                iconLog.log(Level.FINEST, "    {0}", iterator.next());
            }
        }
    }

    public void recursivelySetIcon(List<XIconInfo> list) {
        XWindowPeer.dumpIcons(this.winAttr.icons);
        this.setIconHints(list);
        Window window = (Window)this.target;
        Window[] windowArray = window.getOwnedWindows();
        int n = windowArray.length;
        for (int i = 0; i < n; ++i) {
            ComponentPeer componentPeer = windowArray[i].getPeer();
            if (componentPeer == null || !(componentPeer instanceof XWindowPeer) || !((XWindowPeer)componentPeer).winAttr.iconsInherited) continue;
            ((XWindowPeer)componentPeer).winAttr.icons = list;
            ((XWindowPeer)componentPeer).recursivelySetIcon(list);
        }
    }

    List<XIconInfo> getIconInfo() {
        return this.winAttr.icons;
    }

    void setIconHints(List<XIconInfo> list) {
    }

    protected static synchronized List<XIconInfo> getDefaultIconInfo() {
        if (defaultIconInfo == null) {
            defaultIconInfo = new ArrayList();
            if (XlibWrapper.dataModel == 32) {
                defaultIconInfo.add(new XIconInfo(XAWTIcon32_java_icon16_png.java_icon16_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon32_java_icon24_png.java_icon24_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon32_java_icon32_png.java_icon32_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon32_java_icon48_png.java_icon48_png));
            } else {
                defaultIconInfo.add(new XIconInfo(XAWTIcon64_java_icon16_png.java_icon16_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon64_java_icon24_png.java_icon24_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon64_java_icon32_png.java_icon32_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon64_java_icon48_png.java_icon48_png));
            }
        }
        return defaultIconInfo;
    }

    @Override
    public void updateMinimumSize() {
        this.targetMinimumSize = this.target.isMinimumSizeSet() ? this.target.getMinimumSize() : null;
    }

    public Dimension getTargetMinimumSize() {
        return this.targetMinimumSize == null ? null : new Dimension(this.targetMinimumSize);
    }

    public XWindowPeer getOwnerPeer() {
        return this.ownerPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        XToolkit.awtLock();
        try {
            Rectangle rectangle = this.getBounds();
            super.setBounds(n, n2, n3, n4, n5);
            Rectangle rectangle2 = this.getBounds();
            XSizeHints xSizeHints = this.getHints();
            this.setSizeHints(xSizeHints.get_flags() | 4L | 8L, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            XWM.setMotifDecor(this, false, 0, 0);
            XNETProtocol xNETProtocol = XWM.getWM().getNETProtocol();
            if (xNETProtocol != null && xNETProtocol.active()) {
                XAtomList xAtomList = this.getNETWMState();
                xAtomList.add(xNETProtocol.XA_NET_WM_STATE_SKIP_TASKBAR);
                this.setNETWMState(xAtomList);
            }
            if (!rectangle2.getSize().equals(rectangle.getSize())) {
                this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 101));
            }
            if (!rectangle2.getLocation().equals(rectangle.getLocation())) {
                this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 100));
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFocusability() {
        this.updateFocusableWindowState();
        XToolkit.awtLock();
        try {
            XWMHints xWMHints = this.getWMHints();
            xWMHints.set_flags(xWMHints.get_flags() | 1L);
            xWMHints.set_input(false);
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public Insets getInsets() {
        Insets insets = (Insets)this.insets.clone();
        insets.top += this.getWarningWindowHeight();
        return insets;
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void handleStateChange(int n, int n2) {
        this.postEvent(new WindowEvent((Window)this.target, 209, n, n2));
    }

    @Override
    public Insets insets() {
        return this.getInsets();
    }

    boolean isAutoRequestFocus() {
        if (XToolkit.isToolkitThread()) {
            return WindowAccessor.isAutoRequestFocus((Window)this.target);
        }
        return ((Window)this.target).isAutoRequestFocus();
    }

    static XWindowPeer getNativeFocusedWindowPeer() {
        XBaseWindow xBaseWindow = XToolkit.windowToXWindow(XWindowPeer.xGetInputFocus());
        return xBaseWindow instanceof XWindowPeer ? (XWindowPeer)xBaseWindow : (xBaseWindow instanceof XFocusProxyWindow ? ((XFocusProxyWindow)xBaseWindow).getOwner() : null);
    }

    boolean isFocusableWindow() {
        if (XToolkit.isToolkitThread() || SunToolkit.isAWTLockHeldByCurrentThread()) {
            return this.cachedFocusableWindow;
        }
        return ((Window)this.target).isFocusableWindow();
    }

    boolean isFocusedWindowModalBlocker() {
        return false;
    }

    long getFocusTargetWindow() {
        return this.getContentWindow();
    }

    boolean isNativelyNonFocusableWindow() {
        if (XToolkit.isToolkitThread() || SunToolkit.isAWTLockHeldByCurrentThread()) {
            return this.isSimpleWindow() || !this.cachedFocusableWindow;
        }
        return this.isSimpleWindow() || !((Window)this.target).isFocusableWindow();
    }

    public void handleWindowFocusIn_Dispatch() {
        if (EventQueue.isDispatchThread()) {
            XKeyboardFocusManagerPeer.setCurrentNativeFocusedWindow((Window)this.target);
            this.target.dispatchEvent(new WindowEvent((Window)this.target, 207));
        }
    }

    public void handleWindowFocusInSync(long l) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 207);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusedWindow((Window)this.target);
        XWindowPeer.sendEvent(windowEvent);
    }

    public void handleWindowFocusIn(long l) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 207);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusedWindow((Window)this.target);
        this.postEvent(XWindowPeer.wrapInSequenced(windowEvent));
    }

    public void handleWindowFocusOut(Window window, long l) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 208, window);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusedWindow(null);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusOwner(null);
        this.postEvent(XWindowPeer.wrapInSequenced(windowEvent));
    }

    public void handleWindowFocusOutSync(Window window, long l) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 208, window);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusedWindow(null);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusOwner(null);
        XWindowPeer.sendEvent(windowEvent);
    }

    public void checkIfOnNewScreen(Rectangle rectangle) {
        if (!XToolkit.localEnv.runningXinerama()) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("XWindowPeer: Check if we've been moved to a new screen since we're running in Xinerama mode");
        }
        int n = rectangle.width * rectangle.height;
        int n2 = 0;
        int n3 = ((X11GraphicsDevice)this.getGraphicsConfiguration().getDevice()).getScreen();
        int n4 = 0;
        GraphicsDevice[] graphicsDeviceArray = XToolkit.localEnv.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            int n5;
            Rectangle rectangle2 = graphicsDeviceArray[i].getDefaultConfiguration().getBounds();
            if (!rectangle.intersects(rectangle2)) continue;
            int n6 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width) - Math.max(rectangle.x, rectangle2.x);
            int n7 = n6 * (n5 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - Math.max(rectangle.y, rectangle2.y));
            if (n7 == n) {
                n4 = i;
                break;
            }
            if (n7 <= n2) continue;
            n2 = n7;
            n4 = i;
        }
        if (n4 != n3) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("XWindowPeer: Moved to a new screen");
            }
            this.draggedToNewScreen(n4);
        }
    }

    public void draggedToNewScreen(int n) {
        this.executeDisplayChangedOnEDT(n);
    }

    private void executeDisplayChangedOnEDT(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                XWindowPeer.this.displayChanged(n);
            }
        };
        SunToolkit.executeOnEventHandlerThread(this.target, runnable);
    }

    @Override
    public void displayChanged() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = ((X11GraphicsDevice)graphicsConfiguration.getDevice()).getScreen();
        this.executeDisplayChangedOnEDT(n);
    }

    @Override
    public void paletteChanged() {
    }

    @Override
    public void handleConfigureNotifyEvent(XEvent xEvent) {
        XConfigureEvent xConfigureEvent = xEvent.get_xconfigure();
        this.checkIfOnNewScreen(new Rectangle(xConfigureEvent.get_x(), xConfigureEvent.get_y(), xConfigureEvent.get_width(), xConfigureEvent.get_height()));
        super.handleConfigureNotifyEvent(xEvent);
        this.updateChildrenSizes();
    }

    final void requestXFocus(long l) {
        this.requestXFocus(l, true);
    }

    final void requestXFocus() {
        this.requestXFocus(0L, false);
    }

    protected void requestXFocus(long l, boolean bl) {
        if (focusLog.isLoggable(Level.FINE)) {
            focusLog.fine("Requesting window focus");
        }
        this.requestWindowFocus(l, bl);
    }

    public final boolean focusAllowedFor() {
        if (this.isNativelyNonFocusableWindow()) {
            return false;
        }
        return !this.isModalBlocked();
    }

    public void handleFocusEvent(XEvent xEvent) {
        XFocusChangeEvent xFocusChangeEvent = xEvent.get_xfocus();
        focusLog.log(Level.FINE, "{0}", new Object[]{xFocusChangeEvent});
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        if (xEvent.get_type() == 9) {
            if (this.focusAllowedFor() && (xFocusChangeEvent.get_mode() == 0 || xFocusChangeEvent.get_mode() == 3)) {
                this.handleWindowFocusIn(xFocusChangeEvent.get_serial());
            }
        } else if (!(xFocusChangeEvent.get_mode() != 0 && xFocusChangeEvent.get_mode() != 3 || this.isNativelyNonFocusableWindow())) {
            XWindowPeer xWindowPeer = XWindowPeer.getNativeFocusedWindowPeer();
            Object object = xWindowPeer != null ? xWindowPeer.getTarget() : null;
            Window window = null;
            if (object instanceof Window) {
                window = (Window)object;
            }
            if (xWindowPeer != null && xWindowPeer.isNativelyNonFocusableWindow()) {
                return;
            }
            if (this == xWindowPeer) {
                window = null;
            } else if (xWindowPeer instanceof XDecoratedPeer && ((XDecoratedPeer)xWindowPeer).actualFocusedWindow != null && (object = (xWindowPeer = ((XDecoratedPeer)xWindowPeer).actualFocusedWindow).getTarget()) instanceof Window && xWindowPeer.isVisible() && xWindowPeer.isNativelyNonFocusableWindow()) {
                window = (Window)object;
            }
            this.handleWindowFocusOut(window, xFocusChangeEvent.get_serial());
        }
    }

    void setSaveUnder(boolean bl) {
    }

    @Override
    public void toFront() {
        if (this.isOverrideRedirect() && this.mustControlStackPosition) {
            this.mustControlStackPosition = false;
            this.removeRootPropertyEventDispatcher();
        }
        if (this.isVisible()) {
            super.toFront();
            if (this.isFocusableWindow() && this.isAutoRequestFocus() && !this.isModalBlocked() && !this.isWithdrawn()) {
                this.requestInitialFocus();
            }
        } else {
            this.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toBack() {
        XToolkit.awtLock();
        try {
            if (!this.isOverrideRedirect()) {
                XlibWrapper.XLowerWindow(XToolkit.getDisplay(), this.getWindow());
            } else {
                this.lowerOverrideRedirect();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowerOverrideRedirect() {
        HashSet<Long> hashSet = new HashSet<Long>();
        long l = 0L;
        long l2 = 0L;
        for (XWindowPeer xWindowPeer : windows) {
            l = this.getToplevelWindow(xWindowPeer.getWindow());
            if (xWindowPeer.equals(this)) {
                l2 = l;
            }
            if (l <= 0L) continue;
            hashSet.add(l);
        }
        long l3 = -1L;
        long l4 = -1L;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        XQueryTree xQueryTree = new XQueryTree(XToolkit.getDefaultRootWindow());
        try {
            if (xQueryTree.execute() > 0) {
                int n5 = xQueryTree.get_nchildren();
                long l5 = xQueryTree.get_children();
                for (n4 = 0; n4 < n5; ++n4) {
                    long l6 = Native.getWindow(l5, n4);
                    if (l6 == l2) {
                        n = n4;
                        continue;
                    }
                    if (this.isDesktopWindow(l6)) {
                        n2 = n4;
                        l3 = l6;
                        continue;
                    }
                    if (n3 >= 0 || !hashSet.contains(l6) || l6 == l2) continue;
                    n3 = n4;
                    l4 = l6;
                }
            }
            if ((n < n3 || n3 < 0) && n2 < n) {
                return;
            }
            long l7 = Native.allocateLongArray(2);
            Native.putLong(l7, 0, l4);
            Native.putLong(l7, 1, l2);
            XlibWrapper.XRestackWindows(XToolkit.getDisplay(), l7, 2);
            XlibWrapper.unsafe.freeMemory(l7);
            if (!this.mustControlStackPosition) {
                this.mustControlStackPosition = true;
                this.addRootPropertyEventDispatcher();
            }
        }
        finally {
            xQueryTree.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getToplevelWindow(long l) {
        long l2;
        long l3;
        long l4 = l;
        do {
            l2 = l4;
            XQueryTree xQueryTree = new XQueryTree(l4);
            try {
                if (xQueryTree.execute() == 0) {
                    long l5 = 0L;
                    return l5;
                }
                l3 = xQueryTree.get_root();
                l4 = xQueryTree.get_parent();
            }
            finally {
                xQueryTree.dispose();
            }
        } while (l4 != l3);
        return l2;
    }

    private boolean isDesktopWindow(long l) {
        return XWM.getWM().isDesktopWindow(l);
    }

    private void updateAlwaysOnTop() {
        log.log(Level.FINE, "Promoting always-on-top state {0}", this.alwaysOnTop);
        XWM.getWM().setLayer(this, this.alwaysOnTop ? 1 : 0);
    }

    @Override
    public void setAlwaysOnTop(boolean bl) {
        this.alwaysOnTop = bl;
        this.updateAlwaysOnTop();
    }

    @Override
    boolean isLocationByPlatform() {
        return this.locationByPlatform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteDefaultPosition() {
        this.locationByPlatform = ((Window)this.target).isLocationByPlatform();
        if (this.locationByPlatform) {
            XToolkit.awtLock();
            try {
                Rectangle rectangle = this.getBounds();
                XSizeHints xSizeHints = this.getHints();
                this.setSizeHints(xSizeHints.get_flags() & 0xFFFFFFFFFFFFFFFAL, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean bl) {
        if (!this.isVisible() && bl) {
            this.isBeforeFirstMapNotify = true;
            this.winAttr.initialFocus = this.isAutoRequestFocus();
            if (!this.winAttr.initialFocus) {
                this.suppressWmTakeFocus(true);
            }
        }
        this.updateFocusability();
        this.promoteDefaultPosition();
        super.setVisible(bl);
        if (!bl && !this.isWithdrawn()) {
            XToolkit.awtLock();
            try {
                XUnmapEvent xUnmapEvent = new XUnmapEvent();
                xUnmapEvent.set_window(this.window);
                xUnmapEvent.set_event(XToolkit.getDefaultRootWindow());
                xUnmapEvent.set_type(18);
                xUnmapEvent.set_from_configure(false);
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, xUnmapEvent.pData);
                xUnmapEvent.dispose();
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (this.isOverrideRedirect() && bl) {
            this.updateChildrenSizes();
        }
    }

    protected void suppressWmTakeFocus(boolean bl) {
    }

    final boolean isSimpleWindow() {
        return !(this.target instanceof Frame) && !(this.target instanceof Dialog);
    }

    boolean hasWarningWindow() {
        return this.warningWindow != null;
    }

    int getMenuBarHeight() {
        return 0;
    }

    int getWarningWindowHeight() {
        if (this.warningWindow != null) {
            return this.warningWindow.getHeight();
        }
        return 0;
    }

    void updateChildrenSizes() {
        if (this.warningWindow != null) {
            this.warningWindow.reshape(0, this.getMenuBarHeight(), this.getSize().width, this.warningWindow.getHeight());
        }
    }

    boolean isOverrideRedirect() {
        return XWM.getWMID() == 4 || XTrayIconPeer.isTrayIconStuffWindow((Window)this.target);
    }

    final boolean isOLWMDecorBug() {
        return XWM.getWMID() == 4 && !this.winAttr.nativeDecor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        SunToolkit.awtLock();
        try {
            windows.remove(this);
        }
        finally {
            SunToolkit.awtUnlock();
        }
        if (this.warningWindow != null) {
            this.warningWindow.destroy();
        }
        this.removeRootPropertyEventDispatcher();
        this.mustControlStackPosition = false;
        super.dispose();
        if (this.isSimpleWindow() && this.target == XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow()) {
            Window window = XWindowPeer.getDecoratedOwner((Window)this.target);
            ((XWindowPeer)ComponentAccessor.getPeer(window)).requestWindowFocus();
        }
    }

    @Override
    boolean isResizable() {
        return this.winAttr.isResizable;
    }

    @Override
    public void handleVisibilityEvent(XEvent xEvent) {
        super.handleVisibilityEvent(xEvent);
        XVisibilityEvent xVisibilityEvent = xEvent.get_xvisibility();
        this.winAttr.visibilityState = xVisibilityEvent.get_state();
    }

    @Override
    public void handlePropertyNotify(XEvent xEvent) {
        super.handlePropertyNotify(xEvent);
        XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
        if (xPropertyEvent.get_atom() == XWM.XA_WM_STATE.getAtom()) {
            this.stateChanged = true;
            this.stateChanged(xPropertyEvent.get_time(), this.savedState, this.getWMState());
        } else if (xPropertyEvent.get_atom() == XWM.XA_KDE_NET_WM_FRAME_STRUT.getAtom() || xPropertyEvent.get_atom() == XWM.XA_NET_FRAME_EXTENTS.getAtom()) {
            this.getWMSetInsets(XAtom.get(xPropertyEvent.get_atom()));
        }
    }

    void handleRootPropertyNotify(XEvent xEvent) {
        XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
        if (this.mustControlStackPosition && xPropertyEvent.get_atom() == XAtom.get("_NET_CLIENT_LIST_STACKING").getAtom() && this.isOverrideRedirect()) {
            this.toBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMapNotifyEvent(XEvent xEvent) {
        this.isUnhiding |= this.isWMStateNetHidden();
        super.handleMapNotifyEvent(xEvent);
        if (!this.winAttr.initialFocus) {
            this.suppressWmTakeFocus(false);
            XToolkit.awtLock();
            try {
                XlibWrapper.XRaiseWindow(XToolkit.getDisplay(), this.getWindow());
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (this.shouldFocusOnMapNotify()) {
            focusLog.fine("Automatically request focus on window");
            this.requestInitialFocus();
        }
        this.isUnhiding = false;
        this.isBeforeFirstMapNotify = false;
        this.updateAlwaysOnTop();
        Object object = this.getStateLock();
        synchronized (object) {
            if (!this.isMapped) {
                this.isMapped = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleUnmapNotifyEvent(XEvent xEvent) {
        super.handleUnmapNotifyEvent(xEvent);
        this.isUnhiding |= this.isWMStateNetHidden();
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.isMapped) {
                this.isMapped = false;
            }
        }
    }

    private boolean shouldFocusOnMapNotify() {
        boolean bl = false;
        bl = this.isBeforeFirstMapNotify ? this.winAttr.initialFocus || this.isFocusedWindowModalBlocker() : this.isUnhiding;
        bl = bl && this.isFocusableWindow() && !this.isModalBlocked();
        return bl;
    }

    private boolean isWMStateNetHidden() {
        XNETProtocol xNETProtocol = XWM.getWM().getNETProtocol();
        return xNETProtocol != null && xNETProtocol.isWMStateNetHidden(this);
    }

    protected void requestInitialFocus() {
        this.requestXFocus();
    }

    public void addToplevelStateListener(ToplevelStateListener toplevelStateListener) {
        this.toplevelStateListeners.add(toplevelStateListener);
    }

    public void removeToplevelStateListener(ToplevelStateListener toplevelStateListener) {
        this.toplevelStateListeners.remove(toplevelStateListener);
    }

    protected void stateChanged(long l, int n, int n2) {
        this.updateTransientFor();
        for (ToplevelStateListener toplevelStateListener : this.toplevelStateListeners) {
            toplevelStateListener.stateChangedICCCM(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getWMState() {
        if (this.stateChanged) {
            this.stateChanged = false;
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(this.window, XWM.XA_WM_STATE, 0L, 1L, false, XWM.XA_WM_STATE);
            try {
                int n = windowPropertyGetter.execute();
                if (n != 0 || windowPropertyGetter.getData() == 0L) {
                    this.savedState = 0;
                    int n2 = 0;
                    return n2;
                }
                if (windowPropertyGetter.getActualType() != XWM.XA_WM_STATE.getAtom() && windowPropertyGetter.getActualFormat() != 32) {
                    this.savedState = 0;
                    int n3 = 0;
                    return n3;
                }
                this.savedState = (int)Native.getCard32(windowPropertyGetter.getData());
            }
            finally {
                windowPropertyGetter.dispose();
            }
        }
        return this.savedState;
    }

    boolean isWithdrawn() {
        return this.getWMState() == 0;
    }

    boolean hasDecorations(int n) {
        boolean bl;
        if (!this.winAttr.nativeDecor) {
            return false;
        }
        int n2 = this.winAttr.decorations;
        boolean bl2 = bl = (n2 & n) == n;
        if ((n2 & XWindowAttributesData.AWT_DECOR_ALL) != 0) {
            return !bl;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setReparented(boolean bl) {
        super.setReparented(bl);
        XToolkit.awtLock();
        try {
            if (this.isReparented() && this.delayedModalBlocking) {
                this.addToTransientFors((XDialogPeer)ComponentAccessor.getPeer(this.modalBlocker));
                this.delayedModalBlocking = false;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector<XWindowPeer> collectJavaToplevels() {
        long l;
        int n;
        Vector<XWindowPeer> vector = new Vector<XWindowPeer>();
        Vector<Long> vector2 = new Vector<Long>();
        X11GraphicsEnvironment x11GraphicsEnvironment = (X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = x11GraphicsEnvironment.getScreenDevices();
        if (!x11GraphicsEnvironment.runningXinerama() && graphicsDeviceArray.length > 1) {
            for (GraphicsDevice object : graphicsDeviceArray) {
                n = ((X11GraphicsDevice)object).getScreen();
                l = XlibWrapper.RootWindow(XToolkit.getDisplay(), n);
                vector2.add(l);
            }
        } else {
            vector2.add(XToolkit.getDefaultRootWindow());
        }
        int n2 = windows.size();
        while (vector2.size() > 0 && vector.size() < n2) {
            long l2 = (Long)vector2.remove(0);
            XQueryTree xQueryTree = new XQueryTree(l2);
            try {
                if (xQueryTree.execute() == 0) continue;
                n = xQueryTree.get_nchildren();
                l = xQueryTree.get_children();
                for (int i = 0; i < n; ++i) {
                    long l3 = Native.getWindow(l, i);
                    XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l3);
                    if (xBaseWindow != null && !(xBaseWindow instanceof XWindowPeer)) continue;
                    vector2.add(l3);
                    if (!(xBaseWindow instanceof XWindowPeer)) continue;
                    XWindowPeer xWindowPeer = (XWindowPeer)xBaseWindow;
                    vector.add(xWindowPeer);
                    int n3 = 0;
                    XWindowPeer xWindowPeer2 = vector.get(n3);
                    while (xWindowPeer2 != xWindowPeer) {
                        XWindowPeer xWindowPeer3 = xWindowPeer2.getOwnerPeer();
                        if (xWindowPeer3 == xWindowPeer) {
                            vector.remove(n3);
                            vector.add(xWindowPeer2);
                        } else {
                            ++n3;
                        }
                        xWindowPeer2 = vector.get(n3);
                    }
                }
            }
            finally {
                xQueryTree.dispose();
            }
        }
        return vector;
    }

    @Override
    public void setModalBlocked(Dialog dialog, boolean bl) {
        this.setModalBlocked(dialog, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModalBlocked(Dialog dialog, boolean bl, Vector<XWindowPeer> vector) {
        XToolkit.awtLock();
        try {
            Object object = this.getStateLock();
            synchronized (object) {
                XDialogPeer xDialogPeer = (XDialogPeer)ComponentAccessor.getPeer(dialog);
                if (bl) {
                    log.log(Level.FINE, "{0} is blocked by {1}", new Object[]{this, xDialogPeer});
                    this.modalBlocker = dialog;
                    if (this.isReparented() || XWM.isNonReparentingWM()) {
                        this.addToTransientFors(xDialogPeer, vector);
                    } else {
                        this.delayedModalBlocking = true;
                    }
                } else {
                    if (dialog != this.modalBlocker) {
                        throw new IllegalStateException("Trying to unblock window blocked by another dialog");
                    }
                    this.modalBlocker = null;
                    if (this.isReparented() || XWM.isNonReparentingWM()) {
                        this.removeFromTransientFors();
                    } else {
                        this.delayedModalBlocking = false;
                    }
                }
                this.updateTransientFor();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static void setToplevelTransientFor(XWindowPeer xWindowPeer, XWindowPeer xWindowPeer2, boolean bl, boolean bl2) {
        if (xWindowPeer == null || xWindowPeer2 == null) {
            return;
        }
        if (bl) {
            xWindowPeer.prevTransientFor = xWindowPeer2;
            xWindowPeer2.nextTransientFor = xWindowPeer;
        }
        if (xWindowPeer.curRealTransientFor == xWindowPeer2) {
            return;
        }
        if (!bl2 && xWindowPeer.getWMState() != xWindowPeer2.getWMState()) {
            return;
        }
        if (xWindowPeer.getScreenNumber() != xWindowPeer2.getScreenNumber()) {
            return;
        }
        long l = xWindowPeer.getWindow();
        while (!XlibUtil.isToplevelWindow(l) && !XlibUtil.isXAWTToplevelWindow(l)) {
            l = XlibUtil.getParentWindow(l);
        }
        long l2 = xWindowPeer2.getWindow();
        while (!XlibUtil.isToplevelWindow(l2) && !XlibUtil.isXAWTToplevelWindow(l2)) {
            l2 = XlibUtil.getParentWindow(l2);
        }
        XlibWrapper.XSetTransientFor(XToolkit.getDisplay(), l, l2);
        xWindowPeer.curRealTransientFor = xWindowPeer2;
    }

    void updateTransientFor() {
        int n = this.getWMState();
        XWindowPeer xWindowPeer = this.prevTransientFor;
        while (xWindowPeer != null && (xWindowPeer.getWMState() != n || xWindowPeer.getScreenNumber() != this.getScreenNumber())) {
            xWindowPeer = xWindowPeer.prevTransientFor;
        }
        if (xWindowPeer != null) {
            XWindowPeer.setToplevelTransientFor(this, xWindowPeer, false, false);
        } else {
            XWindowPeer.restoreTransientFor(this);
        }
        XWindowPeer xWindowPeer2 = this.nextTransientFor;
        while (xWindowPeer2 != null && (xWindowPeer2.getWMState() != n || xWindowPeer2.getScreenNumber() != this.getScreenNumber())) {
            xWindowPeer2 = xWindowPeer2.nextTransientFor;
        }
        if (xWindowPeer2 != null) {
            XWindowPeer.setToplevelTransientFor(xWindowPeer2, this, false, false);
        }
    }

    private static void removeTransientForHint(XWindowPeer xWindowPeer) {
        XAtom xAtom = XAtom.get(68L);
        long l = xWindowPeer.getWindow();
        while (!XlibUtil.isToplevelWindow(l) && !XlibUtil.isXAWTToplevelWindow(l)) {
            l = XlibUtil.getParentWindow(l);
        }
        XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), l, xAtom.getAtom());
        xWindowPeer.curRealTransientFor = null;
    }

    private void addToTransientFors(XDialogPeer xDialogPeer) {
        this.addToTransientFors(xDialogPeer, null);
    }

    private void addToTransientFors(XDialogPeer xDialogPeer, Vector<XWindowPeer> vector) {
        XWindowPeer xWindowPeer = xDialogPeer;
        while (xWindowPeer.prevTransientFor != null) {
            xWindowPeer = xWindowPeer.prevTransientFor;
        }
        XWindowPeer xWindowPeer2 = this;
        while (xWindowPeer2.prevTransientFor != null) {
            xWindowPeer2 = xWindowPeer2.prevTransientFor;
        }
        if (xWindowPeer == xDialogPeer) {
            XWindowPeer.setToplevelTransientFor(xDialogPeer, this, true, false);
        } else {
            if (vector == null) {
                vector = XWindowPeer.collectJavaToplevels();
            }
            XWindowPeer xWindowPeer3 = null;
            for (XWindowPeer xWindowPeer4 : vector) {
                XWindowPeer xWindowPeer5 = xWindowPeer3;
                if (xWindowPeer4 == xWindowPeer2) {
                    if (xWindowPeer2 == this) {
                        if (xWindowPeer5 != null) {
                            XWindowPeer.setToplevelTransientFor(this, xWindowPeer5, true, false);
                        }
                        XWindowPeer.setToplevelTransientFor(xWindowPeer, this, true, false);
                        break;
                    }
                    xWindowPeer3 = xWindowPeer2;
                    xWindowPeer2 = xWindowPeer2.nextTransientFor;
                } else {
                    if (xWindowPeer4 != xWindowPeer) continue;
                    xWindowPeer3 = xWindowPeer;
                    xWindowPeer = xWindowPeer.nextTransientFor;
                }
                if (xWindowPeer5 == null) {
                    xWindowPeer3.prevTransientFor = null;
                } else {
                    XWindowPeer.setToplevelTransientFor(xWindowPeer3, xWindowPeer5, true, false);
                    xWindowPeer3.updateTransientFor();
                }
                if (xWindowPeer != xDialogPeer) continue;
                XWindowPeer.setToplevelTransientFor(xWindowPeer2, xWindowPeer3, true, false);
                XWindowPeer.setToplevelTransientFor(xWindowPeer, this, true, false);
                break;
            }
        }
        XToolkit.XSync();
    }

    static void restoreTransientFor(XWindowPeer xWindowPeer) {
        XWindowPeer xWindowPeer2 = xWindowPeer.getOwnerPeer();
        if (xWindowPeer2 != null) {
            XWindowPeer.setToplevelTransientFor(xWindowPeer, xWindowPeer2, false, true);
        } else {
            XWindowPeer.removeTransientForHint(xWindowPeer);
        }
    }

    private void removeFromTransientFors() {
        XWindowPeer xWindowPeer = this;
        XWindowPeer xWindowPeer2 = this.nextTransientFor;
        HashSet<XWindowPeer> hashSet = new HashSet<XWindowPeer>();
        hashSet.add(this);
        XWindowPeer xWindowPeer3 = this.prevTransientFor;
        while (xWindowPeer3 != null) {
            XWindowPeer xWindowPeer4 = (XWindowPeer)ComponentAccessor.getPeer(xWindowPeer3.modalBlocker);
            if (hashSet.contains(xWindowPeer4)) {
                XWindowPeer.setToplevelTransientFor(xWindowPeer, xWindowPeer3, true, false);
                xWindowPeer = xWindowPeer3;
                hashSet.add(xWindowPeer3);
            } else {
                XWindowPeer.setToplevelTransientFor(xWindowPeer2, xWindowPeer3, true, false);
                xWindowPeer2 = xWindowPeer3;
            }
            xWindowPeer3 = xWindowPeer3.prevTransientFor;
        }
        XWindowPeer.restoreTransientFor(xWindowPeer);
        xWindowPeer.prevTransientFor = null;
        XWindowPeer.restoreTransientFor(xWindowPeer2);
        xWindowPeer2.prevTransientFor = null;
        this.nextTransientFor = null;
        XToolkit.XSync();
    }

    boolean isModalBlocked() {
        return this.modalBlocker != null;
    }

    static Window getDecoratedOwner(Window window) {
        while (null != window && !(window instanceof Frame) && !(window instanceof Dialog)) {
            window = (Window)ComponentAccessor.getParent_NoClientCode(window);
        }
        return window;
    }

    @Override
    public boolean requestWindowFocus() {
        return this.requestWindowFocus(0L, false);
    }

    public boolean requestWindowFocus(long l, boolean bl) {
        XDecoratedPeer xDecoratedPeer;
        focusLog.fine("Request for window focus");
        Window window = (Window)this.target;
        Window window2 = XWindowPeer.getDecoratedOwner(window);
        Window window3 = XWindowPeer.getDecoratedOwner(XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow());
        if (window3 == window2) {
            focusLog.fine("Parent window is active - generating focus for this window");
            this.handleWindowFocusInSync(-1L);
            return true;
        }
        focusLog.fine("Parent window is not active");
        ComponentPeer componentPeer = ComponentAccessor.getPeer(window2);
        if (componentPeer instanceof XDecoratedPeer && (xDecoratedPeer = (XDecoratedPeer)componentPeer).requestWindowFocus(this, l, bl)) {
            focusLog.fine("Parent window accepted focus request - generating focus for this window");
            return true;
        }
        focusLog.fine("Denied - parent window is not active and didn't accept focus request");
        return false;
    }

    void setActualFocusedWindow(XWindowPeer xWindowPeer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void xSetVisible(boolean bl) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting visible on " + this + " to " + bl);
        }
        XToolkit.awtLock();
        try {
            this.visible = bl;
            if (bl) {
                XlibWrapper.XMapRaised(XToolkit.getDisplay(), this.getWindow());
            } else {
                XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.getWindow());
            }
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public synchronized void addDropTarget() {
        long l;
        if (this.dropTargetCount == 0 && (l = this.getWindow()) != 0L) {
            XDropTargetRegistry.getRegistry().registerDropSite(l);
        }
        ++this.dropTargetCount;
    }

    public synchronized void removeDropTarget() {
        long l;
        --this.dropTargetCount;
        if (this.dropTargetCount == 0 && (l = this.getWindow()) != 0L) {
            XDropTargetRegistry.getRegistry().unregisterDropSite(l);
        }
    }

    void addRootPropertyEventDispatcher() {
        if (this.rootPropertyEventDispatcher == null) {
            this.rootPropertyEventDispatcher = new XEventDispatcher(){

                public void dispatchEvent(XEvent xEvent) {
                    if (xEvent.get_type() == 28) {
                        XWindowPeer.this.handleRootPropertyNotify(xEvent);
                    }
                }
            };
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), 0x400000L);
            XToolkit.addEventDispatcher(XToolkit.getDefaultRootWindow(), this.rootPropertyEventDispatcher);
        }
    }

    void removeRootPropertyEventDispatcher() {
        if (this.rootPropertyEventDispatcher != null) {
            XToolkit.removeEventDispatcher(XToolkit.getDefaultRootWindow(), this.rootPropertyEventDispatcher);
            this.rootPropertyEventDispatcher = null;
        }
    }

    @Override
    public void updateFocusableWindowState() {
        this.cachedFocusableWindow = this.isFocusableWindow();
    }

    public XAtomList getNETWMState() {
        if (this.net_wm_state == null) {
            this.net_wm_state = this.XA_NET_WM_STATE.getAtomListPropertyList(this);
        }
        return this.net_wm_state;
    }

    public void setNETWMState(XAtomList xAtomList) {
        this.net_wm_state = xAtomList;
        if (xAtomList != null) {
            this.XA_NET_WM_STATE.setAtomListProperty((XBaseWindow)this, xAtomList);
        }
    }

    public PropMwmHints getMWMHints() {
        if (this.mwm_hints == null) {
            this.mwm_hints = new PropMwmHints();
            if (!XWM.XA_MWM_HINTS.getAtomData(this.getWindow(), this.mwm_hints.pData, 5)) {
                this.mwm_hints.zero();
            }
        }
        return this.mwm_hints;
    }

    public void setMWMHints(PropMwmHints propMwmHints) {
        this.mwm_hints = propMwmHints;
        if (propMwmHints != null) {
            XWM.XA_MWM_HINTS.setAtomData(this.getWindow(), this.mwm_hints.pData, 5);
        }
    }

    public Insets getWMSetInsets(XAtom xAtom) {
        if (this.isEmbedded()) {
            return null;
        }
        if (this.wm_set_insets != null) {
            return this.wm_set_insets;
        }
        this.wm_set_insets = xAtom == null ? XWM.getInsetsFromExtents(this.getWindow()) : XWM.getInsetsFromProp(this.getWindow(), xAtom);
        insLog.log(Level.FINER, "FRAME_EXTENTS: {0}", new Object[]{this.wm_set_insets});
        if (this.wm_set_insets != null) {
            this.handleWMSetInsets(this.wm_set_insets);
        }
        return this.wm_set_insets;
    }

    protected void handleWMSetInsets(Insets insets) {
        this.wm_set_insets = (Insets)insets.clone();
    }

    public void resetWMSetInsets() {
        this.wm_set_insets = null;
    }

    protected synchronized void updateDropTarget() {
        long l;
        if (this.dropTargetCount > 0 && (l = this.getWindow()) != 0L) {
            XDropTargetRegistry.getRegistry().unregisterDropSite(l);
            XDropTargetRegistry.getRegistry().registerDropSite(l);
        }
    }

    public void setGrab(boolean bl) {
        this.grab = bl;
        if (bl) {
            this.pressTarget = this;
            this.grabInput();
        } else {
            XWindowPeer.ungrabInput();
        }
    }

    public boolean isGrabbed() {
        return this.grab && XAwtState.getGrabWindow() == this;
    }

    @Override
    public void handleXCrossingEvent(XEvent xEvent) {
        XCrossingEvent xCrossingEvent = xEvent.get_xcrossing();
        if (grabLog.isLoggable(Level.FINE)) {
            grabLog.log(Level.FINE, "{0}, when grabbed {1}, contains {2}", new Object[]{xCrossingEvent, this.isGrabbed(), this.containsGlobal(xCrossingEvent.get_x_root(), xCrossingEvent.get_y_root())});
        }
        if (this.isGrabbed()) {
            XBaseWindow xBaseWindow = XToolkit.windowToXWindow(xCrossingEvent.get_window());
            grabLog.log(Level.FINER, "  -  Grab event target {0}", new Object[]{xBaseWindow});
            if (xBaseWindow != null && xBaseWindow != this) {
                xBaseWindow.dispatchEvent(xEvent);
                return;
            }
        }
        super.handleXCrossingEvent(xEvent);
    }

    @Override
    public void handleMotionNotify(XEvent xEvent) {
        XMotionEvent xMotionEvent = xEvent.get_xmotion();
        if (grabLog.isLoggable(Level.FINE)) {
            grabLog.log(Level.FINER, "{0}, when grabbed {1}, contains {2}", new Object[]{xMotionEvent, this.isGrabbed(), this.containsGlobal(xMotionEvent.get_x_root(), xMotionEvent.get_y_root())});
        }
        if (this.isGrabbed()) {
            boolean bl = (xMotionEvent.get_state() & 0x700) != 0;
            XBaseWindow xBaseWindow = XToolkit.windowToXWindow(xMotionEvent.get_window());
            if (bl && this.pressTarget != xBaseWindow) {
                xBaseWindow = this.pressTarget.isVisible() ? this.pressTarget : this;
                xMotionEvent.set_window(xBaseWindow.getWindow());
                xMotionEvent.set_x(xMotionEvent.get_x_root() - xBaseWindow.getX());
                xMotionEvent.set_y(xMotionEvent.get_y_root() - xBaseWindow.getY());
            }
            grabLog.log(Level.FINER, "  -  Grab event target {0}", new Object[]{xBaseWindow});
            if (xBaseWindow != null && xBaseWindow != this.getContentXWindow() && xBaseWindow != this) {
                xBaseWindow.dispatchEvent(xEvent);
                return;
            }
            if (!this.containsGlobal(xMotionEvent.get_x_root(), xMotionEvent.get_y_root()) && !bl) {
                return;
            }
        }
        super.handleMotionNotify(xEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleButtonPressRelease(XEvent xEvent) {
        block26: {
            XBaseWindow xBaseWindow;
            XButtonEvent xButtonEvent;
            block23: {
                block24: {
                    XWindowPeer xWindowPeer;
                    block27: {
                        block25: {
                            xButtonEvent = xEvent.get_xbutton();
                            if (grabLog.isLoggable(Level.FINE)) {
                                grabLog.log(Level.FINE, "{0}, when grabbed {1}, contains {2} ({3}, {4}, {5}x{6})", new Object[]{xButtonEvent, this.isGrabbed(), this.containsGlobal(xButtonEvent.get_x_root(), xButtonEvent.get_y_root()), this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight()});
                            }
                            if (!this.isGrabbed()) break block26;
                            xBaseWindow = XToolkit.windowToXWindow(xButtonEvent.get_window());
                            try {
                                grabLog.log(Level.FINER, "  -  Grab event target {0} (press target {1})", new Object[]{xBaseWindow, this.pressTarget});
                                if (xButtonEvent.get_type() == 4 && xButtonEvent.get_button() == 1) {
                                    this.pressTarget = xBaseWindow;
                                } else if (xButtonEvent.get_type() == 5 && xButtonEvent.get_button() == 1 && this.pressTarget != xBaseWindow) {
                                    xBaseWindow = this.pressTarget.isVisible() ? this.pressTarget : this;
                                    xButtonEvent.set_window(xBaseWindow.getWindow());
                                    xButtonEvent.set_x(xButtonEvent.get_x_root() - xBaseWindow.getX());
                                    xButtonEvent.set_y(xButtonEvent.get_y_root() - xBaseWindow.getY());
                                    this.pressTarget = this;
                                }
                                if (xBaseWindow == null || xBaseWindow == this.getContentXWindow() || xBaseWindow == this) break block23;
                                xBaseWindow.dispatchEvent(xEvent);
                                Object var5_4 = null;
                                if (xBaseWindow == null) break block24;
                                if (xBaseWindow == this) break block25;
                            }
                            catch (Throwable throwable) {
                                Object var5_6 = null;
                                if (xBaseWindow == null) {
                                    grabLog.log(Level.FINE, "Generating UngrabEvent on because target is null {0}", this);
                                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                    return;
                                }
                                if (!(xBaseWindow != this && xBaseWindow != this.getContentXWindow() || this.containsGlobal(xButtonEvent.get_x_root(), xButtonEvent.get_y_root()))) {
                                    grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because not inside of shell", this);
                                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                    return;
                                }
                                XWindowPeer xWindowPeer2 = xBaseWindow.getToplevelXWindow();
                                if (xWindowPeer2 == null) {
                                    grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because toplevel is null", this);
                                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                    return;
                                }
                                Window window = (Window)xWindowPeer2.target;
                                while (window != null && xWindowPeer2 != this && !(xWindowPeer2 instanceof XDialogPeer)) {
                                    if ((window = (Window)ComponentAccessor.getParent_NoClientCode(window)) == null) continue;
                                    xWindowPeer2 = (XWindowPeer)ComponentAccessor.getPeer(window);
                                }
                                if (window != null) {
                                    if (window == this.target) throw throwable;
                                    if (!(window instanceof Dialog)) throw throwable;
                                }
                                grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because hierarchy ended", this);
                                this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                throw throwable;
                            }
                            if (xBaseWindow != this.getContentXWindow()) break block27;
                        }
                        if (!this.containsGlobal(xButtonEvent.get_x_root(), xButtonEvent.get_y_root())) {
                            grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because not inside of shell", this);
                            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                            return;
                        }
                    }
                    if ((xWindowPeer = xBaseWindow.getToplevelXWindow()) == null) {
                        grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because toplevel is null", this);
                        this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                        return;
                    }
                    Window window = (Window)xWindowPeer.target;
                    while (window != null && xWindowPeer != this && !(xWindowPeer instanceof XDialogPeer)) {
                        if ((window = (Window)ComponentAccessor.getParent_NoClientCode(window)) == null) continue;
                        xWindowPeer = (XWindowPeer)ComponentAccessor.getPeer(window);
                    }
                    if (window != null) {
                        if (window == this.target) return;
                        if (!(window instanceof Dialog)) return;
                    }
                    grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because hierarchy ended", this);
                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    return;
                }
                grabLog.log(Level.FINE, "Generating UngrabEvent on because target is null {0}", this);
                this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                return;
            }
            Object var5_5 = null;
            if (xBaseWindow == null) {
                grabLog.log(Level.FINE, "Generating UngrabEvent on because target is null {0}", this);
                this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                return;
            }
            if (!(xBaseWindow != this && xBaseWindow != this.getContentXWindow() || this.containsGlobal(xButtonEvent.get_x_root(), xButtonEvent.get_y_root()))) {
                grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because not inside of shell", this);
                this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                return;
            }
            XWindowPeer xWindowPeer = xBaseWindow.getToplevelXWindow();
            if (xWindowPeer == null) {
                grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because toplevel is null", this);
                this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                return;
            }
            Window window = (Window)xWindowPeer.target;
            while (window != null && xWindowPeer != this && !(xWindowPeer instanceof XDialogPeer)) {
                if ((window = (Window)ComponentAccessor.getParent_NoClientCode(window)) == null) continue;
                xWindowPeer = (XWindowPeer)ComponentAccessor.getPeer(window);
            }
            if (window == null || window != this.target && window instanceof Dialog) {
                grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because hierarchy ended", this);
                this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
            }
        }
        super.handleButtonPressRelease(xEvent);
    }
}

