/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dialog;
import java.awt.Insets;
import java.awt.Window;
import java.awt.peer.DialogPeer;
import java.util.List;
import java.util.Vector;
import sun.awt.ComponentAccessor;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XDialogPeer
extends XDecoratedPeer
implements DialogPeer {
    private Boolean undecorated;

    XDialogPeer(Dialog dialog) {
        super(dialog);
    }

    @Override
    public void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        Dialog dialog = (Dialog)this.target;
        this.undecorated = dialog.isUndecorated();
        boolean bl = this.winAttr.nativeDecor = !dialog.isUndecorated();
        this.winAttr.decorations = this.winAttr.nativeDecor ? XWindowAttributesData.AWT_DECOR_ALL : XWindowAttributesData.AWT_DECOR_NONE;
        this.winAttr.functions = 1;
        this.winAttr.isResizable = true;
        this.winAttr.initialResizability = dialog.isResizable();
        this.winAttr.title = dialog.getTitle();
        this.winAttr.initialState = XWindowAttributesData.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean bl) {
        XToolkit.awtLock();
        try {
            Dialog dialog = (Dialog)this.target;
            if (bl) {
                if (dialog.getModalityType() != Dialog.ModalityType.MODELESS && !this.isModalBlocked()) {
                    XBaseWindow.ungrabInput();
                }
            } else {
                XDialogPeer.restoreTransientFor(this);
                this.prevTransientFor = null;
                this.nextTransientFor = null;
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        super.setVisible(bl);
    }

    @Override
    protected Insets guessInsets() {
        if (this.isTargetUndecorated()) {
            return new Insets(0, 0, 0, 0);
        }
        return super.guessInsets();
    }

    private boolean isTargetUndecorated() {
        if (this.undecorated != null) {
            return this.undecorated;
        }
        return ((Dialog)this.target).isUndecorated();
    }

    @Override
    int getDecorations() {
        int n = super.getDecorations();
        n = (n & 1) != 0 ? (n |= 0x60) : (n &= 0xFFFFFF9F);
        return n;
    }

    @Override
    int getFunctions() {
        int n = super.getFunctions();
        n = (n & 1) != 0 ? (n |= 0x18) : (n &= 0xFFFFFFE7);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockWindows(List<Window> list) {
        Vector<XWindowPeer> vector = null;
        XToolkit.awtLock();
        try {
            vector = XWindowPeer.collectJavaToplevels();
            for (Window window : list) {
                XWindowPeer xWindowPeer = (XWindowPeer)ComponentAccessor.getPeer(window);
                if (xWindowPeer == null) continue;
                xWindowPeer.setModalBlocked((Dialog)this.target, true, vector);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isFocusedWindowModalBlocker() {
        Window window = XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow();
        XWindowPeer xWindowPeer = null;
        xWindowPeer = window != null ? (XWindowPeer)ComponentAccessor.getPeer(window) : XDialogPeer.getNativeFocusedWindowPeer();
        Object object = this.getStateLock();
        synchronized (object) {
            if (xWindowPeer != null && xWindowPeer.modalBlocker == this.target) {
                return true;
            }
        }
        return super.isFocusedWindowModalBlocker();
    }
}

