/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthUI;

class SynthTabbedPaneUI
extends BasicTabbedPaneUI
implements SynthUI,
PropertyChangeListener {
    private SynthContext tabAreaContext;
    private SynthContext tabContext;
    private SynthContext tabContentContext;
    private SynthStyle style;
    private SynthStyle tabStyle;
    private SynthStyle tabAreaStyle;
    private SynthStyle tabContentStyle;
    private Rectangle textRect;
    private Rectangle iconRect;
    private Rectangle tabAreaBounds = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTabbedPaneUI();
    }

    SynthTabbedPaneUI() {
        this.textRect = new Rectangle();
        this.iconRect = new Rectangle();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    protected void installDefaults() {
        this.updateStyle(this.tabPane);
    }

    private void updateStyle(JTabbedPane jTabbedPane) {
        SynthContext synthContext = this.getContext((JComponent)jTabbedPane, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.tabRunOverlay = this.style.getInt(synthContext, "TabbedPane.tabRunOverlay", 0);
            this.textIconGap = this.style.getInt(synthContext, "TabbedPane.textIconGap", 0);
            this.selectedTabPadInsets = (Insets)this.style.get(synthContext, "TabbedPane.selectedTabPadInsets");
            if (this.selectedTabPadInsets == null) {
                this.selectedTabPadInsets = new Insets(0, 0, 0, 0);
            }
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
        if (this.tabContext != null) {
            this.tabContext.dispose();
        }
        this.tabContext = this.getContext(jTabbedPane, Region.TABBED_PANE_TAB, 1);
        this.tabStyle = SynthLookAndFeel.updateStyle(this.tabContext, this);
        this.tabInsets = this.tabStyle.getInsets(this.tabContext, null);
        if (this.tabAreaContext != null) {
            this.tabAreaContext.dispose();
        }
        this.tabAreaContext = this.getContext(jTabbedPane, Region.TABBED_PANE_TAB_AREA, 1);
        this.tabAreaStyle = SynthLookAndFeel.updateStyle(this.tabAreaContext, this);
        this.tabAreaInsets = this.tabAreaStyle.getInsets(this.tabAreaContext, null);
        if (this.tabContentContext != null) {
            this.tabContentContext.dispose();
        }
        this.tabContentContext = this.getContext(jTabbedPane, Region.TABBED_PANE_CONTENT, 1);
        this.tabContentStyle = SynthLookAndFeel.updateStyle(this.tabContentContext, this);
        this.contentBorderInsets = this.tabContentStyle.getInsets(this.tabContentContext, null);
    }

    protected void installListeners() {
        super.installListeners();
        this.tabPane.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removePropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.tabPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        this.tabStyle.uninstallDefaults(this.tabContext);
        this.tabContext.dispose();
        this.tabContext = null;
        this.tabStyle = null;
        this.tabAreaStyle.uninstallDefaults(this.tabAreaContext);
        this.tabAreaContext.dispose();
        this.tabAreaContext = null;
        this.tabAreaStyle = null;
        this.tabContentStyle.uninstallDefaults(this.tabContentContext);
        this.tabContentContext.dispose();
        this.tabContentContext = null;
        this.tabContentStyle = null;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        SynthStyle synthStyle = null;
        Class<SynthContext> clazz = SynthContext.class;
        if (region == Region.TABBED_PANE_TAB) {
            synthStyle = this.tabStyle;
        } else if (region == Region.TABBED_PANE_TAB_AREA) {
            synthStyle = this.tabAreaStyle;
        } else if (region == Region.TABBED_PANE_CONTENT) {
            synthStyle = this.tabContentStyle;
        }
        return SynthContext.getContext(clazz, jComponent, region, synthStyle, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    protected JButton createScrollButton(int n) {
        return new SynthScrollableTabButton(n);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle(this.tabPane);
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintTabbedPaneBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected int getBaseline(int n) {
        if (this.tabPane.getTabComponentAt(n) != null || this.getTextViewForTab(n) != null) {
            return super.getBaseline(n);
        }
        String string = this.tabPane.getTitleAt(n);
        Font font = this.tabContext.getStyle().getFont(this.tabContext);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Icon icon = this.getIconForTab(n);
        this.textRect.setBounds(0, 0, 0, 0);
        this.iconRect.setBounds(0, 0, 0, 0);
        this.calcRect.setBounds(0, 0, Short.MAX_VALUE, this.maxTabHeight);
        this.tabContext.getStyle().getGraphicsUtils(this.tabContext).layoutText(this.tabContext, fontMetrics, string, icon, 0, 0, 10, 11, this.calcRect, this.iconRect, this.textRect, this.textIconGap);
        return this.textRect.y + fontMetrics.getAscent() + this.getBaselineOffset();
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintTabbedPaneBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        int n = this.tabPane.getSelectedIndex();
        int n2 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            Insets insets = this.tabPane.getInsets();
            int n3 = insets.left;
            int n4 = insets.top;
            int n5 = this.tabPane.getWidth() - insets.left - insets.right;
            int n6 = this.tabPane.getHeight() - insets.top - insets.bottom;
            switch (n2) {
                case 2: {
                    n5 = this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                    break;
                }
                case 4: {
                    int n7 = this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                    n3 = n3 + n5 - n7;
                    n5 = n7;
                    break;
                }
                case 3: {
                    int n8 = this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                    n4 = n4 + n6 - n8;
                    n6 = n8;
                    break;
                }
                default: {
                    n6 = this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                }
            }
            this.tabAreaBounds.setBounds(n3, n4, n5, n6);
            if (graphics.getClipBounds().intersects(this.tabAreaBounds)) {
                this.paintTabArea(this.tabAreaContext, graphics, n2, n, this.tabAreaBounds);
            }
        }
        this.paintContentBorder(this.tabContentContext, graphics, n2, n);
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
        Insets insets = this.tabPane.getInsets();
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = this.tabPane.getWidth() - insets.left - insets.right;
        int n6 = this.tabPane.getHeight() - insets.top - insets.bottom;
        this.paintTabArea(this.tabAreaContext, graphics, n, n2, new Rectangle(n3, n4, n5, n6));
    }

    protected void paintTabArea(SynthContext synthContext, Graphics graphics, int n, int n2, Rectangle rectangle) {
        Rectangle rectangle2 = graphics.getClipBounds();
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        synthContext.getPainter().paintTabbedPaneTabAreaBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
        synthContext.getPainter().paintTabbedPaneTabAreaBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
        int n3 = this.tabPane.getTabCount();
        this.iconRect.setBounds(0, 0, 0, 0);
        this.textRect.setBounds(0, 0, 0, 0);
        for (int i = this.runCount - 1; i >= 0; --i) {
            int n4 = this.tabRuns[i];
            int n5 = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int n6 = n5 != 0 ? n5 - 1 : n3 - 1;
            for (int j = n4; j <= n6; ++j) {
                if (!this.rects[j].intersects(rectangle2) || n2 == j) continue;
                this.paintTab(this.tabContext, graphics, n, this.rects, j, this.iconRect, this.textRect);
            }
        }
        if (n2 >= 0 && this.rects[n2].intersects(rectangle2)) {
            this.paintTab(this.tabContext, graphics, n, this.rects, n2, this.iconRect, this.textRect);
        }
    }

    protected void setRolloverTab(int n) {
        int n2 = this.getRolloverTab();
        super.setRolloverTab(n);
        Rectangle rectangle = null;
        if (n2 >= 0 && n2 < this.tabPane.getTabCount() && (rectangle = this.getTabBounds(this.tabPane, n2)) != null) {
            this.tabPane.repaint(rectangle);
        }
        if (n >= 0 && (rectangle = this.getTabBounds(this.tabPane, n)) != null) {
            this.tabPane.repaint(rectangle);
        }
    }

    protected void paintTab(SynthContext synthContext, Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        this.updateTabContext(n2, bl, this.getRolloverTab() == n2, this.getFocusIndex() == n2);
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle3);
        this.tabContext.getPainter().paintTabbedPaneTabBackground(this.tabContext, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, n2, this.tabPane.getTabPlacement());
        this.tabContext.getPainter().paintTabbedPaneTabBorder(this.tabContext, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, n2, this.tabPane.getTabPlacement());
        if (this.tabPane.getTabComponentAt(n2) == null) {
            String string = this.tabPane.getTitleAt(n2);
            Font font = synthContext.getStyle().getFont(synthContext);
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.tabPane, graphics, font);
            Icon icon = this.getIconForTab(n2);
            this.layoutLabel(synthContext, n, fontMetrics, n2, string, icon, rectangle3, rectangle, rectangle2, bl);
            this.paintText(synthContext, graphics, n, font, fontMetrics, n2, string, rectangle2, bl);
            this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        }
    }

    protected void layoutLabel(SynthContext synthContext, int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        synthContext.getStyle().getGraphicsUtils(synthContext).layoutText(synthContext, fontMetrics, string, icon, 0, 0, 10, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    protected void paintText(SynthContext synthContext, Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
            synthContext.getStyle().getGraphicsUtils(synthContext).paintText(synthContext, graphics, string, rectangle, n3);
        }
    }

    protected void paintContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n7 -= (n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n8 -= (n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        SynthLookAndFeel.updateSubregion(synthContext, graphics, new Rectangle(n5, n6, n7, n8));
        synthContext.getPainter().paintTabbedPaneContentBackground(synthContext, graphics, n5, n6, n7, n8);
        synthContext.getPainter().paintTabbedPaneContentBorder(synthContext, graphics, n5, n6, n7, n8);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    protected int calculateMaxTabHeight(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        int n4 = fontMetrics.getHeight();
        for (int i = 0; i < n2; ++i) {
            n3 = Math.max(this.calculateTabHeight(n, i, n4), n3);
        }
        return n3;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        int n3 = insets.left + insets.right;
        Component component = this.tabPane.getTabComponentAt(n2);
        if (component != null) {
            n3 += component.getPreferredSize().width;
        } else {
            View view;
            if (icon != null) {
                n3 += icon.getIconWidth() + this.textIconGap;
            }
            if ((view = this.getTextViewForTab(n2)) != null) {
                n3 += (int)view.getPreferredSpan(0);
            } else {
                String string = this.tabPane.getTitleAt(n2);
                n3 += this.tabContext.getStyle().getGraphicsUtils(this.tabContext).computeStringWidth(this.tabContext, fontMetrics.getFont(), fontMetrics, string);
            }
        }
        return n3;
    }

    protected int calculateMaxTabWidth(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = Math.max(this.calculateTabWidth(n, i, fontMetrics), n3);
        }
        return n3;
    }

    protected Insets getTabInsets(int n, int n2) {
        this.updateTabContext(n2, false, false, this.getFocusIndex() == n2);
        return this.tabInsets;
    }

    protected FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
    }

    protected FontMetrics getFontMetrics(Font font) {
        return this.tabPane.getFontMetrics(font);
    }

    private void updateTabContext(int n, boolean bl, boolean bl2, boolean bl3) {
        int n2 = 0;
        if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n)) {
            n2 |= 8;
            if (bl) {
                n2 |= 0x200;
            }
        } else if (bl) {
            n2 |= 0x201;
            if (bl2 && UIManager.getBoolean("TabbedPane.isTabRollover")) {
                n2 |= 2;
            }
        } else if (bl2) {
            n2 |= 3;
        } else {
            n2 = SynthLookAndFeel.getComponentState(this.tabPane);
            n2 &= 0xFFFFFEFF;
        }
        if (bl3 && this.tabPane.hasFocus()) {
            n2 |= 0x100;
        }
        this.tabContext.setComponentState(n2);
    }

    private class SynthScrollableTabButton
    extends SynthArrowButton
    implements UIResource {
        public SynthScrollableTabButton(int n) {
            super(n);
        }
    }
}

