/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.View;
import sun.swing.MenuItemCheckIconFactory;
import sun.swing.StringUIClientPropertyKey;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    protected PropertyChangeListener propertyChangeListener;
    Handler handler;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private final transient LayoutInfo layoutInfo = new LayoutInfo();
    static final StringUIClientPropertyKey MAX_ARROW_WIDTH = new StringUIClientPropertyKey("maxArrowWidth");
    static final StringUIClientPropertyKey MAX_CHECK_WIDTH = new StringUIClientPropertyKey("maxCheckWidth");
    static final StringUIClientPropertyKey MAX_ICON_WIDTH = new StringUIClientPropertyKey("maxIconWidth");
    static final StringUIClientPropertyKey MAX_TEXT_WIDTH = new StringUIClientPropertyKey("maxTextWidth");
    static final StringUIClientPropertyKey MAX_ACC_WIDTH = new StringUIClientPropertyKey("maxAccWidth");
    static final StringUIClientPropertyKey MAX_LABEL_WIDTH = new StringUIClientPropertyKey("maxLabelWidth");

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("doClick"));
        BasicLookAndFeel.installAudioActionMap(lazyActionMap);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuItemUI();
    }

    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        Object object = UIManager.get(this.getPropertyPrefix() + ".opaque");
        if (object != null) {
            LookAndFeel.installProperty(this.menuItem, "opaque", object);
        } else {
            LookAndFeel.installProperty(this.menuItem, "opaque", Boolean.TRUE);
        }
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(string + ".margin"));
        }
        LookAndFeel.installProperty(this.menuItem, "iconTextGap", new Integer(4));
        this.defaultTextIconGap = this.menuItem.getIconTextGap();
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        LookAndFeel.installProperty(this.menuItem, "borderPainted", UIManager.get(string + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(string + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(string + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(string + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(string + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(string + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(string + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            MenuItemCheckIconFactory menuItemCheckIconFactory;
            this.checkIcon = UIManager.getIcon(string + ".checkIcon");
            boolean bl = LayoutInfo.isColumnLayout(BasicGraphicsUtils.isLeftToRight(this.menuItem), this.menuItem);
            if (bl && (menuItemCheckIconFactory = (MenuItemCheckIconFactory)UIManager.get(string + ".checkIconFactory")) != null && this.useCheckAndArrow() && menuItemCheckIconFactory.isCompatible(this.checkIcon, string)) {
                this.checkIcon = menuItemCheckIconFactory.getIcon(this.menuItem);
            }
        }
    }

    protected void installComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, jMenuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        this.installLazyActionMap();
        this.updateAcceleratorBinding();
    }

    void installLazyActionMap() {
        LazyActionMap.installLazyActionMap(this.menuItem, BasicMenuItemUI.class, this.getPropertyPrefix() + ".actionMap");
    }

    public void uninstallUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        JComponent jComponent2 = BasicMenuItemUI.getMenuItemParent(this.menuItem);
        if (jComponent2 != null) {
            jComponent2.putClientProperty(MAX_ARROW_WIDTH, null);
            jComponent2.putClientProperty(MAX_CHECK_WIDTH, null);
            jComponent2.putClientProperty(MAX_ACC_WIDTH, null);
            jComponent2.putClientProperty(MAX_TEXT_WIDTH, null);
            jComponent2.putClientProperty(MAX_ICON_WIDTH, null);
            jComponent2.putClientProperty(MAX_LABEL_WIDTH, null);
            jComponent2.putClientProperty(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        LookAndFeel.installProperty(this.menuItem, "borderPainted", this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return this.getHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return this.getHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return this.getHandler();
    }

    Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    InputMap createInputMap(int n) {
        if (n == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        InputMap inputMap = SwingUtilities.getUIInputMap(this.menuItem, 2);
        if (inputMap != null) {
            inputMap.clear();
        }
        if (keyStroke != null) {
            if (inputMap == null) {
                inputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, inputMap);
            }
            inputMap.put(keyStroke, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private static JComponent getMenuItemParent(JMenuItem jMenuItem) {
        Container container = jMenuItem.getParent();
        if (!(!(container instanceof JComponent) || jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu())) {
            return (JComponent)container;
        }
        return null;
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        LayoutInfo layoutInfo = this.getLayoutInfo(jMenuItem, icon, icon2, this.createMaxViewRect(), n, this.acceleratorDelimiter, BasicGraphicsUtils.isLeftToRight(jMenuItem), this.acceleratorFont, this.useCheckAndArrow(), this.getPropertyPrefix());
        Dimension dimension = new Dimension();
        dimension.width = layoutInfo.leadingGap;
        this.addWidth(layoutInfo.maxCheckWidth, layoutInfo.afterCheckIconGap, dimension);
        if (!layoutInfo.isTopLevelMenu && layoutInfo.minTextOffset > 0 && dimension.width < layoutInfo.minTextOffset) {
            dimension.width = layoutInfo.minTextOffset;
        }
        this.addWidth(layoutInfo.maxLabelWidth, layoutInfo.gap, dimension);
        this.addWidth(layoutInfo.maxAccWidth, layoutInfo.gap, dimension);
        this.addWidth(layoutInfo.maxArrowWidth, layoutInfo.gap, dimension);
        dimension.height = BasicMenuItemUI.max(layoutInfo.checkRect.height, layoutInfo.labelRect.height, layoutInfo.accRect.height, layoutInfo.arrowRect.height);
        Insets insets = layoutInfo.mi.getInsets();
        if (insets != null) {
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }
        if (dimension.width % 2 == 0) {
            ++dimension.width;
        }
        if (dimension.height % 2 == 0 && Boolean.TRUE != UIManager.get(this.getPropertyPrefix() + ".evenHeight")) {
            ++dimension.height;
        }
        layoutInfo.clear();
        return dimension;
    }

    private Rectangle createMaxViewRect() {
        return new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void addWidth(int n, int n2, Dimension dimension) {
        if (n > 0) {
            dimension.width += n + n2;
        }
    }

    private static int max(int ... nArray) {
        int n = Integer.MIN_VALUE;
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private LayoutInfo getLayoutInfo(JMenuItem jMenuItem, Icon icon, Icon icon2, Rectangle rectangle, int n, String string, boolean bl, Font font, boolean bl2, String string2) {
        this.layoutInfo.reset(jMenuItem, icon, icon2, rectangle, n, string, bl, font, bl2, string2);
        return this.layoutInfo;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        Font font = graphics.getFont();
        Color color3 = graphics.getColor();
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        graphics.setFont(jMenuItem.getFont());
        Rectangle rectangle = new Rectangle(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
        this.applyInsets(rectangle, jMenuItem.getInsets());
        LayoutInfo layoutInfo = this.getLayoutInfo(jMenuItem, icon, icon2, rectangle, n, this.acceleratorDelimiter, BasicGraphicsUtils.isLeftToRight(jMenuItem), this.acceleratorFont, this.useCheckAndArrow(), this.getPropertyPrefix());
        this.layoutMenuItem(layoutInfo);
        this.paintBackground(graphics, jMenuItem, color);
        this.paintCheckIcon(graphics, layoutInfo, color3, color2);
        this.paintIcon(graphics, layoutInfo, color3);
        this.paintText(graphics, layoutInfo);
        this.paintAccText(graphics, layoutInfo);
        this.paintArrowIcon(graphics, layoutInfo, color2);
        graphics.setColor(color3);
        graphics.setFont(font);
        layoutInfo.clear();
    }

    private void paintIcon(Graphics graphics, LayoutInfo layoutInfo, Color color) {
        if (layoutInfo.icon != null) {
            Icon icon;
            ButtonModel buttonModel = layoutInfo.mi.getModel();
            if (!buttonModel.isEnabled()) {
                icon = layoutInfo.mi.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = layoutInfo.mi.getPressedIcon();
                if (icon == null) {
                    icon = layoutInfo.mi.getIcon();
                }
            } else {
                icon = layoutInfo.mi.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(layoutInfo.mi, graphics, layoutInfo.iconRect.x, layoutInfo.iconRect.y);
                graphics.setColor(color);
            }
        }
    }

    private void paintCheckIcon(Graphics graphics, LayoutInfo layoutInfo, Color color, Color color2) {
        if (layoutInfo.checkIcon != null) {
            ButtonModel buttonModel = layoutInfo.mi.getModel();
            if (buttonModel.isArmed() || layoutInfo.mi instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color);
            }
            if (layoutInfo.useCheckAndArrow) {
                layoutInfo.checkIcon.paintIcon(layoutInfo.mi, graphics, layoutInfo.checkRect.x, layoutInfo.checkRect.y);
            }
            graphics.setColor(color);
        }
    }

    private void paintAccText(Graphics graphics, LayoutInfo layoutInfo) {
        if (!layoutInfo.accText.equals("")) {
            ButtonModel buttonModel = layoutInfo.mi.getModel();
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                if (this.disabledForeground != null) {
                    graphics.setColor(this.disabledForeground);
                    SwingUtilities2.drawString((JComponent)layoutInfo.mi, graphics, layoutInfo.accText, layoutInfo.accRect.x, layoutInfo.accRect.y + layoutInfo.accFm.getAscent());
                } else {
                    graphics.setColor(layoutInfo.mi.getBackground().brighter());
                    SwingUtilities2.drawString((JComponent)layoutInfo.mi, graphics, layoutInfo.accText, layoutInfo.accRect.x, layoutInfo.accRect.y + layoutInfo.accFm.getAscent());
                    graphics.setColor(layoutInfo.mi.getBackground().darker());
                    SwingUtilities2.drawString((JComponent)layoutInfo.mi, graphics, layoutInfo.accText, layoutInfo.accRect.x - 1, layoutInfo.accRect.y + layoutInfo.accFm.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || layoutInfo.mi instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(this.acceleratorSelectionForeground);
                } else {
                    graphics.setColor(this.acceleratorForeground);
                }
                SwingUtilities2.drawString((JComponent)layoutInfo.mi, graphics, layoutInfo.accText, layoutInfo.accRect.x, layoutInfo.accRect.y + layoutInfo.accFm.getAscent());
            }
        }
    }

    private void paintText(Graphics graphics, LayoutInfo layoutInfo) {
        if (!layoutInfo.text.equals("")) {
            if (layoutInfo.htmlView != null) {
                layoutInfo.htmlView.paint(graphics, layoutInfo.textRect);
            } else {
                this.paintText(graphics, layoutInfo.mi, layoutInfo.textRect, layoutInfo.text);
            }
        }
    }

    private void paintArrowIcon(Graphics graphics, LayoutInfo layoutInfo, Color color) {
        if (layoutInfo.arrowIcon != null) {
            ButtonModel buttonModel = layoutInfo.mi.getModel();
            if (buttonModel.isArmed() || layoutInfo.mi instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
            }
            if (layoutInfo.useCheckAndArrow) {
                layoutInfo.arrowIcon.paintIcon(layoutInfo.mi, graphics, layoutInfo.arrowRect.x, layoutInfo.arrowRect.y);
            }
        }
    }

    private void applyInsets(Rectangle rectangle, Insets insets) {
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.right + rectangle.x;
            rectangle.height -= insets.bottom + rectangle.y;
        }
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n = jMenuItem.getWidth();
        int n2 = jMenuItem.getHeight();
        if (jMenuItem.isOpaque()) {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n, n2);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n, n2);
            }
            graphics.setColor(color2);
        } else if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color2);
        }
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)jMenuItem, graphics);
        int n = jMenuItem.getDisplayedMnemonicIndex();
        if (!buttonModel.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(jMenuItem.getBackground().brighter());
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(jMenuItem.getBackground().darker());
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        } else {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            }
            SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    private void layoutMenuItem(LayoutInfo layoutInfo) {
        layoutInfo.checkRect.width = layoutInfo.maxCheckWidth;
        layoutInfo.accRect.width = layoutInfo.maxAccWidth;
        layoutInfo.arrowRect.width = layoutInfo.maxArrowWidth;
        if (layoutInfo.isColumnLayout) {
            if (layoutInfo.isLeftToRight) {
                this.doLTRColumnLayout(layoutInfo);
            } else {
                this.doRTLColumnLayout(layoutInfo);
            }
        } else if (layoutInfo.isLeftToRight) {
            this.doLTRComplexLayout(layoutInfo);
        } else {
            this.doRTLComplexLayout(layoutInfo);
        }
        this.alignAccCheckAndArrowVertically(layoutInfo);
    }

    private void alignAccCheckAndArrowVertically(LayoutInfo layoutInfo) {
        layoutInfo.accRect.y = (int)((float)layoutInfo.labelRect.y + (float)layoutInfo.labelRect.height / 2.0f - (float)layoutInfo.accRect.height / 2.0f);
        this.fixVerticalAlignment(layoutInfo, layoutInfo.accRect);
        if (layoutInfo.useCheckAndArrow) {
            layoutInfo.arrowRect.y = (int)((float)layoutInfo.labelRect.y + (float)layoutInfo.labelRect.height / 2.0f - (float)layoutInfo.arrowRect.height / 2.0f);
            layoutInfo.checkRect.y = (int)((float)layoutInfo.labelRect.y + (float)layoutInfo.labelRect.height / 2.0f - (float)layoutInfo.checkRect.height / 2.0f);
            this.fixVerticalAlignment(layoutInfo, layoutInfo.arrowRect);
            this.fixVerticalAlignment(layoutInfo, layoutInfo.checkRect);
        }
    }

    private void fixVerticalAlignment(LayoutInfo layoutInfo, Rectangle rectangle) {
        int n = 0;
        if (rectangle.y < layoutInfo.viewRect.y) {
            n = layoutInfo.viewRect.y - rectangle.y;
        } else if (rectangle.y + rectangle.height > layoutInfo.viewRect.y + layoutInfo.viewRect.height) {
            n = layoutInfo.viewRect.y + layoutInfo.viewRect.height - rectangle.y - rectangle.height;
        }
        if (n != 0) {
            layoutInfo.checkRect.y += n;
            layoutInfo.iconRect.y += n;
            layoutInfo.textRect.y += n;
            layoutInfo.accRect.y += n;
            layoutInfo.arrowRect.y += n;
        }
    }

    private void doLTRColumnLayout(LayoutInfo layoutInfo) {
        layoutInfo.iconRect.width = layoutInfo.maxIconWidth;
        layoutInfo.textRect.width = layoutInfo.maxTextWidth;
        this.calcXPositionsL2R(layoutInfo.viewRect.x, layoutInfo.leadingGap, layoutInfo.gap, layoutInfo.checkRect, layoutInfo.iconRect, layoutInfo.textRect);
        if (layoutInfo.checkRect.width > 0) {
            layoutInfo.iconRect.x += layoutInfo.afterCheckIconGap - layoutInfo.gap;
            layoutInfo.textRect.x += layoutInfo.afterCheckIconGap - layoutInfo.gap;
        }
        this.calcXPositionsR2L(layoutInfo.viewRect.x + layoutInfo.viewRect.width, layoutInfo.gap, layoutInfo.arrowRect, layoutInfo.accRect);
        int n = layoutInfo.textRect.x - layoutInfo.viewRect.x;
        if (!layoutInfo.isTopLevelMenu && n < layoutInfo.minTextOffset) {
            layoutInfo.textRect.x += layoutInfo.minTextOffset - n;
        }
        this.fixTextRects(layoutInfo);
        this.calcTextAndIconYPositions(layoutInfo);
        layoutInfo.labelRect = layoutInfo.textRect.union(layoutInfo.iconRect);
    }

    private void doLTRComplexLayout(LayoutInfo layoutInfo) {
        layoutInfo.labelRect.width = layoutInfo.maxLabelWidth;
        this.calcXPositionsL2R(layoutInfo.viewRect.x, layoutInfo.leadingGap, layoutInfo.gap, layoutInfo.checkRect, layoutInfo.labelRect);
        if (layoutInfo.checkRect.width > 0) {
            layoutInfo.labelRect.x += layoutInfo.afterCheckIconGap - layoutInfo.gap;
        }
        this.calcXPositionsR2L(layoutInfo.viewRect.x + layoutInfo.viewRect.width, layoutInfo.gap, layoutInfo.arrowRect, layoutInfo.accRect);
        int n = layoutInfo.labelRect.x - layoutInfo.viewRect.x;
        if (!layoutInfo.isTopLevelMenu && n < layoutInfo.minTextOffset) {
            layoutInfo.labelRect.x += layoutInfo.minTextOffset - n;
        }
        this.fixAccTextRect(layoutInfo);
        layoutInfo.textRect = new Rectangle();
        layoutInfo.iconRect = new Rectangle();
        SwingUtilities.layoutCompoundLabel(layoutInfo.mi, layoutInfo.fm, layoutInfo.text, layoutInfo.icon, layoutInfo.verticalAlignment, layoutInfo.horizontalAlignment, layoutInfo.verticalTextPosition, layoutInfo.horizontalTextPosition, layoutInfo.labelRect, layoutInfo.iconRect, layoutInfo.textRect, layoutInfo.gap);
    }

    private void doRTLColumnLayout(LayoutInfo layoutInfo) {
        layoutInfo.iconRect.width = layoutInfo.maxIconWidth;
        layoutInfo.textRect.width = layoutInfo.maxTextWidth;
        this.calcXPositionsR2L(layoutInfo.viewRect.x + layoutInfo.viewRect.width, layoutInfo.leadingGap, layoutInfo.gap, layoutInfo.checkRect, layoutInfo.iconRect, layoutInfo.textRect);
        if (layoutInfo.checkRect.width > 0) {
            layoutInfo.iconRect.x -= layoutInfo.afterCheckIconGap - layoutInfo.gap;
            layoutInfo.textRect.x -= layoutInfo.afterCheckIconGap - layoutInfo.gap;
        }
        this.calcXPositionsL2R(layoutInfo.viewRect.x, layoutInfo.gap, layoutInfo.arrowRect, layoutInfo.accRect);
        int n = layoutInfo.viewRect.x + layoutInfo.viewRect.width - (layoutInfo.textRect.x + layoutInfo.textRect.width);
        if (!layoutInfo.isTopLevelMenu && n < layoutInfo.minTextOffset) {
            layoutInfo.textRect.x -= layoutInfo.minTextOffset - n;
        }
        this.rightAlignAllRects(layoutInfo);
        this.fixTextRects(layoutInfo);
        this.calcTextAndIconYPositions(layoutInfo);
        layoutInfo.labelRect = layoutInfo.textRect.union(layoutInfo.iconRect);
    }

    private void doRTLComplexLayout(LayoutInfo layoutInfo) {
        layoutInfo.labelRect.width = layoutInfo.maxLabelWidth;
        this.calcXPositionsR2L(layoutInfo.viewRect.x + layoutInfo.viewRect.width, layoutInfo.leadingGap, layoutInfo.gap, layoutInfo.checkRect, layoutInfo.labelRect);
        if (layoutInfo.checkRect.width > 0) {
            layoutInfo.labelRect.x -= layoutInfo.afterCheckIconGap - layoutInfo.gap;
        }
        this.calcXPositionsL2R(layoutInfo.viewRect.x, layoutInfo.gap, layoutInfo.arrowRect, layoutInfo.accRect);
        int n = layoutInfo.viewRect.x + layoutInfo.viewRect.width - (layoutInfo.labelRect.x + layoutInfo.labelRect.width);
        if (!layoutInfo.isTopLevelMenu && n < layoutInfo.minTextOffset) {
            layoutInfo.labelRect.x -= layoutInfo.minTextOffset - n;
        }
        this.rightAlignAllRects(layoutInfo);
        this.fixAccTextRect(layoutInfo);
        layoutInfo.textRect = new Rectangle();
        layoutInfo.iconRect = new Rectangle();
        SwingUtilities.layoutCompoundLabel(this.menuItem, layoutInfo.fm, layoutInfo.text, layoutInfo.icon, layoutInfo.verticalAlignment, layoutInfo.horizontalAlignment, layoutInfo.verticalTextPosition, layoutInfo.horizontalTextPosition, layoutInfo.labelRect, layoutInfo.iconRect, layoutInfo.textRect, layoutInfo.gap);
    }

    private void calcXPositionsL2R(int n, int n2, int n3, Rectangle ... rectangleArray) {
        int n4 = n + n2;
        for (Rectangle rectangle : rectangleArray) {
            rectangle.x = n4;
            if (rectangle.width <= 0) continue;
            n4 += rectangle.width + n3;
        }
    }

    private void calcXPositionsL2R(int n, int n2, Rectangle ... rectangleArray) {
        this.calcXPositionsL2R(n, n2, n2, rectangleArray);
    }

    private void calcXPositionsR2L(int n, int n2, int n3, Rectangle ... rectangleArray) {
        int n4 = n - n2;
        for (Rectangle rectangle : rectangleArray) {
            rectangle.x = n4 - rectangle.width;
            if (rectangle.width <= 0) continue;
            n4 -= rectangle.width + n3;
        }
    }

    private void calcXPositionsR2L(int n, int n2, Rectangle ... rectangleArray) {
        this.calcXPositionsR2L(n, n2, n2, rectangleArray);
    }

    private void fixTextRects(LayoutInfo layoutInfo) {
        int n;
        if (layoutInfo.htmlView == null && (n = SwingUtilities2.getLeftSideBearing((JComponent)layoutInfo.mi, layoutInfo.fm, layoutInfo.text)) < 0) {
            layoutInfo.textRect.x -= n;
        }
        this.fixAccTextRect(layoutInfo);
    }

    private void fixAccTextRect(LayoutInfo layoutInfo) {
        int n = SwingUtilities2.getLeftSideBearing((JComponent)layoutInfo.mi, layoutInfo.accFm, layoutInfo.accText);
        if (n < 0) {
            layoutInfo.accRect.x -= n;
        }
    }

    private void calcTextAndIconYPositions(LayoutInfo layoutInfo) {
        if (layoutInfo.verticalAlignment == 1) {
            layoutInfo.textRect.y = (int)((float)layoutInfo.viewRect.y + (float)layoutInfo.labelRect.height / 2.0f - (float)layoutInfo.textRect.height / 2.0f);
            layoutInfo.iconRect.y = (int)((float)layoutInfo.viewRect.y + (float)layoutInfo.labelRect.height / 2.0f - (float)layoutInfo.iconRect.height / 2.0f);
        } else if (layoutInfo.verticalAlignment == 0) {
            layoutInfo.textRect.y = (int)((float)layoutInfo.viewRect.y + (float)layoutInfo.viewRect.height / 2.0f - (float)layoutInfo.textRect.height / 2.0f);
            layoutInfo.iconRect.y = (int)((float)layoutInfo.viewRect.y + (float)layoutInfo.viewRect.height / 2.0f - (float)layoutInfo.iconRect.height / 2.0f);
        } else if (layoutInfo.verticalAlignment == 3) {
            layoutInfo.textRect.y = (int)((float)(layoutInfo.viewRect.y + layoutInfo.viewRect.height) - (float)layoutInfo.labelRect.height / 2.0f - (float)layoutInfo.textRect.height / 2.0f);
            layoutInfo.iconRect.y = (int)((float)(layoutInfo.viewRect.y + layoutInfo.viewRect.height) - (float)layoutInfo.labelRect.height / 2.0f - (float)layoutInfo.iconRect.height / 2.0f);
        }
    }

    private void rightAlignAllRects(LayoutInfo layoutInfo) {
        layoutInfo.iconRect.x = layoutInfo.iconRect.x + layoutInfo.iconRect.width - layoutInfo.origIconWidth;
        layoutInfo.iconRect.width = layoutInfo.origIconWidth;
        layoutInfo.textRect.x = layoutInfo.textRect.x + layoutInfo.textRect.width - layoutInfo.origTextWidth;
        layoutInfo.textRect.width = layoutInfo.origTextWidth;
        layoutInfo.accRect.x = layoutInfo.accRect.x + layoutInfo.accRect.width - layoutInfo.origAccWidth;
        layoutInfo.accRect.width = layoutInfo.origAccWidth;
        layoutInfo.checkRect.x = layoutInfo.checkRect.x + layoutInfo.checkRect.width - layoutInfo.origCheckWidth;
        layoutInfo.checkRect.width = layoutInfo.origCheckWidth;
        layoutInfo.arrowRect.x = layoutInfo.arrowRect.x + layoutInfo.arrowRect.width - layoutInfo.origArrowWidth;
        layoutInfo.arrowRect.width = layoutInfo.origArrowWidth;
    }

    private boolean useCheckAndArrow() {
        boolean bl = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            bl = false;
        }
        return bl;
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n = menuElementArray2.length;
        if (n == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n);
            menuElementArray[n] = this.menuItem;
        } else {
            int n2;
            for (n2 = menuElementArray2.length - 1; n2 >= 0 && menuElementArray2[n2].getComponent() != container; --n2) {
            }
            menuElementArray = new MenuElement[n2 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2 + 1);
            menuElementArray[n2 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    void printMenuElementArray(MenuElement[] menuElementArray, boolean bl) {
        System.out.println("Path is(");
        int n = menuElementArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                System.out.print("  ");
            }
            MenuElement menuElement = menuElementArray[i];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
                continue;
            }
            if (menuElement == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + menuElement + ", ");
        }
        System.out.println(")");
        if (bl) {
            Thread.dumpStack();
        }
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        if (!this.isInternalFrameSystemMenu()) {
            BasicLookAndFeel.playSound(this.menuItem, this.getPropertyPrefix() + ".commandSound");
        }
        if (menuSelectionManager == null) {
            menuSelectionManager = MenuSelectionManager.defaultManager();
        }
        menuSelectionManager.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private boolean isInternalFrameSystemMenu() {
        String string = this.menuItem.getActionCommand();
        return string == "Close" || string == "Minimize" || string == "Restore" || string == "Maximize";
    }

    class Handler
    implements MenuDragMouseListener,
    MouseInputListener,
    PropertyChangeListener {
        Handler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!BasicMenuItemUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                menuSelectionManager.setSelectedPath(BasicMenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 1 && menuElementArray[menuElementArray.length - 1] == BasicMenuItemUI.this.menuItem) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                    int n2 = menuElementArray.length - 1;
                    for (int i = 0; i < n2; ++i) {
                        menuElementArray2[i] = menuElementArray[i];
                    }
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            if (!BasicMenuItemUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "labelFor" || string == "displayedMnemonic" || string == "accelerator") {
                BasicMenuItemUI.this.updateAcceleratorBinding();
            } else if (string == "text" || "font" == string || "foreground" == string) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                String string2 = jMenuItem.getText();
                BasicHTML.updateRenderer(jMenuItem, string2);
            } else if (string == "iconTextGap") {
                BasicMenuItemUI.this.defaultTextIconGap = ((Number)propertyChangeEvent.getNewValue()).intValue();
            }
        }
    }

    private static class Actions
    extends UIAction {
        private static final String CLICK = "doClick";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            jMenuItem.doClick();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseClicked(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseReleased(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseEntered(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseExited(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseDragged(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseMoved(mouseEvent);
        }
    }

    private static class LayoutInfo {
        JMenuItem mi;
        JComponent miParent;
        FontMetrics fm;
        FontMetrics accFm;
        Icon icon;
        Icon checkIcon;
        Icon arrowIcon;
        String text;
        String accText;
        boolean isColumnLayout;
        boolean useCheckAndArrow;
        boolean isLeftToRight;
        boolean isTopLevelMenu;
        View htmlView;
        int verticalAlignment;
        int horizontalAlignment;
        int verticalTextPosition;
        int horizontalTextPosition;
        int gap;
        int leadingGap;
        int afterCheckIconGap;
        int minTextOffset;
        Rectangle viewRect;
        Rectangle iconRect;
        Rectangle textRect;
        Rectangle accRect;
        Rectangle checkRect;
        Rectangle arrowRect;
        Rectangle labelRect;
        int origIconWidth;
        int origTextWidth;
        int origAccWidth;
        int origCheckWidth;
        int origArrowWidth;
        int maxIconWidth;
        int maxTextWidth;
        int maxAccWidth;
        int maxCheckWidth;
        int maxArrowWidth;
        int maxLabelWidth;

        public LayoutInfo() {
        }

        public LayoutInfo(JMenuItem jMenuItem, Icon icon, Icon icon2, Rectangle rectangle, int n, String string, boolean bl, Font font, boolean bl2, String string2) {
            this.reset(jMenuItem, icon, icon2, rectangle, n, string, bl, font, bl2, string2);
        }

        public void reset(JMenuItem jMenuItem, Icon icon, Icon icon2, Rectangle rectangle, int n, String string, boolean bl, Font font, boolean bl2, String string2) {
            this.mi = jMenuItem;
            this.miParent = BasicMenuItemUI.getMenuItemParent(jMenuItem);
            this.accText = this.getAccText(string);
            this.verticalAlignment = jMenuItem.getVerticalAlignment();
            this.horizontalAlignment = jMenuItem.getHorizontalAlignment();
            this.verticalTextPosition = jMenuItem.getVerticalTextPosition();
            this.horizontalTextPosition = jMenuItem.getHorizontalTextPosition();
            this.useCheckAndArrow = bl2;
            this.fm = jMenuItem.getFontMetrics(jMenuItem.getFont());
            this.accFm = jMenuItem.getFontMetrics(font);
            this.isLeftToRight = bl;
            this.isColumnLayout = this.isColumnLayout();
            this.isTopLevelMenu = this.miParent == null;
            this.checkIcon = icon;
            this.icon = this.getIcon(string2);
            this.arrowIcon = icon2;
            this.text = jMenuItem.getText();
            this.gap = n;
            this.afterCheckIconGap = this.getAfterCheckIconGap(string2);
            this.minTextOffset = this.getMinTextOffset(string2);
            this.htmlView = (View)jMenuItem.getClientProperty("html");
            this.viewRect = rectangle;
            this.iconRect = new Rectangle();
            this.textRect = new Rectangle();
            this.accRect = new Rectangle();
            this.checkRect = new Rectangle();
            this.arrowRect = new Rectangle();
            this.labelRect = new Rectangle();
            this.calcWidthsAndHeights();
            this.origIconWidth = this.iconRect.width;
            this.origTextWidth = this.textRect.width;
            this.origAccWidth = this.accRect.width;
            this.origCheckWidth = this.checkRect.width;
            this.origArrowWidth = this.arrowRect.width;
            this.calcMaxWidths();
            this.leadingGap = this.getLeadingGap(string2);
            this.calcMaxTextOffset();
        }

        public void clear() {
            this.mi = null;
            this.miParent = null;
            this.fm = null;
            this.accFm = null;
            this.icon = null;
            this.checkIcon = null;
            this.arrowIcon = null;
            this.text = null;
            this.accText = null;
            this.htmlView = null;
            this.viewRect = null;
            this.iconRect = null;
            this.textRect = null;
            this.accRect = null;
            this.checkRect = null;
            this.arrowRect = null;
            this.labelRect = null;
        }

        private String getAccText(String string) {
            String string2 = "";
            KeyStroke keyStroke = this.mi.getAccelerator();
            if (keyStroke != null) {
                int n;
                int n2 = keyStroke.getModifiers();
                if (n2 > 0) {
                    string2 = KeyEvent.getKeyModifiersText(n2);
                    string2 = string2 + string;
                }
                string2 = (n = keyStroke.getKeyCode()) != 0 ? string2 + KeyEvent.getKeyText(n) : string2 + keyStroke.getKeyChar();
            }
            return string2;
        }

        private Icon getIcon(String string) {
            Icon icon = null;
            MenuItemCheckIconFactory menuItemCheckIconFactory = (MenuItemCheckIconFactory)UIManager.get(string + ".checkIconFactory");
            if (!(this.isColumnLayout && this.useCheckAndArrow && menuItemCheckIconFactory != null && menuItemCheckIconFactory.isCompatible(this.checkIcon, string))) {
                icon = this.mi.getIcon();
            }
            return icon;
        }

        private int getMinTextOffset(String string) {
            int n = 0;
            Object object = UIManager.get(string + ".minimumTextOffset");
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            return n;
        }

        private int getAfterCheckIconGap(String string) {
            int n = this.gap;
            Object object = UIManager.get(string + ".afterCheckIconGap");
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            return n;
        }

        private int getLeadingGap(String string) {
            if (this.maxCheckWidth > 0) {
                return this.getCheckOffset(string);
            }
            return this.gap;
        }

        private int getCheckOffset(String string) {
            int n = this.gap;
            Object object = UIManager.get(string + ".checkIconOffset");
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            return n;
        }

        private void calcWidthsAndHeights() {
            if (this.icon != null) {
                this.iconRect.width = this.icon.getIconWidth();
                this.iconRect.height = this.icon.getIconHeight();
            }
            if (!this.accText.equals("")) {
                this.accRect.width = SwingUtilities2.stringWidth(this.mi, this.accFm, this.accText);
                this.accRect.height = this.accFm.getHeight();
            }
            if (this.text == null) {
                this.text = "";
            } else if (!this.text.equals("")) {
                if (this.htmlView != null) {
                    this.textRect.width = (int)this.htmlView.getPreferredSpan(0);
                    this.textRect.height = (int)this.htmlView.getPreferredSpan(1);
                } else {
                    this.textRect.width = SwingUtilities2.stringWidth(this.mi, this.fm, this.text);
                    this.textRect.height = this.fm.getHeight();
                }
            }
            if (this.useCheckAndArrow) {
                if (this.checkIcon != null) {
                    this.checkRect.width = this.checkIcon.getIconWidth();
                    this.checkRect.height = this.checkIcon.getIconHeight();
                }
                if (this.arrowIcon != null) {
                    this.arrowRect.width = this.arrowIcon.getIconWidth();
                    this.arrowRect.height = this.arrowIcon.getIconHeight();
                }
            }
            if (this.isColumnLayout) {
                this.labelRect.width = this.iconRect.width + this.textRect.width + this.gap;
                this.labelRect.height = BasicMenuItemUI.max(new int[]{this.checkRect.height, this.iconRect.height, this.textRect.height, this.accRect.height, this.arrowRect.height});
            } else {
                this.textRect = new Rectangle();
                this.iconRect = new Rectangle();
                SwingUtilities.layoutCompoundLabel(this.mi, this.fm, this.text, this.icon, this.verticalAlignment, this.horizontalAlignment, this.verticalTextPosition, this.horizontalTextPosition, this.viewRect, this.iconRect, this.textRect, this.gap);
                this.labelRect = this.iconRect.union(this.textRect);
            }
        }

        private void calcMaxWidths() {
            this.maxCheckWidth = this.calcMaxValue(MAX_CHECK_WIDTH, this.checkRect.width);
            this.maxArrowWidth = this.calcMaxValue(MAX_ARROW_WIDTH, this.arrowRect.width);
            this.maxAccWidth = this.calcMaxValue(MAX_ACC_WIDTH, this.accRect.width);
            if (this.isColumnLayout) {
                this.maxIconWidth = this.calcMaxValue(MAX_ICON_WIDTH, this.iconRect.width);
                this.maxTextWidth = this.calcMaxValue(MAX_TEXT_WIDTH, this.textRect.width);
                int n = this.gap;
                if (this.maxIconWidth == 0 || this.maxTextWidth == 0) {
                    n = 0;
                }
                this.maxLabelWidth = this.calcMaxValue(MAX_LABEL_WIDTH, this.maxIconWidth + this.maxTextWidth + n);
            } else {
                this.maxIconWidth = this.getParentIntProperty(MAX_ICON_WIDTH);
                this.maxLabelWidth = this.calcMaxValue(MAX_LABEL_WIDTH, this.labelRect.width);
                int n = this.maxLabelWidth - this.maxIconWidth;
                if (this.maxIconWidth > 0) {
                    n -= this.gap;
                }
                this.maxTextWidth = this.calcMaxValue(MAX_TEXT_WIDTH, n);
            }
        }

        private int calcMaxValue(Object object, int n) {
            int n2 = this.getParentIntProperty(object);
            if (n > n2) {
                if (this.miParent != null) {
                    this.miParent.putClientProperty(object, n);
                }
                return n;
            }
            return n2;
        }

        private int getParentIntProperty(Object object) {
            Object object2 = null;
            if (this.miParent != null) {
                object2 = this.miParent.getClientProperty(object);
            }
            if (object2 == null || !(object2 instanceof Integer)) {
                object2 = 0;
            }
            return (Integer)object2;
        }

        private boolean isColumnLayout() {
            return LayoutInfo.isColumnLayout(this.isLeftToRight, this.horizontalAlignment, this.horizontalTextPosition, this.verticalTextPosition);
        }

        public static boolean isColumnLayout(boolean bl, JMenuItem jMenuItem) {
            assert (jMenuItem != null);
            return LayoutInfo.isColumnLayout(bl, jMenuItem.getHorizontalAlignment(), jMenuItem.getHorizontalTextPosition(), jMenuItem.getVerticalTextPosition());
        }

        public static boolean isColumnLayout(boolean bl, int n, int n2, int n3) {
            if (n3 != 0) {
                return false;
            }
            if (bl) {
                if (n != 10 && n != 2) {
                    return false;
                }
                if (n2 != 11 && n2 != 4) {
                    return false;
                }
            } else {
                if (n != 10 && n != 4) {
                    return false;
                }
                if (n2 != 11 && n2 != 2) {
                    return false;
                }
            }
            return true;
        }

        private void calcMaxTextOffset() {
            if (!this.isColumnLayout || !this.isLeftToRight) {
                return;
            }
            int n = this.viewRect.x + this.leadingGap + this.maxCheckWidth + this.afterCheckIconGap + this.maxIconWidth + this.gap;
            if (this.maxCheckWidth == 0) {
                n -= this.afterCheckIconGap;
            }
            if (this.maxIconWidth == 0) {
                n -= this.gap;
            }
            if (n < this.minTextOffset) {
                n = this.minTextOffset;
            }
            this.calcMaxValue(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET, n);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.toString()).append("\n");
            stringBuilder.append("accFm = ").append(this.accFm).append("\n");
            stringBuilder.append("accRect = ").append(this.accRect).append("\n");
            stringBuilder.append("accText = ").append(this.accText).append("\n");
            stringBuilder.append("afterCheckIconGap = ").append(this.afterCheckIconGap).append("\n");
            stringBuilder.append("arrowIcon = ").append(this.arrowIcon).append("\n");
            stringBuilder.append("arrowRect = ").append(this.arrowRect).append("\n");
            stringBuilder.append("checkIcon = ").append(this.checkIcon).append("\n");
            stringBuilder.append("checkRect = ").append(this.checkRect).append("\n");
            stringBuilder.append("fm = ").append(this.fm).append("\n");
            stringBuilder.append("gap = ").append(this.gap).append("\n");
            stringBuilder.append("horizontalAlignment = ").append(this.horizontalAlignment).append("\n");
            stringBuilder.append("horizontalTextPosition = ").append(this.horizontalTextPosition).append("\n");
            stringBuilder.append("htmlView = ").append(this.htmlView).append("\n");
            stringBuilder.append("icon = ").append(this.icon).append("\n");
            stringBuilder.append("iconRect = ").append(this.iconRect).append("\n");
            stringBuilder.append("isColumnLayout = ").append(this.isColumnLayout).append("\n");
            stringBuilder.append("isLeftToRight = ").append(this.isLeftToRight).append("\n");
            stringBuilder.append("isTopLevelMenu = ").append(this.isTopLevelMenu).append("\n");
            stringBuilder.append("labelRect = ").append(this.labelRect).append("\n");
            stringBuilder.append("leadingGap = ").append(this.leadingGap).append("\n");
            stringBuilder.append("maxAccWidth = ").append(this.maxAccWidth).append("\n");
            stringBuilder.append("maxArrowWidth = ").append(this.maxArrowWidth).append("\n");
            stringBuilder.append("maxCheckWidth = ").append(this.maxCheckWidth).append("\n");
            stringBuilder.append("maxIconWidth = ").append(this.maxIconWidth).append("\n");
            stringBuilder.append("maxLabelWidth = ").append(this.maxLabelWidth).append("\n");
            stringBuilder.append("maxTextWidth = ").append(this.maxTextWidth).append("\n");
            stringBuilder.append("maxTextOffset = ").append(this.getParentIntProperty(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET)).append("\n");
            stringBuilder.append("mi = ").append(this.mi).append("\n");
            stringBuilder.append("minTextOffset = ").append(this.minTextOffset).append("\n");
            stringBuilder.append("miParent = ").append(this.miParent).append("\n");
            stringBuilder.append("origAccWidth = ").append(this.origAccWidth).append("\n");
            stringBuilder.append("origArrowWidth = ").append(this.origArrowWidth).append("\n");
            stringBuilder.append("origCheckWidth = ").append(this.origCheckWidth).append("\n");
            stringBuilder.append("origIconWidth = ").append(this.origIconWidth).append("\n");
            stringBuilder.append("origTextWidth = ").append(this.origTextWidth).append("\n");
            stringBuilder.append("text = ").append(this.text).append("\n");
            stringBuilder.append("textRect = ").append(this.textRect).append("\n");
            stringBuilder.append("useCheckAndArrow = ").append(this.useCheckAndArrow).append("\n");
            stringBuilder.append("verticalAlignment = ").append(this.verticalAlignment).append("\n");
            stringBuilder.append("verticalTextPosition = ").append(this.verticalTextPosition).append("\n");
            stringBuilder.append("viewRect = ").append(this.viewRect).append("\n");
            return stringBuilder.toString();
        }
    }
}

