/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeType
extends OpenType<CompositeData> {
    static final long serialVersionUID = -5366242454346948798L;
    private TreeMap<String, String> nameToDescription;
    private TreeMap<String, OpenType<?>> nameToType;
    private transient Integer myHashCode = null;
    private transient String myToString = null;
    private transient Set<String> myNamesSet = null;

    public CompositeType(String string, String string2, String[] stringArray, String[] stringArray2, OpenType<?>[] openTypeArray) throws OpenDataException {
        super(CompositeData.class.getName(), string, string2, false);
        CompositeType.checkForNullElement(stringArray, "itemNames");
        CompositeType.checkForNullElement(stringArray2, "itemDescriptions");
        CompositeType.checkForNullElement(openTypeArray, "itemTypes");
        CompositeType.checkForEmptyString(stringArray, "itemNames");
        CompositeType.checkForEmptyString(stringArray2, "itemDescriptions");
        if (stringArray.length != stringArray2.length || stringArray.length != openTypeArray.length) {
            throw new IllegalArgumentException("Array arguments itemNames[], itemDescriptions[] and itemTypes[] should be of same length (got " + stringArray.length + ", " + stringArray2.length + " and " + openTypeArray.length + ").");
        }
        this.nameToDescription = new TreeMap();
        this.nameToType = new TreeMap();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (this.nameToDescription.containsKey(string3)) {
                throw new OpenDataException("Argument's element itemNames[" + i + "]=\"" + stringArray[i] + "\" duplicates a previous item names.");
            }
            this.nameToDescription.put(string3, stringArray2[i].trim());
            this.nameToType.put(string3, openTypeArray[i]);
        }
    }

    private static void checkForNullElement(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("Argument " + string + "[] cannot be null or empty.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i + "] cannot be null.");
        }
    }

    private static void checkForEmptyString(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].trim().equals("")) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i + "] cannot be an empty string.");
        }
    }

    public boolean containsKey(String string) {
        if (string == null) {
            return false;
        }
        return this.nameToDescription.containsKey(string);
    }

    public String getDescription(String string) {
        if (string == null) {
            return null;
        }
        return this.nameToDescription.get(string);
    }

    public OpenType<?> getType(String string) {
        if (string == null) {
            return null;
        }
        return this.nameToType.get(string);
    }

    public Set<String> keySet() {
        if (this.myNamesSet == null) {
            this.myNamesSet = Collections.unmodifiableSet(this.nameToDescription.keySet());
        }
        return this.myNamesSet;
    }

    @Override
    public boolean isValue(Object object) {
        if (!(object instanceof CompositeData)) {
            return false;
        }
        CompositeData compositeData = (CompositeData)object;
        CompositeType compositeType = compositeData.getCompositeType();
        return this.isAssignableFrom((OpenType)compositeType);
    }

    @Override
    boolean isAssignableFrom(OpenType openType) {
        if (!(openType instanceof CompositeType)) {
            return false;
        }
        CompositeType compositeType = (CompositeType)openType;
        if (!compositeType.getTypeName().equals(this.getTypeName())) {
            return false;
        }
        for (String string : this.keySet()) {
            OpenType<?> openType2 = compositeType.getType(string);
            OpenType<?> openType3 = this.getType(string);
            if (openType2 != null && openType3.isAssignableFrom(openType2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        CompositeType compositeType;
        if (object == null) {
            return false;
        }
        try {
            compositeType = (CompositeType)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getTypeName().equals(compositeType.getTypeName())) {
            return false;
        }
        return this.nameToType.equals(compositeType.nameToType);
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            int n = 0;
            n += this.getTypeName().hashCode();
            for (String string : this.nameToDescription.keySet()) {
                n += string.hashCode();
                n += this.nameToType.get(string).hashCode();
            }
            this.myHashCode = new Integer(n);
        }
        return this.myHashCode;
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append("(name=");
            stringBuilder.append(this.getTypeName());
            stringBuilder.append(",items=(");
            int n = 0;
            for (String string : this.nameToType.keySet()) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("(itemName=");
                stringBuilder.append(string);
                stringBuilder.append(",itemType=");
                stringBuilder.append(this.nameToType.get(string).toString() + ")");
                ++n;
            }
            stringBuilder.append("))");
            this.myToString = stringBuilder.toString();
        }
        return this.myToString;
    }
}

