/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ArrayPersistenceDelegate;
import java.beans.BeanInfo;
import java.beans.ConstructorProperties;
import java.beans.DefaultPersistenceDelegate;
import java.beans.EnumPersistenceDelegate;
import java.beans.Introspector;
import java.beans.NullPersistenceDelegate;
import java.beans.PersistenceDelegate;
import java.beans.PrimitivePersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.ProxyPersistenceDelegate;
import java.beans.ReflectionUtils;
import java.beans.java_awt_AWTKeyStroke_PersistenceDelegate;
import java.beans.java_awt_Font_PersistenceDelegate;
import java.beans.java_util_Date_PersistenceDelegate;
import java.beans.java_util_EnumSet_PersistenceDelegate;
import java.beans.javax_swing_border_MatteBorder_PersistenceDelegate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.Vector;

class MetaData {
    private static Hashtable internalPersistenceDelegates = new Hashtable();
    private static Hashtable transientProperties = new Hashtable();
    private static PersistenceDelegate nullPersistenceDelegate = new NullPersistenceDelegate();
    private static PersistenceDelegate enumPersistenceDelegate = new EnumPersistenceDelegate();
    private static PersistenceDelegate primitivePersistenceDelegate = new PrimitivePersistenceDelegate();
    private static PersistenceDelegate defaultPersistenceDelegate = new DefaultPersistenceDelegate();
    private static PersistenceDelegate arrayPersistenceDelegate;
    private static PersistenceDelegate proxyPersistenceDelegate;

    MetaData() {
    }

    static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static synchronized PersistenceDelegate getPersistenceDelegate(Class clazz) {
        Object object;
        if (clazz == null) {
            return nullPersistenceDelegate;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return enumPersistenceDelegate;
        }
        if (ReflectionUtils.isPrimitive(clazz)) {
            return primitivePersistenceDelegate;
        }
        if (clazz.isArray()) {
            if (arrayPersistenceDelegate == null) {
                arrayPersistenceDelegate = new ArrayPersistenceDelegate();
            }
            return arrayPersistenceDelegate;
        }
        try {
            if (Proxy.isProxyClass(clazz)) {
                if (proxyPersistenceDelegate == null) {
                    proxyPersistenceDelegate = new ProxyPersistenceDelegate();
                }
                return proxyPersistenceDelegate;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = clazz.getName();
        if (MetaData.getBeanAttribute(clazz, "transient_init") == null) {
            object = (Vector)transientProperties.get(string);
            if (object != null) {
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    MetaData.setPropertyAttribute(clazz, (String)((Vector)object).get(i), "transient", Boolean.TRUE);
                }
            }
            MetaData.setBeanAttribute(clazz, "transient_init", Boolean.TRUE);
        }
        if ((object = (PersistenceDelegate)MetaData.getBeanAttribute(clazz, "persistenceDelegate")) == null) {
            object = (PersistenceDelegate)internalPersistenceDelegates.get(string);
            if (object != null) {
                return object;
            }
            internalPersistenceDelegates.put(string, defaultPersistenceDelegate);
            try {
                String string2 = clazz.getName();
                Class<?> clazz2 = Class.forName("java.beans." + string2.replace('.', '_') + "_PersistenceDelegate");
                object = (PersistenceDelegate)clazz2.newInstance();
                internalPersistenceDelegates.put(string, object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String[] stringArray = MetaData.getConstructorProperties(clazz);
                if (stringArray != null) {
                    object = new DefaultPersistenceDelegate(stringArray);
                    internalPersistenceDelegates.put(string, object);
                }
            }
            catch (Exception exception) {
                System.err.println("Internal error: " + exception);
            }
        }
        return object != null ? object : defaultPersistenceDelegate;
    }

    private static String[] getConstructorProperties(Class clazz) {
        String[] stringArray = null;
        int n = 0;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            String[] stringArray2 = MetaData.getAnnotationValue(constructor);
            if (stringArray2 == null || n >= stringArray2.length || !MetaData.isValid(constructor, stringArray2)) continue;
            stringArray = stringArray2;
            n = stringArray2.length;
        }
        return stringArray;
    }

    private static String[] getAnnotationValue(Constructor constructor) {
        ConstructorProperties constructorProperties = constructor.getAnnotation(ConstructorProperties.class);
        return constructorProperties != null ? constructorProperties.value() : null;
    }

    private static boolean isValid(Constructor constructor, String[] stringArray) {
        Class<?>[] classArray = constructor.getParameterTypes();
        if (stringArray.length != classArray.length) {
            return false;
        }
        for (String string : stringArray) {
            if (string != null) continue;
            return false;
        }
        return true;
    }

    public static BeanInfo getBeanInfo(Class clazz) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return beanInfo;
    }

    private static PropertyDescriptor getPropertyDescriptor(Class clazz, String string) {
        BeanInfo beanInfo = MetaData.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (!string.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    private static void setPropertyAttribute(Class clazz, String string, String string2, Object object) {
        PropertyDescriptor propertyDescriptor = MetaData.getPropertyDescriptor(clazz, string);
        if (propertyDescriptor == null) {
            System.err.println("Warning: property " + string + " is not defined on " + clazz);
            return;
        }
        propertyDescriptor.setValue(string2, object);
    }

    private static void setBeanAttribute(Class clazz, String string, Object object) {
        MetaData.getBeanInfo(clazz).getBeanDescriptor().setValue(string, object);
    }

    private static Object getBeanAttribute(Class clazz, String string) {
        return MetaData.getBeanInfo(clazz).getBeanDescriptor().getValue(string);
    }

    private static void removeProperty(String string, String string2) {
        Vector<String> vector = (Vector<String>)transientProperties.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            transientProperties.put(string, vector);
        }
        vector.add(string2);
    }

    static {
        internalPersistenceDelegates.put("java.net.URI", new PrimitivePersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.plaf.BorderUIResource$MatteBorderUIResource", new javax_swing_border_MatteBorder_PersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.plaf.FontUIResource", new java_awt_Font_PersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.KeyStroke", new java_awt_AWTKeyStroke_PersistenceDelegate());
        internalPersistenceDelegates.put("java.sql.Date", new java_util_Date_PersistenceDelegate());
        internalPersistenceDelegates.put("java.sql.Time", new java_util_Date_PersistenceDelegate());
        internalPersistenceDelegates.put("java.util.JumboEnumSet", new java_util_EnumSet_PersistenceDelegate());
        internalPersistenceDelegates.put("java.util.RegularEnumSet", new java_util_EnumSet_PersistenceDelegate());
        MetaData.removeProperty("java.awt.geom.RectangularShape", "frame");
        MetaData.removeProperty("java.awt.Rectangle", "bounds");
        MetaData.removeProperty("java.awt.Dimension", "size");
        MetaData.removeProperty("java.awt.Point", "location");
        MetaData.removeProperty("java.awt.Component", "foreground");
        MetaData.removeProperty("java.awt.Component", "background");
        MetaData.removeProperty("java.awt.Component", "font");
        MetaData.removeProperty("java.awt.Component", "visible");
        MetaData.removeProperty("java.awt.ScrollPane", "scrollPosition");
        MetaData.removeProperty("java.awt.im.InputContext", "compositionEnabled");
        MetaData.removeProperty("javax.swing.JComponent", "minimumSize");
        MetaData.removeProperty("javax.swing.JComponent", "preferredSize");
        MetaData.removeProperty("javax.swing.JComponent", "maximumSize");
        MetaData.removeProperty("javax.swing.ImageIcon", "image");
        MetaData.removeProperty("javax.swing.ImageIcon", "imageObserver");
        MetaData.removeProperty("javax.swing.JMenuBar", "helpMenu");
        MetaData.removeProperty("javax.swing.JScrollPane", "verticalScrollBar");
        MetaData.removeProperty("javax.swing.JScrollPane", "horizontalScrollBar");
        MetaData.removeProperty("javax.swing.JScrollPane", "rowHeader");
        MetaData.removeProperty("javax.swing.JScrollPane", "columnHeader");
        MetaData.removeProperty("javax.swing.JViewport", "extentSize");
        MetaData.removeProperty("javax.swing.table.JTableHeader", "defaultRenderer");
        MetaData.removeProperty("javax.swing.JList", "cellRenderer");
        MetaData.removeProperty("javax.swing.JList", "selectedIndices");
        MetaData.removeProperty("javax.swing.DefaultListSelectionModel", "leadSelectionIndex");
        MetaData.removeProperty("javax.swing.DefaultListSelectionModel", "anchorSelectionIndex");
        MetaData.removeProperty("javax.swing.JComboBox", "selectedIndex");
        MetaData.removeProperty("javax.swing.JTabbedPane", "selectedIndex");
        MetaData.removeProperty("javax.swing.JTabbedPane", "selectedComponent");
        MetaData.removeProperty("javax.swing.AbstractButton", "disabledIcon");
        MetaData.removeProperty("javax.swing.JLabel", "disabledIcon");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "caret");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "caretPosition");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "selectionStart");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "selectionEnd");
    }
}

