/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuItemPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuItem
extends MenuComponent
implements Accessible {
    boolean enabled = true;
    String label;
    String actionCommand;
    long eventMask;
    transient ActionListener actionListener;
    private MenuShortcut shortcut = null;
    private static final String base = "menuitem";
    private static int nameCounter;
    private static final long serialVersionUID = -21757335363267194L;
    private int menuItemSerializedDataVersion = 1;

    public MenuItem() throws HeadlessException {
        this("", null);
    }

    public MenuItem(String string) throws HeadlessException {
        this(string, null);
    }

    public MenuItem(String string, MenuShortcut menuShortcut) throws HeadlessException {
        this.label = string;
        this.shortcut = menuShortcut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<MenuItem> clazz = MenuItem.class;
        synchronized (MenuItem.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenuItem(this);
            }
        }
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.setLabel(string);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean bl) {
        this.enable(bl);
    }

    @Deprecated
    public synchronized void enable() {
        this.enabled = true;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.enable();
        }
    }

    @Deprecated
    public void enable(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    @Deprecated
    public synchronized void disable() {
        this.enabled = false;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.disable();
        }
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(MenuShortcut menuShortcut) {
        this.shortcut = menuShortcut;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.setLabel(this.label);
        }
    }

    public void deleteShortcut() {
        this.shortcut = null;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.setLabel(this.label);
        }
    }

    void deleteShortcut(MenuShortcut menuShortcut) {
        if (menuShortcut.equals(this.shortcut)) {
            this.shortcut = null;
            MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
            if (menuItemPeer != null) {
                menuItemPeer.setLabel(this.label);
            }
        }
    }

    void doMenuEvent(long l, int n) {
        Toolkit.getEventQueue().postEvent(new ActionEvent(this, 1001, this.getActionCommand(), l, n));
    }

    private final boolean isItemEnabled() {
        Menu menu;
        if (!this.isEnabled()) {
            return false;
        }
        MenuContainer menuContainer = this.getParent_NoClientCode();
        do {
            if (!(menuContainer instanceof Menu)) {
                return true;
            }
            menu = (Menu)menuContainer;
            if (menu.isEnabled()) continue;
            return false;
        } while ((menuContainer = menu.getParent_NoClientCode()) != null);
        return true;
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        MenuShortcut menuShortcut = new MenuShortcut(keyEvent.getKeyCode(), (keyEvent.getModifiers() & 1) > 0);
        if (menuShortcut.equals(this.shortcut) && this.isItemEnabled()) {
            if (keyEvent.getID() == 401) {
                this.doMenuEvent(keyEvent.getWhen(), keyEvent.getModifiers());
            }
            return true;
        }
        return false;
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        return menuShortcut.equals(this.shortcut) ? this : null;
    }

    protected final void enableEvents(long l) {
        this.eventMask |= l;
        this.newEventsOnly = true;
    }

    protected final void disableEvents(long l) {
        this.eventMask &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.getActionCommandImpl();
    }

    final String getActionCommandImpl() {
        return this.actionCommand == null ? this.label : this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        ActionListener actionListener = null;
        if (clazz == ActionListener.class) {
            actionListener = this.actionListener;
        }
        return AWTEventMulticaster.getListeners((EventListener)actionListener, clazz);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        }
    }

    @Override
    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        ActionListener actionListener = this.actionListener;
        if (actionListener != null) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public String paramString() {
        String string = ",label=" + this.label;
        if (this.shortcut != null) {
            string = string + ",shortcut=" + this.shortcut;
        }
        return super.paramString() + string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("actionL" == string) {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    private static native void initIDs();

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuItem();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MenuItem.initIDs();
        }
        nameCounter = 0;
    }

    protected class AccessibleAWTMenuItem
    extends MenuComponent.AccessibleAWTMenuComponent
    implements AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = -217847831945965825L;

        protected AccessibleAWTMenuItem() {
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (MenuItem.this.getLabel() == null) {
                return super.getAccessibleName();
            }
            return MenuItem.this.getLabel();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return new String("click");
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                Toolkit.getEventQueue().postEvent(new ActionEvent(MenuItem.this, 1001, MenuItem.this.getActionCommand(), EventQueue.getMostRecentEventTime(), 0));
                return true;
            }
            return false;
        }

        public Number getCurrentAccessibleValue() {
            return 0;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return 0;
        }

        public Number getMaximumAccessibleValue() {
            return 0;
        }
    }
}

