/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import gnu.java.awt.color.ColorSpaceConverter;

public class SrgbConverter
implements ColorSpaceConverter {
    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        return SrgbConverter.XYZtoRGB(fArray);
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        return SrgbConverter.RGBtoXYZ(fArray);
    }

    @Override
    public float[] toRGB(float[] fArray) {
        float[] fArray2 = new float[3];
        System.arraycopy(fArray, 0, fArray2, 0, 3);
        return fArray2;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        float[] fArray2 = new float[3];
        System.arraycopy(fArray, 0, fArray2, 0, 3);
        return fArray2;
    }

    public static float[] XYZtoRGB(float[] fArray) {
        float[] fArray2 = new float[]{3.1338f * fArray[0] - 1.6171f * fArray[1] - 0.4907f * fArray[2], -0.9785f * fArray[0] + 1.916f * fArray[1] + 0.0334f * fArray[2], 0.072f * fArray[0] - 0.229f * fArray[1] + 1.4056f * fArray[2]};
        float[] fArray3 = new float[3];
        for (int i = 0; i < 3; ++i) {
            if (fArray2[i] < 0.0f) {
                fArray2[i] = 0.0f;
            }
            if (fArray2[i] > 1.0f) {
                fArray2[i] = 1.0f;
            }
            fArray3[i] = fArray2[i] <= 0.00304f ? fArray2[i] * 12.92f : 1.055f * (float)Math.exp(0.4166666666666667 * Math.log(fArray2[i])) - 0.055f;
        }
        return fArray3;
    }

    public static float[] RGBtoXYZ(float[] fArray) {
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray2[i] = fArray[i] <= 0.03928f ? fArray[i] / 12.92f : (float)Math.exp(2.4 * Math.log(((double)fArray[i] + 0.055) / 1.055));
        }
        fArray3[0] = (float)(0.436063750222 * (double)fArray2[0] + 0.385149601465 * (double)fArray2[1] + 0.143086418888 * (double)fArray2[2]);
        fArray3[1] = (float)(0.222450894035 * (double)fArray2[0] + 0.71692584775 * (double)fArray2[1] + 0.060624511256 * (double)fArray2[2]);
        fArray3[2] = (float)(0.0138985186 * (double)fArray2[0] + 0.097079690112 * (double)fArray2[1] + 0.713996045725 * (double)fArray2[2]);
        return fArray3;
    }
}

