/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import gnu.java.awt.LineSegment;
import gnu.java.awt.Segment;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;

public class CubicSegment
extends Segment {
    public Point2D cp1;
    public Point2D cp2;

    public CubicSegment(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.P1 = new Point2D.Double(d, d2);
        this.P2 = new Point2D.Double(d7, d8);
        this.cp1 = new Point2D.Double(d3, d4);
        this.cp2 = new Point2D.Double(d5, d6);
    }

    public CubicSegment(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        this.P1 = point2D;
        this.P2 = point2D4;
        this.cp1 = point2D2;
        this.cp2 = point2D3;
    }

    public Object clone() {
        CubicSegment cubicSegment = null;
        try {
            cubicSegment = (CubicSegment)super.clone();
            cubicSegment.P1 = (Point2D)this.P1.clone();
            cubicSegment.P2 = (Point2D)this.P2.clone();
            cubicSegment.cp1 = (Point2D)this.cp1.clone();
            cubicSegment.cp2 = (Point2D)this.cp2.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError();
            internalError.initCause(cloneNotSupportedException);
            throw internalError;
        }
        return cubicSegment;
    }

    @Override
    public Segment[] getDisplacedSegments(double d) {
        Segment segment = null;
        Segment segment2 = null;
        this.radius = d;
        CubicCurve2D[] cubicCurve2DArray = new CubicCurve2D[10];
        cubicCurve2DArray[0] = new CubicCurve2D.Double(this.P1.getX(), this.P1.getY(), this.cp1.getX(), this.cp1.getY(), this.cp2.getX(), this.cp2.getY(), this.P2.getX(), this.P2.getY());
        int n = 1;
        while (n > 0) {
            Segment[] segmentArray;
            if (cubicCurve2DArray[n - 1].getFlatnessSq() <= d / 3.0 || n == 10) {
                segmentArray = new LineSegment(cubicCurve2DArray[n - 1].getP1(), cubicCurve2DArray[n - 1].getP2()).getDisplacedSegments(d);
                if (segment == null) {
                    segment = segmentArray[0];
                    segment2 = segmentArray[1];
                } else {
                    segment.add(segmentArray[0]);
                    segment2.add(segmentArray[1]);
                }
                --n;
                continue;
            }
            segmentArray = new CubicCurve2D.Double();
            CubicCurve2D.Double double_ = new CubicCurve2D.Double();
            cubicCurve2DArray[n - 1].subdivide((CubicCurve2D)segmentArray, double_);
            cubicCurve2DArray[n - 1] = double_;
            cubicCurve2DArray[n] = segmentArray;
            cubicCurve2DArray[n - 1] = double_;
            cubicCurve2DArray[n] = segmentArray;
            ++n;
        }
        return new Segment[]{segment, segment2};
    }

    @Override
    public void reverse() {
        Point2D point2D = this.P1;
        this.P1 = this.P2;
        this.P2 = point2D;
        point2D = this.cp1;
        this.cp1 = this.cp2;
        this.cp2 = point2D;
    }

    @Override
    public double[] cp1() {
        return new double[]{this.cp1.getX(), this.cp1.getY()};
    }

    @Override
    public double[] cp2() {
        return new double[]{this.cp2.getX(), this.cp2.getY()};
    }
}

