/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.server.RuntimeEndpointInfo;
import com.sun.xml.internal.ws.spi.runtime.WSConnection;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.FastInfosetUtil;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.SOAPUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPConnectionUtil {
    private static final String DEFAULT_SERVER_ERROR_ENVELOPE = "<?xml version='1.0' encoding='UTF-8'?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"><env:Body><env:Fault><faultcode>env:Server</faultcode><faultstring>Internal server error</faultstring></env:Fault></env:Body></env:Envelope>";
    private static final String DEFAULT_SERVER_ERROR_SOAP12_ENVELOPE = "<?xml version='1.0' encoding='UTF-8'?><env:Envelope xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\"><env:Body><env:Fault><env:Code><env:Value>env:Receiver</env:Value></env:Code><env:Reason><env:Text lang=\"" + Locale.getDefault().getLanguage() + "\">" + "Internal server error</env:Text></env:Reason>" + "</env:Fault>" + "</env:Body>" + "</env:Envelope>";

    public static SOAPMessage getSOAPMessage(WSConnection wSConnection, MessageInfo messageInfo, String string) {
        try {
            Object object;
            Object object2;
            Map<String, List<String>> map = wSConnection.getHeaders();
            MimeHeaders mimeHeaders = new MimeHeaders();
            if (map != null) {
                object2 = map.entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    String string2 = (String)object.getKey();
                    for (String string3 : (List)object.getValue()) {
                        try {
                            mimeHeaders.addHeader(string2, string3);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
            }
            if ((object2 = MessageInfoUtil.getRuntimeContext(messageInfo)) != null) {
                object = ((RuntimeContext)object2).getRuntimeEndpointInfo();
                if (string == null) {
                    string = ((BindingImpl)((RuntimeEndpointInfo)object).getBinding()).getBindingId();
                }
            }
            object = SOAPUtil.createMessage(mimeHeaders, wSConnection.getInput(), string);
            return object;
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    private static void send(WSConnection wSConnection, SOAPMessage sOAPMessage) {
        try {
            if (sOAPMessage.saveRequired()) {
                sOAPMessage.saveChanges();
            }
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
            Iterator iterator = mimeHeaders.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                String string = mimeHeader.getName();
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(mimeHeader.getValue());
            }
            wSConnection.setHeaders(hashMap);
            sOAPMessage.writeTo(wSConnection.getOutput());
            wSConnection.closeOutput();
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    public static void sendResponse(WSConnection wSConnection, SOAPMessage sOAPMessage) {
        SOAPConnectionUtil.send(wSConnection, sOAPMessage);
    }

    public static void sendKnownError(MessageInfo messageInfo, int n) {
        WSConnection wSConnection = messageInfo.getConnection();
        SOAPConnectionUtil.setStatus(wSConnection, n);
        wSConnection.getOutput();
        wSConnection.closeOutput();
    }

    public static void sendResponseOneway(MessageInfo messageInfo) {
        WSConnection wSConnection = messageInfo.getConnection();
        SOAPConnectionUtil.setStatus(wSConnection, 202);
        wSConnection.getOutput();
        if (messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation") == "optimistic") {
            List<String> list = null;
            List<String> list2 = null;
            Map<String, List<String>> map = wSConnection.getHeaders();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                if (entry.getKey().equalsIgnoreCase("content-type")) {
                    list2 = entry.getValue();
                    continue;
                }
                if (!entry.getKey().equalsIgnoreCase("accept")) continue;
                list = entry.getValue();
            }
            assert (list2 != null && list != null);
            list2.set(0, FastInfosetUtil.getFastInfosetFromAccept(list));
        }
        wSConnection.closeOutput();
    }

    public static void sendResponseError(WSConnection wSConnection, String string) {
        try {
            SOAPMessage sOAPMessage = SOAPUtil.createMessage(string);
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayBuffer, "UTF-8");
            if (string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                outputStreamWriter.write(DEFAULT_SERVER_ERROR_SOAP12_ENVELOPE);
            } else {
                outputStreamWriter.write(DEFAULT_SERVER_ERROR_ENVELOPE);
            }
            ((Writer)outputStreamWriter).close();
            sOAPMessage.getSOAPPart().setContent(new StreamSource(byteArrayBuffer.newInputStream()));
            SOAPConnectionUtil.setStatus(wSConnection, 500);
            SOAPConnectionUtil.send(wSConnection, sOAPMessage);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    public static Map<String, List<String>> getHeaders(WSConnection wSConnection) {
        return wSConnection.getHeaders();
    }

    public static void setHeaders(WSConnection wSConnection, Map<String, List<String>> map) {
        wSConnection.setHeaders(map);
    }

    public static void setStatus(WSConnection wSConnection, int n) {
        wSConnection.setStatus(n);
    }
}

