/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.IPAcl.SnmpAcl;
import com.sun.jmx.snmp.InetAddressAcl;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpIpAddress;
import com.sun.jmx.snmp.SnmpMessage;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpParameters;
import com.sun.jmx.snmp.SnmpPduFactory;
import com.sun.jmx.snmp.SnmpPduFactoryBER;
import com.sun.jmx.snmp.SnmpPduPacket;
import com.sun.jmx.snmp.SnmpPduRequest;
import com.sun.jmx.snmp.SnmpPduTrap;
import com.sun.jmx.snmp.SnmpPeer;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpTimeticks;
import com.sun.jmx.snmp.SnmpTooBigException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.SnmpVarBindList;
import com.sun.jmx.snmp.agent.SnmpErrorHandlerAgent;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibHandler;
import com.sun.jmx.snmp.agent.SnmpUserDataFactory;
import com.sun.jmx.snmp.daemon.CommunicationException;
import com.sun.jmx.snmp.daemon.CommunicatorServer;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServerMBean;
import com.sun.jmx.snmp.daemon.SnmpInformHandler;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpMibTree;
import com.sun.jmx.snmp.daemon.SnmpRequestHandler;
import com.sun.jmx.snmp.daemon.SnmpSession;
import com.sun.jmx.snmp.daemon.SnmpSubRequestHandler;
import com.sun.jmx.snmp.tasks.ThreadService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SnmpAdaptorServer
extends CommunicatorServer
implements SnmpAdaptorServerMBean,
MBeanRegistration,
SnmpDefinitions,
SnmpMibHandler {
    private int trapPort = 162;
    private int informPort = 162;
    InetAddress address = null;
    private Object ipacl = null;
    private SnmpPduFactory pduFactory = null;
    private SnmpUserDataFactory userDataFactory = null;
    private boolean authRespEnabled = true;
    private boolean authTrapEnabled = true;
    private SnmpOid enterpriseOid = new SnmpOid("1.3.6.1.4.1.42");
    int bufferSize = 1024;
    private transient long startUpTime = 0L;
    private transient DatagramSocket socket = null;
    transient DatagramSocket trapSocket = null;
    private transient SnmpSession informSession = null;
    private transient DatagramPacket packet = null;
    transient Vector<SnmpMibAgent> mibs = new Vector();
    private transient SnmpMibTree root;
    private transient boolean useAcl = true;
    private int maxTries = 3;
    private int timeout = 3000;
    int snmpOutTraps = 0;
    private int snmpOutGetResponses = 0;
    private int snmpOutGenErrs = 0;
    private int snmpOutBadValues = 0;
    private int snmpOutNoSuchNames = 0;
    private int snmpOutTooBigs = 0;
    int snmpOutPkts = 0;
    private int snmpInASNParseErrs = 0;
    private int snmpInBadCommunityUses = 0;
    private int snmpInBadCommunityNames = 0;
    private int snmpInBadVersions = 0;
    private int snmpInGetRequests = 0;
    private int snmpInGetNexts = 0;
    private int snmpInSetRequests = 0;
    private int snmpInPkts = 0;
    private int snmpInTotalReqVars = 0;
    private int snmpInTotalSetVars = 0;
    private int snmpSilentDrops = 0;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    static final SnmpOid sysUpTimeOid = new SnmpOid("1.3.6.1.2.1.1.3.0");
    static final SnmpOid snmpTrapOidOid = new SnmpOid("1.3.6.1.6.3.1.1.4.1.0");
    private ThreadService threadService;
    private static int threadNumber = 6;

    public SnmpAdaptorServer() {
        this(true, null, 161, null);
    }

    public SnmpAdaptorServer(int n) {
        this(true, null, n, null);
    }

    public SnmpAdaptorServer(InetAddressAcl inetAddressAcl) {
        this(false, inetAddressAcl, 161, null);
    }

    public SnmpAdaptorServer(InetAddress inetAddress) {
        this(true, null, 161, inetAddress);
    }

    public SnmpAdaptorServer(InetAddressAcl inetAddressAcl, int n) {
        this(false, inetAddressAcl, n, null);
    }

    public SnmpAdaptorServer(int n, InetAddress inetAddress) {
        this(true, null, n, inetAddress);
    }

    public SnmpAdaptorServer(InetAddressAcl inetAddressAcl, InetAddress inetAddress) {
        this(false, inetAddressAcl, 161, inetAddress);
    }

    public SnmpAdaptorServer(InetAddressAcl inetAddressAcl, int n, InetAddress inetAddress) {
        this(false, inetAddressAcl, n, inetAddress);
    }

    public SnmpAdaptorServer(boolean bl, int n, InetAddress inetAddress) {
        this(bl, null, n, inetAddress);
    }

    private SnmpAdaptorServer(boolean bl, InetAddressAcl inetAddressAcl, int n, InetAddress inetAddress) {
        super(4);
        if (inetAddressAcl == null && bl) {
            try {
                inetAddressAcl = new SnmpAcl("SNMP protocol adaptor IP ACL");
            }
            catch (UnknownHostException unknownHostException) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "constructor", "UnknowHostException when creating ACL", unknownHostException);
                }
            }
        } else {
            this.useAcl = inetAddressAcl != null || bl;
        }
        this.init(inetAddressAcl, n, inetAddress);
    }

    public int getServedClientCount() {
        return super.getServedClientCount();
    }

    public int getActiveClientCount() {
        return super.getActiveClientCount();
    }

    public int getMaxActiveClientCount() {
        return super.getMaxActiveClientCount();
    }

    public void setMaxActiveClientCount(int n) throws IllegalStateException {
        super.setMaxActiveClientCount(n);
    }

    public InetAddressAcl getInetAddressAcl() {
        return (InetAddressAcl)this.ipacl;
    }

    public Integer getTrapPort() {
        return new Integer(this.trapPort);
    }

    public void setTrapPort(Integer n) {
        this.setTrapPort((int)n);
    }

    public void setTrapPort(int n) {
        int n2 = n;
        if (n2 < 0) {
            throw new IllegalArgumentException("Trap port cannot be a negative value");
        }
        this.trapPort = n2;
    }

    public int getInformPort() {
        return this.informPort;
    }

    public void setInformPort(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Inform request port cannot be a negative value");
        }
        this.informPort = n;
    }

    public String getProtocol() {
        return "snmp";
    }

    public Integer getBufferSize() {
        return new Integer(this.bufferSize);
    }

    public void setBufferSize(Integer n) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.bufferSize = n;
    }

    public final int getMaxTries() {
        return this.maxTries;
    }

    public final synchronized void setMaxTries(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.maxTries = n;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final synchronized void setTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.timeout = n;
    }

    public SnmpPduFactory getPduFactory() {
        return this.pduFactory;
    }

    public void setPduFactory(SnmpPduFactory snmpPduFactory) {
        this.pduFactory = snmpPduFactory == null ? new SnmpPduFactoryBER() : snmpPduFactory;
    }

    public void setUserDataFactory(SnmpUserDataFactory snmpUserDataFactory) {
        this.userDataFactory = snmpUserDataFactory;
    }

    public SnmpUserDataFactory getUserDataFactory() {
        return this.userDataFactory;
    }

    public boolean getAuthTrapEnabled() {
        return this.authTrapEnabled;
    }

    public void setAuthTrapEnabled(boolean bl) {
        this.authTrapEnabled = bl;
    }

    public boolean getAuthRespEnabled() {
        return this.authRespEnabled;
    }

    public void setAuthRespEnabled(boolean bl) {
        this.authRespEnabled = bl;
    }

    public String getEnterpriseOid() {
        return this.enterpriseOid.toString();
    }

    public void setEnterpriseOid(String string) throws IllegalArgumentException {
        this.enterpriseOid = new SnmpOid(string);
    }

    public String[] getMibs() {
        String[] stringArray = new String[this.mibs.size()];
        int n = 0;
        Enumeration<SnmpMibAgent> enumeration = this.mibs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpMibAgent snmpMibAgent = enumeration.nextElement();
            stringArray[n++] = snmpMibAgent.getMibName();
        }
        return stringArray;
    }

    public Long getSnmpOutTraps() {
        return new Long(this.snmpOutTraps);
    }

    public Long getSnmpOutGetResponses() {
        return new Long(this.snmpOutGetResponses);
    }

    public Long getSnmpOutGenErrs() {
        return new Long(this.snmpOutGenErrs);
    }

    public Long getSnmpOutBadValues() {
        return new Long(this.snmpOutBadValues);
    }

    public Long getSnmpOutNoSuchNames() {
        return new Long(this.snmpOutNoSuchNames);
    }

    public Long getSnmpOutTooBigs() {
        return new Long(this.snmpOutTooBigs);
    }

    public Long getSnmpInASNParseErrs() {
        return new Long(this.snmpInASNParseErrs);
    }

    public Long getSnmpInBadCommunityUses() {
        return new Long(this.snmpInBadCommunityUses);
    }

    public Long getSnmpInBadCommunityNames() {
        return new Long(this.snmpInBadCommunityNames);
    }

    public Long getSnmpInBadVersions() {
        return new Long(this.snmpInBadVersions);
    }

    public Long getSnmpOutPkts() {
        return new Long(this.snmpOutPkts);
    }

    public Long getSnmpInPkts() {
        return new Long(this.snmpInPkts);
    }

    public Long getSnmpInGetRequests() {
        return new Long(this.snmpInGetRequests);
    }

    public Long getSnmpInGetNexts() {
        return new Long(this.snmpInGetNexts);
    }

    public Long getSnmpInSetRequests() {
        return new Long(this.snmpInSetRequests);
    }

    public Long getSnmpInTotalSetVars() {
        return new Long(this.snmpInTotalSetVars);
    }

    public Long getSnmpInTotalReqVars() {
        return new Long(this.snmpInTotalReqVars);
    }

    public Long getSnmpSilentDrops() {
        return new Long(this.snmpSilentDrops);
    }

    public Long getSnmpProxyDrops() {
        return new Long(0L);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            objectName = new ObjectName(mBeanServer.getDefaultDomain() + ":" + "name=SnmpAdaptorServer");
        }
        return super.preRegister(mBeanServer, objectName);
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    public void postDeregister() {
        super.postDeregister();
    }

    public SnmpMibHandler addMib(SnmpMibAgent snmpMibAgent) throws IllegalArgumentException {
        if (snmpMibAgent == null) {
            throw new IllegalArgumentException();
        }
        if (!this.mibs.contains(snmpMibAgent)) {
            this.mibs.addElement(snmpMibAgent);
        }
        this.root.register(snmpMibAgent);
        return this;
    }

    public SnmpMibHandler addMib(SnmpMibAgent snmpMibAgent, SnmpOid[] snmpOidArray) throws IllegalArgumentException {
        if (snmpMibAgent == null) {
            throw new IllegalArgumentException();
        }
        if (snmpOidArray == null) {
            return this.addMib(snmpMibAgent);
        }
        if (!this.mibs.contains(snmpMibAgent)) {
            this.mibs.addElement(snmpMibAgent);
        }
        for (int i = 0; i < snmpOidArray.length; ++i) {
            this.root.register(snmpMibAgent, snmpOidArray[i].longValue());
        }
        return this;
    }

    public SnmpMibHandler addMib(SnmpMibAgent snmpMibAgent, String string) throws IllegalArgumentException {
        return this.addMib(snmpMibAgent);
    }

    public SnmpMibHandler addMib(SnmpMibAgent snmpMibAgent, String string, SnmpOid[] snmpOidArray) throws IllegalArgumentException {
        return this.addMib(snmpMibAgent, snmpOidArray);
    }

    public boolean removeMib(SnmpMibAgent snmpMibAgent, String string) {
        return this.removeMib(snmpMibAgent);
    }

    public boolean removeMib(SnmpMibAgent snmpMibAgent) {
        this.root.unregister(snmpMibAgent);
        return this.mibs.removeElement(snmpMibAgent);
    }

    public boolean removeMib(SnmpMibAgent snmpMibAgent, SnmpOid[] snmpOidArray) {
        this.root.unregister(snmpMibAgent, snmpOidArray);
        return this.mibs.removeElement(snmpMibAgent);
    }

    public boolean removeMib(SnmpMibAgent snmpMibAgent, String string, SnmpOid[] snmpOidArray) {
        return this.removeMib(snmpMibAgent, snmpOidArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBind() throws CommunicationException, InterruptedException {
        try {
            SnmpAdaptorServer snmpAdaptorServer = this;
            synchronized (snmpAdaptorServer) {
                this.socket = new DatagramSocket(this.port, this.address);
            }
            this.dbgTag = this.makeDebugTag();
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "doBind", "cannot bind on port " + this.port);
            }
            throw new CommunicationException(socketException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        SnmpAdaptorServer snmpAdaptorServer = this;
        synchronized (snmpAdaptorServer) {
            if (this.socket != null) {
                return this.socket.getLocalPort();
            }
        }
        return super.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnbind() throws CommunicationException, InterruptedException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "doUnbind", "Finally close the socket");
        }
        SnmpAdaptorServer snmpAdaptorServer = this;
        synchronized (snmpAdaptorServer) {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        this.closeTrapSocketIfNeeded();
        this.closeInformSocketIfNeeded();
    }

    void createSnmpRequestHandler(SnmpAdaptorServer snmpAdaptorServer, int n, DatagramSocket datagramSocket, DatagramPacket datagramPacket, SnmpMibTree snmpMibTree, Vector vector, Object object, SnmpPduFactory snmpPduFactory, SnmpUserDataFactory snmpUserDataFactory, MBeanServer mBeanServer, ObjectName objectName) {
        SnmpRequestHandler snmpRequestHandler = new SnmpRequestHandler(this, n, datagramSocket, datagramPacket, snmpMibTree, vector, object, snmpPduFactory, snmpUserDataFactory, mBeanServer, objectName);
        this.threadService.submitTask(snmpRequestHandler);
    }

    protected void doReceive() throws CommunicationException, InterruptedException {
        try {
            this.packet = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
            this.socket.receive(this.packet);
            int n = this.getState();
            if (n != 0) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "doReceive", "received a message but state not online, returning.");
                }
                return;
            }
            this.createSnmpRequestHandler(this, this.servedClientCount, this.socket, this.packet, this.root, this.mibs, this.ipacl, this.pduFactory, this.userDataFactory, this.topMBS, this.objectName);
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.toString());
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "doReceive", "received a message");
        }
    }

    protected void doError(Exception exception) throws CommunicationException {
    }

    protected void doProcess() throws CommunicationException, InterruptedException {
    }

    protected int getBindTries() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block7: {
            int n = this.getPort();
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "stop", "Stopping: using port " + n);
            }
            if (this.state == 0 || this.state == 3) {
                super.stop();
                try {
                    DatagramSocket datagramSocket = new DatagramSocket(0);
                    try {
                        byte[] byArray = new byte[1];
                        DatagramPacket datagramPacket = this.address != null ? new DatagramPacket(byArray, 1, this.address, n) : new DatagramPacket(byArray, 1, InetAddress.getLocalHost(), n);
                        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "stop", "Sending: using port " + n);
                        }
                        datagramSocket.send(datagramPacket);
                        Object var6_6 = null;
                        datagramSocket.close();
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        datagramSocket.close();
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block7;
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "stop", "Got unexpected Throwable", throwable);
                }
            }
        }
    }

    public void snmpV1Trap(int n, int n2, SnmpVarBindList snmpVarBindList) throws IOException, SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV1Trap", "generic=" + n + ", specific=" + n2);
        }
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.address = null;
        snmpPduTrap.port = this.trapPort;
        snmpPduTrap.type = 5;
        snmpPduTrap.version = 330;
        snmpPduTrap.community = null;
        snmpPduTrap.enterprise = this.enterpriseOid;
        snmpPduTrap.genericTrap = n;
        snmpPduTrap.specificTrap = n2;
        snmpPduTrap.timeStamp = this.getSysUpTime();
        if (snmpVarBindList != null) {
            snmpPduTrap.varBindList = new SnmpVarBind[snmpVarBindList.size()];
            snmpVarBindList.copyInto(snmpPduTrap.varBindList);
        } else {
            snmpPduTrap.varBindList = null;
        }
        try {
            snmpPduTrap.agentAddr = this.address != null ? this.handleMultipleIpVersion(this.address.getAddress()) : this.handleMultipleIpVersion(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            byte[] byArray = new byte[4];
            snmpPduTrap.agentAddr = this.handleMultipleIpVersion(byArray);
        }
        this.sendTrapPdu(snmpPduTrap);
    }

    private SnmpIpAddress handleMultipleIpVersion(byte[] byArray) {
        if (byArray.length == 4) {
            return new SnmpIpAddress(byArray);
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "handleMultipleIPVersion", "Not an IPv4 address, return null");
        }
        return null;
    }

    public void snmpV1Trap(InetAddress inetAddress, String string, int n, int n2, SnmpVarBindList snmpVarBindList) throws IOException, SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV1Trap", "generic=" + n + ", specific=" + n2);
        }
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.address = null;
        snmpPduTrap.port = this.trapPort;
        snmpPduTrap.type = 5;
        snmpPduTrap.version = 330;
        snmpPduTrap.community = (byte[])(string != null ? string.getBytes() : null);
        snmpPduTrap.enterprise = this.enterpriseOid;
        snmpPduTrap.genericTrap = n;
        snmpPduTrap.specificTrap = n2;
        snmpPduTrap.timeStamp = this.getSysUpTime();
        if (snmpVarBindList != null) {
            snmpPduTrap.varBindList = new SnmpVarBind[snmpVarBindList.size()];
            snmpVarBindList.copyInto(snmpPduTrap.varBindList);
        } else {
            snmpPduTrap.varBindList = null;
        }
        try {
            snmpPduTrap.agentAddr = this.address != null ? this.handleMultipleIpVersion(this.address.getAddress()) : this.handleMultipleIpVersion(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            byte[] byArray = new byte[4];
            snmpPduTrap.agentAddr = this.handleMultipleIpVersion(byArray);
        }
        if (inetAddress != null) {
            this.sendTrapPdu(inetAddress, snmpPduTrap);
        } else {
            this.sendTrapPdu(snmpPduTrap);
        }
    }

    public void snmpV1Trap(InetAddress inetAddress, SnmpIpAddress snmpIpAddress, String string, SnmpOid snmpOid, int n, int n2, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        this.snmpV1Trap(inetAddress, this.trapPort, snmpIpAddress, string, snmpOid, n, n2, snmpVarBindList, snmpTimeticks);
    }

    public void snmpV1Trap(SnmpPeer snmpPeer, SnmpIpAddress snmpIpAddress, SnmpOid snmpOid, int n, int n2, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        SnmpParameters snmpParameters = snmpPeer.getParams();
        this.snmpV1Trap(snmpPeer.getDestAddr(), snmpPeer.getDestPort(), snmpIpAddress, snmpParameters.getRdCommunity(), snmpOid, n, n2, snmpVarBindList, snmpTimeticks);
    }

    private void snmpV1Trap(InetAddress inetAddress, int n, SnmpIpAddress snmpIpAddress, String string, SnmpOid snmpOid, int n2, int n3, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV1Trap", "generic=" + n2 + ", specific=" + n3);
        }
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.address = null;
        snmpPduTrap.port = n;
        snmpPduTrap.type = 5;
        snmpPduTrap.version = 330;
        snmpPduTrap.community = (byte[])(string != null ? string.getBytes() : null);
        snmpPduTrap.enterprise = snmpOid != null ? snmpOid : this.enterpriseOid;
        snmpPduTrap.genericTrap = n2;
        snmpPduTrap.specificTrap = n3;
        snmpPduTrap.timeStamp = snmpTimeticks != null ? (long)snmpTimeticks.longValue() : this.getSysUpTime();
        if (snmpVarBindList != null) {
            snmpPduTrap.varBindList = new SnmpVarBind[snmpVarBindList.size()];
            snmpVarBindList.copyInto(snmpPduTrap.varBindList);
        } else {
            snmpPduTrap.varBindList = null;
        }
        if (snmpIpAddress == null) {
            try {
                InetAddress inetAddress2 = this.address != null ? this.address : InetAddress.getLocalHost();
                snmpIpAddress = this.handleMultipleIpVersion(inetAddress2.getAddress());
            }
            catch (UnknownHostException unknownHostException) {
                byte[] byArray = new byte[4];
                snmpIpAddress = this.handleMultipleIpVersion(byArray);
            }
        }
        snmpPduTrap.agentAddr = snmpIpAddress;
        if (inetAddress != null) {
            this.sendTrapPdu(inetAddress, snmpPduTrap);
        } else {
            this.sendTrapPdu(snmpPduTrap);
        }
    }

    public void snmpV2Trap(SnmpPeer snmpPeer, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        SnmpParameters snmpParameters = snmpPeer.getParams();
        this.snmpV2Trap(snmpPeer.getDestAddr(), snmpPeer.getDestPort(), snmpParameters.getRdCommunity(), snmpOid, snmpVarBindList, snmpTimeticks);
    }

    public void snmpV2Trap(SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IOException, SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV2Trap", "trapOid=" + snmpOid);
        }
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.address = null;
        snmpPduRequest.port = this.trapPort;
        snmpPduRequest.type = 9;
        snmpPduRequest.version = 220;
        snmpPduRequest.community = null;
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList != null ? snmpVarBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        snmpVarBindList2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        snmpVarBindList2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        snmpPduRequest.varBindList = new SnmpVarBind[snmpVarBindList2.size()];
        snmpVarBindList2.copyInto(snmpPduRequest.varBindList);
        this.sendTrapPdu(snmpPduRequest);
    }

    public void snmpV2Trap(InetAddress inetAddress, String string, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IOException, SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV2Trap", "trapOid=" + snmpOid);
        }
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.address = null;
        snmpPduRequest.port = this.trapPort;
        snmpPduRequest.type = 9;
        snmpPduRequest.version = 220;
        snmpPduRequest.community = (byte[])(string != null ? string.getBytes() : null);
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList != null ? snmpVarBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        snmpVarBindList2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        snmpVarBindList2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        snmpPduRequest.varBindList = new SnmpVarBind[snmpVarBindList2.size()];
        snmpVarBindList2.copyInto(snmpPduRequest.varBindList);
        if (inetAddress != null) {
            this.sendTrapPdu(inetAddress, snmpPduRequest);
        } else {
            this.sendTrapPdu(snmpPduRequest);
        }
    }

    public void snmpV2Trap(InetAddress inetAddress, String string, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        this.snmpV2Trap(inetAddress, this.trapPort, string, snmpOid, snmpVarBindList, snmpTimeticks);
    }

    private void snmpV2Trap(InetAddress inetAddress, int n, String string, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        Serializable serializable;
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            serializable = new StringBuilder().append("trapOid=").append(snmpOid).append("\ncommunity=").append(string).append("\naddr=").append(inetAddress).append("\nvarBindList=").append(snmpVarBindList).append("\ntime=").append(snmpTimeticks).append("\ntrapPort=").append(n);
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV2Trap", ((StringBuilder)serializable).toString());
        }
        serializable = new SnmpPduRequest();
        ((SnmpPduRequest)serializable).address = null;
        ((SnmpPduRequest)serializable).port = n;
        ((SnmpPduRequest)serializable).type = 9;
        ((SnmpPduRequest)serializable).version = 220;
        ((SnmpPduRequest)serializable).community = (byte[])(string != null ? string.getBytes() : null);
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList != null ? snmpVarBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks snmpTimeticks2 = null;
        snmpTimeticks2 = snmpTimeticks != null ? snmpTimeticks : new SnmpTimeticks(this.getSysUpTime());
        snmpVarBindList2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        snmpVarBindList2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks2), 0);
        ((SnmpPduRequest)serializable).varBindList = new SnmpVarBind[snmpVarBindList2.size()];
        snmpVarBindList2.copyInto(((SnmpPduRequest)serializable).varBindList);
        if (inetAddress != null) {
            this.sendTrapPdu(inetAddress, (SnmpPduPacket)serializable);
        } else {
            this.sendTrapPdu((SnmpPduPacket)serializable);
        }
    }

    public void snmpPduTrap(InetAddress inetAddress, SnmpPduPacket snmpPduPacket) throws IOException, SnmpStatusException {
        if (inetAddress != null) {
            this.sendTrapPdu(inetAddress, snmpPduPacket);
        } else {
            this.sendTrapPdu(snmpPduPacket);
        }
    }

    public void snmpPduTrap(SnmpPeer snmpPeer, SnmpPduPacket snmpPduPacket) throws IOException, SnmpStatusException {
        if (snmpPeer != null) {
            snmpPduPacket.port = snmpPeer.getDestPort();
            this.sendTrapPdu(snmpPeer.getDestAddr(), snmpPduPacket);
        } else {
            snmpPduPacket.port = this.getTrapPort();
            this.sendTrapPdu(snmpPduPacket);
        }
    }

    private void sendTrapPdu(SnmpPduPacket snmpPduPacket) throws SnmpStatusException, IOException {
        block14: {
            SnmpMessage snmpMessage = null;
            try {
                snmpMessage = (SnmpMessage)this.pduFactory.encodeSnmpPdu(snmpPduPacket, this.bufferSize);
                if (snmpMessage == null) {
                    throw new SnmpStatusException(70);
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent to anyone");
                }
                throw new SnmpStatusException(660);
            }
            int n = 0;
            this.openTrapSocketIfNeeded();
            if (this.ipacl != null) {
                Enumeration enumeration = ((InetAddressAcl)this.ipacl).getTrapDestinations();
                while (enumeration.hasMoreElements()) {
                    snmpMessage.address = (InetAddress)enumeration.nextElement();
                    Enumeration enumeration2 = ((InetAddressAcl)this.ipacl).getTrapCommunities(snmpMessage.address);
                    while (enumeration2.hasMoreElements()) {
                        snmpMessage.community = ((String)enumeration2.nextElement()).getBytes();
                        try {
                            this.sendTrapMessage(snmpMessage);
                            ++n;
                        }
                        catch (SnmpTooBigException snmpTooBigException) {
                            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent to " + snmpMessage.address);
                        }
                    }
                }
            }
            if (n == 0) {
                try {
                    snmpMessage.address = InetAddress.getLocalHost();
                    this.sendTrapMessage(snmpMessage);
                }
                catch (SnmpTooBigException snmpTooBigException) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent.");
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block14;
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent.");
                }
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    private void sendTrapPdu(InetAddress inetAddress, SnmpPduPacket snmpPduPacket) throws SnmpStatusException, IOException {
        block7: {
            SnmpMessage snmpMessage = null;
            try {
                snmpMessage = (SnmpMessage)this.pduFactory.encodeSnmpPdu(snmpPduPacket, this.bufferSize);
                if (snmpMessage == null) {
                    throw new SnmpStatusException(70);
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent to the specified host.");
                }
                throw new SnmpStatusException(660);
            }
            this.openTrapSocketIfNeeded();
            if (inetAddress != null) {
                snmpMessage.address = inetAddress;
                try {
                    this.sendTrapMessage(snmpMessage);
                }
                catch (SnmpTooBigException snmpTooBigException) {
                    if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block7;
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent to " + snmpMessage.address);
                }
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    private void sendTrapMessage(SnmpMessage snmpMessage) throws IOException, SnmpTooBigException {
        byte[] byArray = new byte[this.bufferSize];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        int n = snmpMessage.encodeMessage(byArray);
        datagramPacket.setLength(n);
        datagramPacket.setAddress(snmpMessage.address);
        datagramPacket.setPort(snmpMessage.port);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "sendTrapMessage", "sending trap to " + snmpMessage.address + ":" + snmpMessage.port);
        }
        this.trapSocket.send(datagramPacket);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "sendTrapMessage", "sent to " + snmpMessage.address + ":" + snmpMessage.port);
        }
        ++this.snmpOutTraps;
        ++this.snmpOutPkts;
    }

    synchronized void openTrapSocketIfNeeded() throws SocketException {
        if (this.trapSocket == null) {
            this.trapSocket = new DatagramSocket(0, this.address);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "openTrapSocketIfNeeded", "using port " + this.trapSocket.getLocalPort() + " to send traps");
            }
        }
    }

    synchronized void closeTrapSocketIfNeeded() {
        if (this.trapSocket != null && this.state != 0) {
            this.trapSocket.close();
            this.trapSocket = null;
        }
    }

    public Vector snmpInformRequest(SnmpInformHandler snmpInformHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpInformRequest", "trapOid=" + snmpOid);
        }
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList != null ? snmpVarBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        snmpVarBindList2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        snmpVarBindList2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        this.openInformSocketIfNeeded();
        Vector<SnmpInformRequest> vector = new Vector<SnmpInformRequest>();
        InetAddress inetAddress = null;
        String string = null;
        if (this.ipacl != null) {
            Enumeration enumeration = ((InetAddressAcl)this.ipacl).getInformDestinations();
            while (enumeration.hasMoreElements()) {
                inetAddress = (InetAddress)enumeration.nextElement();
                Enumeration enumeration2 = ((InetAddressAcl)this.ipacl).getInformCommunities(inetAddress);
                while (enumeration2.hasMoreElements()) {
                    string = (String)enumeration2.nextElement();
                    vector.addElement(this.informSession.makeAsyncRequest(inetAddress, string, snmpInformHandler, snmpVarBindList2, this.getInformPort()));
                }
            }
        }
        return vector;
    }

    public SnmpInformRequest snmpInformRequest(InetAddress inetAddress, String string, SnmpInformHandler snmpInformHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IOException, SnmpStatusException {
        return this.snmpInformRequest(inetAddress, this.getInformPort(), string, snmpInformHandler, snmpOid, snmpVarBindList);
    }

    public SnmpInformRequest snmpInformRequest(SnmpPeer snmpPeer, SnmpInformHandler snmpInformHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IOException, SnmpStatusException {
        SnmpParameters snmpParameters = snmpPeer.getParams();
        return this.snmpInformRequest(snmpPeer.getDestAddr(), snmpPeer.getDestPort(), snmpParameters.getInformCommunity(), snmpInformHandler, snmpOid, snmpVarBindList);
    }

    public static final int mapErrorStatus(int n, int n2, int n3) {
        return SnmpSubRequestHandler.mapErrorStatus(n, n2, n3);
    }

    private SnmpInformRequest snmpInformRequest(InetAddress inetAddress, int n, String string, SnmpInformHandler snmpInformHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpInformRequest", "trapOid=" + snmpOid);
        }
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList != null ? snmpVarBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        snmpVarBindList2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        snmpVarBindList2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        this.openInformSocketIfNeeded();
        return this.informSession.makeAsyncRequest(inetAddress, string, snmpInformHandler, snmpVarBindList2, n);
    }

    synchronized void openInformSocketIfNeeded() throws SocketException {
        if (this.informSession == null) {
            this.informSession = new SnmpSession(this);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "openInformSocketIfNeeded", "to send inform requests and receive inform responses");
            }
        }
    }

    synchronized void closeInformSocketIfNeeded() {
        if (this.informSession != null && this.state != 0) {
            this.informSession.destroySession();
            this.informSession = null;
        }
    }

    InetAddress getAddress() {
        return this.address;
    }

    protected void finalize() {
        block3: {
            try {
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
                this.threadService.terminate();
            }
            catch (Exception exception) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) break block3;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "finalize", "Exception in finalizer", exception);
            }
        }
    }

    String makeDebugTag() {
        return "SnmpAdaptorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    void updateRequestCounters(int n) {
        switch (n) {
            case 1: {
                ++this.snmpInGetRequests;
                break;
            }
            case 2: {
                ++this.snmpInGetNexts;
                break;
            }
            case 4: {
                ++this.snmpInSetRequests;
                break;
            }
        }
        ++this.snmpInPkts;
    }

    void updateErrorCounters(int n) {
        switch (n) {
            case 1230: {
                ++this.snmpOutGetResponses;
                break;
            }
            case 0: {
                ++this.snmpOutGenErrs;
                break;
            }
            case 40: {
                ++this.snmpOutBadValues;
                break;
            }
            case 10: {
                ++this.snmpOutNoSuchNames;
                break;
            }
            case 660: {
                ++this.snmpOutTooBigs;
                break;
            }
        }
        ++this.snmpOutPkts;
    }

    void updateVarCounters(int n, int n2) {
        switch (n) {
            case 1: 
            case 2: 
            case 8: {
                this.snmpInTotalReqVars += n2;
                break;
            }
            case 4: {
                this.snmpInTotalSetVars += n2;
            }
        }
    }

    void incSnmpInASNParseErrs(int n) {
        this.snmpInASNParseErrs += n;
    }

    void incSnmpInBadVersions(int n) {
        this.snmpInBadVersions += n;
    }

    void incSnmpInBadCommunityUses(int n) {
        this.snmpInBadCommunityUses += n;
    }

    void incSnmpInBadCommunityNames(int n) {
        this.snmpInBadCommunityNames += n;
    }

    void incSnmpSilentDrops(int n) {
        this.snmpSilentDrops += n;
    }

    long getSysUpTime() {
        return (System.currentTimeMillis() - this.startUpTime) / 10L;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.mibs = new Vector();
    }

    private void init(Object object, int n, InetAddress inetAddress) {
        this.root = new SnmpMibTree();
        this.root.setDefaultAgent(new SnmpErrorHandlerAgent());
        this.startUpTime = System.currentTimeMillis();
        this.maxActiveClientCount = 10;
        this.pduFactory = new SnmpPduFactoryBER();
        this.port = n;
        this.ipacl = object;
        this.address = inetAddress;
        if (this.ipacl == null && this.useAcl) {
            throw new IllegalArgumentException("ACL object cannot be null");
        }
        this.threadService = new ThreadService(threadNumber);
    }

    SnmpMibAgent getAgentMib(SnmpOid snmpOid) {
        return this.root.getAgentMib(snmpOid);
    }

    protected Thread createMainThread() {
        Thread thread = super.createMainThread();
        thread.setDaemon(true);
        return thread;
    }

    static {
        String string = System.getProperty("com.sun.jmx.snmp.threadnumber");
        if (string != null) {
            try {
                threadNumber = Integer.parseInt(System.getProperty(string));
            }
            catch (Exception exception) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpAdaptorServer.class.getName(), "<static init>", "Got wrong value for com.sun.jmx.snmp.threadnumber: " + string + ". Use the default value: " + threadNumber);
            }
        }
    }
}

