/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.EnvHelp;
import java.beans.ConstructorProperties;
import java.io.InvalidObjectException;
import java.lang.annotation.ElementType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.management.JMX;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataInvocationHandler;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeDataView;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OpenConverter {
    private final Type targetType;
    private final OpenType openType;
    private final Class openClass;
    private static final ConverterMap converterMap = new ConverterMap();
    private static final List<OpenConverter> permanentConverters = Util.newList();
    private static final String[] keyArray;
    private static final String[] keyValueArray;
    private static final Map<Type, Type> inProgress;

    private OpenConverter(Type type, OpenType openType, Class clazz) {
        this.targetType = type;
        this.openType = openType;
        this.openClass = clazz;
    }

    public final Object fromOpenValue(MXBeanLookup mXBeanLookup, Object object) throws InvalidObjectException {
        if (object == null) {
            return null;
        }
        return this.fromNonNullOpenValue(mXBeanLookup, object);
    }

    abstract Object fromNonNullOpenValue(MXBeanLookup var1, Object var2) throws InvalidObjectException;

    void checkReconstructible() throws InvalidObjectException {
    }

    final Object toOpenValue(MXBeanLookup mXBeanLookup, Object object) throws OpenDataException {
        if (object == null) {
            return null;
        }
        return this.toNonNullOpenValue(mXBeanLookup, object);
    }

    abstract Object toNonNullOpenValue(MXBeanLookup var1, Object var2) throws OpenDataException;

    boolean isIdentity() {
        return false;
    }

    final Type getTargetType() {
        return this.targetType;
    }

    final OpenType getOpenType() {
        return this.openType;
    }

    final Class getOpenClass() {
        return this.openClass;
    }

    private static synchronized OpenConverter getConverter(Type type) {
        WeakReference weakReference = (WeakReference)converterMap.get(type);
        return weakReference == null ? null : (OpenConverter)weakReference.get();
    }

    private static synchronized void putConverter(Type type, OpenConverter openConverter) {
        WeakReference<OpenConverter> weakReference = new WeakReference<OpenConverter>(openConverter);
        converterMap.put(type, weakReference);
    }

    private static synchronized void putPermanentConverter(Type type, OpenConverter openConverter) {
        OpenConverter.putConverter(type, openConverter);
        permanentConverters.add(openConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OpenConverter toConverter(Type type) throws OpenDataException {
        if (inProgress.containsKey(type)) {
            throw new OpenDataException("Recursive data structure");
        }
        OpenConverter openConverter = OpenConverter.getConverter(type);
        if (openConverter != null) {
            return openConverter;
        }
        inProgress.put(type, type);
        try {
            openConverter = OpenConverter.makeConverter(type);
            Object var3_2 = null;
            inProgress.remove(type);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            inProgress.remove(type);
            throw throwable;
        }
        OpenConverter.putConverter(type, openConverter);
        return openConverter;
    }

    private static OpenConverter makeConverter(Type type) throws OpenDataException {
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            return OpenConverter.makeArrayOrCollectionConverter(type, type2);
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isEnum()) {
                return OpenConverter.makeEnumConverter(clazz, ElementType.class);
            }
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                return OpenConverter.makeArrayOrCollectionConverter(clazz, clazz2);
            }
            if (JMX.isMXBeanInterface(clazz)) {
                return OpenConverter.makeMXBeanConverter(clazz);
            }
            return OpenConverter.makeCompositeConverter(clazz);
        }
        if (type instanceof ParameterizedType) {
            return OpenConverter.makeParameterizedConverter((ParameterizedType)type);
        }
        throw new OpenDataException("Cannot map type: " + type);
    }

    private static <T extends Enum<T>> OpenConverter makeEnumConverter(Class<?> clazz, Class<T> clazz2) {
        Class clazz3 = (Class)Util.cast(clazz);
        return new EnumConverter(clazz3);
    }

    private static OpenConverter makeArrayOrCollectionConverter(Type type, Type type2) throws OpenDataException {
        Class<?> clazz;
        OpenConverter openConverter = OpenConverter.toConverter(type2);
        OpenType openType = openConverter.getOpenType();
        ArrayType<E[]> arrayType = ArrayType.getArrayType(openType);
        Class clazz2 = openConverter.getOpenClass();
        String string = clazz2.isArray() ? "[" + clazz2.getName() : "[L" + clazz2.getName() + ";";
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw OpenConverter.openDataException("Cannot obtain array class", classNotFoundException);
        }
        if (type instanceof ParameterizedType) {
            return new CollectionConverter(type, arrayType, clazz, openConverter);
        }
        if (openConverter.isIdentity()) {
            return new IdentityConverter(type, arrayType, clazz);
        }
        return new ArrayConverter(type, arrayType, clazz, openConverter);
    }

    private static OpenConverter makeTabularConverter(Type type, boolean bl, Type type2, Type type3) throws OpenDataException {
        String string = type.toString();
        OpenConverter openConverter = OpenConverter.toConverter(type2);
        OpenConverter openConverter2 = OpenConverter.toConverter(type3);
        OpenType openType = openConverter.getOpenType();
        OpenType openType2 = openConverter2.getOpenType();
        CompositeType compositeType = new CompositeType(string, string, keyValueArray, keyValueArray, new OpenType[]{openType, openType2});
        TabularType tabularType = new TabularType(string, string, compositeType, keyArray);
        return new TabularConverter(type, bl, tabularType, openConverter, openConverter2);
    }

    private static OpenConverter makeParameterizedConverter(ParameterizedType parameterizedType) throws OpenDataException {
        Type type = parameterizedType.getRawType();
        if (type instanceof Class) {
            boolean bl;
            Class clazz = (Class)type;
            if (clazz == List.class || clazz == Set.class || clazz == SortedSet.class) {
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                assert (typeArray.length == 1);
                if (clazz == SortedSet.class) {
                    OpenConverter.mustBeComparable(clazz, typeArray[0]);
                }
                return OpenConverter.makeArrayOrCollectionConverter(parameterizedType, typeArray[0]);
            }
            boolean bl2 = bl = clazz == SortedMap.class;
            if (clazz == Map.class || bl) {
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                assert (typeArray.length == 2);
                if (bl) {
                    OpenConverter.mustBeComparable(clazz, typeArray[0]);
                }
                return OpenConverter.makeTabularConverter(parameterizedType, bl, typeArray[0], typeArray[1]);
            }
        }
        throw new OpenDataException("Cannot convert type: " + parameterizedType);
    }

    private static OpenConverter makeMXBeanConverter(Type type) throws OpenDataException {
        return new MXBeanConverter(type);
    }

    private static OpenConverter makeCompositeConverter(Class clazz) throws OpenDataException {
        Object object;
        String[] stringArray;
        boolean bl = clazz.getName().equals("com.sun.management.GcInfo") && clazz.getClassLoader() == null;
        List<Method> list = MBeanAnalyzer.eliminateCovariantMethods(clazz.getMethods());
        SortedMap<String, Method> sortedMap = Util.newSortedMap();
        for (Method methodArray2 : list) {
            stringArray = OpenConverter.propertyName(methodArray2);
            if (stringArray == null || bl && stringArray.equals("CompositeType") || (object = sortedMap.put(OpenConverter.decapitalize((String)stringArray), methodArray2)) == null) continue;
            String n2 = "Class " + clazz.getName() + " has method name clash: " + ((Method)object).getName() + ", " + methodArray2.getName();
            throw new OpenDataException(n2);
        }
        int n = sortedMap.size();
        if (n == 0) {
            throw new OpenDataException("Can't map " + clazz.getName() + " to an open data type");
        }
        Method[] methodArray = new Method[n];
        stringArray = new String[n];
        object = new OpenType[n];
        int n2 = 0;
        for (Map.Entry entry : sortedMap.entrySet()) {
            Method method;
            stringArray[n2] = (String)entry.getKey();
            methodArray[n2] = method = (Method)entry.getValue();
            Type type = method.getGenericReturnType();
            object[n2] = OpenConverter.toConverter(type).getOpenType();
            ++n2;
        }
        CompositeType compositeType = new CompositeType(clazz.getName(), clazz.getName(), stringArray, stringArray, (OpenType<?>[])object);
        return new CompositeConverter(clazz, compositeType, stringArray, methodArray);
    }

    static InvalidObjectException invalidObjectException(String string, Throwable throwable) {
        return EnvHelp.initCause(new InvalidObjectException(string), throwable);
    }

    static InvalidObjectException invalidObjectException(Throwable throwable) {
        return OpenConverter.invalidObjectException(throwable.getMessage(), throwable);
    }

    static OpenDataException openDataException(String string, Throwable throwable) {
        return EnvHelp.initCause(new OpenDataException(string), throwable);
    }

    static OpenDataException openDataException(Throwable throwable) {
        return OpenConverter.openDataException(throwable.getMessage(), throwable);
    }

    static void mustBeComparable(Class clazz, Type type) throws OpenDataException {
        if (!(type instanceof Class) || !Comparable.class.isAssignableFrom((Class)type)) {
            String string = "Parameter class " + type + " of " + clazz.getName() + " does not implement " + Comparable.class.getName();
            throw new OpenDataException(string);
        }
    }

    public static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = Character.offsetByCodePoints(string, 0, 1);
        if (n < string.length() && Character.isUpperCase(string.codePointAt(n))) {
            return string;
        }
        return string.substring(0, n).toLowerCase() + string.substring(n);
    }

    static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = string.offsetByCodePoints(0, 1);
        return string.substring(0, n).toUpperCase() + string.substring(n);
    }

    public static String propertyName(Method method) {
        String string = null;
        String string2 = method.getName();
        if (string2.startsWith("get")) {
            string = string2.substring(3);
        } else if (string2.startsWith("is") && method.getReturnType() == Boolean.TYPE) {
            string = string2.substring(2);
        }
        if (string == null || string.length() == 0 || method.getParameterTypes().length > 0 || method.getReturnType() == Void.TYPE || string2.equals("getClass")) {
            return null;
        }
        return string;
    }

    static {
        OpenType[] openTypeArray = new OpenType[]{SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.BOOLEAN, SimpleType.BYTE, SimpleType.CHARACTER, SimpleType.DATE, SimpleType.DOUBLE, SimpleType.FLOAT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.OBJECTNAME, SimpleType.SHORT, SimpleType.STRING, SimpleType.VOID};
        for (int i = 0; i < openTypeArray.length; ++i) {
            Class<?> clazz;
            OpenType openType = openTypeArray[i];
            try {
                clazz = Class.forName(openType.getClassName(), false, ObjectName.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error(classNotFoundException);
            }
            IdentityConverter identityConverter = new IdentityConverter(clazz, openType, clazz);
            OpenConverter.putPermanentConverter(clazz, identityConverter);
            if (!clazz.getName().startsWith("java.lang.")) continue;
            try {
                Field field = clazz.getField("TYPE");
                Class clazz2 = (Class)field.get(null);
                IdentityConverter identityConverter2 = new IdentityConverter(clazz2, openType, clazz2);
                OpenConverter.putPermanentConverter(clazz2, identityConverter2);
                if (clazz2 == Void.TYPE) continue;
                Class<?> clazz3 = Array.newInstance(clazz2, 0).getClass();
                ArrayType<?> arrayType = ArrayType.getPrimitiveArrayType(clazz3);
                IdentityConverter identityConverter3 = new IdentityConverter(clazz3, arrayType, clazz3);
                OpenConverter.putPermanentConverter(clazz3, identityConverter3);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false);
                continue;
            }
        }
        keyArray = new String[]{"key"};
        keyValueArray = new String[]{"key", "value"};
        inProgress = Util.newIdentityHashMap();
    }

    private static final class CompositeBuilderViaProxy
    extends CompositeBuilder {
        CompositeBuilderViaProxy(Class clazz, String[] stringArray) {
            super(clazz, stringArray);
        }

        String applicable(Method[] methodArray) {
            Class<?> clazz = this.getTargetClass();
            if (!clazz.isInterface()) {
                return "not an interface";
            }
            Set<Method> set = Util.newSet(Arrays.asList(clazz.getMethods()));
            set.removeAll(Arrays.asList(methodArray));
            String string = null;
            for (Method method : set) {
                String string2 = method.getName();
                Class<?>[] classArray = method.getParameterTypes();
                try {
                    Method method2 = Object.class.getMethod(string2, classArray);
                    if (Modifier.isPublic(method2.getModifiers())) continue;
                    string = string2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    string = string2;
                }
            }
            if (string != null) {
                return "contains methods other than getters (" + string + ")";
            }
            return null;
        }

        final Object fromCompositeData(MXBeanLookup mXBeanLookup, CompositeData compositeData, String[] stringArray, OpenConverter[] openConverterArray) {
            Class<?> clazz = this.getTargetClass();
            return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new CompositeDataInvocationHandler(compositeData));
        }
    }

    private static final class CompositeBuilderViaConstructor
    extends CompositeBuilder {
        private List<Constr> annotatedConstructors;

        CompositeBuilderViaConstructor(Class clazz, String[] stringArray) {
            super(clazz, stringArray);
        }

        String applicable(Method[] methodArray) throws InvalidObjectException {
            Object string;
            BitSet bitSet;
            Object object;
            Object object2;
            Class<ConstructorProperties> clazz = ConstructorProperties.class;
            Class<?> clazz2 = this.getTargetClass();
            Constructor<?>[] constructorArray = clazz2.getConstructors();
            List<Constructor<?>> list = Util.newList();
            for (Constructor<?> constructor : constructorArray) {
                if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getAnnotation(clazz) == null) continue;
                list.add(constructor);
            }
            if (list.isEmpty()) {
                return "no constructor has @ConstructorProperties annotation";
            }
            this.annotatedConstructors = Util.newList();
            Map map = Util.newMap();
            String[] stringArray = this.getItemNames();
            for (int i = 0; i < stringArray.length; ++i) {
                map.put(stringArray[i], i);
            }
            Set<BitSet> set = Util.newSet();
            for (Constructor object4 : list) {
                Object[] objectArray = object4.getAnnotation(clazz).value();
                object2 = object4.getGenericParameterTypes();
                if (((Type[])object2).length != objectArray.length) {
                    object = "Number of constructor params does not match @ConstructorProperties annotation: " + object4;
                    throw new InvalidObjectException((String)object);
                }
                object = new int[methodArray.length];
                for (int i = 0; i < methodArray.length; ++i) {
                    object[i] = -1;
                }
                bitSet = new BitSet();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object3;
                    String string2 = objectArray[i];
                    if (!map.containsKey(string2)) {
                        String string3 = "@ConstructorProperties includes name " + string2 + " which does not correspond to a property: " + object4;
                        throw new InvalidObjectException(string3);
                    }
                    int n = (Integer)map.get(string2);
                    object[n] = i;
                    if (bitSet.get(n)) {
                        object3 = "@ConstructorProperties contains property " + string2 + " more than once: " + object4;
                        throw new InvalidObjectException((String)object3);
                    }
                    bitSet.set(n);
                    object3 = methodArray[n];
                    Type type = ((Method)object3).getGenericReturnType();
                    if (type.equals(object2[i])) continue;
                    String string4 = "@ConstructorProperties gives property " + string2 + " of type " + type + " for parameter " + " of type " + object2[i] + ": " + object4;
                    throw new InvalidObjectException(string4);
                }
                if (!set.add(bitSet)) {
                    String string5 = "More than one constructor has a @ConstructorProperties annotation with this set of names: " + Arrays.toString(objectArray);
                    throw new InvalidObjectException(string5);
                }
                string = new Constr(object4, (int[])object, bitSet);
                this.annotatedConstructors.add((Constr)string);
            }
            for (BitSet bitSet2 : set) {
                boolean bl = false;
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = (BitSet)object2.next();
                    if (bitSet2 == object) {
                        bl = true;
                        continue;
                    }
                    if (!bl) continue;
                    bitSet = new BitSet();
                    bitSet.or(bitSet2);
                    bitSet.or((BitSet)object);
                    if (set.contains(bitSet)) continue;
                    string = new TreeSet();
                    int n = bitSet.nextSetBit(0);
                    while (n >= 0) {
                        string.add(stringArray[n]);
                        n = bitSet.nextSetBit(n + 1);
                    }
                    String string6 = "Constructors with @ConstructorProperties annotation  would be ambiguous for these items: " + string;
                    throw new InvalidObjectException(string6);
                }
            }
            return null;
        }

        Object fromCompositeData(MXBeanLookup mXBeanLookup, CompositeData compositeData, String[] stringArray, OpenConverter[] openConverterArray) throws InvalidObjectException {
            Object object;
            Object[] objectArray;
            CompositeType compositeType = compositeData.getCompositeType();
            BitSet bitSet = new BitSet();
            for (int i = 0; i < stringArray.length; ++i) {
                if (compositeType.getType(stringArray[i]) == null) continue;
                bitSet.set(i);
            }
            Constr constr = null;
            for (Constr constr2 : this.annotatedConstructors) {
                if (!CompositeBuilderViaConstructor.subset(constr2.presentParams, bitSet) || constr != null && !CompositeBuilderViaConstructor.subset(constr.presentParams, constr2.presentParams)) continue;
                constr = constr2;
            }
            if (constr == null) {
                objectArray = "No constructor has a @ConstructorProperties for this set of items: " + compositeType.keySet();
                throw new InvalidObjectException((String)objectArray);
            }
            objectArray = new Object[constr.presentParams.cardinality()];
            for (int i = 0; i < stringArray.length; ++i) {
                if (!constr.presentParams.get(i)) continue;
                object = compositeData.get(stringArray[i]);
                Object object2 = openConverterArray[i].fromOpenValue(mXBeanLookup, object);
                int n = constr.paramIndexes[i];
                if (n < 0) continue;
                objectArray[n] = object2;
            }
            try {
                return constr.constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                object = "Exception constructing " + this.getTargetClass().getName();
                throw OpenConverter.invalidObjectException((String)object, exception);
            }
        }

        private static boolean subset(BitSet bitSet, BitSet bitSet2) {
            BitSet bitSet3 = (BitSet)bitSet.clone();
            bitSet3.andNot(bitSet2);
            return bitSet3.isEmpty();
        }

        private static class Constr {
            final Constructor constructor;
            final int[] paramIndexes;
            final BitSet presentParams;

            Constr(Constructor constructor, int[] nArray, BitSet bitSet) {
                this.constructor = constructor;
                this.paramIndexes = nArray;
                this.presentParams = bitSet;
            }
        }
    }

    private static class CompositeBuilderViaSetters
    extends CompositeBuilder {
        private Method[] setters;

        CompositeBuilderViaSetters(Class clazz, String[] stringArray) {
            super(clazz, stringArray);
        }

        String applicable(Method[] methodArray) {
            Method[] methodArray2;
            try {
                methodArray2 = this.getTargetClass().getConstructor(null);
            }
            catch (Exception exception) {
                return "does not have a public no-arg constructor";
            }
            methodArray2 = new Method[methodArray.length];
            for (int i = 0; i < methodArray.length; ++i) {
                Method method;
                Method method2 = methodArray[i];
                Class<?> clazz = method2.getReturnType();
                String string = OpenConverter.propertyName(method2);
                String string2 = "set" + string;
                try {
                    method = this.getTargetClass().getMethod(string2, clazz);
                    if (method.getReturnType() != Void.TYPE) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    return "not all getters have corresponding setters (" + method2 + ")";
                }
                methodArray2[i] = method;
            }
            this.setters = methodArray2;
            return null;
        }

        Object fromCompositeData(MXBeanLookup mXBeanLookup, CompositeData compositeData, String[] stringArray, OpenConverter[] openConverterArray) throws InvalidObjectException {
            Object obj;
            try {
                obj = this.getTargetClass().newInstance();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!compositeData.containsKey(stringArray[i])) continue;
                    Object object = compositeData.get(stringArray[i]);
                    Object object2 = openConverterArray[i].fromOpenValue(mXBeanLookup, object);
                    this.setters[i].invoke(obj, object2);
                }
            }
            catch (Exception exception) {
                throw OpenConverter.invalidObjectException(exception);
            }
            return obj;
        }
    }

    private static class CompositeBuilderCheckGetters
    extends CompositeBuilder {
        private final OpenConverter[] getterConverters;

        CompositeBuilderCheckGetters(Class clazz, String[] stringArray, OpenConverter[] openConverterArray) {
            super(clazz, stringArray);
            this.getterConverters = openConverterArray;
        }

        String applicable(Method[] methodArray) {
            for (int i = 0; i < methodArray.length; ++i) {
                try {
                    this.getterConverters[i].checkReconstructible();
                    continue;
                }
                catch (InvalidObjectException invalidObjectException) {
                    return "method " + methodArray[i].getName() + " returns type " + "that cannot be mapped back from OpenData";
                }
            }
            return "";
        }

        final Object fromCompositeData(MXBeanLookup mXBeanLookup, CompositeData compositeData, String[] stringArray, OpenConverter[] openConverterArray) {
            throw new Error();
        }
    }

    private static final class CompositeBuilderViaFrom
    extends CompositeBuilder {
        private Method fromMethod;

        CompositeBuilderViaFrom(Class clazz, String[] stringArray) {
            super(clazz, stringArray);
        }

        String applicable(Method[] methodArray) throws InvalidObjectException {
            Class<?> clazz = this.getTargetClass();
            try {
                Method method = clazz.getMethod("from", CompositeData.class);
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new InvalidObjectException("Method from(CompositeData) is not static");
                }
                if (method.getReturnType() != this.getTargetClass()) {
                    String string = "Method from(CompositeData) returns " + method.getReturnType().getName() + " not " + clazz.getName();
                    throw new InvalidObjectException(string);
                }
                this.fromMethod = method;
                return null;
            }
            catch (InvalidObjectException invalidObjectException) {
                throw invalidObjectException;
            }
            catch (Exception exception) {
                return "no method from(CompositeData)";
            }
        }

        final Object fromCompositeData(MXBeanLookup mXBeanLookup, CompositeData compositeData, String[] stringArray, OpenConverter[] openConverterArray) throws InvalidObjectException {
            try {
                return this.fromMethod.invoke(null, compositeData);
            }
            catch (Exception exception) {
                throw OpenConverter.invalidObjectException("Failed to invoke from(CompositeData)", exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CompositeBuilder {
        private final Class<?> targetClass;
        private final String[] itemNames;

        CompositeBuilder(Class clazz, String[] stringArray) {
            this.targetClass = clazz;
            this.itemNames = stringArray;
        }

        Class<?> getTargetClass() {
            return this.targetClass;
        }

        String[] getItemNames() {
            return this.itemNames;
        }

        abstract String applicable(Method[] var1) throws InvalidObjectException;

        abstract Object fromCompositeData(MXBeanLookup var1, CompositeData var2, String[] var3, OpenConverter[] var4) throws InvalidObjectException;
    }

    private static final class CompositeConverter
    extends OpenConverter {
        private final String[] itemNames;
        private final Method[] getters;
        private final OpenConverter[] getterConverters;
        private CompositeBuilder compositeBuilder;

        CompositeConverter(Class clazz, CompositeType compositeType, String[] stringArray, Method[] methodArray) throws OpenDataException {
            super(clazz, compositeType, CompositeData.class);
            assert (stringArray.length == methodArray.length);
            this.itemNames = stringArray;
            this.getters = methodArray;
            this.getterConverters = new OpenConverter[methodArray.length];
            for (int i = 0; i < methodArray.length; ++i) {
                Type type = methodArray[i].getGenericReturnType();
                this.getterConverters[i] = OpenConverter.toConverter(type);
            }
        }

        final Object toNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) throws OpenDataException {
            CompositeType compositeType = (CompositeType)this.getOpenType();
            if (object instanceof CompositeDataView) {
                return ((CompositeDataView)object).toCompositeData(compositeType);
            }
            if (object == null) {
                return null;
            }
            Object[] objectArray = new Object[this.getters.length];
            for (int i = 0; i < this.getters.length; ++i) {
                try {
                    Object object2 = this.getters[i].invoke(object, null);
                    objectArray[i] = this.getterConverters[i].toOpenValue(mXBeanLookup, object2);
                    continue;
                }
                catch (Exception exception) {
                    throw CompositeConverter.openDataException("Error calling getter for " + this.itemNames[i] + ": " + exception, exception);
                }
            }
            return new CompositeDataSupport(compositeType, this.itemNames, objectArray);
        }

        private synchronized void makeCompositeBuilder() throws InvalidObjectException {
            if (this.compositeBuilder != null) {
                return;
            }
            Class clazz = (Class)this.getTargetType();
            CompositeBuilder[][] compositeBuilderArrayArray = new CompositeBuilder[][]{{new CompositeBuilderViaFrom(clazz, this.itemNames)}, {new CompositeBuilderViaConstructor(clazz, this.itemNames)}, {new CompositeBuilderCheckGetters(clazz, this.itemNames, this.getterConverters), new CompositeBuilderViaSetters(clazz, this.itemNames), new CompositeBuilderViaProxy(clazz, this.itemNames)}};
            CompositeBuilder compositeBuilder = null;
            StringBuilder stringBuilder = new StringBuilder();
            block0: for (CompositeBuilder[] compositeBuilderArray : compositeBuilderArrayArray) {
                for (int i = 0; i < compositeBuilderArray.length; ++i) {
                    CompositeBuilder compositeBuilder2 = compositeBuilderArray[i];
                    String string = compositeBuilder2.applicable(this.getters);
                    if (string == null) {
                        compositeBuilder = compositeBuilder2;
                        break block0;
                    }
                    if (string.length() <= 0) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append(string);
                    if (i == 0) continue block0;
                }
            }
            if (compositeBuilder == null) {
                String string = "Do not know how to make a " + clazz.getName() + " from a CompositeData: " + stringBuilder;
                throw new InvalidObjectException(string);
            }
            this.compositeBuilder = compositeBuilder;
        }

        void checkReconstructible() throws InvalidObjectException {
            this.makeCompositeBuilder();
        }

        public final Object fromNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) throws InvalidObjectException {
            this.makeCompositeBuilder();
            return this.compositeBuilder.fromCompositeData(mXBeanLookup, (CompositeData)object, this.itemNames, this.getterConverters);
        }
    }

    private static final class TabularConverter
    extends OpenConverter {
        private final boolean sortedMap;
        private final OpenConverter keyConverter;
        private final OpenConverter valueConverter;

        TabularConverter(Type type, boolean bl, TabularType tabularType, OpenConverter openConverter, OpenConverter openConverter2) {
            super(type, tabularType, TabularData.class);
            this.sortedMap = bl;
            this.keyConverter = openConverter;
            this.valueConverter = openConverter2;
        }

        final Object toNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) throws OpenDataException {
            Object object2;
            Map map = (Map)Util.cast(object);
            if (map instanceof SortedMap && (object2 = ((SortedMap)map).comparator()) != null) {
                String string = "Cannot convert SortedMap with non-null comparator: " + object2;
                throw new OpenDataException(string);
            }
            object2 = (TabularType)this.getOpenType();
            TabularDataSupport tabularDataSupport = new TabularDataSupport((TabularType)object2);
            CompositeType compositeType = ((TabularType)object2).getRowType();
            for (Map.Entry entry : map.entrySet()) {
                Object object3 = this.keyConverter.toOpenValue(mXBeanLookup, entry.getKey());
                Object object4 = this.valueConverter.toOpenValue(mXBeanLookup, entry.getValue());
                CompositeDataSupport compositeDataSupport = new CompositeDataSupport(compositeType, keyValueArray, new Object[]{object3, object4});
                tabularDataSupport.put(compositeDataSupport);
            }
            return tabularDataSupport;
        }

        public final Object fromNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) throws InvalidObjectException {
            TabularData tabularData = (TabularData)object;
            Collection collection = (Collection)Util.cast(tabularData.values());
            Map<Object, Object> map = this.sortedMap ? Util.newSortedMap() : Util.newMap();
            for (CompositeData compositeData : collection) {
                Object object2;
                Object object3 = this.keyConverter.fromOpenValue(mXBeanLookup, compositeData.get("key"));
                if (map.put(object3, object2 = this.valueConverter.fromOpenValue(mXBeanLookup, compositeData.get("value"))) == null) continue;
                String string = "Duplicate entry in TabularData: key=" + object3;
                throw new InvalidObjectException(string);
            }
            return map;
        }

        void checkReconstructible() throws InvalidObjectException {
            this.keyConverter.checkReconstructible();
            this.valueConverter.checkReconstructible();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MXBeanConverter
    extends OpenConverter {
        MXBeanConverter(Type type) {
            super(type, SimpleType.OBJECTNAME, ObjectName.class);
        }

        @Override
        final Object toNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) throws OpenDataException {
            this.lookupNotNull(mXBeanLookup, OpenDataException.class);
            ObjectName objectName = mXBeanLookup.mxbeanToObjectName(object);
            if (objectName == null) {
                throw new OpenDataException("No name for object: " + object);
            }
            return objectName;
        }

        @Override
        public final Object fromNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) throws InvalidObjectException {
            this.lookupNotNull(mXBeanLookup, InvalidObjectException.class);
            ObjectName objectName = (ObjectName)object;
            Object t = mXBeanLookup.objectNameToMXBean(objectName, (Class)this.getTargetType());
            if (t == null) {
                String string = "No MXBean for name: " + objectName;
                throw new InvalidObjectException(string);
            }
            return t;
        }

        private <T extends Exception> void lookupNotNull(MXBeanLookup mXBeanLookup, Class<T> clazz) throws T {
            if (mXBeanLookup == null) {
                Exception exception;
                try {
                    Constructor<T> constructor = clazz.getConstructor(String.class);
                    exception = (Exception)constructor.newInstance("Cannot convert MXBean interface in this context");
                }
                catch (Exception exception2) {
                    throw new RuntimeException(exception2);
                }
                throw exception;
            }
        }
    }

    private static final class CollectionConverter
    extends OpenConverter {
        private final Class<? extends Collection> collectionClass;
        private final OpenConverter elementConverter;

        CollectionConverter(Type type, ArrayType arrayType, Class clazz, OpenConverter openConverter) {
            super(type, arrayType, clazz);
            this.elementConverter = openConverter;
            Type type2 = ((ParameterizedType)type).getRawType();
            Class clazz2 = (Class)type2;
            if (clazz2 == List.class) {
                this.collectionClass = ArrayList.class;
            } else if (clazz2 == Set.class) {
                this.collectionClass = HashSet.class;
            } else if (clazz2 == SortedSet.class) {
                this.collectionClass = TreeSet.class;
            } else {
                assert (false);
                this.collectionClass = null;
            }
        }

        final Object toNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) throws OpenDataException {
            Object[] objectArray;
            Collection collection = (Collection)object;
            if (collection instanceof SortedSet && (objectArray = ((SortedSet)collection).comparator()) != null) {
                String string = "Cannot convert SortedSet with non-null comparator: " + objectArray;
                throw new OpenDataException(string);
            }
            objectArray = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), collection.size());
            int n = 0;
            for (Object e : collection) {
                objectArray[n++] = this.elementConverter.toOpenValue(mXBeanLookup, e);
            }
            return objectArray;
        }

        public final Object fromNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) throws InvalidObjectException {
            Collection collection;
            Object[] objectArray = (Object[])object;
            try {
                collection = (Collection)Util.cast(this.collectionClass.newInstance());
            }
            catch (Exception exception) {
                throw CollectionConverter.invalidObjectException("Cannot create collection", exception);
            }
            for (Object object2 : objectArray) {
                Object object3 = this.elementConverter.fromOpenValue(mXBeanLookup, object2);
                if (collection.add(object3)) continue;
                String string = "Could not add " + object2 + " to " + this.collectionClass.getName() + " (duplicate set element?)";
                throw new InvalidObjectException(string);
            }
            return collection;
        }

        void checkReconstructible() throws InvalidObjectException {
            this.elementConverter.checkReconstructible();
        }
    }

    private static final class ArrayConverter
    extends OpenConverter {
        private final OpenConverter elementConverter;

        ArrayConverter(Type type, ArrayType arrayType, Class clazz, OpenConverter openConverter) {
            super(type, arrayType, clazz);
            this.elementConverter = openConverter;
        }

        final Object toNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) throws OpenDataException {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            Object[] objectArray2 = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), n);
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = this.elementConverter.toOpenValue(mXBeanLookup, objectArray[i]);
            }
            return objectArray2;
        }

        public final Object fromNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) throws InvalidObjectException {
            Class<?> clazz;
            Object[] objectArray = (Object[])object;
            Type type = this.getTargetType();
            if (type instanceof GenericArrayType) {
                clazz = ((GenericArrayType)type).getGenericComponentType();
            } else if (type instanceof Class && ((Class)type).isArray()) {
                clazz = ((Class)type).getComponentType();
            } else {
                throw new IllegalArgumentException("Not an array: " + type);
            }
            Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.elementConverter.fromOpenValue(mXBeanLookup, objectArray[i]);
            }
            return objectArray2;
        }

        void checkReconstructible() throws InvalidObjectException {
            this.elementConverter.checkReconstructible();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnumConverter<T extends Enum<T>>
    extends OpenConverter {
        private final Class<T> enumClass;

        EnumConverter(Class<T> clazz) {
            super(clazz, SimpleType.STRING, String.class);
            this.enumClass = clazz;
        }

        @Override
        final Object toNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) {
            return ((Enum)object).name();
        }

        @Override
        public final Object fromNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) throws InvalidObjectException {
            try {
                return Enum.valueOf(this.enumClass, (String)object);
            }
            catch (Exception exception) {
                throw EnumConverter.invalidObjectException("Cannot convert to enum: " + object, exception);
            }
        }
    }

    private static final class IdentityConverter
    extends OpenConverter {
        IdentityConverter(Type type, OpenType openType, Class clazz) {
            super(type, openType, clazz);
        }

        boolean isIdentity() {
            return true;
        }

        final Object toNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) {
            return object;
        }

        public final Object fromNonNullOpenValue(MXBeanLookup mXBeanLookup, Object object) {
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConverterMap
    extends WeakHashMap<Type, WeakReference<OpenConverter>> {
        private ConverterMap() {
        }
    }
}

