/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.ObjectName;
import javax.management.loading.PrivateClassLoader;

final class ClassLoaderRepositorySupport
implements ModifiableClassLoaderRepository {
    private static final LoaderEntry[] EMPTY_LOADER_ARRAY = new LoaderEntry[0];
    private LoaderEntry[] loaders = EMPTY_LOADER_ARRAY;
    private final Map<String, List<ClassLoader>> search = new Hashtable<String, List<ClassLoader>>(10);
    private final Map<ObjectName, ClassLoader> loadersWithNames = new Hashtable<ObjectName, ClassLoader>(10);

    ClassLoaderRepositorySupport() {
    }

    private synchronized boolean add(ObjectName objectName, ClassLoader classLoader) {
        ArrayList<LoaderEntry> arrayList = new ArrayList<LoaderEntry>(Arrays.asList(this.loaders));
        arrayList.add(new LoaderEntry(objectName, classLoader));
        this.loaders = arrayList.toArray(EMPTY_LOADER_ARRAY);
        return true;
    }

    private synchronized boolean remove(ObjectName objectName, ClassLoader classLoader) {
        int n = this.loaders.length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            LoaderEntry loaderEntry = this.loaders[i];
            boolean bl2 = objectName == null ? classLoader == loaderEntry.loader : (bl = objectName.equals(loaderEntry.name));
            if (!bl) continue;
            LoaderEntry[] loaderEntryArray = new LoaderEntry[n - 1];
            System.arraycopy(this.loaders, 0, loaderEntryArray, 0, i);
            System.arraycopy(this.loaders, i + 1, loaderEntryArray, i, n - 1 - i);
            this.loaders = loaderEntryArray;
            return true;
        }
        return false;
    }

    public final Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(this.loaders, string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class loadClassWithout(ClassLoader classLoader, String string) throws ClassNotFoundException {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "loadClassWithout", string + " without " + classLoader);
        }
        if (classLoader == null) {
            return this.loadClass(this.loaders, string, null, null);
        }
        this.startValidSearch(classLoader, string);
        try {
            Class clazz = this.loadClass(this.loaders, string, classLoader, null);
            Object var5_4 = null;
            this.stopValidSearch(classLoader, string);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.stopValidSearch(classLoader, string);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class loadClassBefore(ClassLoader classLoader, String string) throws ClassNotFoundException {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "loadClassBefore", string + " before " + classLoader);
        }
        if (classLoader == null) {
            return this.loadClass(this.loaders, string, null, null);
        }
        this.startValidSearch(classLoader, string);
        try {
            Class clazz = this.loadClass(this.loaders, string, null, classLoader);
            Object var5_4 = null;
            this.stopValidSearch(classLoader, string);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.stopValidSearch(classLoader, string);
            throw throwable;
        }
    }

    private Class loadClass(LoaderEntry[] loaderEntryArray, String string, ClassLoader classLoader, ClassLoader classLoader2) throws ClassNotFoundException {
        int n = loaderEntryArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                ClassLoader classLoader3 = loaderEntryArray[i].loader;
                if (classLoader3 == null) {
                    return Class.forName(string, false, null);
                }
                if (classLoader3 == classLoader) continue;
                if (classLoader3 == classLoader2) break;
                if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "loadClass", "Trying loader = " + classLoader3);
                }
                return Class.forName(string, false, classLoader3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(string);
    }

    private synchronized void startValidSearch(ClassLoader classLoader, String string) throws ClassNotFoundException {
        List<ClassLoader> list = this.search.get(string);
        if (list != null && list.contains(classLoader)) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "startValidSearch", "Already requested loader = " + classLoader + " class = " + string);
            }
            throw new ClassNotFoundException(string);
        }
        if (list == null) {
            list = new ArrayList<ClassLoader>(1);
            this.search.put(string, list);
        }
        list.add(classLoader);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "startValidSearch", "loader = " + classLoader + " class = " + string);
        }
    }

    private synchronized void stopValidSearch(ClassLoader classLoader, String string) {
        List<ClassLoader> list = this.search.get(string);
        if (list != null) {
            list.remove(classLoader);
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "stopValidSearch", "loader = " + classLoader + " class = " + string);
            }
        }
    }

    public final void addClassLoader(ClassLoader classLoader) {
        this.add(null, classLoader);
    }

    public final void removeClassLoader(ClassLoader classLoader) {
        this.remove(null, classLoader);
    }

    public final synchronized void addClassLoader(ObjectName objectName, ClassLoader classLoader) {
        this.loadersWithNames.put(objectName, classLoader);
        if (!(classLoader instanceof PrivateClassLoader)) {
            this.add(objectName, classLoader);
        }
    }

    public final synchronized void removeClassLoader(ObjectName objectName) {
        ClassLoader classLoader = this.loadersWithNames.remove(objectName);
        if (!(classLoader instanceof PrivateClassLoader)) {
            this.remove(objectName, classLoader);
        }
    }

    public final ClassLoader getClassLoader(ObjectName objectName) {
        return this.loadersWithNames.get(objectName);
    }

    private static class LoaderEntry {
        ObjectName name;
        ClassLoader loader;

        LoaderEntry(ObjectName objectName, ClassLoader classLoader) {
            this.name = objectName;
            this.loader = classLoader;
        }
    }
}

