/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsTextUI;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.Position;

public class WindowsTextFieldUI
extends BasicTextFieldUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTextFieldUI();
    }

    protected void paintBackground(Graphics graphics) {
        super.paintBackground(graphics);
    }

    protected Caret createCaret() {
        return new WindowsFieldCaret();
    }

    static class WindowsFieldCaret
    extends DefaultCaret
    implements UIResource {
        protected void adjustVisibility(Rectangle rectangle) {
            SwingUtilities.invokeLater(new SafeScroller(rectangle));
        }

        protected Highlighter.HighlightPainter getSelectionPainter() {
            return WindowsTextUI.WindowsPainter;
        }

        private class SafeScroller
        implements Runnable {
            private Rectangle r;

            SafeScroller(Rectangle rectangle) {
                this.r = rectangle;
            }

            public void run() {
                JTextField jTextField = (JTextField)WindowsFieldCaret.this.getComponent();
                if (jTextField != null) {
                    TextUI textUI = jTextField.getUI();
                    int n = WindowsFieldCaret.this.getDot();
                    Position.Bias bias = Position.Bias.Forward;
                    Rectangle rectangle = null;
                    try {
                        rectangle = textUI.modelToView(jTextField, n, bias);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    Insets insets = jTextField.getInsets();
                    BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
                    int n2 = this.r.x + boundedRangeModel.getValue() - insets.left;
                    int n3 = boundedRangeModel.getExtent() / 4;
                    if (this.r.x < insets.left) {
                        boundedRangeModel.setValue(n2 - n3);
                    } else if (this.r.x + this.r.width > insets.left + boundedRangeModel.getExtent()) {
                        boundedRangeModel.setValue(n2 - 3 * n3);
                    }
                    if (rectangle != null) {
                        try {
                            Rectangle rectangle2 = textUI.modelToView(jTextField, n, bias);
                            if (rectangle2 != null && !rectangle2.equals(rectangle)) {
                                WindowsFieldCaret.this.damage(rectangle2);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

