/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import sun.tools.javap.JavapEnvironment;
import sun.tools.javap.JavapPrinter;

public class Main {
    private Vector classList = new Vector();
    private PrintWriter out;
    JavapEnvironment env = new JavapEnvironment();
    private static boolean errorOccurred = false;
    private static final String progname = "javap";

    public Main(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public static void main(String[] stringArray) {
        Main.entry(stringArray);
        if (errorOccurred) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entry(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        try {
            Main main = new Main(printWriter);
            main.perform(stringArray);
        }
        finally {
            printWriter.close();
        }
    }

    private void perform(String[] stringArray) {
        if (this.parseArguments(stringArray)) {
            this.displayResults();
        }
    }

    private void error(String string) {
        errorOccurred = true;
        System.err.println(string);
        System.err.flush();
    }

    private void usage() {
        PrintStream printStream = System.out;
        printStream.println("Usage: javap <options> <classes>...");
        printStream.println();
        printStream.println("where options include:");
        printStream.println("   -c                        Disassemble the code");
        printStream.println("   -classpath <pathlist>     Specify where to find user class files");
        printStream.println("   -extdirs <dirs>           Override location of installed extensions");
        printStream.println("   -help                     Print this usage message");
        printStream.println("   -J<flag>                  Pass <flag> directly to the runtime system");
        printStream.println("   -l                        Print line number and local variable tables");
        printStream.println("   -public                   Show only public classes and members");
        printStream.println("   -protected                Show protected/public classes and members");
        printStream.println("   -package                  Show package/protected/public classes");
        printStream.println("                             and members (default)");
        printStream.println("   -private                  Show all classes and members");
        printStream.println("   -s                        Print internal type signatures");
        printStream.println("   -bootclasspath <pathlist> Override location of class files loaded");
        printStream.println("                             by the bootstrap class loader");
        printStream.println("   -verbose                  Print stack size, number of locals and args for methods");
        printStream.println("                             If verifying, print reasons for failure");
        printStream.println();
    }

    private boolean parseArguments(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-")) {
                if (string.equals("-l")) {
                    this.env.showLineAndLocal = true;
                    continue;
                }
                if (string.equals("-private") || string.equals("-p")) {
                    this.env.showAccess = 0;
                    continue;
                }
                if (string.equals("-package")) {
                    this.env.showAccess = 2;
                    continue;
                }
                if (string.equals("-protected")) {
                    this.env.showAccess = 1;
                    continue;
                }
                if (string.equals("-public")) {
                    this.env.showAccess = 3;
                    continue;
                }
                if (string.equals("-c")) {
                    this.env.showDisassembled = true;
                    continue;
                }
                if (string.equals("-s")) {
                    this.env.showInternalSigs = true;
                    continue;
                }
                if (string.equals("-verbose")) {
                    this.env.showVerbose = true;
                    continue;
                }
                if (string.equals("-v")) {
                    this.env.showVerbose = true;
                    continue;
                }
                if (string.equals("-h")) {
                    this.error("-h is no longer available - use the 'javah' program");
                    return false;
                }
                if (string.equals("-verify")) {
                    this.error("-verify is no longer available - use 'java -verify'");
                    return false;
                }
                if (string.equals("-verify-verbose")) {
                    this.error("-verify is no longer available - use 'java -verify'");
                    return false;
                }
                if (string.equals("-help")) {
                    this.usage();
                    return false;
                }
                if (string.equals("-classpath")) {
                    if (i + 1 < stringArray.length) {
                        this.env.classPathString = stringArray[++i];
                        continue;
                    }
                    this.error("-classpath requires argument");
                    this.usage();
                    return false;
                }
                if (string.equals("-bootclasspath")) {
                    if (i + 1 < stringArray.length) {
                        this.env.bootClassPathString = stringArray[++i];
                        continue;
                    }
                    this.error("-bootclasspath requires argument");
                    this.usage();
                    return false;
                }
                if (string.equals("-extdirs")) {
                    if (i + 1 < stringArray.length) {
                        this.env.extDirsString = stringArray[++i];
                        continue;
                    }
                    this.error("-extdirs requires argument");
                    this.usage();
                    return false;
                }
                if (string.equals("-all")) {
                    this.env.showallAttr = true;
                    continue;
                }
                this.error("invalid flag: " + string);
                this.usage();
                return false;
            }
            this.classList.addElement(string);
            this.env.nothingToDo = false;
        }
        if (this.env.nothingToDo) {
            System.out.println("No classes were specified on the command line.  Try -help.");
            errorOccurred = true;
            return false;
        }
        return true;
    }

    private void displayResults() {
        for (int i = 0; i < this.classList.size(); ++i) {
            String string = (String)this.classList.elementAt(i);
            InputStream inputStream = this.env.getFileInputStream(string);
            try {
                JavapPrinter javapPrinter = new JavapPrinter(inputStream, this.out, this.env);
                javapPrinter.print();
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error(illegalArgumentException.getMessage());
            }
        }
    }
}

