/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.tools.java.CompilerError;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class MethodSet {
    private final Map lookupMap = new HashMap();
    private int count = 0;
    private boolean frozen = false;

    public int size() {
        return this.count;
    }

    public void add(MemberDefinition memberDefinition) {
        if (this.frozen) {
            throw new CompilerError("add()");
        }
        Identifier identifier = memberDefinition.getName();
        ArrayList<MemberDefinition> arrayList = (ArrayList<MemberDefinition>)this.lookupMap.get(identifier);
        if (arrayList == null) {
            arrayList = new ArrayList<MemberDefinition>();
            this.lookupMap.put(identifier, arrayList);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!((MemberDefinition)arrayList.get(i)).getType().equalArguments(memberDefinition.getType())) continue;
            throw new CompilerError("duplicate addition");
        }
        arrayList.add(memberDefinition);
        ++this.count;
    }

    public void replace(MemberDefinition memberDefinition) {
        if (this.frozen) {
            throw new CompilerError("replace()");
        }
        Identifier identifier = memberDefinition.getName();
        ArrayList<MemberDefinition> arrayList = (ArrayList<MemberDefinition>)this.lookupMap.get(identifier);
        if (arrayList == null) {
            arrayList = new ArrayList<MemberDefinition>();
            this.lookupMap.put(identifier, arrayList);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!((MemberDefinition)arrayList.get(i)).getType().equalArguments(memberDefinition.getType())) continue;
            arrayList.set(i, memberDefinition);
            return;
        }
        arrayList.add(memberDefinition);
        ++this.count;
    }

    public MemberDefinition lookupSig(Identifier identifier, Type type) {
        Iterator iterator = this.lookupName(identifier);
        while (iterator.hasNext()) {
            MemberDefinition memberDefinition = (MemberDefinition)iterator.next();
            if (!memberDefinition.getType().equalArguments(type)) continue;
            return memberDefinition;
        }
        return null;
    }

    public Iterator lookupName(Identifier identifier) {
        List list = (List)this.lookupMap.get(identifier);
        if (list == null) {
            return Collections.emptyIterator();
        }
        return list.iterator();
    }

    public Iterator iterator() {
        class MethodIterator
        implements Iterator {
            Iterator hashIter;
            Iterator listIter;

            MethodIterator() {
                this.hashIter = MethodSet.this.lookupMap.values().iterator();
                this.listIter = Collections.emptyIterator();
            }

            public boolean hasNext() {
                if (this.listIter.hasNext()) {
                    return true;
                }
                if (this.hashIter.hasNext()) {
                    this.listIter = ((List)this.hashIter.next()).iterator();
                    if (this.listIter.hasNext()) {
                        return true;
                    }
                    throw new CompilerError("iterator() in MethodSet");
                }
                return false;
            }

            public Object next() {
                return this.listIter.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new MethodIterator();
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public String toString() {
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        stringBuffer.append("{");
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (--n <= 0) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

