/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadGroupReferenceImpl
extends ObjectReferenceImpl
implements ThreadGroupReference,
VMListener {
    String name;
    ThreadGroupReference parent;
    boolean triedParent;

    @Override
    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ThreadGroupReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
        this.vm.state().addListener(this);
    }

    @Override
    protected String description() {
        return "ThreadGroupReference " + this.uniqueID();
    }

    @Override
    public String name() {
        if (this.name == null) {
            try {
                this.name = JDWP.ThreadGroupReference.Name.process((VirtualMachineImpl)this.vm, (ThreadGroupReferenceImpl)this).groupName;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.name;
    }

    @Override
    public ThreadGroupReference parent() {
        if (!this.triedParent) {
            try {
                this.parent = JDWP.ThreadGroupReference.Parent.process((VirtualMachineImpl)this.vm, (ThreadGroupReferenceImpl)this).parentGroup;
                this.triedParent = true;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.parent;
    }

    @Override
    public void suspend() {
        List<ThreadReference> list = this.threads();
        Iterator<ObjectReference> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().suspend();
        }
        List<ThreadGroupReference> list2 = this.threadGroups();
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((ThreadGroupReference)iterator.next()).suspend();
        }
    }

    @Override
    public void resume() {
        List<ThreadReference> list = this.threads();
        Iterator<ObjectReference> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().resume();
        }
        List<ThreadGroupReference> list2 = this.threadGroups();
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((ThreadGroupReference)iterator.next()).resume();
        }
    }

    private JDWP.ThreadGroupReference.Children kids() {
        JDWP.ThreadGroupReference.Children children = null;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null) {
                children = cache.kids;
            }
            if (children == null) {
                children = JDWP.ThreadGroupReference.Children.process(this.vm, this);
                if (cache != null) {
                    cache.kids = children;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace(this.description() + " temporarily caching children ");
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return children;
    }

    @Override
    public List<ThreadReference> threads() {
        return Arrays.asList((ThreadReference[])this.kids().childThreads);
    }

    @Override
    public List<ThreadGroupReference> threadGroups() {
        return Arrays.asList((ThreadGroupReference[])this.kids().childGroups);
    }

    @Override
    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', " + "id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 103;
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        JDWP.ThreadGroupReference.Children kids = null;

        private Cache() {
        }
    }
}

