/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.tools.jdi.EventQueueImpl;
import com.sun.tools.jdi.EventSetImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.Packet;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TargetVM
implements Runnable {
    private Map<String, Packet> waitingQueue = new HashMap<String, Packet>(32, 0.75f);
    private boolean shouldListen = true;
    private List<EventQueue> eventQueues = Collections.synchronizedList(new ArrayList(2));
    private VirtualMachineImpl vm;
    private Connection connection;
    private Thread readerThread;
    private EventController eventController = null;
    private boolean eventsHeld = false;
    private static final int OVERLOADED_QUEUE = 2000;
    private static final int UNDERLOADED_QUEUE = 100;

    TargetVM(VirtualMachineImpl virtualMachineImpl, Connection connection) {
        this.vm = virtualMachineImpl;
        this.connection = connection;
        this.readerThread = new Thread(virtualMachineImpl.threadGroupForJDI(), this, "JDI Target VM Interface");
        this.readerThread.setDaemon(true);
    }

    void start() {
        this.readerThread.start();
    }

    private void dumpPacket(Packet packet, boolean bl) {
        CharSequence charSequence;
        String string;
        String string2 = string = bl ? "Sending" : "Receiving";
        if (bl) {
            this.vm.printTrace(string + " Command. id=" + packet.id + ", length=" + packet.data.length + ", commandSet=" + packet.cmdSet + ", command=" + packet.cmd + ", flags=" + packet.flags);
        } else {
            charSequence = (packet.flags & 0x80) != 0 ? "Reply" : "Event";
            this.vm.printTrace(string + " " + (String)charSequence + ". id=" + packet.id + ", length=" + packet.data.length + ", errorCode=" + packet.errorCode + ", flags=" + packet.flags);
        }
        charSequence = new StringBuffer(80);
        ((StringBuffer)charSequence).append("0000: ");
        for (int i = 0; i < packet.data.length; ++i) {
            String string3;
            int n;
            if (i > 0 && i % 16 == 0) {
                this.vm.printTrace(((StringBuffer)charSequence).toString());
                ((StringBuffer)charSequence).setLength(0);
                ((StringBuffer)charSequence).append(String.valueOf(i));
                ((StringBuffer)charSequence).append(": ");
                n = ((StringBuffer)charSequence).length();
                for (int j = 0; j < 6 - n; ++j) {
                    ((StringBuffer)charSequence).insert(0, '0');
                }
            }
            if ((string3 = Integer.toHexString(n = 0xFF & packet.data[i])).length() == 1) {
                ((StringBuffer)charSequence).append('0');
            }
            ((StringBuffer)charSequence).append(string3);
            ((StringBuffer)charSequence).append(' ');
        }
        if (((StringBuffer)charSequence).length() > 6) {
            this.vm.printTrace(((StringBuffer)charSequence).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        if ((this.vm.traceFlags & 1) != 0) {
            this.vm.printTrace("Target VM interface thread running");
        }
        Packet packet = null;
        while (this.shouldListen) {
            Packet packet2;
            boolean bl = false;
            try {
                object = this.connection.readPacket();
                if (((byte[])object).length == 0) {
                    bl = true;
                }
                packet = Packet.fromByteArray((byte[])object);
            }
            catch (IOException iOException) {
                bl = true;
            }
            if (bl) {
                this.shouldListen = false;
                try {
                    this.connection.close();
                }
                catch (IOException iOException) {}
                break;
            }
            if ((this.vm.traceFlags & VirtualMachineImpl.TRACE_RAW_RECEIVES) != 0) {
                this.dumpPacket(packet, false);
            }
            if ((packet.flags & 0x80) == 0) {
                this.handleVMCommand(packet);
                continue;
            }
            this.vm.state().notifyCommandComplete(packet.id);
            String string = String.valueOf(packet.id);
            object = this.waitingQueue;
            synchronized (object) {
                packet2 = this.waitingQueue.get(string);
                if (packet2 != null) {
                    this.waitingQueue.remove(string);
                }
            }
            if (packet2 == null) {
                System.err.println("Recieved reply with no sender!");
                continue;
            }
            packet2.errorCode = packet.errorCode;
            packet2.data = packet.data;
            packet2.replied = true;
            object = packet2;
            synchronized (object) {
                packet2.notify();
            }
        }
        this.vm.vmManager.disposeVirtualMachine(this.vm);
        Object object2 = this.eventQueues;
        synchronized (object2) {
            object = this.eventQueues.iterator();
            while (object.hasNext()) {
                ((EventQueueImpl)object.next()).close();
            }
        }
        object2 = this.waitingQueue;
        synchronized (object2) {
            object = this.waitingQueue.values().iterator();
            while (object.hasNext()) {
                Packet packet3;
                Packet packet4 = packet3 = (Packet)object.next();
                synchronized (packet4) {
                    packet3.notify();
                }
            }
            this.waitingQueue.clear();
        }
        if ((this.vm.traceFlags & 1) != 0) {
            this.vm.printTrace("Target VM interface thread exiting");
        }
    }

    protected void handleVMCommand(Packet packet) {
        switch (packet.cmdSet) {
            case 64: {
                this.handleEventCmdSet(packet);
                break;
            }
            default: {
                System.err.println("Ignoring cmd " + packet.id + "/" + packet.cmdSet + "/" + packet.cmd + " from the VM");
                return;
            }
        }
    }

    protected void handleEventCmdSet(Packet packet) {
        EventSetImpl eventSetImpl = new EventSetImpl((VirtualMachine)this.vm, packet);
        if (eventSetImpl != null) {
            this.queueEventSet(eventSetImpl);
        }
    }

    private EventController eventController() {
        if (this.eventController == null) {
            this.eventController = new EventController(this.vm);
        }
        return this.eventController;
    }

    private synchronized void controlEventFlow(int n) {
        if (!this.eventsHeld && n > 2000) {
            this.eventController().hold();
            this.eventsHeld = true;
        } else if (this.eventsHeld && n < 100) {
            this.eventController().release();
            this.eventsHeld = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDequeueEventSet() {
        int n = 0;
        List<EventQueue> list = this.eventQueues;
        synchronized (list) {
            for (EventQueueImpl eventQueueImpl : this.eventQueues) {
                n = Math.max(n, eventQueueImpl.size());
            }
        }
        this.controlEventFlow(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEventSet(EventSet eventSet) {
        int n = 0;
        List<EventQueue> list = this.eventQueues;
        synchronized (list) {
            for (EventQueueImpl eventQueueImpl : this.eventQueues) {
                eventQueueImpl.enqueue(eventSet);
                n = Math.max(n, eventQueueImpl.size());
            }
        }
        this.controlEventFlow(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Packet packet) {
        String string = String.valueOf(packet.id);
        Map<String, Packet> map = this.waitingQueue;
        synchronized (map) {
            this.waitingQueue.put(string, packet);
        }
        if ((this.vm.traceFlags & VirtualMachineImpl.TRACE_RAW_SENDS) != 0) {
            this.dumpPacket(packet, true);
        }
        try {
            this.connection.writePacket(packet.toByteArray());
        }
        catch (IOException iOException) {
            throw new VMDisconnectedException(iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForReply(Packet packet) {
        Packet packet2 = packet;
        synchronized (packet2) {
            while (!packet.replied && this.shouldListen) {
                try {
                    packet.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!packet.replied) {
                throw new VMDisconnectedException();
            }
        }
    }

    void addEventQueue(EventQueueImpl eventQueueImpl) {
        if ((this.vm.traceFlags & 4) != 0) {
            this.vm.printTrace("New event queue added");
        }
        this.eventQueues.add(eventQueueImpl);
    }

    void stopListening() {
        if ((this.vm.traceFlags & 4) != 0) {
            this.vm.printTrace("Target VM i/f closing event queues");
        }
        this.shouldListen = false;
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class EventController
    extends Thread {
        VirtualMachineImpl vm;
        int controlRequest = 0;

        EventController(VirtualMachineImpl virtualMachineImpl) {
            super(virtualMachineImpl.threadGroupForJDI(), "JDI Event Control Thread");
            this.vm = virtualMachineImpl;
            this.setDaemon(true);
            this.setPriority(7);
            super.start();
        }

        synchronized void hold() {
            ++this.controlRequest;
            this.notifyAll();
        }

        synchronized void release() {
            --this.controlRequest;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                int n;
                EventController eventController = this;
                synchronized (eventController) {
                    while (this.controlRequest == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    n = this.controlRequest;
                    this.controlRequest = 0;
                }
                try {
                    if (n > 0) {
                        JDWP.VirtualMachine.HoldEvents.process(this.vm);
                        continue;
                    }
                    JDWP.VirtualMachine.ReleaseEvents.process(this.vm);
                    continue;
                }
                catch (JDWPException jDWPException) {
                    jDWPException.toJDIException().printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }
    }
}

