/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.MonitorInfo;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.ThreadAction;
import com.sun.tools.jdi.ThreadListener;
import com.sun.tools.jdi.VMState;

public class MonitorInfoImpl
extends MirrorImpl
implements MonitorInfo,
ThreadListener {
    private boolean isValid = true;
    ObjectReference monitor;
    ThreadReference thread;
    int stack_depth;

    MonitorInfoImpl(VirtualMachine virtualMachine, ObjectReference objectReference, ThreadReference threadReference, int n) {
        super(virtualMachine);
        this.monitor = objectReference;
        this.thread = threadReference;
        this.stack_depth = n;
    }

    public boolean threadResumable(ThreadAction threadAction) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            if (this.isValid) {
                this.isValid = false;
                return false;
            }
            throw new InternalException("Invalid stack frame thread listener");
        }
    }

    private void validateMonitorInfo() {
        if (!this.isValid) {
            throw new InvalidStackFrameException("Thread has been resumed");
        }
    }

    public ObjectReference monitor() {
        this.validateMonitorInfo();
        return this.monitor;
    }

    public int stackDepth() {
        this.validateMonitorInfo();
        return this.stack_depth;
    }

    public ThreadReference thread() {
        this.validateMonitorInfo();
        return this.thread;
    }
}

