/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.ReferenceTypeImpl;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceTypeImpl
extends ReferenceTypeImpl
implements InterfaceType {
    private SoftReference<List<InterfaceType>> superinterfacesRef = null;

    protected InterfaceTypeImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
    }

    @Override
    public List<InterfaceType> superinterfaces() {
        List<InterfaceType> list;
        List<InterfaceType> list2 = list = this.superinterfacesRef == null ? null : this.superinterfacesRef.get();
        if (list == null) {
            list = this.getInterfaces();
            list = Collections.unmodifiableList(list);
            this.superinterfacesRef = new SoftReference<List<InterfaceType>>(list);
        }
        return list;
    }

    @Override
    public List<InterfaceType> subinterfaces() {
        ArrayList<InterfaceType> arrayList = new ArrayList<InterfaceType>();
        for (ReferenceType referenceType : this.vm.allClasses()) {
            InterfaceType interfaceType;
            if (!(referenceType instanceof InterfaceType) || !(interfaceType = (InterfaceType)referenceType).isPrepared() || !interfaceType.superinterfaces().contains(this)) continue;
            arrayList.add(interfaceType);
        }
        return arrayList;
    }

    @Override
    public List<ClassType> implementors() {
        ArrayList<ClassType> arrayList = new ArrayList<ClassType>();
        for (ReferenceType referenceType : this.vm.allClasses()) {
            ClassType classType;
            if (!(referenceType instanceof ClassType) || !(classType = (ClassType)referenceType).isPrepared() || !classType.interfaces().contains(this)) continue;
            arrayList.add(classType);
        }
        return arrayList;
    }

    @Override
    void addVisibleMethods(Map<String, Method> map) {
        for (InterfaceType interfaceType : this.superinterfaces()) {
            ((InterfaceTypeImpl)interfaceType).addVisibleMethods(map);
        }
        this.addToMethodMap(map, this.methods());
    }

    @Override
    public List<Method> allMethods() {
        ArrayList<Method> arrayList = new ArrayList<Method>(this.methods());
        for (InterfaceType interfaceType : this.allSuperinterfaces()) {
            arrayList.addAll(interfaceType.methods());
        }
        return arrayList;
    }

    List<InterfaceType> allSuperinterfaces() {
        ArrayList<InterfaceType> arrayList = new ArrayList<InterfaceType>();
        this.addSuperinterfaces(arrayList);
        return arrayList;
    }

    void addSuperinterfaces(List<InterfaceType> list) {
        ArrayList<InterfaceType> arrayList = new ArrayList<InterfaceType>(this.superinterfaces());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            InterfaceType interfaceType = (InterfaceType)iterator.next();
            if (!list.contains(interfaceType)) continue;
            iterator.remove();
        }
        list.addAll(arrayList);
        for (InterfaceType interfaceType : arrayList) {
            ((InterfaceTypeImpl)interfaceType).addSuperinterfaces(list);
        }
    }

    @Override
    boolean isAssignableTo(ReferenceType referenceType) {
        if (this.equals(referenceType)) {
            return true;
        }
        for (InterfaceType interfaceType : this.superinterfaces()) {
            if (!((InterfaceTypeImpl)interfaceType).isAssignableTo(referenceType)) continue;
            return true;
        }
        return false;
    }

    List<InterfaceType> inheritedTypes() {
        return this.superinterfaces();
    }

    @Override
    public boolean isInitialized() {
        return this.isPrepared();
    }

    @Override
    public String toString() {
        return "interface " + this.name() + " (" + this.loaderString() + ")";
    }
}

