/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.FieldImpl;
import com.sun.tools.jdi.InterfaceTypeImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTypeImpl
extends ReferenceTypeImpl
implements ClassType {
    private boolean cachedSuperclass = false;
    private ClassType superclass = null;
    private int lastLine = -1;
    private List<InterfaceType> interfaces = null;

    protected ClassTypeImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
    }

    @Override
    public ClassType superclass() {
        if (!this.cachedSuperclass) {
            ClassTypeImpl classTypeImpl = null;
            try {
                classTypeImpl = JDWP.ClassType.Superclass.process((VirtualMachineImpl)this.vm, (ClassTypeImpl)this).superclass;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
            if (classTypeImpl != null) {
                this.superclass = classTypeImpl;
            }
            this.cachedSuperclass = true;
        }
        return this.superclass;
    }

    @Override
    public List<InterfaceType> interfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.getInterfaces();
        }
        return this.interfaces;
    }

    void addInterfaces(List<InterfaceType> list) {
        List<InterfaceType> list2 = this.interfaces();
        list.addAll(this.interfaces());
        for (InterfaceTypeImpl referenceTypeImpl2 : list2) {
            referenceTypeImpl2.addSuperinterfaces(list);
        }
        ClassTypeImpl classTypeImpl = (ClassTypeImpl)this.superclass();
        if (classTypeImpl != null) {
            classTypeImpl.addInterfaces(list);
        }
    }

    @Override
    public List<InterfaceType> allInterfaces() {
        ArrayList<InterfaceType> arrayList = new ArrayList<InterfaceType>();
        this.addInterfaces(arrayList);
        return arrayList;
    }

    @Override
    public List<ClassType> subclasses() {
        List<ReferenceType> list = this.vm.allClasses();
        ArrayList<ClassType> arrayList = new ArrayList<ClassType>();
        for (ReferenceType referenceType : list) {
            ClassType classType;
            ClassType classType2;
            if (!(referenceType instanceof ClassType) || (classType2 = (classType = (ClassType)referenceType).superclass()) == null || !classType2.equals(this)) continue;
            arrayList.add((ClassType)referenceType);
        }
        return arrayList;
    }

    @Override
    public boolean isEnum() {
        ClassType classType = this.superclass();
        return classType != null && classType.name().equals("java.lang.Enum");
    }

    @Override
    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        block5: {
            this.validateMirror(field);
            this.validateMirrorOrNull(value);
            this.validateFieldSet(field);
            if (!field.isStatic()) {
                throw new IllegalArgumentException("Must set non-static field through an instance");
            }
            try {
                JDWP.ClassType.SetValues.FieldValue[] fieldValueArray = new JDWP.ClassType.SetValues.FieldValue[]{new JDWP.ClassType.SetValues.FieldValue(((FieldImpl)field).ref(), ValueImpl.prepareForAssignment(value, (FieldImpl)field))};
                try {
                    JDWP.ClassType.SetValues.process(this.vm, this, fieldValueArray);
                }
                catch (JDWPException jDWPException) {
                    throw jDWPException.toJDIException();
                }
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                if (value == null) break block5;
                throw classNotLoadedException;
            }
        }
    }

    PacketStream sendInvokeCommand(final ThreadReferenceImpl threadReferenceImpl, final MethodImpl methodImpl, final ValueImpl[] valueImplArray, final int n) {
        CommandSender commandSender = new CommandSender(){

            public PacketStream send() {
                return JDWP.ClassType.InvokeMethod.enqueueCommand(ClassTypeImpl.this.vm, ClassTypeImpl.this, threadReferenceImpl, methodImpl.ref(), valueImplArray, n);
            }
        };
        PacketStream packetStream = (n & 1) != 0 ? threadReferenceImpl.sendResumingCommand(commandSender) : this.vm.sendResumingCommand(commandSender);
        return packetStream;
    }

    PacketStream sendNewInstanceCommand(final ThreadReferenceImpl threadReferenceImpl, final MethodImpl methodImpl, final ValueImpl[] valueImplArray, final int n) {
        CommandSender commandSender = new CommandSender(){

            public PacketStream send() {
                return JDWP.ClassType.NewInstance.enqueueCommand(ClassTypeImpl.this.vm, ClassTypeImpl.this, threadReferenceImpl, methodImpl.ref(), valueImplArray, n);
            }
        };
        PacketStream packetStream = (n & 1) != 0 ? threadReferenceImpl.sendResumingCommand(commandSender) : this.vm.sendResumingCommand(commandSender);
        return packetStream;
    }

    @Override
    public Value invokeMethod(ThreadReference threadReference, Method method, List<? extends Value> list, int n) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        JDWP.ClassType.InvokeMethod invokeMethod;
        this.validateMirror(threadReference);
        this.validateMirror(method);
        this.validateMirrorsOrNulls(list);
        MethodImpl methodImpl = (MethodImpl)method;
        ThreadReferenceImpl threadReferenceImpl = (ThreadReferenceImpl)threadReference;
        this.validateMethodInvocation(methodImpl);
        List<Value> list2 = methodImpl.validateAndPrepareArgumentsForInvoke(list);
        ValueImpl[] valueImplArray = list2.toArray(new ValueImpl[0]);
        try {
            PacketStream packetStream = this.sendInvokeCommand(threadReferenceImpl, methodImpl, valueImplArray, n);
            invokeMethod = JDWP.ClassType.InvokeMethod.waitForReply(this.vm, packetStream);
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw jDWPException.toJDIException();
        }
        if ((n & 1) == 0) {
            this.vm.notifySuspend();
        }
        if (invokeMethod.exception != null) {
            throw new InvocationException(invokeMethod.exception);
        }
        return invokeMethod.returnValue;
    }

    @Override
    public ObjectReference newInstance(ThreadReference threadReference, Method method, List<? extends Value> list, int n) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        this.validateMirror(threadReference);
        this.validateMirror(method);
        this.validateMirrorsOrNulls(list);
        MethodImpl methodImpl = (MethodImpl)method;
        ThreadReferenceImpl threadReferenceImpl = (ThreadReferenceImpl)threadReference;
        this.validateConstructorInvocation(methodImpl);
        List<Value> list2 = methodImpl.validateAndPrepareArgumentsForInvoke(list);
        ValueImpl[] valueImplArray = list2.toArray(new ValueImpl[0]);
        JDWP.ClassType.NewInstance newInstance = null;
        try {
            PacketStream packetStream = this.sendNewInstanceCommand(threadReferenceImpl, methodImpl, valueImplArray, n);
            newInstance = JDWP.ClassType.NewInstance.waitForReply(this.vm, packetStream);
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw jDWPException.toJDIException();
        }
        if ((n & 1) == 0) {
            this.vm.notifySuspend();
        }
        if (newInstance.exception != null) {
            throw new InvocationException(newInstance.exception);
        }
        return newInstance.newObject;
    }

    @Override
    public Method concreteMethodByName(String string, String string2) {
        List<Method> list = this.visibleMethods();
        Method method = null;
        for (Method method2 : list) {
            if (!method2.name().equals(string) || !method2.signature().equals(string2) || method2.isAbstract()) continue;
            method = method2;
            break;
        }
        return method;
    }

    @Override
    public List<Method> allMethods() {
        ArrayList<Method> arrayList = new ArrayList<Method>(this.methods());
        for (ClassType classType = this.superclass(); classType != null; classType = classType.superclass()) {
            arrayList.addAll(classType.methods());
        }
        for (InterfaceType interfaceType : this.allInterfaces()) {
            arrayList.addAll(interfaceType.methods());
        }
        return arrayList;
    }

    List<ReferenceType> inheritedTypes() {
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        if (this.superclass() != null) {
            arrayList.add(0, this.superclass());
        }
        for (InterfaceType interfaceType : this.interfaces()) {
            arrayList.add(interfaceType);
        }
        return arrayList;
    }

    void validateMethodInvocation(Method method) throws InvalidTypeException, InvocationException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)method.declaringType();
        if (!referenceTypeImpl.isAssignableFrom(this)) {
            throw new IllegalArgumentException("Invalid method");
        }
        if (!method.isStatic()) {
            throw new IllegalArgumentException("Cannot invoke instance method on a class type");
        }
        if (method.isStaticInitializer()) {
            throw new IllegalArgumentException("Cannot invoke static initializer");
        }
    }

    void validateConstructorInvocation(Method method) throws InvalidTypeException, InvocationException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)method.declaringType();
        if (!referenceTypeImpl.equals(this)) {
            throw new IllegalArgumentException("Invalid constructor");
        }
        if (!method.isConstructor()) {
            throw new IllegalArgumentException("Cannot create instance with non-constructor");
        }
    }

    @Override
    void addVisibleMethods(Map<String, Method> map) {
        for (InterfaceTypeImpl referenceTypeImpl2 : this.interfaces()) {
            referenceTypeImpl2.addVisibleMethods(map);
        }
        ClassTypeImpl classTypeImpl = (ClassTypeImpl)this.superclass();
        if (classTypeImpl != null) {
            classTypeImpl.addVisibleMethods(map);
        }
        this.addToMethodMap(map, this.methods());
    }

    @Override
    boolean isAssignableTo(ReferenceType referenceType) {
        ClassTypeImpl classTypeImpl = (ClassTypeImpl)this.superclass();
        if (this.equals(referenceType)) {
            return true;
        }
        if (classTypeImpl != null && classTypeImpl.isAssignableTo(referenceType)) {
            return true;
        }
        List<InterfaceType> list = this.interfaces();
        for (InterfaceTypeImpl interfaceTypeImpl : list) {
            if (!interfaceTypeImpl.isAssignableTo(referenceType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "class " + this.name() + " (" + this.loaderString() + ")";
    }
}

