/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.internalizer;

import com.sun.istack.internal.SAXParseException2;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.reader.internalizer.DOMForest;
import com.sun.tools.internal.xjc.reader.internalizer.Messages;
import com.sun.tools.internal.xjc.reader.internalizer.NamespaceContextImpl;
import com.sun.tools.internal.xjc.util.DOMUtils;
import com.sun.xml.internal.bind.v2.util.EditDistance;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Internalizer {
    private static final XPathFactory xpf = XPathFactory.newInstance();
    private final XPath xpath = xpf.newXPath();
    private final DOMForest forest;
    private ErrorReceiver errorHandler;
    private static final String EXTENSION_PREFIXES = "extensionBindingPrefixes";

    static void transform(DOMForest dOMForest) {
        new Internalizer(dOMForest).transform();
    }

    private Internalizer(DOMForest dOMForest) {
        this.errorHandler = dOMForest.getErrorHandler();
        this.forest = dOMForest;
    }

    private void transform() {
        HashMap<Element, Node> hashMap = new HashMap<Element, Node>();
        for (Element element : this.forest.outerMostBindings) {
            this.buildTargetNodeMap(element, element, hashMap);
        }
        for (Element element : this.forest.outerMostBindings) {
            this.move(element, hashMap);
        }
    }

    private void validate(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr.getNamespaceURI() == null && !attr.getLocalName().equals("node") && !attr.getLocalName().equals("schemaLocation")) continue;
        }
    }

    private void buildTargetNodeMap(Element element, Node node, Map<Element, Node> map) {
        Object object;
        Node node2 = node;
        this.validate(element);
        if (element.getAttributeNode("schemaLocation") != null) {
            object = element.getAttribute("schemaLocation");
            try {
                object = new URL(new URL(this.forest.getSystemId(element.getOwnerDocument())), (String)object).toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            node2 = this.forest.get((String)object);
            if (node2 == null) {
                this.reportError(element, Messages.format("Internalizer.IncorrectSchemaReference", object, EditDistance.findNearest((String)object, (String[])this.forest.listSystemIDs())));
                return;
            }
        }
        if (element.getAttributeNode("node") != null) {
            NodeList nodeList;
            object = element.getAttribute("node");
            try {
                this.xpath.setNamespaceContext(new NamespaceContextImpl(element));
                nodeList = (NodeList)this.xpath.evaluate((String)object, node2, XPathConstants.NODESET);
            }
            catch (XPathExpressionException xPathExpressionException) {
                this.reportError(element, Messages.format("Internalizer.XPathEvaluationError", xPathExpressionException.getMessage()), xPathExpressionException);
                return;
            }
            if (nodeList.getLength() == 0) {
                this.reportError(element, Messages.format("Internalizer.XPathEvaluatesToNoTarget", object));
                return;
            }
            if (nodeList.getLength() != 1) {
                this.reportError(element, Messages.format("Internalizer.XPathEvaulatesToTooManyTargets", object, nodeList.getLength()));
                return;
            }
            Node node3 = nodeList.item(0);
            if (!(node3 instanceof Element)) {
                this.reportError(element, Messages.format("Internalizer.XPathEvaluatesToNonElement", object));
                return;
            }
            if (!this.forest.logic.checkIfValidTargetNode(this.forest, element, (Element)node3)) {
                this.reportError(element, Messages.format("Internalizer.XPathEvaluatesToNonSchemaElement", object, node3.getNodeName()));
                return;
            }
            node2 = node3;
        }
        map.put(element, node2);
        object = DOMUtils.getChildElements(element, "http://java.sun.com/xml/ns/jaxb", "bindings");
        for (Element element2 : object) {
            this.buildTargetNodeMap(element2, node2, map);
        }
    }

    private void move(Element element, Map<Element, Node> map) {
        Element[] elementArray;
        Node node = map.get(element);
        if (node == null) {
            return;
        }
        for (Element element2 : elementArray = DOMUtils.getChildElements(element)) {
            if ("bindings".equals(element2.getLocalName())) {
                this.move(element2, map);
                continue;
            }
            if (!(node instanceof Element)) {
                if (node instanceof Document) {
                    this.reportError(element2, Messages.format("Internalizer.NoContextNodeSpecified", new Object[0]));
                } else {
                    this.reportError(element2, Messages.format("Internalizer.ContextNodeIsNotElement", new Object[0]));
                }
                return;
            }
            if (!this.forest.logic.checkIfValidTargetNode(this.forest, element2, (Element)node)) {
                this.reportError(element2, Messages.format("Internalizer.OrphanedCustomization", element2.getNodeName()));
                return;
            }
            this.moveUnder(element2, (Element)node);
        }
    }

    private void moveUnder(Element element, Element element2) {
        Object object;
        Element element3 = this.forest.logic.refineTarget(element2);
        this.declExtensionNamespace(element, element2);
        Element element4 = element;
        HashSet<String> hashSet = new HashSet<String>();
        while (true) {
            object = element4.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                String string;
                Attr attr = (Attr)object.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !hashSet.add(string = attr.getName().indexOf(58) == -1 ? "" : attr.getLocalName()) || element4 == element) continue;
                element.setAttributeNodeNS((Attr)attr.cloneNode(true));
            }
            if (element4.getParentNode() instanceof Document) break;
            element4 = (Element)element4.getParentNode();
        }
        if (!hashSet.contains("")) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        if (element3.getOwnerDocument() != element.getOwnerDocument()) {
            object = element;
            element = (Element)element3.getOwnerDocument().importNode(element, true);
            this.copyLocators((Element)object, element);
        }
        element3.appendChild(element);
    }

    private void declExtensionNamespace(Element element, Element element2) {
        if (!"http://java.sun.com/xml/ns/jaxb".equals(element.getNamespaceURI())) {
            this.declareExtensionNamespace(element2, element.getNamespaceURI());
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            this.declExtensionNamespace((Element)node, element2);
        }
    }

    private void declareExtensionNamespace(Element element, String string) {
        String string2;
        Element element2 = element.getOwnerDocument().getDocumentElement();
        Attr attr = element2.getAttributeNodeNS("http://java.sun.com/xml/ns/jaxb", EXTENSION_PREFIXES);
        if (attr == null) {
            string2 = this.allocatePrefix(element2, "http://java.sun.com/xml/ns/jaxb");
            attr = element.getOwnerDocument().createAttributeNS("http://java.sun.com/xml/ns/jaxb", string2 + ':' + EXTENSION_PREFIXES);
            element2.setAttributeNodeNS(attr);
        }
        string2 = this.allocatePrefix(element2, string);
        if (attr.getValue().indexOf(string2) == -1) {
            attr.setValue(attr.getValue() + ' ' + string2);
        }
    }

    private String allocatePrefix(Element element, String string) {
        String string2;
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || attr.getName().indexOf(58) == -1 || !attr.getValue().equals(string)) continue;
            return attr.getLocalName();
        }
        while (element.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string2 = "p" + (int)(Math.random() * 1000000.0) + '_') != null) {
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, string);
        return string2;
    }

    private void copyLocators(Element element, Element element2) {
        this.forest.locatorTable.storeStartLocation(element2, this.forest.locatorTable.getStartLocation(element));
        this.forest.locatorTable.storeEndLocation(element2, this.forest.locatorTable.getEndLocation(element));
        Element[] elementArray = DOMUtils.getChildElements(element);
        Element[] elementArray2 = DOMUtils.getChildElements(element2);
        for (int i = 0; i < elementArray.length; ++i) {
            this.copyLocators(elementArray[i], elementArray2[i]);
        }
    }

    private void reportError(Element element, String string) {
        this.reportError(element, string, null);
    }

    private void reportError(Element element, String string, Exception exception) {
        SAXParseException2 sAXParseException2 = new SAXParseException2(string, this.forest.locatorTable.getStartLocation(element), exception);
        this.errorHandler.error((SAXParseException)sAXParseException2);
    }
}

