/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ring {
    private final Map<Class, Object> components = new HashMap<Class, Object>();
    private static final ThreadLocal<Ring> instances = new ThreadLocal<Ring>(){

        @Override
        public Ring initialValue() {
            return new Ring();
        }
    };

    private Ring() {
    }

    public static <T> void add(Class<T> clazz, T t) {
        assert (!Ring.get().components.containsKey(clazz));
        Ring.get().components.put(clazz, t);
    }

    public static <T> void add(T t) {
        Ring.add(t.getClass(), t);
    }

    public static <T> T get(Class<T> clazz) {
        Object object = Ring.get().components.get(clazz);
        if (object == null) {
            try {
                Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                object = constructor.newInstance(new Object[0]);
                if (!Ring.get().components.containsKey(clazz)) {
                    Ring.add(clazz, object);
                }
            }
            catch (InstantiationException instantiationException) {
                throw new Error(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error(illegalAccessException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new Error(noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new Error(invocationTargetException);
            }
        }
        assert (object != null);
        return (T)object;
    }

    public static Ring get() {
        return instances.get();
    }

    public static Ring begin() {
        Ring ring = instances.get();
        instances.set(new Ring());
        return ring;
    }

    public static void end(Ring ring) {
        instances.set(ring);
    }
}

